(function($) {
	$( document ).on( 'click', '.swg-opts-upload, .swg-menu-upload', function( event ) {
		var file_frame;	
		var formfield = $(this).attr('rel-id');
		var preview = $(this).parent().find('img');

		// If the media frame already exists, reopen it.
		if ( file_frame ) {
			file_frame.open();
			return;
		}

		// Create the media frame.
		file_frame = wp.media.frames.downloadable_file = wp.media({
			title: "Choose an image",
			button: {
				text: 'Use image'
			},
			multiple: false
		});

		// When an image is selected, run a callback.
		file_frame.on( 'select', function() {
			var attachment = file_frame.state().get( 'selection' ).first().toJSON();
			$img_url = ( typeof( attachment.sizes.thumbnail ) != 'undefined' ) ? attachment.sizes.thumbnail.url : attachment.sizes.full.url;
			$(preview).attr( 'src', $img_url );
			$(formfield).val( attachment.sizes.full.url );
            $('#swg-opts-screenshot-'+formfield).css( 'display','block' );
			$(formfield).parents( '.field-table' ).prev().prev().fadeOut('slow');
			$(formfield).parents( '.field-table' ).prev().fadeIn('slow');
		});

		// Finally, open the modal.
		file_frame.open();
		event.preventDefault();
	});
	$(document).ready(function(){
		$( document ).on( 'click', '.swg-opts-upload-remove, .swg-menu-upload-remove', function(){
			$relid = $(this).attr('rel-id');
			$($relid).val('');
			$(this).prev().fadeIn('fast');
			$(this).prev().prev().fadeIn('fast', function(){jQuery(this).attr("src", swg_upload.url);});
			$(this).fadeOut('slow');
		});
		 
	});
	function MenuClick(){
		$(document).on('click', '.menu-advance-href', function(){
			$(this).parent().find('.menu-config-content').slideToggle();
		});
	}
	$(document).ready(function(){
		MenuClick();
	});
}(jQuery));