<?php 
/**
 * Plugin Name: Sw Mega Menu
 * Plugin URI: http://www.wpthemego.com/
 * Description: Display menu as mega menu and many style.
 * Version: 1.0.9
 * Author: WpThemeGo
 * Author URI: http://www.wpthemego.com/
 * Requires at least: 4.1
 * Tested up to: WorPress 6.7.x 
 *
 * Text Domain: sw-megamenu
 * Domain Path: /languages/
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// define plugin path
if ( ! defined( 'MMNPATH' ) ) {
	define( 'MMNPATH', plugin_dir_path( __FILE__ ) );
}

// define plugin URL
if ( ! defined( 'MMNURL' ) ) {
	define( 'MMNURL', plugins_url(). '/sw-mega-menu' );
}

// define plugin theme path
if ( ! defined( 'MMNTHEME' ) ) {
	define( 'MMNTHEME', plugin_dir_path( __FILE__ ). 'includes/themes' );
}

function sw_megamenu_construct(){
	require_once( MMNPATH . '/includes/functions.php' );

	add_action( 'wp_enqueue_scripts', 'sw_megamenu_enqueue_script' );

	/* Load text domain */
	load_plugin_textdomain( 'sw-megamenu', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
	if(did_action('elementor/loaded')) {
		add_action('elementor/widgets/register', 'swg_register_megamenu_elementor_widgets' );
	}	
}
add_action( 'plugins_loaded', 'sw_megamenu_construct', 20 );

function swg_register_megamenu_elementor_widgets(){
	include( MMNPATH . '/includes/sw-elementor-menu-widget.php' );
}

/*
** Load script
*/
function sw_megamenu_enqueue_script(){	
	if( !is_admin() ){
		wp_register_style('swg-megamenu-style',  plugins_url( 'css/style.css', __FILE__ ), array(), null);	
		wp_enqueue_style('swg-megamenu-style');
		if( is_rtl() ){
			wp_enqueue_style('rtl-swg-megamenu-style',  plugins_url( 'css/rtl.css', __FILE__ ), array(), null);	
		}
		if ( !wp_script_is('swg-megamenu') ){
			wp_register_script( 'swg-megamenu', plugins_url( 'js/megamenu.js', __FILE__ ),array(), null, true );
			wp_enqueue_script('swg-megamenu');			
		}
	}
}