<?php 
/*
** Register taxonomy for Header & Footer Template
*/
add_action( 'init', 'swg_header_footer_register', 5 );
/* add_action( 'admin_init', 'swg_header_footer_init' );
add_action( 'save_post', 'swg_header_footer_save_meta', 10, 1 ); */


/* Register Post Type */
function swg_header_footer_register() {
	$labels = array(
		'name' => __('Header & Footer', 'sw_core' ),
		'singular_name' => __('Header & Footer', 'sw_core'),
		'add_new' => __('Add New', 'sw_core'),
		'add_new_item' => __('Add New Header or Footer', 'sw_core'),
		'edit_item' => __('Edit Item', 'sw_core'),
		'new_item' => __('New Item', 'sw_core'),
		'view_item' => __('View Item', 'sw_core'),
		'search_items' => __('Search Item', 'sw_core'),
		'not_found' =>  __('Nothing found', 'sw_core'),
		'not_found_in_trash' => __('Nothing found in Trash', 'sw_core'),
		'parent_item_colon' => ''
	);

	$args = array(
		'labels' => $labels,
		'public' => true,
		'has_archive' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'query_var' => true,
		'menu_icon' => 'dashicons-id',
		'rewrite' =>  true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'menu_position' => 20,
		'supports' => array('title','author', 'editor')
	  ); 

	register_post_type( 'hftemplate' , $args );
}

function swg_header_footer_init(){
	add_meta_box( 'swg_hftemplate', esc_html__( 'Header - Footer Config', 'sw_core' ), 'swg_hftemplate', array( 'hftemplate' ), 'normal', 'low' );
}

function swg_hftemplate( $post ){
	$postid = $post->ID;
	$pages = get_pages(); 		
	$options = get_option( 'swg_template_condition' );	
?>
	<div class="item-header-template">
		<div class="box-item">
			<label><?php echo esc_html__( 'Template Type: ', 'sw_core' ); ?></label> <br/>
			<select name="template_type">
				<option value="header" <?php echo ( isset( $options['header'][$postid ] ) ) ? 'selected' : ''; ?>><?php echo esc_html__( 'Header', 'sw_core' ); ?></option>
				<option value="footer" <?php echo ( isset( $options['footer'][$postid ] ) ) ? 'selected' : ''; ?>><?php echo esc_html__( 'Footer', 'sw_core' ); ?></option>
			</select>
		</div>
		<div class="box-template-select">
			<label><?php echo esc_html__( 'Template Condition', 'sw_core' ); ?></label> <br/>
			<div class="item-template">
				<select name="template_show">
					<option value="all" <?php echo ( ( isset( $options['header'][$postid ] ) && $options['header'][$postid ][0] === 'all' ) || ( isset( $options['footer'][$postid ] ) && $options['footer'][$postid ][0] === 'all' ) ) ? 'selected' : ''; ?>><?php echo esc_html__( 'All', 'sw_core' ); ?></option>
					<option value="page" <?php echo ( ( isset( $options['header'][$postid ] ) && $options['header'][$postid ][0] === 'page' ) || ( isset( $options['footer'][$postid ] ) && $options['footer'][$postid ][0] === 'page' ) ) ? 'selected' : ''; ?>><?php echo esc_html__( 'Page', 'sw_core' ); ?></option>
				</select>				
				<select name="template_page_id">
					<option value="0"><?php echo esc_html__( 'Select Page' ); ?></option>
				<?php foreach ( $pages as $page ) { ?>
				
						<option value="<?php echo esc_attr( $page->ID ) ?>" <?php echo ( ( isset( $options['header'][$postid ] ) && $options['header'][$postid ][1] == $page->ID ) || ( isset( $options['footer'][$postid ] ) && $options['footer'][$postid ][1] == $page->ID ) ) ? 'selected' : ''; ?>><?php echo esc_html( $page->post_title ) ?></option>
				<?php }	?>
				</select>
			</div>
		</div>
		<input type="hidden" name="post_type" value="<?php echo esc_attr( $post->post_type ); ?>"/>
	</div>
<?php 
}

function swg_header_footer_save_meta( $post_id ){
	$type = isset( $_POST['template_type'] ) ? $_POST['template_type'] : 'header';
	$show = isset( $_POST['template_show'] ) ? $_POST['template_show'] : 'all';
	$page_id = isset( $_POST['template_page_id'] ) ? $_POST['template_page_id'] : 0;
	$revisions = wp_get_post_revisions( $post_id );
	if( isset(  $_POST['hftemplate'] ) && $_POST['hftemplate'] != 'hftemplate' ){
		return;
	}
	$options = get_option( 'swg_template_condition' );
	if( !$options ){
		$option = array();
		if( $type === 'header' ){
			$option['header'][$post_id] = array( $show, $page_id );			
		}
		if( $type === 'footer' ){
			$option['footer'][$post_id] = array( $show, $page_id );			
		}
		update_option( 'swg_template_condition', $option );
	}elseif( is_array( $options ) ){
		if( $type === 'header' ){
			$options['header'][$post_id] = array( $show, $page_id );
			unset( $options['footer'][$post_id] );
		}
		if( $type === 'footer' ){
			$options['footer'][$post_id] = array( $show, $page_id );
			unset( $options['header'][$post_id] );
		}
		foreach( $revisions as $revision ){
			unset( $options['header'][$revision->ID] );
			unset( $options['footer'][$revision->ID] );
		}
		array_unique($options);
		update_option( 'swg_template_condition', $options );
	}
}

function swg_check_conditions( $type ){
	$args = get_option( 'swg_template_condition' );
	if( !is_array( $args ) ){
		return;
	}
	
	foreach( $args as $key => $values ){
		if( $key === $type ){
			$page_id = 0;
			foreach( $values as $key => $value ){
				if( $value[0] === 'page' && get_the_ID() == $value[1] ){
					$page_id = $key;
					break;
				}
				elseif( $value[0] === 'all' ){
					$page_id = $key;
					continue 1;
				}
			}
			if( defined( 'ELEMENTOR_VERSION' ) && \Elementor\Plugin::$instance->documents->get( $page_id ) ){
				echo \Elementor\Plugin::$instance->frontend->get_builder_content( $page_id );
			}
		}
	}
}

/* add_action( 'template_redirect', 'swg_custom_template_redirect' );

function swg_custom_template_redirect(){
	if ( ! did_action( 'swg_core/register_location' ) ) {			
		do_action( 'swg_core/register_location' );
	}
}

add_action( 'swg_core/register_location', 'swg_custom_location_header_footer' ); 
function swg_custom_location_header_footer(){
	$header = ( !empty( swg_options( 'header_layout' ) ) ) ? swg_options( 'header_layout' ) : false;
	$footer = ( !empty( swg_options( 'footer_layout' ) ) ) ? swg_options( 'footer_layout' ) : false;
	if( !swg_mobile_check() ){
		if( $header ){
			add_action( 'get_header', 'swg_customize_header', 10, 2 );
		}
		if( $footer ){
			add_action( 'get_footer', 'swg_customize_footer', 10, 2 );
		}
	}
}


function swg_customize_header( $name, $args = array() ){
	include( 'template-header.php' );
	$templates = array();
	$name      = (string) $name;
	if ( '' !== $name ) {
		$templates[] = "header-{$name}.php";
	}
	
	$templates[] = 'header.php';
	remove_all_actions( 'wp_head' );
	
	ob_start();
	if ( ! locate_template( $templates, true, true, $args ) ) {
		return false;
	}
	ob_get_clean();
}

function swg_customize_footer( $name = null, $args = array() ) {
	include( 'template-footer.php' );
	$templates = array();
	$name      = (string) $name;
	if ( '' !== $name ) {
		$templates[] = "footer-{$name}.php";
	}

	$templates[] = 'footer.php';
	remove_all_actions( 'wp_footer' );
	ob_start();
	if ( ! locate_template( $templates, true, true, $args ) ) {
		return false;
	}
	ob_get_clean();
}
 */
function swg_register_document_controls_template( $document ) {
	
    if ( !get_post_type() === 'hftemplate' || ! $document::get_property( 'has_elements' ) ) {
        return;
    }
	$document->start_controls_section(
        'section_template',
        [
            'label' => esc_html__( 'Template Type', 'textdomain' ),
            'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
        ]
    );

	$document->add_control(
		'template_type',
		[
			'label' => esc_html__( 'Type', 'sw_core' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [
				''		 => __( 'Select Type', 'sw_core' ),
				'header' => __( 'Header', 'sw_core' ),
				'footer' => __( 'Footer', 'sw_core' )
			],
		]
	);

    $document->end_controls_section();
}
add_action( 'elementor/documents/register_controls', 'swg_register_document_controls_template' );
/*
**
*/
add_filter( 'template_include', 'swg_hftemplate_include' );
function swg_hftemplate_include( $template ){
	if( is_singular( 'hftemplate' ) ){
		$template = sw_core_override_check( 'templates', 'single-hftemplate' );
	}
	return $template;
}


/*
** Custom Column hf template
*/
add_filter( "manage_hftemplate_posts_columns", function ( $defaults ) {
	$defaults['shortcode'] = __( 'Shortcode', 'sw_core' );
	return $defaults;
});

add_action( 'manage_hftemplate_posts_custom_column', 'swg_manage_hftemplate_custom_column_callback', 10,2 );
function swg_manage_hftemplate_custom_column_callback( $column_name, $post_id ) {
	if( $column_name === 'shortcode' ){
		echo "[swg_template id=$post_id]";
	}
}

/*
** Customize post state
*/
add_filter( 'display_post_states', 'swg_add_display_post_states', 10, 2 );

/**
 * Add a post display state for special WC pages in the page list table.
 *
 * @param array   $post_states An array of post display states.
 * @param WP_Post $post        The current post object.
 */
function swg_add_display_post_states( $post_states, $post ) {
	if( $post->post_type === 'hftemplate' && function_exists( 'emarket_options' ) ){
		if( $post->ID == emarket_options()->getCpanelValue( 'header_layout' ) ){
			$post_states['header_template'] = __( 'Header Activated', 'sw_core' );
		}
		if( $post->ID == emarket_options()->getCpanelValue( 'mobile_header' ) ){
			$post_states['header_template'] = __( 'Header Mobile Activated', 'sw_core' );
		}
		if( $post->ID == emarket_options()->getCpanelValue( 'footer_layout' ) ){
			$post_states['header_template'] = __( 'Footer Activated', 'sw_core' );
		}
		if( $post->ID == emarket_options()->getCpanelValue( 'mobile_footer' ) ){
			$post_states['header_template'] = __( 'Footer Mobile Activated', 'sw_core' );
		}
	}
	return $post_states;
}

/*
*** Add a shortcode hftemplate
*/
add_shortcode( 'swg_template', 'swg_template_callback' );
function swg_template_callback( $atts ){
	extract( shortcode_atts(
		array(			
			'id' => '',
		), $atts )
	);
	ob_start();
	if( defined( 'ELEMENTOR_VERSION' ) && \Elementor\Plugin::$instance->documents->get( $id ) ){
		echo \Elementor\Plugin::$instance->frontend->get_builder_content( $id );
	}
	$content = ob_get_clean();
	return $content;
}
