/**
 * script.js
 *
 * @copyright  2021 Add on elements. All rights reserved.
 * @license MIT
 */
 (function ($) {
 	"use strict";
	var swg_bfimage = { 		
		swe_bfimage: function($target) {
 			let wraps = $target.find('.swg-before-after-image');
 			$.each(wraps, function(item) {
				const $before = $(wraps[item]).data('before_title');
				const $after = $(wraps[item]).data('after_title');
				const $separator_color = $(wraps[item]).data('separator_color');
				const $bullet_color = $(wraps[item]).data('bullet_color');
				const $arrow_color = $(wraps[item]).data('arrow_color');
				const $separator_position = $(wraps[item]).data('separator_position');
				const $opacity = $(wraps[item]).data('opacity');
				const $active_opacity = $(wraps[item]).data('active_opacity');
				const $hover_opacity = $(wraps[item]).data('hover_opacity');
				$(wraps[item]).beforeAfter({
					movable: true,
					clickMove: true,
					position: $separator_position,
					separatorColor: $separator_color,
					bulletColor: $bullet_color,
					arrowColor: $arrow_color,
					before_title: $before,
					after_title: $after,
					opacity: $opacity,
					activeOpacity: $active_opacity,
					hoverOpacity: $hover_opacity,					
				});
			});
 		},
	};
    $(window).on('elementor/frontend/init', function () {       
		elementorFrontend.hooks.addAction(
            "frontend/element_ready/swg-before-after-image.default",
            swg_bfimage.swe_bfimage
		);			
    });  
})(jQuery);
