<?php 
namespace WCPATH\SWG_Gallery_Images;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Control_Media;

final class SWG_Gallery_Images extends Widget_Base{	
	function get_name() {
		return 'swg-gallery-images';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE Gallery Images', 'sw_core');
	}

	/**
	 * @return array
	 */

	
	public function get_categories() {
		return [ 'sw-post-elements' ];
	}
	
	public function get_icon() {
		return 'eicon-gallery-grid';
	}
	
	public function get_style_depends() {
		return ['slick'];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'slick', 'swwe-script' ];
	}
	
	public function register_controls() {		
		
		
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);	
		
		$this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Images', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);
		
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
			]
		);
		
		$this->add_control('columns', [
			'label' => __( 'Columns', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 4,
			],
		]);
		
		$this->add_control('columns_tablet', [
			'label' => __( 'Columns Tablet', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 4,
			],
		]);	
		
		$this->add_control('columns_mobile', [
			'label' => __( 'Columns mobile', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 4,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 4,
			],
		]);			
		
		$this->end_controls_section();		
		
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Style', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);	
		
		$this->add_control('column_gap', [
			'label' => __( 'Column Gap', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .gallery' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_control('row_gap', [
			'label' => __( 'Row Gap', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .gallery' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
			],
		]);
		
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .gallery > li > a > img',
				'separator' => 'before',
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .gallery > li > a > img',
			]
		);
		
		$this->start_controls_tabs( 'image_effects' );

		$this->start_controls_tab( 'normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'opacity',
			[
				'label' => esc_html__( 'Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .gallery > li > a > img' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}} .gallery > li > a > img',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border_hover',
				'selector' => '{{WRAPPER}} .gallery > li:hover > a > img',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'opacity_hover',
			[
				'label' => esc_html__( 'Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .gallery > li:hover > a > img' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters_hover',
				'selector' => '{{WRAPPER}} .gallery > li:hover > a > img',
			]
		);

		$this->add_control(
			'background_hover_transition',
			[
				'label' => esc_html__( 'Transition Duration', 'elementor' ) . ' (s)',
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 3,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .gallery > li > a > img' => 'transition-duration: {{SIZE}}s',
				],
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'elementor' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();	
		
		$this->add_control(
			'box_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gallery > li > a > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .gallery > li > a > img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
	}	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( empty( $settings['gallery'] ) ) {
			return;
		}
		$imgClass = '';
		if ( isset( $settings['hover_animation'] ) && '' !== $settings['hover_animation'] ) {
			$imgClass = 'elementor-animation-' .$settings['hover_animation'];
		}
	?>	
		<div class="swg-gallery">
			<ul class="thumbnails photobox-gallery gallery gallery-columns-<?php echo esc_attr( $settings['columns']['size'] ) ?> columns-tablet-<?php echo esc_attr( $settings['columns_tablet']['size'] ) ?> columns-mobile-<?php echo esc_attr( $settings['columns_mobile']['size'] ) ?>">
				<?php 			
				foreach ( $settings['gallery'] as $index => $attachment ) {
					$image_url = Group_Control_Image_Size::get_attachment_image_src( $attachment['id'], 'thumbnail', $settings );

					if ( ! $image_url && isset( $attachment['url'] ) ) {
						$image_url = $attachment['url'];
					}
					$image_full = wp_get_attachment_image_src( $attachment['id'], 'full' );
				?>
				<li>
					<a href="<?php echo esc_url( $image_full[0] ); ?>"><img class="<?php echo esc_attr( $imgClass ); ?>"  src="<?php echo esc_attr( $image_url ) ?>" alt="<?php echo esc_attr( Control_Media::get_image_alt( $attachment ) ) ?>" /></a>
				</li>
				<?php } ?>	
				
			</ul>
		</div>
	<?php 
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SWG_Gallery_Images());
?>