<?php 
namespace WCPATH\SWG_LIST_STORE;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use ElementorPro\Plugin;

final class SWG_List_Store extends Widget_Base{	
	function get_name() {
		return 'swg_list_store';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE List Store', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-post-elements' ];
	}
	
	public function get_icon() {
		return 'eicon-product-tabs';
	}
	
	public function get_script_depends() {
		return [ 'swg-core' ];
	}
	
	public function register_controls() {		
		
		
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);	
		
		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'tab' => esc_html__( 'Tab', 'sw_core' ),
					'slider' => esc_html__( 'Slider', 'sw_core' ),
				],
				'default' => 'tab',
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_image',
			[
				'label' => esc_html__( 'Choose Image', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],		
			]
		);
		
		$repeater->add_control(
			'list_title',
			[
				'label' => esc_html__( 'Title', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'List Title' , 'sw_core' ),
				'label_block' => true,			
			]
		);
		
		$repeater->add_control(
			'list_content',
			[
				'label' => esc_html__( 'Content', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => '',
				'label_block' => true,			
			]
		);
		
		$repeater->add_control(
			'list_link',
			[
				'label' => esc_html__( 'Link', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'label_block' => true,		
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'List Store', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'list_title' => esc_html__( 'Title #1', 'sw_core' ),
						'list_image' => '',
						'list_content' => '',
						'list_link'	 => '',
					],
					[
						'list_title' => esc_html__( 'Title #2', 'sw_core' ),
						'list_image' => '',
						'list_content' => '',
						'list_link'	 => '',
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'include' => [],
				'default' => 'thumbnail',
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section( 'slider_config', [
			'label' => __( 'Slider Config', 'sw-woo-elements' ),
			'tab' => Controls_Manager::TAB_CONTENT,
			'condition' => [
				'layout' => [ 'slider' ],
			]
		]);

		$this->add_control('slides_to_show', [
			'label' => __( 'Slides To Show', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 4,
			],
		]);
		
		$this->add_control('slides_to_show_tablet', [
			'label' => __( 'Slides To Show Tablet', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 3,
			],
		]);
		
		$this->add_control('slides_to_show_mobile', [
			'label' => __( 'Slides To Show Mobile', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 2,
			],
		]);	
		
		$this->add_responsive_control('slides_space', [
			'label' => __( 'Space Items', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 30,
			],
			'selectors' => [
				'{{WRAPPER}} .slick-slider .slick-list' => 'margin: 0 calc(-{{SIZE}}px/2);',
				'{{WRAPPER}} .slick-slider .slick-slide' => 'margin: 0 calc({{SIZE}}px/2);',
			],
		]);
	   

		$this->add_control( 'pause_on_hover', [
			'label' => __( 'Pause On Hover', 'sw-woo-elements' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw-woo-elements' ),
			'label_off' => __( 'Hide', 'sw-woo-elements' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);	
		
		$this->end_controls_section();
		
		/**
		* Style tab item
		*/
		$this->start_controls_section( 'section_style_tab_item', [
			'label' => __( 'Tab Items', 'sw_core' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]);

		$this->add_responsive_control( 'tab_item_position', [
			'label'                => __( 'Position', 'sw_core' ),
			'type'                 => Controls_Manager::CHOOSE,
			'label_block'          => false,
			'options'              => [
                'left'   => [
                    'title' => __( 'Left', 'sw_core' ),
                    'icon'  => 'eicon-h-align-left',
                ],
                'center' => [
                    'title' => __( 'Center', 'sw_core' ),
                    'icon'  => 'eicon-h-align-center',
                ],
                'right'  => [
                    'title' => __( 'Right', 'sw_core' ),
                    'icon'  => 'eicon-h-align-right',
                ]
            ],
			'selectors'            => [
				'{{WRAPPER}} .swe-wrap-tab-head' => '{{VALUE}}',
			],
			'selectors_dictionary' => [
				'left'   => 'justify-content: flex-start;',
				'center' => 'justify-content: center;',
				'right'  => 'justify-content: flex-end;',
			],
		]);

		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name' => 'tab_item_typography',
			'selector' => '{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title',
		]);

		$this->start_controls_tabs( 'tab_item_tabs' );

		$this->start_controls_tab( 'tab_item_normal', [
			'label' => __( 'Normal', 'sw_core' ),
		]);

		$this->add_control( 'tab_item_color', [
			'label' => __( 'Color', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title' => 'color: {{VALUE}};',
			],
		]);

		$this->add_control( 'tab_item_bg', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title' => 'background: {{VALUE}};',
			],
		]);

		$this->add_group_control( Group_Control_Border::get_type(), [
			'name' => 'tab_item_border',
			'label' => __( 'Border', 'sw_core' ),
			'selector' => '{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title',
		]);

		$this->end_controls_tab();

		$this->start_controls_tab( 'tab_item_hover', [
			'label' => __( 'Hover', 'sw_core' ),
		]);

		$this->add_control( 'tab_item_color_hover', [
			'label' => __( 'Color', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title:hover, {{WRAPPER}} .swe-wrap-tab-head .swe-tab-title.active' => 'color: {{VALUE}};',
			],
		]);

		$this->add_control( 'tab_item_bg_hover', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title:hover, {{WRAPPER}} .swe-wrap-tab-head .swe-tab-title.active' => 'background: {{VALUE}};',
			],
		]);

		$this->add_control( 'tab_item_border_hover', [
			'label' => __( 'Border Color', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title:hover, {{WRAPPER}} .swe-wrap-tab-head .swe-tab-title.active' => 'border-color: {{VALUE}};',
			],
		]);
		
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control( 'tab_item_border_radius', [
			'label'     => __( 'Border Radius', 'sw_core' ),
			'type'      => Controls_Manager::SLIDER,
			'range'     => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'size_units'     => [ '%', 'px' ],
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control( 'tab_item_padding', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-head .swe-tab-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control('tab_item_space', [
			'label' => __( 'Space', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 50,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tabs .swe-wrap-tab-head .swe-tab-title + .swe-tab-title' => 'margin-left: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_responsive_control( 'tab_margin', [
			'label'      => __( 'Margin', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-head' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$this->end_controls_section();

		/**
		* Style tab content
		*/
		$this->start_controls_section( 'section_style_tab_content', [
			'label' => __( 'Tab Content', 'sw_core' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]);	
		
		$this->add_control( 'tab_content_background', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-content' => 'background: {{VALUE}};',
			],
		]);
		
		$this->add_responsive_control( 'tab_content_padding', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$this->add_group_control( Group_Control_Border::get_type(), [
			'name' => 'tab_content_border',
			'label' => __( 'Border', 'sw_core' ),
			'selector' => '{{WRAPPER}} .swe-wrap-tab-content',
		]);

		$this->add_control( 'tab_content_border_radius', [
			'label'     => __( 'Border Radius', 'sw_core' ),
			'type'      => Controls_Manager::SLIDER,
			'range'     => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'size_units'     => [ '%', 'px' ],
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-content' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);		
		
		$this->add_control(
			'image_heading',
			[
				'label' => esc_html__( 'Image', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);	

		$this->add_responsive_control( 'tab_image_width', [
			'label'     => __( 'Width', 'sw_core' ),
			'type'      => Controls_Manager::SLIDER,
			'range'     => [
				'px' => [
					'min' => 100,
					'max' => 2000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'size_units'     => [ '%', 'px' ],
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-img' => 'width: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_group_control( Group_Control_Border::get_type(), [
			'name' => 'tab_image_border',
			'label' => __( 'Border', 'sw_core' ),
			'selector' => '{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-img',
		]);

		
		$this->add_responsive_control( 'tab_image_border_radius', [
			'label'      => __( 'Border Radius', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control( 'tab_image_padding', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control( 'tab_image_margin', [
			'label'      => __( 'Margin', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);
		
		$this->add_control(
			'content_heading',
			[
				'label' => esc_html__( 'Content Items', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);	
		
		$this->add_responsive_control( 'tab_content_alignment', [
			'label'                => __( 'Alignment', 'sw_core' ),
			'type'                 => Controls_Manager::CHOOSE,
			'label_block'          => false,
			'options'              => [
                'left'   => [
                    'title' => __( 'Top', 'sw_core' ),
                    'icon'  => 'eicon-v-align-top',
                ],
                'center' => [
                    'title' => __( 'Center', 'sw_core' ),
                    'icon'  => 'eicon-h-align-center',
                ],
                'right'  => [
                    'title' => __( 'Bottom', 'sw_core' ),
                    'icon'  => 'eicon-v-align-bottom',
                ]
            ],
			'selectors'            => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content' => '{{VALUE}}',
			],
			'selectors_dictionary' => [
				'left'   => 'align-items: flex-start;',
				'center' => 'align-items: center;',
				'right'  => 'align-items: flex-end;',
			],
		]);
		
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name' => 'tab_content_item_typography',
			'selector' => '{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content',
		]);

		$this->add_responsive_control( 'tab_content_item_width', [
			'label'     => __( 'Width', 'sw_core' ),
			'type'      => Controls_Manager::SLIDER,
			'range'     => [
				'px' => [
					'min' => 100,
					'max' => 2000,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'size_units'     => [ '%', 'px' ],
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content' => 'width: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_group_control( Group_Control_Border::get_type(), [
			'name' => 'tab_content_item_border',
			'label' => __( 'Border', 'sw_core' ),
			'selector' => '{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content',
		]);

		
		$this->add_responsive_control( 'tab_content_item_border_radius', [
			'label'      => __( 'Border Radius', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);
		
		$this->add_control( 'tab_content_item_spacing', [
			'label'     => __( 'Spacing Each Line', 'sw_core' ),
			'type'      => Controls_Manager::SLIDER,
			'range'     => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'size_units'     => [ '%', 'px' ],
			'selectors' => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content .item-content-inner p + p' => 'margin-top: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control( 'tab_content_item_padding', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control( 'tab_content_item_margin', [
			'label'      => __( 'Margin', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);
		
		$this->add_control(
			'content_tab_heading',
			[
				'label' => esc_html__( 'Content Heading Title', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);	
		
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name' => 'tab_content_heading_typography',
			'selector' => '{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h1, 
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h2, 
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h3,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h4,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h5,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h6',
		]);
		
		$this->add_group_control( Group_Control_Border::get_type(), [
			'name' => 'tab_content_heading_border',
			'selector' => '{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h1, 
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h2, 
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h3,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h4,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h5,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h6',
		]);
		
		$this->add_responsive_control( 'tab_content_heading_margin', [
			'label'      => __( 'Margin', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h1, 
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h2, 
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h3,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h4,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h5,
			{{WRAPPER}} .swe-wrap-tab-content .liststore-content .item-content h6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$this->end_controls_section();
		
	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$lists = $settings['list'];
		$layout = isset( $settings['layout'] ) ? $settings['layout'] : 'tab';
		if( $layout === 'slider' ){
			$this->add_render_attribute( 'slider_options', [
			'data-slides_to_show'   => $settings[ 'slides_to_show' ] ? $settings[ 'slides_to_show' ]['size'] : 2,
			'data-slides_to_show_tablet'   => isset($settings[ 'slides_to_show_tablet' ]) ? $settings[ 'slides_to_show_tablet' ]['size'] : 2,
			'data-slides_to_show_mobile'   => isset($settings[ 'slides_to_show_mobile' ]) ? $settings[ 'slides_to_show_mobile' ]['size'] : 2,

			'data-slides_to_rows'   =>  1,
			'data-slides_to_rows_tablet'   =>  1,
			'data-slides_to_rows_mobile'   =>  1,

			'data-slides_to_scroll'   => 1,

			'data-arrows' => 'yes',
			'data-arrows_tablet' => 'yes',
			'data-arrows_mobile' => 'yes',

			'data-dots'   => '',
			'data-dots_tablet'   => '',
			'data-dots_mobile'   => '',

			'data-pause_on_hover'   => $settings[ 'pause_on_hover' ],
			'data-autoplay'   => 'no',
			'data-fade'   => 'fade',
			'data-speed' => 500,
			'data-autoplay_speed' => 0,
			'data-infinite'   => 'yes',
			'data-lazyload' => '',
			'data-variable_width' => 'false',

		]);

		$settings['slider_options'] = $this->get_render_attribute_string('slider_options');			
	?>
		<div class="swg-list-store swe-slider">
			<ul class="list-images-wrapper swe-slider" <?php echo $settings['slider_options']; ?>>
			<?php foreach( $lists as $key => $list ){ ?>
				<li>
					<div class="liststore-content">
					<?php if( wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ) ) { ?>
						<div class="item-img">
							<?php echo wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ); ?>
						</div>
					<?php } ?>
					
					<?php if( !empty( $list['list_content'] ) ) { ?>
						<div class="item-content">
							<div class="item-content-inner">
								<?php echo wp_kses_post( $list['list_content'] ); ?>
							</div>
						</div>
					<?php } ?>
					</div>
				</li>
			<?php } ?>
			</ul>
		</div>
	<?php }else{ ?>
		<div class="swg-list-store swe-wrap-tabs">
			<div class="swe-wrap-tab-head">		
				<div class="swe-tab-head">
				<?php foreach( $lists as $key => $list ){ ?>
					<div id="<?php echo esc_attr( 'swe-tab-title-'. $list['_id'] ) ?>" class="swe-tab-title <?php echo esc_attr( $key === 0 ? 'active' : '' ); ?>" aria-selected="true" data-tab="<?php echo esc_attr( $key ); ?>" role="tab" tabindex="0" aria-controls="<?php echo esc_attr( 'swe-tab-content-'. $list['_id'] ) ?>" aria-expanded="false">
						<?php echo esc_html( $list['list_title'] ); ?>
					</div>
				<?php } ?>
				</div>
			</div>
			<div class="swe-wrap-tab-content">
			<?php foreach( $lists as $key => $list ){ ?>
				<div id="<?php echo esc_attr( 'swe-tab-content-'. $list['_id'] ) ?>" class="swe-tab-content <?php echo esc_attr( $key === 0 ? 'active' : '' ); ?>" aria-selected="true">
					<div class="liststore-content">
					<?php if( wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ) ) { ?>
						<div class="item-img">
							<?php echo wp_get_attachment_image( $list['list_image']['id'], $settings['thumbnail_size'] ); ?>
						</div>
					<?php } ?>
					
					<?php if( !empty( $list['list_content'] ) ) { ?>
						<div class="item-content">
							<div class="item-content-inner">
								<?php echo wp_kses_post( $list['list_content'] ); ?>
							</div>
						</div>
					<?php } ?>
					</div>
				</div>
			<?php } ?>
			</div>
		</div>
	<?php 
		}
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SWG_List_Store());