<?php 
namespace Elementor;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;


final class SW_Popup_Login_elementor extends Widget_Base{
	function get_name() {
		return 'swg-login';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE Login Ajax', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-woo-elements', 'sw-post-elements' ];
	}
	
	public function get_icon() {
		return 'eicon-lock-user';
	}
	
	public function get_available_menus(){
		$all_categories = wp_get_nav_menus();

		$data = array();
		if( $all_categories ){
			foreach ($all_categories as $cat) {
				$data[$cat->name] = $cat->name;
			}
		}
		return $data;
	}
	
	public function register_controls() {
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);		
		$this->add_control(
			'description',
			array(
				'label'   => __( 'Title', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
			)
		);
		$this->add_control(
			'title',
			array(
				'label'   => __( 'Login Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Login', 'sw_core' ),
			)
		);
		$this->add_control(
			'title_register',
			array(
				'label'   => __( 'Register Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Register', 'sw_core' ),
			)
		);		
		
		$this->add_control(
			'title_logout',
			array(
				'label'   => __( 'Logout Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Logout', 'sw_core' ),
			)
		);
		$this->add_control(
			'title_welcome',
			array(
				'label'   => __( 'Welcome Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
			)
		);
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'sw_core' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'sw_core' ),
							'icon' => 'eicon-user-circle-o',
						],						
					],
				],
				'default' => [
					'value' => 'fas fa-user',
					'library' => 'fa-solid',
				],
			]
		);	
		
		$this->add_control(
			'show_popup',
			[
				'label' => esc_html__( 'Show Popup', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'sw_core' ),
				'label_off' => esc_html__( 'Hide', 'sw_core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_icon',
			[
				'label' => esc_html__( 'Show Only Icon', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'sw_core' ),
				'label_off' => esc_html__( 'Hide', 'sw_core' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$this->add_control(
			'load_menu',
			[
				'label' => esc_html__( 'Load Menu As Dropdown', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'sw_core' ),
				'label_off' => esc_html__( 'Hide', 'sw_core' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$menus = $this->get_available_menus();
		if ( ! empty( $menus ) ) {
			$this->add_control(
				'menu',
				[
					'label' => esc_html__( 'Menu', 'sw_core' ),
					'type' => Controls_Manager::SELECT,
					'options' => $menus,
					'default' => array_keys( $menus )[0],
					'save_default' => true,
					'separator' => 'after',
					'description' => sprintf(
						/* translators: 1: Link opening tag, 2: Link closing tag. */
						esc_html__( 'Go to the %1$sMenus screen%2$s to manage your menus.', 'sw_core' ),
						sprintf( '<a href="%s" target="_blank">', admin_url( 'nav-menus.php' ) ),
						'</a>'
					),
					'condition' => [
						'load_menu' => 'yes',
					]	
				]
			);
		} else {
			$this->add_control(
				'menu',
				[
					'type' => Controls_Manager::RAW_HTML,
					'raw' => '<strong>' . esc_html__( 'There are no menus in your site.', 'sw_core' ) . '</strong><br>' .
							sprintf(
								/* translators: 1: Link opening tag, 2: Link closing tag. */
								esc_html__( 'Go to the %1$sMenus screen%2$s to create one.', 'sw_core' ),
								sprintf( '<a href="%s" target="_blank">', admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
								'</a>'
							),
					'separator' => 'after',
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}
		
		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_popup',
			array(
				'label' => __( 'Popup Configurations', 'sw_core' ),
				'condition' => [
					'show_popup' => 'yes',
				]
			)
		);
		$this->add_control(
			'title_popup',
			array(
				'label'   => __( 'Title', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Sign in or register', 'sw_core' ),
			)
		);
		$this->add_control(
			'title_popup_login',
			array(
				'label'   => __( 'Button Login Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' =>  __( 'Login', 'sw_core' ),
			)
		);			
		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'title_popup_username',
			[
				'label' => esc_html__( "Username's Placeholder", 'sw_core' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
				'default' => esc_html__( 'Username', 'sw_core' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);		
		$this->add_control(
			'title_popup_password',
			[
				'label' => esc_html__( "Password's Placeholder", 'sw_core' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
				'default' => esc_html__( 'Password', 'sw_core' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);		
		$this->add_control(
			'user_icon',
			[
				'label' => esc_html__( 'User Icon', 'sw_core' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'sw_core' ),
							'icon' => 'fas fa-user-alt',
						],						
					],
				],
				'default' => [
					'value' => 'fas fa-user-alt',
					'library' => 'fa-solid',
				],
			]
		);	
		
		$this->add_control(
			'pass_icon',
			[
				'label' => esc_html__( 'Password Icon', 'sw_core' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'sw_core' ),
							'icon' => 'fas fa-lock',
						],						
					],
				],
				'default' => [
					'value' => 'fas fa-lock',
					'library' => 'fa-solid',
				],
			]
		);	
		
		$this->add_control(
			'hr1',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'title_register_content',
			[
				'label' => esc_html__( 'Registration', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_control(
			'content_popup',
			array(
				'label'   =>__( 'Content', 'sw_core' ),
				'type'    => Controls_Manager::WYSIWYG,
				'default' => '',
			)
		);
		
		$this->add_control(
			'title_popup_create',
			array(
				'label'   => __( 'Button Create Account Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' =>  __( 'Create account', 'sw_core' ),
			)
		);
			
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style_content',
			[
				'label' => esc_html__( 'Content Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE			
			]
		);
		
		$this->add_responsive_control(
			'content_align',
			[
				'label' => esc_html__( 'Align', 'sw_core' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Left', 'sw_core' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sw_core' ),
						'icon' => 'eicon-h-align-center',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', 'sw_core' ),
						'icon' => 'eicon-h-align-right',
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .top-login > ul > li' => 'justify-content: {{VALUE}}',
				],				
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .top-login > ul > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .top-login > ul > li' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->add_control(
			'content_icon_config',
			[
				'label' => esc_html__( 'Icon', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_responsive_control(
			'content_icon_size',
			[
				'label' => esc_html__( 'Size', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'size' => 14,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .login-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_icon_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .top-login > ul > li .login-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .top-login > ul > li .login-icon' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'content_icon_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .top-login > ul > li .login-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .top-login > ul > li .login-icon' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->start_controls_tabs( 'tabs_content_icon_colors' );

		$this->start_controls_tab(
			'tab_content_icon_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);
		
		$this->add_control(
			'content_title_icon_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .login-icon' => 'color: {{VALUE}};',
					'{{WRAPPER}} .login-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_content_icon_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);		
		$this->add_control(
			'content_icon_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .login-icon:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .login-icon:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();		
		
		$this->add_control(
			'content_desc_config',
			[
				'label' => esc_html__( 'Description', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_desc_typography',
				'selector' => '{{WRAPPER}} .login-desc',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);
		
		$this->add_control(
			'content_desc_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .login-desc' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'content_desc_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .login-desc' => 'background-color: {{VALUE}}',
				]				
			]
		);
		
		$this->add_responsive_control(
			'content_desc_space',
			[
				'label' => esc_html__( 'Spacing', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 5,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .login-desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'content_title_config',
			[
				'label' => esc_html__( 'Title Login', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_title_typography',
				'selector' => '{{WRAPPER}} .swg-login ul > li a',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_content_title_colors' );

		$this->start_controls_tab(
			'tab_content_title_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);
		
		$this->add_control(
			'content_title_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-login ul > li' => 'color: {{VALUE}};',
					'{{WRAPPER}} .swg-login ul > li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_content_title_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);		
		$this->add_control(
			'content_title_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-login ul > li:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .swg-login ul > li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();		
		
		
		$this->add_responsive_control(
			'content_title_space',
			[
				'label' => esc_html__( 'Spacing', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .swg-login ul > li a' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
			
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style_content_popup',
			[
				'label' => esc_html__( 'Content Popup Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_popup' => 'yes',
				]
			]
		);
		
		$this->add_control(
			'content_popup_title_config',
			[
				'label' => esc_html__( 'Heading Popup', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'popup_title_typography',
				'selector' => '{{WRAPPER}} #login_form .tt_popup_login',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);
		
		$this->add_control(
			'popup_title_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} #login_form .tt_popup_login' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_control(
			'popup_title_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #login_form .tt_popup_login' => 'background-color: {{VALUE}}',
				]				
			]
		);
		
		$this->add_responsive_control(
			'popup_title_space',
			[
				'label' => esc_html__( 'Padding', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 5,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  #login_form .tt_popup_login' => 'padding: {{SIZE}}{{UNIT}};'
				],
			]
		);
		
		$this->add_control(
			'content_popup_input_config',
			[
				'label' => esc_html__( 'Input Style', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'popup_input_typography',
				'selector' => '{{WRAPPER}} #login_form .block-popup-login .input-text',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);
		
		$this->add_control(
			'popup_input_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} #login_form .block-popup-login .input-text' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_control(
			'popup_input_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #login_form .block-popup-login .input-text' => 'background-color: {{VALUE}}'
				]				
			]
		);
		
		$this->add_responsive_control(
			'popup_input_space',
			[
				'label' => esc_html__( 'Padding', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 5,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  #login_form .block-popup-login .input-text' => 'padding: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_responsive_control(
			'popup_input_spacing',
			[
				'label' => esc_html__( 'Spacing', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 5,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .block-popup-login .block-content .col-reg .input-login' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		
		$this->add_control(
			'popup_input_border_color',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .input-text' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'popup_input_border_width',
			[
				'label' => esc_html__( 'Border Width', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .input-text' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->add_control(
			'popup_input_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .input-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .block-popup-login .input-text' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->add_control(
			'content_popup_icon_config',
			[
				'label' => esc_html__( 'Icon', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .block-content .col-reg .input-login span' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'icon_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .block-content .col-reg .input-login span' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'icon_border',
				'selector' => '{{WRAPPER}} .block-popup-login .block-content .col-reg .input-login span',
			]
		);
		
		$this->add_control(
			'popup_icon_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .block-content .col-reg .input-login span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .block-popup-login .block-content .col-reg .input-login span' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->add_control(
			'content_popup_button_config',
			[
				'label' => esc_html__( 'Button', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .block-popup-login .btn-custom',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition' => [
					'button_type' => 'text',
				]				
			]
		);

		$this->start_controls_tabs( 'tabs_button_colors' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .btn-submit-login' => 'color: {{VALUE}}',
					'{{WRAPPER}} .block-popup-login .btn-reg-popup' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .btn-submit-login' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .block-popup-login .btn-reg-popup' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'button_text_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .btn-submit-login:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .block-popup-login .btn-reg-popup:hover' => 'color: {{VALUE}}'
				],
			]
		);
		
		$this->add_control(
			'button_border_color_hover',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .btn-submit-login:hover' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .block-popup-login .btn-reg-popup:hover' => 'border-color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'button_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .btn-submit-login:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .block-popup-login .btn-reg-popup:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		

		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .block-popup-login .btn-reg-popup, {{WRAPPER}} .block-popup-login .btn-submit-login',
			]
		);
		
		$this->add_responsive_control(
			'popup_button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .block-popup-login .btn-reg-popup, {{WRAPPER}} .block-popup-login .btn-submit-login' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);
				
		$this->end_controls_section();		
		
		$this->start_controls_section(
			'section_content_menu',
			[
				'label' => __( 'Menu Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,			
				'condition' => [
					'load_menu' => 'yes',
				]
			]			
		);
		$this->add_control(
			'content_menu_wrapper',
			[
				'label' => esc_html__( 'Wrapper Style', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_responsive_control(
			'content_menu_width',
			[
				'label' => esc_html__( 'Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul' => 'min-width: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_menu_offset_top',
			[
				'label' => esc_html__( 'Offset Top', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul' => 'top: calc( 100% + {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .top-login ul li ul:before' => 'height: {{SIZE}}{{UNIT}}; top: -{{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'content_menu_offset_left',
			[
				'label' => esc_html__( 'Offset Left', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul' => 'left: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .top-login ul li ul' => 'right: {{SIZE}}{{UNIT}}; left: auto',
					
				],
			]
		);
		
		$this->add_control(
			'content_menu_background',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'content_menu_border',
				'selector' => '{{WRAPPER}} .top-login ul li ul',
			]
		);
		
		$this->add_responsive_control(
			'content_menu_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'content_menu_boxshadow',				
				'selector' => '{{WRAPPER}} .top-login ul li ul',
			]
		);
		
		$this->add_responsive_control(
			'content_menu_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .top-login ul li ul' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->add_control(
			'content_menu_items',
			[
				'label' => esc_html__( 'Menu Items Style', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_menu_item_typography',
				'selector' => '{{WRAPPER}} .top-login ul li ul > li > a',				
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'content_menu_item_border',
				'selector' => '{{WRAPPER}} .top-login ul li ul > li > a',
			]
		);
		
		
		$this->start_controls_tabs( 'tabs_content_menu' );

		$this->start_controls_tab(
			'tab_content_menu_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'content_menu_item_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul > li > a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'content_menu_item_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul > li > a' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_content_menu_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'content_menu_item_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul > li > a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'content_menu_item_border_color_hover',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul > li > a:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'content_menu_item_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul > li > a:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		

		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'content_menu_item_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .top-login ul li ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .top-login ul li ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->end_controls_section();		
	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		extract( $settings );
		$welcome_text = ( $title_welcome ) ? $title_welcome : esc_html__( 'Welcome ', 'sw_core' );
	?>
		<div class="swg-login top-login">
			<ul>
				<li>
				<?php if ( ! is_user_logged_in() ) {  ?>
					<?php if( $settings['show_popup'] === 'yes' ) { ?>
					<a class="elementor-icon login-icon" href="#" data-toggle="modal" data-target="#login_form"><?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></a>
					<?php }else{ ?>
						<a class="elementor-icon login-icon" href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></a>
					<?php } ?>
				<?php }else{ ?>
				<a class="elementor-icon login-icon" href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></a>
				<?php } ?>
				<?php if( $settings['show_icon'] != 'yes' ){ ?>
				<div class="login-right">
				<?php if ( ! is_user_logged_in() ) {  ?>
					<?php if( $description != '' ){ ?>
						<div class="login-desc"><?php echo esc_html( $description ); ?></div>
					<?php } ?>
					<div class="login-heading">
						<?php if( $settings['show_popup'] === 'yes' ) { ?>
							<a href="#" data-toggle="modal" data-target="#login_form"><?php echo esc_html( $title ); ?></a>
						<?php }else{ ?>
							<a href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><?php echo esc_html( $title ); ?></a>
						<?php } ?>
						<?php if( $title_register ){ ?>
							&nbsp/&nbsp;<a class="user-info" href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><?php echo esc_html( $title_register ); ?></a>
						<?php } ?>
					</div>
				<?php } else{ ?>		
					<?php 
						$user_id = get_current_user_id();
						$user_info = get_userdata( $user_id );	
						$username = ( $user_info->last_name ) ? $user_info->last_name : $user_info->user_nicename;
					?>
					<a class="user-info" href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>"><?php echo sprintf( '%s %s', $welcome_text, $username ); ?></a> - 
					<a href="<?php echo wp_logout_url( home_url('/') ); ?>" title="<?php esc_attr_e( 'Logout', 'sw_core' ) ?>"><span><?php echo esc_html( $title_logout ); ?></span></a>
				<?php } ?>
				</div>
				<?php } ?>
				<?php if( $settings['load_menu'] === 'yes' ){ ?>
					<?php wp_nav_menu( array( 'menu' => $settings['menu'], 'menu_class' => 'swg-elementor-menu') ); ?>
				<?php } ?>
				</li>
			</ul>			
		</div>
		<div class="modal fade" id="login_form" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog block-popup-login">
				<a href="#" title="<?php esc_attr_e( 'Close', 'pharxtore' ) ?>" class="close close-login" data-dismiss="modal">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path d="M18.3 5.71a.996.996 0 0 0-1.41 0L12 10.59L7.11 5.7A.996.996 0 1 0 5.7 7.11L10.59 12L5.7 16.89a.996.996 0 1 0 1.41 1.41L12 13.41l4.89 4.89a.996.996 0 1 0 1.41-1.41L13.41 12l4.89-4.89c.38-.38.38-1.02 0-1.4"/></svg>
				</a>
				<div class="tt_popup_login"><strong><?php echo esc_html( $title_popup ) ?></strong></div>
				<form method="post" class="login" id="login_ajax" action="<?php echo wp_login_url(); ?>">
					<div class="block-content">
						<div class="col-reg registered-account">
							<div class="input-login email-input">
								<span><?php \Elementor\Icons_Manager::render_icon( $settings['user_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
								<input type="text" class="input-text username" name="username" id="username" placeholder="<?php echo esc_attr( $title_popup_username ) ?>"/>
							</div>
							<div class="input-login pass-input">
								<span><?php \Elementor\Icons_Manager::render_icon( $settings['pass_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
								<input class="input-text password" type="password" placeholder="<?php echo esc_attr( $title_popup_password ) ?>" name="password" id="password" />
							</div>
							<div class="ft-link-p">
								<a href="<?php echo esc_url( wc_lostpassword_url() ); ?>" title="<?php esc_attr_e( 'Forgot your password', 'pharxtore' ) ?>"><?php esc_html_e( 'Forgot your password?', 'pharxtore' ); ?></a>
							</div>
							<div class="actions">
								<div class="submit-login">
									<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
									<input type="submit" class="button btn-submit-login btn-custom" name="login" value="<?php echo esc_attr( $title_popup_login ); ?>" />
								</div>	
							</div>
							<div id="login_message"></div>							
						</div>
						<div class="col-reg login-customer">
							<?php 
							if( $content_popup ) { 
								$is_dom_optimized = Plugin::$instance->experiments->is_feature_active( 'e_dom_optimization' );
								$is_edit_mode = Plugin::$instance->editor->is_edit_mode();
								$should_render_inline_editing = ( ! $is_dom_optimized || $is_edit_mode );
								$editor_content = $this->get_settings_for_display( 'content_popup' );
								$editor_content = $this->parse_text_editor( $editor_content );

								if ( $should_render_inline_editing ) {
									$this->add_render_attribute( 'content_popup', 'class', [ 'elementor-text-editor', 'elementor-clearfix' ] );
								}

								$this->add_inline_editing_attributes( 'content_popup', 'advanced' );
								?>
								<?php if ( $should_render_inline_editing ) { ?>
									<div <?php $this->print_render_attribute_string( 'content_popup' ); ?>>
								<?php } ?>
								<?php // PHPCS - the main text of a widget should not be escaped.
										echo $editor_content; // phpcs:ignore WordPress.Security.EscapeOutput ?>
								<?php if ( $should_render_inline_editing ) { ?>
									</div>
								<?php } ?>							
							<?php }else{ ?>
							<h2><?php esc_html_e( 'NEW HERE?', 'pharxtore' ); ?></h2>
							<p class="note-reg"><?php esc_html_e( 'Registration is free and easy!', 'pharxtore' ); ?></p>
							<ul class="list-log">
								<li><?php esc_html_e( 'Faster checkout', 'pharxtore' ); ?></li>
								<li><?php esc_html_e( 'Save multiple shipping addresses', 'pharxtore' ); ?></li>
								<li><?php esc_html_e( 'View and track orders and more', 'pharxtore' ); ?></li>
							</ul>
							<?php } ?>
							<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php echo esc_attr( $title_popup_login ); ?>" class="btn-custom btn-reg-popup"><?php echo esc_attr( $title_popup_create ); ?></a>
						</div>
					</div>
				</form>
				<?php do_action('woocommerce_after_customer_login_form'); ?>
			</div>
		</div>
	<?php 
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SW_Popup_Login_elementor());
?>