<?php 
namespace SWPATH\SWG_Single_Categories_Product;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use ElementorPro\Plugin;


final class SW_Single_Categories_Product_elementor extends Widget_Base{

	function get_name() {
		return 'sw-single-categories-product';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SW Single Categories Product', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'woocommerce-elements-single' ];
	}
	
	public function get_icon() {
		return 'eicon-woo-settings';
	}
	
	public function register_controls() {
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);
		$this->add_control(
			'title',
			array(
				'label'   => __( 'Title', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Title', 'sw_core' ),
			)
		);
		
		$this->add_responsive_control( 'show_image', [
			'label' => __( 'Show Image', 'sw_core' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Item Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_group_control( Group_Control_Typography::get_type(), [
			'name' => 'title_typography',
			'selector' => '{{WRAPPER}} .item-categories',
		]);
		
		$this->add_control(
			'title_style',
			[
				'label' => esc_html__( 'Title', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);		
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-categories > span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control( 'title_padding', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .item-categories > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				'body.rtl {{WRAPPER}} .item-categories > span' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
			],
			'separator' => 'after',
		]);
		
		$this->add_control(
			'content_style',
			[
				'label' => esc_html__( 'Content Link', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->start_controls_tabs( 'tabs_content_style' );

		$this->start_controls_tab(
			'tab_content_style_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);
		$this->add_control(
			'link_color',
			[
				'label' => esc_html__( 'Link Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-categories > a' => 'color: {{VALUE}}', // Harder selector to override text color control
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_content_style_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'toggle_heading_hover',
			[
				'label' => esc_html__( 'Link Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-categories > a:hover' => 'color: {{VALUE}}', // Harder selector to override text color control
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_control(
			'content_image_style',
			[
				'label' => esc_html__( 'Content Image', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .item-categories > a > img',
			]
		);
		
		$this->add_responsive_control( 'image_border_radius', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .item-categories > a > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				'body.rtl {{WRAPPER}} .item-categories > a > img' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
			],
			'separator' => 'after',
		]);
		
		$this->add_responsive_control( 'image_padding', [
			'label'      => __( 'Padding', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', 'em', 'rem', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .item-categories > a > img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				'body.rtl {{WRAPPER}} .item-categories > a > img' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
			],
			'separator' => 'after',
		]);
		
		$this->add_responsive_control( 'image_margin', [
			'label'      => __( 'Margin', 'sw_core' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', 'em', 'rem', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .item-categories > a > img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				'body.rtl {{WRAPPER}} .item-categories > a > img' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
			],
			'separator' => 'after',
		]);
		
		$this->end_controls_section();	
	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		global $post, $product;
		$terms = wp_get_object_terms( $post->ID, 'product_cat' );
		
		if( !is_wp_error( $terms ) && count( $terms ) ){
	?>
		<div class="item-categories">
			<?php echo  ( $settings['title'] != '' ) ? '<span>'. esc_html(  $settings['title'] ) .'</span>' : ''; ?>
			<?php 
				foreach( $terms as $key => $term ){
					$thumbnail_id = absint( get_term_meta( $term->term_id, 'thumbnail_id', true ) );
					if( $thumbnail_id && $settings['show_image'] == 'yes' ){
			?>
					<a href="<?php echo get_term_link( $term->term_id, 'product_cat' ); ?>"><img
						src="<?php echo wp_get_attachment_url( $thumbnail_id, 'full' ); ?>" alt="Image"
						title="<?php echo esc_attr( $term->name ); ?>" />
					</a>
				<?php 
					}else{
			?>
					<a href="<?php echo get_term_link( $term->term_id, 'product_cat' ); ?>"><?php echo $term->name; ?></a>
			<?php echo( ( $key + 1 ) === count( $terms ) ) ? '' : ', '; ?>
			<?php 
					}					
				}
			?>
		</div>
		<?php 
		}
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SW_Single_Categories_Product_elementor());
?>