<?php 
namespace WCPATH\SW_Login;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;


final class SW_Popup_Login_elementor extends Widget_Base{
	function get_name() {
		return 'sw_top';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SW Top', 'sw-woocommerce');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'product' ];
	}
	
	public function get_icon() {
		return 'eicon-woo-settings';
	}
	
	public function register_controls() {
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw-woocommerce' ),
			)
		);
		$this->add_control(
			'title',
			array(
				'label'   => __( 'Title', 'sw-woocommerce' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Title', 'sw-woocommerce' ),
			)
		);
		$this->end_controls_section();
	}
	
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SW_Popup_Login_elementor());
?>