<?php 
namespace SWWE\Widgets;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;

/**
 * SWE_Banner
 *
 * @author Youtech
 * @package SWE
 */

if (class_exists('WooCommerce')) {
    final class SWE_Woo_Cart extends Widget_Base {
        /**
         * @return string
         */
        function get_name() {
            return 'swe-woo-cart';
        }

        /**
         * @return string
         */
        function get_title() {
            return esc_html__('SWE Woo Cart', 'sw-woocommerce');
        }

        /**
         * @return array
         */
        public function get_categories() {
            return [ 'sw-woocommerce-elements' ];
        }

        /**
         * @return string
         */
        function get_icon() {
            return 'eicon-cart-medium';
        }

        /**
         * @return array Widget scripts dependencies.
         */
        public function get_script_depends() {
            return [ 'swwe-script' ];
        }

        /**
         * Register controls
         */

        public function _register_controls() {

            /**
            * Content Settings
            */
            $this->start_controls_section( 'content_settings', [
                'label' => __( 'Content Settings', 'sw-woocommerce' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]);

            $this->add_control( 'show_image_icon', [
                'label' => __( 'Show Image Icon', 'sw-woocommerce' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'sw-woocommerce' ),
                'label_off' => __( 'Hide', 'sw-woocommerce' ),
                'return_value' => 'yes',
                'default' => '',
            ]);
			
			$this->add_control('lstyle', [
                'label' => __( 'Cart Style', 'sw-woocommerce' ),
                'type' => Controls_Manager::SELECT,
                'options' => apply_filters( 'sw_woo_cart_layout_style_args', [
                    'style-1' => __('Style 1', 'sw-woocommerce'),                  
                ] ),
            ]);
			
            $this->add_control('icon', [
                'label' => esc_html__('Icon', 'sw-woocommerce'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-shopping-cart',
                    'library' => 'solid',
                ],
                'condition' => [
                    'show_image_icon!' => 'yes'
                ]
            ]);

            $this->start_controls_tabs( 'image_icon_tabs', [
                'condition' => [
                    'show_image_icon' => 'yes'
                ]
            ] );

            $this->start_controls_tab( 'image_icon_tab_normal', [ 'label' => __( 'Normal', 'sw-woocommerce' ) ] );

            $this->add_control('image_icon', [
                'label' => esc_html__('Image Icon', 'sw-woocommerce'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'show_image_icon' => 'yes'
                ]
            ]);

            $this->end_controls_tab();

            $this->start_controls_tab( 'image_icon_tab_hover', [ 'label' => __( 'Hover', 'sw-woocommerce' ) ] );

            $this->add_control('image_icon_hover', [
                'label' => esc_html__('Image Icon', 'sw-woocommerce'),
                'type' => Controls_Manager::MEDIA,
                'condition' => [
                    'show_image_icon' => 'yes'
                ]
            ]);
            $this->end_controls_tab();

            $this->end_controls_tabs();


            $this->add_control('layout_style', [
                'label' => __( 'Layout style', 'sw-woocommerce' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'cart-hover' => __('Cart Hover', 'sw-woocommerce'),
                    'cart-canvas' => __('Cart Canvas', 'sw-woocommerce'),
                ],
                'default' => 'cart-hover'
            ]);

            $this->add_control( 'show_count', [
                'label' => __( 'Show Count Items', 'sw-woocommerce' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'sw-woocommerce' ),
                'label_off' => __( 'Hide', 'sw-woocommerce' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]);
			
			$this->add_control( 'show_count_number', [
                'label' => __( 'Show Count Number Only', 'sw-woocommerce' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'sw-woocommerce' ),
                'label_off' => __( 'Hide', 'sw-woocommerce' ),
                'return_value' => 'yes',
                'default' => 'yes',
				'condition' => [
					'show_count' => 'yes'
				],
             ]);

            $this->add_control( 'show_subtotal', [
                'label' => __( 'Show Subtotal', 'sw-woocommerce' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'sw-woocommerce' ),
                'label_off' => __( 'Hide', 'sw-woocommerce' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]);
			
			$this->add_control( 'show_text', [
                'label' => __( 'Show Text Cart', 'sw-woocommerce' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'sw-woocommerce' ),
                'label_off' => __( 'Hide', 'sw-woocommerce' ),
                'return_value' => 'yes',
                'default' => '',
            ]);
			
            $this->add_control('text_cart', [
                'label' => esc_html__('Text Subtotal', 'sw-woocommerce'),
                'type' => Controls_Manager::TEXT,
                'default' => __('My Cart:', 'sw-woocommerce'),
				'condition' => [
                    'show_text' => 'yes'
                ]
            ]);

            $this->add_control('position_icon', [
                'label' => __( 'Position Icon', 'sw-woocommerce' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'icon-left' => __('Left', 'sw-woocommerce'),
                    'icon-right' => __('Right', 'sw-woocommerce'),
                ],
                'default' => 'icon-left',
                'condition' => [
                    'show_subtotal' => 'yes'
                ]
            ]);

            $this->add_control( 'position_content', [
                'label' => __( 'Position Content', 'sw-woocommerce' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'right' => __('Right', 'sw-woocommerce'),
                    'left' => __('Left', 'sw-woocommerce'),
                ],
                'selectors'            => [
                    '{{WRAPPER}} .swe-woo-cart.cart-hover .swe-wrap-cart-content' => '{{VALUE}}',
                ],
                'selectors_dictionary' => [
                    'right'   => 'left:auto;right:0;',
                    'left'   => 'right:auto;left:0;',
                ],
                'default' => 'right',
                'condition' => [
                    'layout_style' => 'cart-hover'
                ]
            ]);

            $this->end_controls_section();

            /**
            * Style for Icon Cart
            */
            $this->start_controls_section( 'section_style_icon', [
                'label' => __( 'Icon Cart', 'sw-woocommerce' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                "condition" => [
                    'show_image_icon!' => 'yes'
                ]
            ] );

            $this->add_control( 'wrap_icon_style', [
                'label' => __( 'Icon', 'sw-woocommerce' ),
                'type' => Controls_Manager::HEADING,
                // 'separator' => 'before',
            ]);

            $this->add_control( 'wrap_icon_block', [
                'label'     => __( 'Block', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
            ]);

            $this->add_control( 'wrap_icon_size', [
                'label'     => __( 'Size', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon i, {{WRAPPER}} .swe-cart-icon svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'wrap_icon_padding', [
                'label'     => __( 'Padding', 'sw-woocommerce' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};width: auto; height: auto;',
                ],
            ]);

            $this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'wrap_icon_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '{{WRAPPER}} .swe-cart-icon',
            ]);

            $this->add_control( 'wrap_icon_border_radius', [
                'label'     => __( 'Border Radius', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ '%', 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]);

            $this->start_controls_tabs( 'wrap_icon_tabs' );

            $this->start_controls_tab( 'wrap_icon_normal', [
                'label' => __( 'Normal', 'sw-woocommerce' ),
            ]);

            $this->add_control( 'wrap_icon_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon' => 'color: {{VALUE}};',
					'{{WRAPPER}} .swe-cart-icon > svg' => 'fill: {{VALUE}};',
                ],
            ]);

            $this->add_control( 'wrap_icon_bg', [
                'label' => __( 'Background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon' => 'background: {{VALUE}};',
                ],
            ]);

            $this->end_controls_tab();

            $this->start_controls_tab( 'wrap_icon_hover', [
                'label' => __( 'Hover', 'sw-woocommerce' ),
            ]);

            $this->add_control( 'wrap_icon_color_hover', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart:hover .swe-cart-icon' => 'color: {{VALUE}};',
					'{{WRAPPER}} .swe-woo-cart:hover .swe-cart-icon > svg' => 'fill: {{VALUE}};',
                ],
            ]);

            $this->add_control( 'wrap_icon_bg_hover', [
                'label' => __( 'Background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart:hover .swe-cart-icon' => 'background: {{VALUE}};',
                ],
            ]);

            $this->add_control( 'wrap_icon_border_hover', [
                'label' => __( 'Border Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart:hover .swe-cart-icon' => 'border-color: {{VALUE}};',
                ],
            ]);

            $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->end_controls_section();

            /**
            * Style for Image Icon Cart
            */
            $this->start_controls_section( 'section_style_image_icon', [
                'label' => __( 'Image Icon Cart', 'sw-woocommerce' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                "condition" => [
                    'show_image_icon' => 'yes'
                ]
            ]);

            $this->add_control( 'wrap_image_size', [
                'label'     => __( 'Size', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .image-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]);

            $this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'wrap_image_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '{{WRAPPER}} .swe-cart-icon .image-icon img',
            ]);
			
            $this->add_control( 'wrap_image_border_radius', [
                'label'     => __( 'Border Radius', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ '%', 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .image-icon img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]);
			
            $this->add_control( 'wrap_image_space', [
                'label'      => __( 'Margin', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .image-icon img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'wrap_image_padding', [
                'label'      => __( 'Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .image-icon img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
            $this->start_controls_tabs( 'wrap_image_tabs' );

            $this->start_controls_tab( 'wrap_image_normal', [
                'label' => __( 'Normal', 'sw-woocommerce' ),
            ]);

            $this->add_control( 'wrap_image_bg', [
                'label' => __( 'Background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .image-icon img' => 'background: {{VALUE}};',
                ],
            ]);

            $this->end_controls_tab();

            $this->start_controls_tab( 'wrap_image_hover', [
                'label' => __( 'Hover', 'sw-woocommerce' ),
            ]);

            $this->add_control( 'wrap_image_bg_hover', [
                'label' => __( 'Background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart:hover .swe-cart-icon .image-icon img' => 'background: {{VALUE}};',
                ],
            ]);

            $this->add_control( 'wrap_image_border_hover', [
                'label' => __( 'Border Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart:hover .swe-cart-icon .image-icon img' => 'border-color: {{VALUE}};',
                ],
            ]);

            $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->end_controls_section();

            /**
            * Style for Count Items
            */
            $this->start_controls_section( 'section_style_count_items', [
                'label' => __( 'Count Items', 'sw-woocommerce' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ] );

            $this->add_control( 'wrap_count_position', [
                'label' => __( 'Position', 'sw-woocommerce' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '' => __('Default', 'sw-woocommerce'),
                    'top-right' => __('Top right', 'sw-woocommerce'),
                    'top-left' => __('Top left', 'sw-woocommerce'),
                    'bottom-right' => __('Bottom right', 'sw-woocommerce'),
                    'bottom-left' => __('Bottom left', 'sw-woocommerce'),
					'center-left' => __('Center left', 'sw-woocommerce'),
					'center-right' => __('Center right', 'sw-woocommerce'),
                    'center' => __('Center center', 'sw-woocommerce')
                ],
                'selectors'            => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => '{{VALUE}}',
                ],
                'selectors_dictionary' => [
                    'top-right'   => 'top: 0;left: 100%;',
                    'top-left'   => 'top: 0;left: 0%;',
                    'bottom-right'   => 'top: 100%;left: 100%;',
                    'bottom-left'   => 'top: 100%;left: 0;',
					'center-left'   => 'top: 50%;left: 0;',
					'center-right'   => 'top: 50%;left: 100%;',
                    'center'   => 'top: 50%;left: 50%;',
                ],
                'default' => '',
				'prefix_class' => 'swe-woocart-counter-',
            ]);
			
			 $this->add_control( 'wrap_count_items_offset_top', [
                'label'     => __( 'Offset Top', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]);
			
			 $this->add_control( 'wrap_count_items_offset_left', [
                'label'     => __( 'Offset Left', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]);


            $this->add_control( 'wrap_count_items_block', [
                'label'     => __( 'Block', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'min-width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
            ]);

            $this->add_control( 'wrap_count_items_size', [
                'label'     => __( 'Size', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]);

            $this->add_control( 'wrap_count_items_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'color: {{VALUE}};',
                ],
            ]);

            $this->add_control( 'wrap_count_items_bg', [
                'label' => __( 'Background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'background: {{VALUE}};',
                ],
            ]);

            $this->add_control( 'wrap_count_padding', [
                'label'     => __( 'Padding', 'sw-woocommerce' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'wrap_count_border_radius', [
                'label'     => __( 'Border Radius', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-icon .swe-cart-count' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]);

            $this->end_controls_section();

            /**
            * Style for Subtotal
            */
            $this->start_controls_section( 'section_style_subtotal', [
                'label' => __( 'Subtotal', 'sw-woocommerce' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ] );
			
			$this->add_responsive_control(
				'minicart_align',
				[
					'label' => esc_html__( 'Align', 'elementor-pro' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'top' => [
							'title' => esc_html__( 'Top', 'elementor-pro' ),
							'icon' => 'eicon-v-align-top',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'elementor-pro' ),
							'icon' => 'eicon-v-align-middle',
						],
						'bottom' => [
							'title' => esc_html__( 'Bottom', 'elementor-pro' ),
							'icon' => 'eicon-v-align-bottom',
						],
					],
					'selectors'            => [
						'{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-head' => '{{VALUE}}',
					],
					'selectors_dictionary' => [
						'top'   => 'align-items: flex-start;',
						'center'   => 'align-items: center;',
						'bottom'   => 'text-align: flex-end;',
					],		
				]
			);
			
            $this->add_control( 'wrap_subtotal_space', [
                'label'     => __( 'Space', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .icon-right .swe-cart-subtotal' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .icon-left .swe-cart-subtotal' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'wrap_subtotal_padding', [
                'label'     => __( 'Padding', 'sw-woocommerce' ),
                'type'      => Controls_Manager::DIMENSIONS,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-subtotal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
            $this->add_control( 'wrap_text_style', [
                'label' => __( 'Text Subtotal', 'sw-woocommerce' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]);

            $this->add_control( 'wrap_text_block', [
                'label' => __( 'Display Block', 'sw-woocommerce' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'sw-woocommerce' ),
                'label_off' => __( 'Hide', 'sw-woocommerce' ),
                'return_value' => 'yes',
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-subtotal .text' => '{{VALUE}}',
                ],
                'selectors_dictionary' => [
                    'yes'   => 'display:block;margin-right:0px;',
                ],
            ]);

            $this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'wrap_text_typography',
                'selector' => '{{WRAPPER}} .swe-cart-subtotal .text',
            ]);

            $this->add_control( 'wrap_text_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-subtotal .text' => 'color: {{VALUE}};',
                ],
            ]);
			
			$this->add_control( 'wrap_text_space', [
                'label'      => __( 'Margin', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-subtotal .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
            $this->add_control( 'wrap_price_style', [
                'label' => __( 'Price', 'sw-woocommerce' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]);

            $this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'wrap_price_typography',
                'selector' => '{{WRAPPER}} .swe-cart-subtotal',
            ]);

            $this->add_control( 'wrap_price_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-cart-subtotal' => 'color: {{VALUE}};',
                ],
            ]);

            $this->end_controls_section(); 
			
			 $this->start_controls_section( 'section_style_minicart', [
                'label' => __( 'Mini Cart Style', 'sw-woocommerce' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ] );
			
			$this->add_control( 'minicart_background_color', [
                'label' => __( 'background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-wrap-cart-content' => 'background-color: {{VALUE}};',
                ],
				'default' => '#ffffff'
            ]);
			
			$this->add_control( 'minicart_padding', [
                'label'      => __( 'Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-wrap-cart-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'minicart_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '{{WRAPPER}} .swe-wrap-cart-content',
            ]);
			
			$this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), [
                'name' => 'minicart_box_shadow',
                'selector' => '{{WRAPPER}} .swe-wrap-cart-content',
            ]);
			
			$this->add_control(
				'hr4',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			
			$this->add_control(
				'minicart_title_heading',
				[
					'label' => esc_html__( 'Minicart Heading', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);
			
			$this->add_control( 'minicart_title_heading_padding', [
                'label'      => __( 'Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .swe-wrap-cart-top' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);	
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_title_heading_typography',
				'label' => __( 'Heading Title', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .swe-wrap-cart-content .swe-wrap-cart-top .cart-title',
            ]);
			
			$this->add_control( 'minicart_title_heading_color', [
                'label' => __( 'Heading Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .swe-wrap-cart-top .cart-title' => 'color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_control(
				'hr8',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_heading_close_typography',
				'label' => __( 'Close Typography', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .swe-wrap-cart-content .swe-wrap-cart-top .cart-title',
            ]);
			
			$this->add_control( 'minicart_heading_close_color', [
                'label' => __( 'Close Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .swe-wrap-cart-top .swe-close' => 'color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_control( 'minicart_heading_close_color_hover', [
                'label' => __( 'Close Color hover', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .swe-wrap-cart-top .swe-close' => 'color: {{VALUE}};',
                ],
            ]);			
			
			$this->add_control(
				'hr5',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			
			$this->add_control(
				'minicart_product',
				[
					'label' => esc_html__( 'Products', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);
			
			$this->add_control( 'minicart_product_padding', [
                'label'      => __( 'Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .minicart-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'minicart_product_margin', [
                'label'      => __( 'Margin', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .minicart-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);	
			
			$this->add_control(
				'minicart_image',
				[
					'label' => esc_html__( 'Image', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);
			
			$this->add_control( 'minicart_image_width', [
                'label'     => __( 'Width', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'minicart_image_spacing', [
                'label'     => __( 'Spacing', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li img' => 'margin-right: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li img' => 'margin-right: 0; margin-left: {{SIZE}}{{UNIT}};'
                ],
            ]);
			
			$this->add_control( 'minicart_image_padding', [
                'label'      => __( 'Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'minicart_image_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li img',
            ]);			
			
			$this->add_control(
				'minicart_title',
				[
					'label' => esc_html__( 'Product Title', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_title_typography',
                'selector' => '.swe-woo-cart ul.woocommerce-mini-cart li a',
            ]);
			
			$this->add_control( 'minicart_title_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li a' => 'color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_control( 'minicart_title_color_hover', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li a:hover' => 'color: {{VALUE}};',
                ],
            ]);			
			
			$this->add_control( 'minicart_title_padding', [
                'label'      => __( 'Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control(
				'minicart_price',
				[
					'label' => esc_html__( 'Price', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_price_typography',
                'selector' => '.swe-woo-cart ul.woocommerce-mini-cart li .quantity',
            ]);
			
			$this->add_control( 'minicart_price_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li .quantity' => 'color: {{VALUE}};',
                ],
            ]);			
			
			$this->add_control(
				'minicart_remove',
				[
					'label' => esc_html__( 'Remove', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_remove_typography',
                'selector' => '.swe-woo-cart ul.woocommerce-mini-cart li a.remove',
            ]);
			
			$this->add_control( 'minicart_remove_color', [
                'label' => __( 'Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li a.remove' => 'color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_control( 'minicart_remove_color_hover', [
                'label' => __( 'Color Hover', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart ul.woocommerce-mini-cart li a.remove:hover' => 'color: {{VALUE}};',
                ],
            ]);		

			$this->add_control(
				'hr3',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			
			$this->add_control(
				'minicart_subtotal',
				[
					'label' => esc_html__( 'Subtotal', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]
			);			
			
			
			$this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'minicart_subtotal_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .woocommerce-mini-cart__total',
            ]);	
			
			$this->add_control( 'minicart_subtotal_background', [
                'label' => __( 'Background', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .woocommerce-mini-cart__total' => 'background-color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_control( 'minicart_subtotal_padding', [
                'label'      => __( 'Wrap Button Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .woocommerce-mini-cart__total' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_subtotal_label_typography',
				'label' => __( 'Label Typography', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .woocommerce-mini-cart__total strong',
            ]);
			
			$this->add_control( 'minicart_subtotal_label_color', [
                'label' => __( 'Label Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .woocommerce-mini-cart__total strong' => 'color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_subtotal_typography',
				'label' => __( 'Subtotal Typography', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .total .amount',
            ]);
			
			$this->add_control( 'minicart_subtotal_color', [
                'label' => __( 'Subtotal Color', 'sw-woocommerce' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .total .amount' => 'color: {{VALUE}};',
                ],
            ]);	
			
			$this->add_control(
				'hr6',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			
			$this->add_control(
				'minicart_button',
				[
					'label' => esc_html__( 'Button', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]			
			);
			
			$this->add_group_control( Group_Control_Typography::get_type(), [
                'name' => 'minicart_button_typography',
				'label' => __( 'Button Typography', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .swe-wrap-cart-content .woocommerce-mini-cart__buttons',
            ]);
			
			$this->add_control( 'minicart_button_padding', [
                'label'      => __( 'Wrap Button Padding', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .woocommerce-mini-cart__buttons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);

			$this->add_control( 'minicart_button_spacing', [
                'label'     => __( 'Button Spacing', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .woocommerce-mini-cart__buttons' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control( 'minicart_button_height', [
                'label'     => __( 'Block', 'sw-woocommerce' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                    ],
                ],
                'size_units'     => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .woocommerce-mini-cart__buttons .button' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]);

			$this->add_control( 'minicart_button_border-radius', [
                'label'      => __( 'Border Radius', 'sw-woocommerce' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swe-woo-cart .swe-wrap-cart-content .woocommerce-mini-cart__buttons .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]);
			
			$this->add_control(
				'minicart_button_cart',
				[
					'label' => esc_html__( 'Button View Cart', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]			
			);
			
			$this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'minicart_button_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '{{WRAPPER}} .swe-woo-cart .buttons .button',
            ]);	
			
			$this->start_controls_tabs( 'tabs_button_cart_colors' );

			$this->start_controls_tab(
				'tab_button_cart_normal',
				[
					'label' => esc_html__( 'Normal', 'sw_core' ),
				]
			);

			$this->add_control(
				'button_cart_color',
				[
					'label' => esc_html__( 'Text Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_cart_background',
				[
					'label' => esc_html__( 'Background Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_button_cart_hover',
				[
					'label' => esc_html__( 'Hover', 'sw_core' ),
				]
			);

			$this->add_control(
				'button_cart_color_hover',
				[
					'label' => esc_html__( 'Text Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_cart_background_hover',
				[
					'label' => esc_html__( 'Background Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			
			$this->add_control(
				'button_checkout_cart_hover',
				[
					'label' => esc_html__( 'Background Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->add_control(
				'minicart_button_checkout',
				[
					'label' => esc_html__( 'Button checkout', 'sw-woocommerce' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'after',
				]			
			);
			
			$this->add_group_control( Group_Control_Border::get_type(), [
                'name' => 'button_checkout_border',
                'label' => __( 'Border', 'sw-woocommerce' ),
                'selector' => '.swe-woo-cart .buttons .button.checkout',
            ]);	
			
			$this->start_controls_tabs( 'tabs_button_checkout_colors' );

			$this->start_controls_tab(
				'tab_button_checkout_normal',
				[
					'label' => esc_html__( 'Normal', 'sw_core' ),
				]
			);

			$this->add_control(
				'button_checkout_color',
				[
					'label' => esc_html__( 'Text Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button.checkout' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_checkout_background',
				[
					'label' => esc_html__( 'Background Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button.checkout' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'tab_button_checkout_hover',
				[
					'label' => esc_html__( 'Hover', 'sw_core' ),
				]
			);

			$this->add_control(
				'button_checkout_color_hover',
				[
					'label' => esc_html__( 'Text Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button.checkout:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_checkout_background_hover',
				[
					'label' => esc_html__( 'Background Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button.checkout:hover' => 'background-color: {{VALUE}}',
					],
				]
			);
			
			$this->add_control(
				'button_checkout_border_hover',
				[
					'label' => esc_html__( 'Background Color', 'sw_core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .swe-woo-cart .buttons .button.checkout:hover' => 'border-color: {{VALUE}}',
					],
				]
			);

			$this->end_controls_tab();

			$this->end_controls_tabs();
			
			$this->end_controls_section();

        }

        /**
         * Render
         */
        protected function render() {
            $settings = $this->get_settings_for_display();
            $id_int = substr( $this->get_id_int(), 0, 3 );
            $settings['id_int'] = $id_int;

           include sw_override_check('elementor', 'template-woo-cart', $settings);
        }
    }

    ElementorPlugin::instance()->widgets_manager->register(new SWE_Woo_Cart());
}
