<?php
/**
	* SW Woocommerce Slider
	* Register Widget Woocommerce Slider
	* @author 		flytheme
	* @version     1.0.0
	**/
	if ( !class_exists('sw_woo_slider_widget') ) {
		class sw_woo_slider_widget extends WP_Widget {
		/**
		 * Widget setup.
		 */
		private $snumber = 1;

		function __construct(){
			/* Widget settings. */
			$widget_ops = array( 'classname' => 'sw_woo_slider_widget', 'description' => __('Sw Woo Slider', 'sw-woocommerce') );

			/* Widget control settings. */
			$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'sw_woo_slider_widget' );

			/* Create the widget. */
			parent::__construct( 'sw_woo_slider_widget', __('Sw Woo Slider widget', 'sw-woocommerce'), $widget_ops, $control_ops );
			
			/* Create Shortcode */
			add_shortcode( 'woo_slide', array( $this, 'WS_Shortcode' ) );
			
			/* Create Vc_map */
			if ( class_exists('Vc_Manager') ) {
				add_action( 'vc_before_init', array( $this, 'WS_integrateWithVC' ), 20 );
			}

		}
		
		public function generateID() {
			return $this->id_base . '_' . (int) $this->snumber++;
		}
		
		/**
		* Add Vc Params
		**/
		function WS_integrateWithVC(){
			$terms = get_terms( 'product_cat', array( 'parent' => '', 'hide_empty' => false ) );
			$term = array( __( 'All Categories', 'sw-woocommerce' ) => '' );
			if( count( $terms )  > 0 ){
				foreach( $terms as $cat ){
					$term[$cat->name] = $cat -> slug;
				}
			}
			vc_map( array(
				"name" => __( "SW Woocommerce Slider", 'sw-woocommerce' ),
				"base" => "woo_slide",
				"icon" => "icon-wpb-ytc",
				"class" => "",
				"category" => __( "SW Shortcodes", 'sw-woocommerce'),
				"params" => array(
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Title", 'sw-woocommerce' ),
						"param_name" => "title1",
						"admin_label" => true,
						"value" => '',
						"description" => __( "Title", 'sw-woocommerce' )
						),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Product Title Length", 'sw-woocommerce' ),
						"param_name" => "title_length",
						"admin_label" => true,
						"value" => 0,
						"description" => __( "Choose Product Title Length if you want to trim word, leave 0 to not trim word", 'sw-woocommerce' )
						),		
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Description", 'sw-woocommerce' ),
						"param_name" => "description",
						"admin_label" => true,
						"value" => '',
						"description" => __( "Description", 'sw-woocommerce' )
						),
					array(
						'type' => 'attach_images',
						'heading' => __( 'Select Image', 'sw-woocommerce' ),
						'param_name' => 'image',
						'description' => __( 'Select Image', 'sw-woocommerce' ),
						'dependency' => array(
							'element' => 'layout',
							'value' => array( 'childcat', 'childcat1', 'childcat2' ),
						)
					),
					 array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Banner Links", 'sw-woocommerce' ),
						"param_name" => "banner_links",
						"value" => '',
						"description" => __( "Each banner link seperate by commas.", 'sw-woocommerce' ),
						"dependency" => array( 
							'element' => 'layout',
							'value' => array( 'childcat', 'childcat1', 'childcat2' ),
							)
						),
					 array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Select Style", 'sw-woocommerce' ),
						"param_name" => "style",
						"admin_label" => true,
						"value" => array('' => 'Select', 'style1' => 'style1', 'style2' => 'style2', 'style3' => 'style3'),
						"description" => __( "Select Style", 'sw-woocommerce' ),
						'dependency' => array(
							'element' => 'layout',
							'value' => array( 'childcat' )
						),
					 ),
					array(
						'type' => 'textfield',
						'heading' => __( 'Select Icon Mobile', 'sw-woocommerce' ),
						'param_name' => 'icon_m',
						'description' => __( 'Select Icon FontAwesome', 'sw-woocommerce' ),
						'dependency' => array(
							'element' => 'layout',
							'value' => array( 'theme_mobile','theme_mobile2'),
							)
						),
					array(
						'type' => 'date',
						'heading' => __( 'Countdown Date', 'sw-woocommerce' ),
						'param_name' => 'date',
						'value' =>'',
						'description' => __( 'Countdown Date', 'sw-woocommerce' ),
						"admin_label" => true,
						'dependency' => array(
							'element' => 'layout',
							'value' => array( 'theme_mobile2','bestsales'),
							)
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Category", 'sw-woocommerce' ),
						"param_name" => "category",
						"admin_label" => true,
						"value" => $term,
						"description" => __( "Select Categories", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Order By", 'sw-woocommerce' ),
						"param_name" => "orderby",
						"admin_label" => true,
						"value" => array('Name' => 'name', 'Author' => 'author', 'Date' => 'date', 'Modified' => 'modified', 'Parent' => 'parent', 'ID' => 'ID', 'Random' =>'rand', 'Comment Count' => 'comment_count'),
						"description" => __( "Order By", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Order", 'sw-woocommerce' ),
						"param_name" => "order",
						"admin_label" => true,
						"value" => array('Descending' => 'DESC', 'Ascending' => 'ASC'),
						"description" => __( "Order", 'sw-woocommerce' )
						),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number Of Post", 'sw-woocommerce' ),
						"param_name" => "numberposts",
						"admin_label" => true,
						"value" => 5,
						"description" => __( "Number Of Post", 'sw-woocommerce' )
						),
					 array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number Of Child Category", 'sw-woocommerce' ),
						"param_name" => "number_child",
						"admin_label" => true,
						"value" => 5,
						"description" => __( "Number child category will show.", 'sw-woocommerce' ),
						'dependency' => array(
							'element' => 'layout',
							'value' => array( 'childcat', 'childcat1', 'childcat2' )
						),
					 ),
					  array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number Best Seller", "sw_woocommerce" ),
						"param_name" => "bnumber",
						"admin_label" => true,
						"value" => 5,
						"description" => __( "Number of items best seller", "sw_woocommerce" ),
							'dependency' => array(
							'element' => 'layout',
							'value' => 'childcat1' ,
						),
					),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number row per column", 'sw-woocommerce' ),
						"param_name" => "item_row",
						"admin_label" => true,
						"value" =>array(1,2,3,4),
						"description" => __( "Number row per column", 'sw-woocommerce' )
						),

					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number of Columns >1200px: ", 'sw-woocommerce' ),
						"param_name" => "columns",
						"admin_label" => true,
						"value" => array(1,2,3,4,5,6),
						"description" => __( "Number of Columns >1200px:", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number of Columns on 992px to 1199px:", 'sw-woocommerce' ),
						"param_name" => "columns1",
						"admin_label" => true,
						"value" => array(1,2,3,4,5,6),
						"description" => __( "Number of Columns on 992px to 1199px:", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number of Columns on 768px to 991px:", 'sw-woocommerce' ),
						"param_name" => "columns2",
						"admin_label" => true,
						"value" => array(1,2,3,4,5,6),
						"description" => __( "Number of Columns on 768px to 991px:", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number of Columns on 480px to 767px:", 'sw-woocommerce' ),
						"param_name" => "columns3",
						"admin_label" => true,
						"value" => array(1,2,3,4,5,6),
						"description" => __( "Number of Columns on 480px to 767px:", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Number of Columns in 480px or less than:", 'sw-woocommerce' ),
						"param_name" => "columns4",
						"admin_label" => true,
						"value" => array(1,2,3,4,5,6),
						"description" => __( "Number of Columns in 480px or less than:", 'sw-woocommerce' )
						),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Speed", 'sw-woocommerce' ),
						"param_name" => "speed",
						"admin_label" => true,
						"value" => 1000,
						"description" => __( "Speed Of Slide", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Auto Play", 'sw-woocommerce' ),
						"param_name" => "autoplay",
						"admin_label" => true,
						"value" => array( 'False' => 'false', 'True' => 'true' ),
						"description" => __( "Auto Play", 'sw-woocommerce' )
						),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Interval", 'sw-woocommerce' ),
						"param_name" => "interval",
						"admin_label" => true,
						"value" => 5000,
						"description" => __( "Interval", 'sw-woocommerce' )
						),
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Layout", 'sw-woocommerce' ),
						"param_name" => "layout",
						"admin_label" => true,
						"value" => array( 'Layout Default' => 'default', 'Layout Most Views' => 'default1', 'Layout Most Views 2' => 'mostviewed2', 'Layout Most Views 3' => 'mostviewed3', 'Layout Flash Sale' => 'bestsales', 'Layout Child Category' => 'childcat',
						'Layout Child Category2' => 'childcat1', 'Layout Child Category3' => 'childcat2', 'Layout Child Category4' => 'childcat3', 'Layout Toprated' => 'toprated', 'Layout Mobile1' => 'theme_mobile', 'Layout Mobile2' => 'theme_mobile2' ),
						"description" => __( "Layout", 'sw-woocommerce' )
						),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => __( "Total Items Slided", 'sw-woocommerce' ),
						"param_name" => "scroll",
						"admin_label" => true,
						"value" => 1,
						"description" => __( "Total Items Slided", 'sw-woocommerce' )
						),
					)
) );
}
		/**
			** Add Shortcode
			**/
			function WS_Shortcode( $atts ){
				extract( shortcode_atts(
					array(
						'title1' => '',	
						'title_length' => 0,
						'description' => '',
						'image' =>'',
						'banner_links' => '',	
						'style' => '',	
						'icon_m'=> '',
						'date' =>'',
						'orderby' => 'name',
						'order'	=> 'DESC',
						'category' => '',
						'numberposts' => 5,
						'number_child' => 4,
						'bnumber' => 5,
						'length' => 25,
						'item_row'=> 1,
						'columns' => 4,
						'columns1' => 4,
						'columns2' => 3,
						'columns3' => 2,
						'columns4' => 1,
						'speed' => 1000,
						'autoplay' => 'false',
						'interval' => 5000,
						'layout'  => 'default',
						'scroll' => 1
						), $atts )
				);
				$path = sw_override_check( 'sw-slider', 'default' );
				switch ( $layout ) {
					case 'default':
					$path = sw_override_check( 'sw-slider', 'default' );
					break;	
					case 'default1':
					$path = sw_override_check( 'sw-slider', 'default1' );
					break;
					case 'mostviewed2':
					$path = sw_override_check( 'sw-slider', 'most-viewed' );
					break;
					case 'mostviewed3':
					$path = sw_override_check( 'sw-slider', 'most-viewed2' );
					break;
					case 'bestsales':
					$path = sw_override_check( 'sw-slider', 'bestsales' );
					break;
					case 'childcat':
					$path = sw_override_check( 'sw-slider', 'childcat' );
					break;
					case 'childcat1':
					$path = sw_override_check( 'sw-slider', 'childcat1' );
					break;
					case 'childcat2':
					$path = sw_override_check( 'sw-slider', 'childcat2' );
					break;
					case 'childcat3':
					$path = sw_override_check( 'sw-slider', 'childcat3' );
					break;
					case 'toprated':
					$path = sw_override_check( 'sw-slider', 'toprated' );
					break;
					case 'theme_mobile':
					$path = sw_override_check( 'sw-slider', 'theme-mobile' );
					break;
					case 'theme_mobile2':
					$path = sw_override_check( 'sw-slider', 'theme-mobile2' );
					break;				

					default:
					$path = sw_override_check( 'sw-slider', 'default' );
				}
				ob_start();
					include($path);
				$content = ob_get_clean();
				return $content;
			}
		/**
			* Cut string
			**/
			public function ya_trim_words( $text, $num_words = 30, $more = null ) {
				$text = strip_shortcodes( $text);
				$text = apply_filters('the_content', $text);
				$text = str_replace(']]>', ']]&gt;', $text);
				return wp_trim_words($text, $num_words, $more);
			}
		/**
		 * Display the widget on the screen.
		 */
		public function widget( $args, $instance ) {
			wp_reset_postdata();
			extract($args);
			$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
			$description1 = apply_filters( 'widget_description', empty( $instance['description1'] ) ? '' : $instance['description1'], $instance, $this->id_base );
			echo $before_widget;
			if ( !empty( $title ) && !empty( $description1 ) ) { echo $before_title . $title . $after_title . '<h5 class="category_description clearfix">' . $description1 . '</h5>'; }
			else if (!empty( $title ) && $description1==NULL ){ echo $before_title . $title . $after_title; }
			
			if ( !isset($instance['category']) ){
				$instance['category'] = array();
			}
			$id = $this -> number;
			extract($instance);

			if ( !array_key_exists('widget_template', $instance) ){
				$instance['widget_template'] = 'default';
			}
			
			if ( $tpl =  sw_override_check( 'sw-slider', $instance['widget_template'] ) ){ 			
				$link_img = plugins_url('images/', __FILE__);
				$widget_id = $args['widget_id'];		
				include $tpl;
			}

			/* After widget (defined by themes). */
			echo $after_widget;
		}    
		
		/**
		 * Update the widget settings.
		 */
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			// strip tag on text field
			$instance['title1'] = strip_tags( $new_instance['title1'] );
			
			if ( array_key_exists('title2', $new_instance) ){
				$instance['title2'] = strip_tags( $new_instance['title2'] );
			}
			
			if ( array_key_exists('description', $new_instance) ){
				$instance['description'] = strip_tags( $new_instance['description'] );
			}
			
			if ( array_key_exists('title_length', $new_instance) ){
				$instance['title_length'] = intval( $new_instance['title_length'] );
			}				
			
			if ( array_key_exists('icon_m', $new_instance) ){
				$instance['icon_m'] = strip_tags( $new_instance['icon_m'] );
			}
			// int or array
			if ( array_key_exists('category', $new_instance) ){
				if ( is_array($new_instance['category']) ){
					$instance['category'] = $new_instance['category'];
				} else {
					$instance['category'] = $new_instance['category'];
				}
			}
			if ( array_key_exists('style', $new_instance) ){
				$instance['style'] = strip_tags( $new_instance['style'] );
			}
			
			if ( array_key_exists('orderby', $new_instance) ){
				$instance['orderby'] = strip_tags( $new_instance['orderby'] );
			}

			if ( array_key_exists('order', $new_instance) ){
				$instance['order'] = strip_tags( $new_instance['order'] );
			}

			if ( array_key_exists('numberposts', $new_instance) ){
				$instance['numberposts'] = intval( $new_instance['numberposts'] );
			}
			
			if ( array_key_exists('number_child', $new_instance) ){
				$instance['number_child'] = intval( $new_instance['number_child'] );
			}
			
			if ( array_key_exists('bnumber', $new_instance) ){
				$instance['bnumber'] = intval( $new_instance['bnumber'] );
			}
			
			if ( array_key_exists('length', $new_instance) ){
				$instance['length'] = intval( $new_instance['length'] );
			}
			
			if ( array_key_exists('item_row', $new_instance) ){
				$instance['item_row'] = intval( $new_instance['item_row'] );
			}
			
			if ( array_key_exists('banner_links', $new_instance) ){
				$instance['banner_links'] = esc_url( $new_instance['banner_links'] );
			}
			
			if ( array_key_exists('image', $new_instance) ){
				$instance['image'] = strip_tags( $new_instance['image'] );
			}
			
			if ( array_key_exists('date', $new_instance) ){
				$instance['date'] = $new_instance['date'];
			}
			if ( array_key_exists('columns', $new_instance) ){
				$instance['columns'] = intval( $new_instance['columns'] );
			}
			if ( array_key_exists('columns1', $new_instance) ){
				$instance['columns1'] = intval( $new_instance['columns1'] );
			}
			if ( array_key_exists('columns2', $new_instance) ){
				$instance['columns2'] = intval( $new_instance['columns2'] );
			}
			if ( array_key_exists('columns3', $new_instance) ){
				$instance['columns3'] = intval( $new_instance['columns3'] );
			}
			if ( array_key_exists('columns4', $new_instance) ){
				$instance['columns4'] = intval( $new_instance['columns4'] );
			}
			if ( array_key_exists('interval', $new_instance) ){
				$instance['interval'] = intval( $new_instance['interval'] );
			}
			if ( array_key_exists('speed', $new_instance) ){
				$instance['speed'] = intval( $new_instance['speed'] );
			}
			if ( array_key_exists('start', $new_instance) ){
				$instance['start'] = intval( $new_instance['start'] );
			}
			if ( array_key_exists('scroll', $new_instance) ){
				$instance['scroll'] = intval( $new_instance['scroll'] );
			}	
			if ( array_key_exists('autoplay', $new_instance) ){
				$instance['autoplay'] = strip_tags( $new_instance['autoplay'] );
			}
			$instance['widget_template'] = strip_tags( $new_instance['widget_template'] );
			

			
			return $instance;
		}

		function category_select( $field_name, $opts = array(), $field_value = null ){
			$default_options = array(
				'multiple' => false,
				'disabled' => false,
				'size' => 5,
				'class' => 'widefat',
				'required' => false,
				'autofocus' => false,
				'form' => false,
				);
			$opts = wp_parse_args($opts, $default_options);

			if ( (is_string($opts['multiple']) && strtolower($opts['multiple'])=='multiple') || (is_bool($opts['multiple']) && $opts['multiple']) ){
				$opts['multiple'] = 'multiple';
				if ( !is_numeric($opts['size']) ){
					if ( intval($opts['size']) ){
						$opts['size'] = intval($opts['size']);
					} else {
						$opts['size'] = 5;
					}
				}
				if (array_key_exists('allow_select_all', $opts) && $opts['allow_select_all']){
					unset($opts['allow_select_all']);
					$allow_select_all = '<option value="">All Categories</option>';
				}
			} else {
				// is not multiple
				unset($opts['multiple']);
				unset($opts['size']);
				if (is_array($field_value)){
					$field_value = array_shift($field_value);
				}
				if (array_key_exists('allow_select_all', $opts) && $opts['allow_select_all']){
					unset($opts['allow_select_all']);
					$allow_select_all = '<option value="">All Categories</option>';
				}
			}

			if ( (is_string($opts['disabled']) && strtolower($opts['disabled'])=='disabled') || is_bool($opts['disabled']) && $opts['disabled'] ){
				$opts['disabled'] = 'disabled';
			} else {
				unset($opts['disabled']);
			}

			if ( (is_string($opts['required']) && strtolower($opts['required'])=='required') || (is_bool($opts['required']) && $opts['required']) ){
				$opts['required'] = 'required';
			} else {
				unset($opts['required']);
			}

			if ( !is_string($opts['form']) ) unset($opts['form']);

			if ( !isset($opts['autofocus']) || !$opts['autofocus'] ) unset($opts['autofocus']);

			$opts['id'] = $this->get_field_id($field_name);

			$opts['name'] = $this->get_field_name($field_name);
			if ( isset($opts['multiple']) ){
				$opts['name'] .= '[]';
			}
			$select_attributes = '';
			foreach ( $opts as $an => $av){
				$select_attributes .= "{$an}=\"{$av}\" ";
			}
			
			$categories = get_terms('product_cat');
			$all_category_ids = array();
			foreach ($categories as $cat) $all_category_ids[] = $cat->slug;
			
			$is_valid_field_value = in_array($field_value, $all_category_ids);
			if (!$is_valid_field_value && is_array($field_value)){
				$intersect_values = array_intersect($field_value, $all_category_ids);
				$is_valid_field_value = count($intersect_values) > 0;
			}
			if (!$is_valid_field_value){
				$field_value = '';
			}

			$select_html = '<select ' . $select_attributes . '>';
			if (isset($allow_select_all)) $select_html .= $allow_select_all;
			foreach ($categories as $cat){			
				$select_html .= '<option value="' . $cat->slug . '"';
				if ($cat->slug == $field_value || (is_array($field_value)&&in_array($cat->slug, $field_value))){ $select_html .= ' selected="selected"';}
				$select_html .=  '>'.$cat->name.'</option>';
			}
			$select_html .= '</select>';
			return $select_html;
		}
		

		/**
		 * Displays the widget settings controls on the widget panel.
		 * Make use of the get_field_id() and get_field_name() function
		 * when creating your form elements. This handles the confusing stuff.
		 */
		public function form( $instance ) {

			/* Set up some default widget settings. */
			$defaults = array();
			$instance = wp_parse_args( (array) $instance, $defaults ); 		

			$title1 			= isset( $instance['title1'] )    	? strip_tags($instance['title1']) : '';
			$title2 			= isset( $instance['title2'] )    	? strip_tags($instance['title2']) : '';
			$title_length	= isset( $instance['title_length'] )  	? intval($instance['title_length']) : 0;
			$description 	= isset( $instance['description'] )   	? strip_tags($instance['description']) : '';
			$categoryid 	= isset( $instance['category'] )  		? $instance['category'] : '';
			$icon_m 	    = isset( $instance['icon_m'] )  		? strip_tags($instance['icon_m']) : '';
			$style      	= isset( $instance['style'] )       	? strip_tags($instance['style']) : 'style1';
			$banner_links	= isset( $instance['banner_links'] )    ? strip_tags($instance['banner_links']) : '';
			$image    		= isset( $instance['image'] )     		? strip_tags($instance['image']) : '';
			$date    		= isset( $instance['date'] )     		? strip_tags($instance['date']) : '';
			$orderby    	= isset( $instance['orderby'] )     	? strip_tags($instance['orderby']) : 'ID';
			$order      	= isset( $instance['order'] )       	? strip_tags($instance['order']) : 'ASC';
			$number     	= isset( $instance['numberposts'] ) 	? intval($instance['numberposts']) : 5;
			$number_child   = isset( $instance['number_child'] ) 	? intval($instance['number_child']) : 5;
			$bnumber        = isset( $instance['bnumber'] ) 	? intval($instance['bnumber']) : 5;
			$length     	= isset( $instance['length'] )      	? intval($instance['length']) : 25;
			$item_row     	= isset( $instance['item_row'] )      	? intval($instance['item_row']) : 1;
			$columns     	= isset( $instance['columns'] )      	? intval($instance['columns']) : 1;
			$columns1     	= isset( $instance['columns1'] )     	? intval($instance['columns1']) : 1;
			$columns2     	= isset( $instance['columns2'] )      	? intval($instance['columns2']) : 1;
			$columns3     	= isset( $instance['columns3'] )      	? intval($instance['columns3']) : 1;
			$columns4     	= isset( $instance['columns'] )      	? intval($instance['columns4']) : 1;
			$autoplay     	= isset( $instance['autoplay'] )      	? strip_tags($instance['autoplay']) : 'false';
			$interval     	= isset( $instance['interval'] )      	? intval($instance['interval']) : 5000;
			$speed     		= isset( $instance['speed'] )      		? intval($instance['speed']) : 1000;
			$scroll     	= isset( $instance['scroll'] )      	? intval($instance['scroll']) : 1;
			$widget_template   	= isset( $instance['widget_template'] ) ? strip_tags($instance['widget_template']) : 'default';


			?>		
		</p> 
		<div style="background: Blue; color: white; font-weight: bold; text-align:center; padding: 3px"> * Data Config * </div>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('title1'); ?>"><?php _e('Title', 'sw-woocommerce')?></label>
		<br />
		<input class="widefat" id="<?php echo $this->get_field_id('title1'); ?>" name="<?php echo $this->get_field_name('title1'); ?>"
		type="text"	value="<?php echo esc_attr($title1); ?>" />
	</p>
	<?php if ( $widget_template=='dailydeals4' || $widget_template=='default3' || $widget_template=='default4' || $widget_template=='default11'){ ?>
	
		<p>
			<label for="<?php echo $this->get_field_id('title2'); ?>"><?php _e('Title2', 'sw-woocommerce')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('title2'); ?>" name="<?php echo $this->get_field_name('title2'); ?>"
			type="text"	value="<?php echo esc_attr( $title2 ); ?>" />
		</p>
	
	<?php } ?>
	<p>
		<label for="<?php echo $this->get_field_id('title_length'); ?>"><?php _e('Product Title Length', 'sw-woocommerce')?></label>
		<br />
		<input class="widefat" id="<?php echo $this->get_field_id('title_length'); ?>" name="<?php echo $this->get_field_name('title_length'); ?>"
		type="text"	value="<?php echo esc_attr($title_length); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description', 'sw-woocommerce')?></label>
		<br />
		<input class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"
		type="text"	value="<?php echo esc_attr($description); ?>" />
	</p>	
	
	<p id="wgd-<?php echo $this->get_field_id('category'); ?>">
		<label for="<?php echo $this->get_field_id('category'); ?>"><?php _e('Category', 'sw-woocommerce')?></label>
		<br />
		<?php echo $this->category_select('category', array('allow_select_all' => true), $categoryid); ?>
	</p>

	<?php if ( $widget_template=='theme-mobile' || $widget_template=='theme-mobile2' || $widget_template=='childcat5' ){ ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('icon_m'); ?>"><?php _e('Select Icon', 'sw-woocommerce')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('icon_m'); ?>" name="<?php echo $this->get_field_name('icon_m'); ?>"
			type="text"	value="<?php echo esc_attr($icon_m); ?>" />
		</p>
		
	<?php } ?>
	<p>
		<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e('Style', 'sw-woocommerce')?></label>
		<br />
		<select class="widefat"
			id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>">
			<option value="" <?php if ($style=='default'){?> selected="selected"
				<?php } ?>>
				<?php _e('Default', 'sw-woocommerce')?>
			</option>
			<option value="style1" <?php if ($style=='style1'){?> selected="selected"
				<?php } ?>>
				<?php _e('Style1', 'sw-woocommerce')?>
			</option>
			<option value="style2" <?php if ($style=='style2'){?> selected="selected"	<?php } ?>>
				<?php _e('Style2', 'sw-woocommerce')?>
			</option>
			<option value="style3" <?php if ($style=='style3'){?> selected="selected"	<?php } ?>>
				<?php _e('Style3', 'sw-woocommerce')?>
			</option>
		</select>
	</p>

	<p>
		<label for="<?php echo $this->get_field_id('orderby'); ?>"><?php _e('Orderby', 'sw-woocommerce')?></label>
		<br />
		<?php $allowed_keys = array('name' => 'Name', 'author' => 'Author', 'date' => 'Date', 'title' => 'Title', 'modified' => 'Modified', 'parent' => 'Parent', 'ID' => 'ID', 'rand' =>'Rand', 'comment_count' => 'Comment Count'); ?>
		<select class="widefat"
		id="<?php echo $this->get_field_id('orderby'); ?>"
		name="<?php echo $this->get_field_name('orderby'); ?>">
		<?php
		$option ='';
		foreach ($allowed_keys as $value => $key) :
			$option .= '<option value="' . $value . '" ';
		if ($value == $orderby){
			$option .= 'selected="selected"';
		}
		$option .=  '>'.$key.'</option>';
		endforeach;
		echo $option;
		?>
	</select>
</p>

<p>
	<label for="<?php echo $this->get_field_id('order'); ?>"><?php _e('Order', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('order'); ?>" name="<?php echo $this->get_field_name('order'); ?>">
	<option value="DESC" <?php if ($order=='DESC'){?> selected="selected"
		<?php } ?>>
		<?php _e('Descending', 'sw-woocommerce')?>
	</option>
	<option value="ASC" <?php if ($order=='ASC'){?> selected="selected"	<?php } ?>>
		<?php _e('Ascending', 'sw-woocommerce')?>
	</option>
</select>
</p>

<p>
	<label for="<?php echo $this->get_field_id('numberposts'); ?>"><?php _e('Number of Posts', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('numberposts'); ?>" name="<?php echo $this->get_field_name('numberposts'); ?>"
	type="text"	value="<?php echo esc_attr($number); ?>" />
</p>

<p>
	<label for="<?php echo $this->get_field_id('number_child'); ?>"><?php _e('Number Of Child Category', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('number_child'); ?>" name="<?php echo $this->get_field_name('number_child'); ?>"
		type="text"	value="<?php echo esc_attr($number_child); ?>" />
</p>

	<?php if ( $widget_template=='childcat1' ){ ?>
	
		<p>
			<label for="<?php echo $this->get_field_id('bnumber'); ?>"><?php _e('Number of items best seller', 'sw-woocommerce')?></label>
			<br />
			<input class="widefat" id="<?php echo $this->get_field_id('bnumber'); ?>" name="<?php echo $this->get_field_name('bnumber'); ?>"
				type="text"	value="<?php echo esc_attr($bnumber); ?>" />
		</p>
	
	<?php } ?>

<p>
	<label for="<?php echo $this->get_field_id('length'); ?>"><?php _e('Excerpt length (in words): ', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat"
	id="<?php echo $this->get_field_id('length'); ?>" name="<?php echo $this->get_field_name('length'); ?>" type="text" 
	value="<?php echo esc_attr($length); ?>" />
</p> 

<p>
	<label for="<?php echo $this->get_field_id('banner_links'); ?>"><?php _e('Banner Links', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('banner_links'); ?>" name="<?php echo $this->get_field_name('banner_links'); ?>"
		type="text"	value="<?php echo esc_attr($banner_links); ?>" />
</p>

<p>
	<label for="<?php echo $this->get_field_id('image'); ?>"><?php _e('Image attachment ID', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('image'); ?>"
		type="text"	value="<?php echo esc_attr($image); ?>" />
</p>

<p>
	<label for="<?php echo $this->get_field_id('date'); ?>"><?php _e('Date ( for layout best seller or layout deals )', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('date'); ?>" name="<?php echo $this->get_field_name('date'); ?>"
		type="date"	value="<?php echo esc_attr($date); ?>" />
</p>
			
<?php $row_number = array( '1' => 1, '2' => 2, '3' => 3, '4' => 4, '5' => 5 ); ?>
<p>
	<label for="<?php echo $this->get_field_id('item_row'); ?>"><?php _e('Number row per column:  ', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('item_row'); ?>"
	name="<?php echo $this->get_field_name('item_row'); ?>">
	<?php
	$option ='';
	foreach ($row_number as $key => $value) :
		$option .= '<option value="' . $value . '" ';
	if ($value == $item_row){
		$option .= 'selected="selected"';
	}
	$option .=  '>'.$key.'</option>';
	endforeach;
	echo $option;
	?>
</select>
</p> 

<?php $number = array('1' => 1, '2' => 2, '3' => 3, '4' => 4, '5' => 5, '6' => 6); ?>
<p>
	<label for="<?php echo $this->get_field_id('columns'); ?>"><?php _e('Number of Columns >1200px: ', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('columns'); ?>"
	name="<?php echo $this->get_field_name('columns'); ?>">
	<?php
	$option ='';
	foreach ($number as $key => $value) :
		$option .= '<option value="' . $value . '" ';
	if ($value == $columns){
		$option .= 'selected="selected"';
	}
	$option .=  '>'.$key.'</option>';
	endforeach;
	echo $option;
	?>
</select>
</p> 

<p>
	<label for="<?php echo $this->get_field_id('columns1'); ?>"><?php _e('Number of Columns on 992px to 1199px: ', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('columns1'); ?>"
	name="<?php echo $this->get_field_name('columns1'); ?>">
	<?php
	$option ='';
	foreach ($number as $key => $value) :
		$option .= '<option value="' . $value . '" ';
	if ($value == $columns1){
		$option .= 'selected="selected"';
	}
	$option .=  '>'.$key.'</option>';
	endforeach;
	echo $option;
	?>
</select>
</p> 

<p>
	<label for="<?php echo $this->get_field_id('columns2'); ?>"><?php _e('Number of Columns on 768px to 991px: ', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('columns2'); ?>"
	name="<?php echo $this->get_field_name('columns2'); ?>">
	<?php
	$option ='';
	foreach ($number as $key => $value) :
		$option .= '<option value="' . $value . '" ';
	if ($value == $columns2){
		$option .= 'selected="selected"';
	}
	$option .=  '>'.$key.'</option>';
	endforeach;
	echo $option;
	?>
</select>
</p> 

<p>
	<label for="<?php echo $this->get_field_id('columns3'); ?>"><?php _e('Number of Columns on 480px to 767px: ', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('columns3'); ?>"
	name="<?php echo $this->get_field_name('columns3'); ?>">
	<?php
	$option ='';
	foreach ($number as $key => $value) :
		$option .= '<option value="' . $value . '" ';
	if ($value == $columns3){
		$option .= 'selected="selected"';
	}
	$option .=  '>'.$key.'</option>';
	endforeach;
	echo $option;
	?>
</select>
</p> 

<p>
	<label for="<?php echo $this->get_field_id('columns4'); ?>"><?php _e('Number of Columns in 480px or less than: ', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('columns4'); ?>"
	name="<?php echo $this->get_field_name('columns4'); ?>">
	<?php
	$option ='';
	foreach ($number as $key => $value) :
		$option .= '<option value="' . $value . '" ';
	if ($value == $columns4){
		$option .= 'selected="selected"';
	}
	$option .=  '>'.$key.'</option>';
	endforeach;
	echo $option;
	?>
</select>
</p> 

<p>
	<label for="<?php echo $this->get_field_id('autoplay'); ?>"><?php _e('Auto Play', 'sw-woocommerce')?></label>
	<br />
	<select class="widefat"
	id="<?php echo $this->get_field_id('autoplay'); ?>" name="<?php echo $this->get_field_name('autoplay'); ?>">
	<option value="false" <?php if ($autoplay=='false'){?> selected="selected"
		<?php } ?>>
		<?php _e('False', 'sw-woocommerce')?>
	</option>
	<option value="true" <?php if ($autoplay=='true'){?> selected="selected"	<?php } ?>>
		<?php _e('True', 'sw-woocommerce')?>
	</option>
</select>
</p>

<p>
	<label for="<?php echo $this->get_field_id('interval'); ?>"><?php _e('Interval', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('interval'); ?>" name="<?php echo $this->get_field_name('interval'); ?>"
	type="text"	value="<?php echo esc_attr($interval); ?>" />
</p>

<p>
	<label for="<?php echo $this->get_field_id('speed'); ?>"><?php _e('Speed', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('speed'); ?>" name="<?php echo $this->get_field_name('speed'); ?>"
	type="text"	value="<?php echo esc_attr($speed); ?>" />
</p>


<p>
	<label for="<?php echo $this->get_field_id('scroll'); ?>"><?php _e('Total Items Slided', 'sw-woocommerce')?></label>
	<br />
	<input class="widefat" id="<?php echo $this->get_field_id('scroll'); ?>" name="<?php echo $this->get_field_name('scroll'); ?>"
	type="text"	value="<?php echo esc_attr($scroll); ?>" />
</p>

<p>
	<label for="<?php echo $this->get_field_id('widget_template'); ?>"><?php _e("Template", 'sw-woocommerce')?></label>
	<br/>
	
	
	<select class="widefat"
	id="<?php echo $this->get_field_id('widget_template'); ?>"	name="<?php echo $this->get_field_name('widget_template'); ?>">
	<option value="default" <?php if ($widget_template=='default'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default', 'sw-woocommerce')?>		
	</option>
	<option value="default1" <?php if ($widget_template=='default1'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default1', 'sw-woocommerce')?>		
	</option>
	<option value="default2" <?php if ($widget_template=='default2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default2', 'sw-woocommerce')?>		
	</option>
	<option value="default3" <?php if ($widget_template=='default3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default3', 'sw-woocommerce')?>		
	</option>
	<option value="default4" <?php if ($widget_template=='default4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default4', 'sw-woocommerce')?>		
	</option>
	<option value="default5" <?php if ($widget_template=='default5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default5', 'sw-woocommerce')?>		
	</option>
	<option value="default6" <?php if ($widget_template=='default6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default6', 'sw-woocommerce')?>		
	</option>
	<option value="default7" <?php if ($widget_template=='default7'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default7', 'sw-woocommerce')?>		
	</option>
	<option value="default8" <?php if ($widget_template=='default8'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default8', 'sw-woocommerce')?>		
	</option>
	<option value="default9" <?php if ($widget_template=='default9'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default9', 'sw-woocommerce')?>		
	</option>
	<option value="default10" <?php if ($widget_template=='default10'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default10', 'sw-woocommerce')?>		
	</option>
	<option value="default11" <?php if ($widget_template=='default11'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default11', 'sw-woocommerce')?>		
	</option>
	<option value="default12" <?php if ($widget_template=='default12'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default12', 'sw-woocommerce')?>		
	</option>
	<option value="default13" <?php if ($widget_template=='default13'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default13', 'sw-woocommerce')?>		
	</option>
	<option value="default14" <?php if ($widget_template=='default14'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default14', 'sw-woocommerce')?>		
	</option>
	<option value="default15" <?php if ($widget_template=='default15'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default15', 'sw-woocommerce')?>		
	</option>
	<option value="default16" <?php if ($widget_template=='default16'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default16', 'sw-woocommerce')?>		
	</option>
	<option value="default17" <?php if ($widget_template=='default17'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default17', 'sw-woocommerce')?>		
	</option>
	<option value="default18" <?php if ($widget_template=='default18'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default18', 'sw-woocommerce')?>		
	</option>
	<option value="default19" <?php if ($widget_template=='default19'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default19', 'sw-woocommerce')?>		
	</option>
	<option value="default20" <?php if ($widget_template=='default20'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default20', 'sw-woocommerce')?>		
	</option>
	<option value="default21" <?php if ($widget_template=='default21'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default21', 'sw-woocommerce')?>		
	</option>
	<option value="default22" <?php if ($widget_template=='default22'){?> selected="selected"
		<?php } ?>>
		<?php _e('Default22', 'sw-woocommerce')?>		
	</option>
	<option value="latest" <?php if ($widget_template=='latest'){?> selected="selected"
		<?php } ?>>
		<?php _e('Latest Product', 'sw-woocommerce')?>		
	</option>
	<option value="latest2" <?php if ($widget_template=='latest2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Latest2 Product', 'sw-woocommerce')?>		
	</option>
	<option value="latest3" <?php if ($widget_template=='latest3'){ ?> selected="selected"
		<?php } ?>>
		<?php _e('Latest3 Product', 'sw-woocommerce')?>		
	</option>
	<option value="latest4" <?php if ($widget_template=='latest4'){ ?> selected="selected"
		<?php } ?>>
		<?php _e('Latest4 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured" <?php if ($widget_template=='featured'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured2" <?php if ($widget_template=='featured2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured2 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured3" <?php if ($widget_template=='featured3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured3 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured4" <?php if ($widget_template=='featured4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured4 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured5" <?php if ($widget_template=='featured5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured5 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured6" <?php if ($widget_template=='featured6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured6 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured7" <?php if ($widget_template=='featured7'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured7 Product', 'sw-woocommerce')?>		
	</option>
	<option value="featured8" <?php if ($widget_template=='featured8'){?> selected="selected"
		<?php } ?>>
		<?php _e('Featured8 Product', 'sw-woocommerce')?>		
	</option>
	<option value="recommend" <?php if ($widget_template=='recommend'){?> selected="selected"
		<?php } ?>>
		<?php _e('Recommend Product', 'sw-woocommerce')?>		
	</option>
	<option value="recommend2" <?php if ($widget_template=='recommend2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Recommend Product2', 'sw-woocommerce')?>		
	</option>
	<option value="recommend3" <?php if ($widget_template=='recommend3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Recommend Product3', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat" <?php if ($widget_template=='banner-cat'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat2" <?php if ($widget_template=='banner-cat2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product2', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat3" <?php if ($widget_template=='banner-cat3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product3', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat4" <?php if ($widget_template=='banner-cat4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product4', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat5" <?php if ($widget_template=='banner-cat5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product5', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat6" <?php if ($widget_template=='banner-cat6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product6', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat7" <?php if ($widget_template=='banner-cat7'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product7', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat8" <?php if ($widget_template=='banner-cat8'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product8', 'sw-woocommerce')?>		
	</option>
	<option value="banner-cat9" <?php if ($widget_template=='banner-cat9'){?> selected="selected"
		<?php } ?>>
		<?php _e('Banner Categories Product9', 'sw-woocommerce')?>		
	</option>
	<option value="bestsales" <?php if ($widget_template=='bestsales'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider', 'sw-woocommerce')?>
	</option>
	<option value="bestsales2" <?php if ($widget_template=='bestsales2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider2', 'sw-woocommerce')?>
	</option>
	<option value="bestsales3" <?php if ($widget_template=='bestsales3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider3', 'sw-woocommerce')?>
	</option>
	<option value="bestsales4" <?php if ($widget_template=='bestsales4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider4', 'sw-woocommerce')?>
	</option>
	<option value="bestsales5" <?php if ($widget_template=='bestsales5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider5', 'sw-woocommerce')?>
	</option>
	<option value="bestsales6" <?php if ($widget_template=='bestsales6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider6', 'sw-woocommerce')?>
	</option>
	<option value="bestsales7" <?php if ($widget_template=='bestsales7'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider7', 'sw-woocommerce')?>
	</option>
	<option value="bestsales8" <?php if ($widget_template=='bestsales8'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider8', 'sw-woocommerce')?>
	</option>
	<option value="bestsales9" <?php if ($widget_template=='bestsales9'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider9', 'sw-woocommerce')?>
	</option>
	<option value="bestsales10" <?php if ($widget_template=='bestsales10'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider10', 'sw-woocommerce')?>
	</option>
	<option value="bestsales11" <?php if ($widget_template=='bestsales11'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider11', 'sw-woocommerce')?>
	</option>
	<option value="bestsales12" <?php if ($widget_template=='bestsales12'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider12', 'sw-woocommerce')?>
	</option>
	<option value="bestsales13" <?php if ($widget_template=='bestsales13'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider13', 'sw-woocommerce')?>
	</option>
	<option value="bestsales14" <?php if ($widget_template=='bestsales14'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider14', 'sw-woocommerce')?>
	</option>
	<option value="bestsales15" <?php if ($widget_template=='bestsales15'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider15', 'sw-woocommerce')?>
	</option>
	<option value="bestsales16" <?php if ($widget_template=='bestsales16'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider16', 'sw-woocommerce')?>
	</option>
	<option value="bestsales17" <?php if ($widget_template=='bestsales17'){?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider17', 'sw-woocommerce')?>
	</option>
	<option value="bestsales18" <?php if ($widget_template=='bestsales18'){ ?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider18', 'sw-woocommerce')?>
	</option>
	<option value="bestsales19" <?php if ($widget_template=='bestsales19'){ ?> selected="selected"
		<?php } ?>>
		<?php _e('Best Selling Slider19', 'sw-woocommerce')?>
	</option>
	<option value="childcat" <?php if ($widget_template=='childcat'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category', 'sw-woocommerce')?>
	</option>
	<option value="childcat1" <?php if ($widget_template=='childcat1'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category2', 'sw-woocommerce')?>
	</option>
	<option value="childcat2" <?php if ($widget_template=='childcat2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category3', 'sw-woocommerce')?>
	</option>
	<option value="childcat3" <?php if ($widget_template=='childcat3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category4', 'sw-woocommerce')?>
	</option>
	<option value="childcat4" <?php if ($widget_template=='childcat4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category5', 'sw-woocommerce')?>
	</option>
	<option value="childcat5" <?php if ($widget_template=='childcat5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category6', 'sw-woocommerce')?>
	</option>
	<option value="childcat6" <?php if ($widget_template=='childcat6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category7', 'sw-woocommerce')?>
	</option>
	<option value="childcat7" <?php if ($widget_template=='childcat7'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category8', 'sw-woocommerce')?>
	</option>
	<option value="childcat8" <?php if ($widget_template=='childcat8'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Child Category 9', 'sw-woocommerce')?>
	</option>
	<option value="top-brand" <?php if ($widget_template=='top-brand'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Top Product', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals2" <?php if ($widget_template=='dailydeals2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 2', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals3" <?php if ($widget_template=='dailydeals3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 3', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals4" <?php if ($widget_template=='dailydeals4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 4', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals5" <?php if ($widget_template=='dailydeals5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 5', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals6" <?php if ($widget_template=='dailydeals6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 6', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals7" <?php if ($widget_template=='dailydeals7'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 7', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals8" <?php if ($widget_template=='dailydeals8'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 8', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals9" <?php if ($widget_template=='dailydeals9'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 9', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals10" <?php if ($widget_template=='dailydeals10'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 10', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals11" <?php if ($widget_template=='dailydeals11'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 11', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals12" <?php if ($widget_template=='dailydeals12'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 12', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals13" <?php if ($widget_template=='dailydeals13'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 13', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals14" <?php if ($widget_template=='dailydeals14'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 14', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals15" <?php if ($widget_template=='dailydeals15'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 15', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals16" <?php if ($widget_template=='dailydeals16'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 16', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals17" <?php if ($widget_template=='dailydeals17'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 17', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals18" <?php if ($widget_template=='dailydeals18'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 18', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals19" <?php if ($widget_template=='dailydeals19'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 19', 'sw-woocommerce')?>
	</option>
	<option value="dailydeals20" <?php if ($widget_template=='dailydeals20'){?> selected="selected"
		<?php } ?>>
		<?php _e('Daily deals 20', 'sw-woocommerce')?>
	</option>
	<option value="most-viewed" <?php if ($widget_template=='most-viewed'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Most Viewed', 'sw-woocommerce')?>
	</option>
	<option value="most-viewed2" <?php if ($widget_template=='most-viewed2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Most Viewed 2', 'sw-woocommerce')?>
	</option>
	<option value="most-viewed3" <?php if ($widget_template=='most-viewed3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Most Viewed 3', 'sw-woocommerce')?>
	</option>
	<option value="most-viewed4" <?php if ($widget_template=='most-viewed4'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Most Viewed 4', 'sw-woocommerce')?>
	</option>
	<option value="most-viewed5" <?php if ($widget_template=='most-viewed5'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Most Viewed 5', 'sw-woocommerce')?>
	</option>
	<option value="most-viewed6" <?php if ($widget_template=='most-viewed6'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Most Viewed 6', 'sw-woocommerce')?>
	</option>
	<option value="on-sale" <?php if ($widget_template=='on-sale'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout On Sale', 'sw-woocommerce')?>
	</option>
	<option value="tab-newarrival" <?php if ($widget_template=='tab-newarrival'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Tab New Arrival', 'sw-woocommerce')?>
	</option>
	<option value="tab-featured" <?php if ($widget_template=='tab-featured'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Tab Featured Product', 'sw-woocommerce')?>
	</option>
	<option value="tab-bestsales" <?php if ($widget_template=='tab-bestsales'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Tab Bestsale Product', 'sw-woocommerce')?>
	</option>
	<option value="toprated" <?php if ($widget_template=='toprated'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Top Rated', 'sw-woocommerce')?>
	</option>
	<option value="toprated2" <?php if ($widget_template=='toprated2'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Top Rated2', 'sw-woocommerce')?>
	</option>
	<option value="theme-mobile" <?php if ($widget_template=='theme-mobile'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Mobile 1', 'sw-woocommerce')?>
	</option>
	<option value="theme-mobile2" <?php if ($widget_template=='theme-mobile'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Mobile 2', 'sw-woocommerce')?>
	</option>
	<option value="theme-mobile3" <?php if ($widget_template=='theme-mobile3'){?> selected="selected"
		<?php } ?>>
		<?php _e('Layout Mobile 3', 'sw-woocommerce')?>
	</option>
</select>
</p>  
<?php
}	
}
}
?>