<?php 

/**
	* Layout Theme Default
	* @version     1.0.0
**/
?>
<div class="item-wrap34">
	<div class="item-detail">										
		<div class="item-img products-thumb">
			<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
			<div class="item-button">
				<?php woocommerce_template_loop_add_to_cart(); ?>
				<?php
				if ( class_exists( 'YITH_WCWL' ) ){
					echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
				} ?>
				<?php if ( class_exists( 'YITH_WOOCOMPARE' ) ){ 
				?>
				<a href="javascript:void(0)" class="compare button"  title="<?php esc_html_e( 'Add to Compare', 'sw-woocommerce' ) ?>" data-product_id="<?php echo esc_attr($post->ID); ?>" rel="nofollow"> <?php esc_html('compare','sw-woocomerce'); ?></a>
				<?php } ?>
				<?php echo emarket_quickview(); ?>
			</div>
			<?php do_action( 'sw_woocommerce_custom_action' ); ?>
		</div>									
		<div class="item-content">	
			<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php sw_trim_words( get_the_title(), $title_length ); ?></a></h4>							
				<!-- rating  -->
				<?php 
				$rating_count = $product->get_rating_count();
				$review_count = $product->get_review_count();
				$average      = $product->get_average_rating();
				?>
				<?php if (  wc_review_ratings_enabled() ) { ?>
				<div class="reviews-content">
					<div class="star"><?php echo ( $average > 0 ) ?'<span style="width:'. ( $average*12 ).'px"></span>' : ''; ?></div>
				</div>	
				<?php } ?>
				<!-- end rating  -->
				<!-- price -->
				<?php if ( $price_html = $product->get_price_html() ){?>
				<div class="item-price">
					<span>
						<?php echo $price_html; ?>
					</span>
				</div>
			<?php } ?>	
			<?php
				$userid = (int)$post->post_author;
				$user =  get_userdata( $userid );
				
				if( class_exists( 'WC_Vendors' ) && in_array('vendor', $user->roles) ):
			?>
				<a class="shop-user" href="<?php echo esc_url( WCV_Vendors::get_vendor_shop_page( $user->ID ) ); ?>"><?php echo get_avatar($user->ID, 20); ?><?php echo $user->display_name; ?></a>
				
			<?php elseif( class_exists( 'WeDevs_Dokan' ) && in_array('seller', $user->roles) ):
				$store_url  = dokan_get_store_url( $userid );
			?>
				<a class="shop-user" href="<?php echo esc_url( $store_url ); ?>"><?php echo get_avatar($user->ID, 20); ?><?php echo $user->display_name; ?></a>
				
			<?php elseif( class_exists('WCMp') && in_array('dc_vendor', $user->roles) ):
				global $WCMp;
				$vendor = get_wcmp_vendor( $userid );
				$store_icon_src = wp_get_attachment_image_src( get_user_meta( $user->ID, '_vendor_image', true ), array( 20, 20 ) );
			?>
				<a class="shop-user" href="<?php echo esc_url( $vendor->get_permalink() ); ?>"><img src="<?php echo esc_url( $store_icon_src ) ?>" /><?php echo $vendor->page_title ?></a>
				
			<?php elseif( class_exists('WCFMmp') ):
				global $WCFMmp;
				$store_user      = wcfmmp_get_store( $userid );
				$store_url       = wcfmmp_get_store_url( $userid );
				$store_name      = wcfm_get_vendor_store_name( $userid );
				$gravatar        = $store_user->get_avatar();
			?>
				<a class="shop-user" href="<?php echo esc_url( $store_url ); ?>"><img width="20" src="<?php echo esc_url( $gravatar ) ?>" /><?php echo $store_name; ?></a>	
			
			<?php endif; ?>	
		</div>
	</div>
</div>
