<?php 

/**
	* Layout Child Category
	* @version     1.0.0
**/
if( $category == '' ){
	return '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'Please select a category for SW Woo Slider. Layout ', 'sw-woocommerce' ).'</p>
	</div>';
}

$widget_id = isset( $widget_id ) ? $widget_id : $this->generateID();
$viewall = get_permalink( wc_get_page_id( 'shop' ) );
$default = array();
if( $category != '' ){
	$default = array(
		'post_type' => 'product',
		'tax_query' => array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ) ),
		'ignore_sticky_posts'   => 1,
		'meta_key' 		 		=> 'total_sales',
		'orderby' 		 		=> 'meta_value_num '. $orderby ,
		'order' => $order,
		'post_status' => 'publish',
		'showposts' => $numberposts
	);
}

$term_name = '';
$term = get_term_by( 'slug', $category, 'product_cat' );
if( $term ) :
	$term_name = $term->name;
	$viewall = get_term_link( $term->term_id, 'product_cat' );
endif;

$list = new WP_Query( $default );
if ( $list -> have_posts() ){
?>
	<div id="<?php echo 'slider_' . $widget_id.rand(); ?>" class="sw-banner-cat-product4 clearfix" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-dots="false" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
		<div class="childcat-slider-content clearfix">
			<!-- Product tab listing -->
						<?php 
			$banner_links = explode( ',', $banner_links );
			if( $image != '' ) :
				$image = explode( ',', $image );	
			?>

			<div class="banner-category">
				<div id="<?php echo esc_attr( 'banner_' . $widget_id ); ?>" class="banner-slider" data-lg="1" data-md="1" data-sm="1" data-xs="1" data-mobile="1" data-arrow="false" data-fade="false">
					<div class="banner-responsive">
						<?php foreach( $image as $key => $img ) : ?>
							<div class="item">
								<a href="<?php echo esc_url( isset( $banner_links[$key] ) ? $banner_links[$key] : '#' ); ?>"><?php echo wp_get_attachment_image( $img, 'large' ); ?></a>
							</div>
						<?php endforeach;?>
					</div>
				</div>									
			</div>
			<?php else:
				echo esc_html__('Please enter the banner image ID for layout.','sw-woocommerce');
			 endif;?>
			<div class="box-title">
				<h3><span><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></span></h3>
				<a class="view-all pull-right" href="<?php echo esc_url( $viewall ); ?>"><?php echo esc_html__('View all','sw-woocommerce'); ?></a>
			</div>
			<div class="resp-slider-container">
				<div class="slider clearfix">	
				<?php 
					$count_items 	= 0;
					$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
					$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
					$i 				= 0;
					while($list->have_posts()): $list->the_post();global $product, $post;
					$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
				?>
					<div class="item <?php echo esc_attr( $class )?> product">
						<div class="item-wrap">
							<div class="item-detail">										
								<div class="item-img products-thumb">			
									<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
										<?php 
										$id = get_the_ID();
										if ( has_post_thumbnail() ){
											echo get_the_post_thumbnail( $post->ID, 'woocommerce_thumbnail', array( 'alt' => $post->post_title ) ) ? get_the_post_thumbnail( $post->ID, 'woocommerce_thumbnail', array( 'alt' => $post->post_title ) ): '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'large'.'.png" alt="No thumb">';		
										}else{
											echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'large'.'.png" alt="No thumb">';
										}
										?>
									</a>
									<!-- add to cart, wishlist, compare -->
									<?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
								</div>										
								<div class="item-content">
									<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php sw_trim_words( get_the_title(), $title_length ); ?></a></h4>								
									<?php if ( $price_html = $product->get_price_html() ){ ?>
										<div class="item-price">
											<span>
												<?php echo $price_html; ?>
											</span>
										</div>
									<?php } ?>	
									<?php
										$product_type = $product->get_type();
										echo sw_label_new();
										if( $product_type != 'variable' ) {
											$forginal_price 	= get_post_meta( $post->ID, '_regular_price', true );	
											$fsale_price 		= get_post_meta( $post->ID, '_sale_price', true );
											if( $fsale_price > 0 && $product->is_on_sale() ){ 
												$sale_off = 100 - ( ( $fsale_price/$forginal_price ) * 100 ); 
												$html = '<div class="sale-off2 ' . esc_attr( ( sw_label_new() != '' ) ? 'has-newicon' : '' ) .'">';
												$html .= ''.round( $sale_off ).'% '. esc_html__('off','sw-woocommerce');
												$html .= '</div>';
												echo apply_filters( 'sw_label_sales', $html );
											} 
										}else{
											echo '<div class="' . esc_attr( ( sw_label_new() != '' ) ? 'has-newicon' : '' ) .'">';
											wc_get_template( 'single-product/sale-flash.php' );
											echo '</div>';
										}
									?>
									<?php $total_sales = get_post_meta( $post->ID, 'total_sales', true ); ?>
									<div class="stock-sold"><span><?php echo $total_sales; ?><?php echo esc_html__(' Sold','sw-woocommerce');?></span></div>
								</div>								
							</div>
						</div>
					 </div>
					<?php $i++; endwhile; wp_reset_postdata();?>
				</div>
			</div>	
		</div>
	</div>
	<?php
	}else{
		echo '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'There is not product in this category', 'sw-woocommerce' ) .'</p>
	</div>';
	}
?>