<?php 

require_once( WSPATH . '/includes/product-variation.php' );

/*
** Hook filter add to cart variable
*/
add_filter( 'woocommerce_loop_add_to_cart_args', 'sw_wooswatches_custom_add_to_cart_args' );
function sw_wooswatches_custom_add_to_cart_args( $args ){
	global $product;
	if( $product->get_type() == 'variable' ) :
		$args['attributes']['data-variation_id'] = 0;
	endif;
	return $args;
}

add_action( 'wc_ajax_sw_wooswatches_custom_add_to_cart_ajax', 'sw_wooswatches_custom_add_to_cart_ajax_callback' );
function sw_wooswatches_custom_add_to_cart_ajax_callback(){
	$product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) );
	$quantity = empty( $_POST['quantity'] ) ? 1 : apply_filters( 'woocommerce_stock_amount', $_POST['quantity'] );
	$variation_id = $_POST['variation_id'];
	$variation  = $_POST['variation'];
	$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

	if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity, $variation_id, $variation  ) ) {
		do_action( 'woocommerce_ajax_added_to_cart', $product_id );
		if ( get_option( 'woocommerce_cart_redirect_after_add' ) == 'yes' ) {
			wc_add_to_cart_message( $product_id );
		}
		
		$wc_ajax = new WC_AJAX();

			// Return fragments
		$wc_ajax::get_refreshed_fragments();
	} else {
		// If there was an error adding to the cart, redirect to the product page to show any errors
		$data = array(
			'error' => true,
			'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id )
			);
		echo json_encode( $data );
	}
	exit();
}
