<?php 
/*
** Product variation hook
*/

/* check if wooswatches not enable */
if( empty( get_option( 'sw_wooswatches_enable' ) ) || get_option( 'sw_wooswatches_enable' ) === 'no' ) :
	return;
endif;

class SW_WooSwatches_Frontend{
	public function __construct(){
		add_filter( 'woocommerce_dropdown_variation_attribute_options_html', array( $this, 'sw_woocommerce_custom_variation' ), 10, 2 );
		// add_action( 'woocommerce_after_shop_loop_item', array( $this, 'sw_wooswatches_custom_variation_listing' ), 200 );
		add_action( 'sw_woocommerce_custom_action', array( $this, 'sw_wooswatches_custom_variation_listing' ), 200 );
		add_action( 'sw_wooswatches_custom', array( $this, 'sw_wooswatches_custom_variation_custom' ), 200 );
	}
	
	/**
	* Single Product Variation
	**/
	function sw_woocommerce_custom_variation( $html, $args ){
		global $product, $post;	
		$options   = $args['options'];
		$product   = $args['product'];
		$attribute = $args['attribute'];
		$name      = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title( $attribute );
		$id        = $args['id'] ? $args['id'] : sanitize_title( $attribute );
		$class     = $args['class'];		
			
		if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
			$attributes = $product->get_variation_attributes();
			$options    = $attributes[ $attribute ];
		}	
		
		if ( ! empty( $options ) ) {
			$attr 		= '';
			$attr2 		= '';
			$img_size = ( get_option( 'sw_wooswatches_tooltip_size' ) ) ? get_option( 'sw_wooswatches_tooltip_size' ) : 'shop_catalog';			
			$width 		= ( get_option( 'sw_wooswatches_w_size' ) ) ? get_option( 'sw_wooswatches_w_size' ) : 0;
			$height		= ( get_option( 'sw_wooswatches_h_size' ) ) ? get_option( 'sw_wooswatches_h_size' ) : 0;
			
			$wh_attr  = ( $width && $height ) ? 'style="width:'. esc_attr( $width ) .'px; height: '. esc_attr( $height ) .'px;" ' : '' ;
			if ( $product && taxonomy_exists( $attribute ) ) {
				global $wpdb;
				$attribute_type = $wpdb->get_row( $wpdb->prepare( "
						SELECT attribute_type
						FROM {$wpdb->prefix}woocommerce_attribute_taxonomies WHERE attribute_name = %s
						",
						wc_attribute_label( $attribute )
					)
				); 
								
				if( $attribute_type->attribute_type == 'select' ){
					$content_html = $html;
				}else{	
					$content_html = '<div class="sw-custom-variation">';		
					$content_html .= $html;
					$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );
					foreach ( $terms as $key => $term ) {
						$color  	= get_term_meta( $term->term_id, 'sw_variation_color', true );
						$color2  	= get_term_meta( $term->term_id, 'sw_variation_color2', true );
						$thumb_id 	= absint( get_term_meta( $term->term_id, 'variation_thumbnail_id', true ) );
						$active 	= ( checked( sanitize_title( $args['selected'] ), $term->slug, false ) ) ? ' selected' : '';				
						$attr 		= ( $color != '' ) ? 'class="variation-color" style="background-color: '. esc_attr( $color ) .';"' : '';
						$attr2 		= ( $color2 != '' ) ? 'class="variation-color style2" style="background: linear-gradient(-45deg, '. esc_attr( $color ) .' 0%, '. esc_attr( $color ) .' 50%, '. esc_attr( $color2 ) .' 50%, '. esc_attr( $color2 ) .' 100%);"' : $attr;

						$parent_attr = '';
						if( $thumb_id ){					
							$attr2 				= ( $thumb_id ) ? 'class="variation-image" style="background-image: url( '. esc_url( wp_get_attachment_thumb_url( $thumb_id ) ) .' );"' : '';
							$img_url			= wp_get_attachment_image_src( $thumb_id, $img_size );
							$parent_attr  = ( 'yes' === get_option( 'sw_wooswatches_tooltip_enable' ) ) ? 'data-toogle="tooltip" data-img="'. esc_url( $img_url[0] ).'" data-width="' . esc_attr( $img_url[1] ) . '" data-height="' . esc_attr( $img_url[2] ) . '"' : '';				
						}
						$parent_attr   .= $wh_attr;
						if ( in_array( $term->slug, $options ) ) {
							$content_html .= '<label class="radio-label sw-radio-variation sw-radio-variation-color sw-radio-variation-'. esc_attr( $key .' '. $active ) .'" title="'. esc_attr( $term->slug )  .'" for="'. esc_attr( $term->slug . '_' . $key ) . '" '. $parent_attr .'>';
							$content_html .= '<input type="radio" id="'.  esc_attr( $term->slug . '_' . $key ) .'"  class="variation-radio" name="' . esc_attr( $name ) . '" data-attribute_name="attribute_' . esc_attr( sanitize_title( $attribute ) ) . '" value="' . esc_attr( $term->slug ) . '" '. checked( sanitize_title( $args['selected'] ), $term->slug, false ) .'/>';
							$content_html .= '<span '. $attr2 .'>'. $term->name .'</span>';
							$content_html .= '</label>';
						}
					}
					$content_html .= '</div>';
				}
			}else {
				
				$meta_variation_check = get_post_meta( $post->ID,  'sw_variation_check', true );
				$meta_variation_type  = get_post_meta( $post->ID,  'sw_variation_type', true );
				$meta_variation       = get_post_meta( $post->ID,  'sw_variation', true ); 
				
				$variation_check = isset( $meta_variation_check[$attribute] ) ? $meta_variation_check[$attribute] : 0;
				$variation_type  = isset( $meta_variation_type[$attribute] ) ? $meta_variation_type[$attribute] : 'checkbox';
				
				if( $variation_type == 'select' ){
					$content_html =  apply_filters( 'sw_wooswatches_single_frontend', $html );		
				}else{
				$content_html 	 = '<div class="sw-custom-variation" data-type="checkbox">';
					$content_html .= $html;
					$options_id = str_replace( ' ', '_', $attribute );
					foreach ( $options as $key => $option ) {					
						$variation_color = isset( $meta_variation[$attribute]['color'][$key] ) ? $meta_variation[$attribute]['color'][$key] : '';
						$variation_color2 = isset( $meta_variation[$attribute]['color2'][$key] ) ? $meta_variation[$attribute]['color2'][$key] : '';
						$variation_image = isset( $meta_variation[$attribute]['image'][$key] ) ? $meta_variation[$attribute]['image'][$key] : 0;
						$parent_attr     = '';
						
						if( !$variation_check && $variation_color != '' ){
							if( $variation_color2 != '' ){
								$attr = 'class="variation-color style2" style="background: linear-gradient(-45deg, '. esc_attr( $variation_color ) .' 0%, '. esc_attr( $variation_color ) .' 50%, '. esc_attr( $variation_color2 ) .' 50%, '. esc_attr( $variation_color2 ) .' 100%);"';
							}else{
								$attr = 'class="variation-color" style="background-color: '. esc_attr( $variation_color ) .'"';
							}
						}
						if( $variation_check && $variation_image ){
							$attr 			 = 'class="variation-image" style="background-image: url( '. esc_url( wp_get_attachment_thumb_url( $variation_image ) ) .' )"';
							$img_url		 = wp_get_attachment_image_src( $variation_image, $img_size );
							$parent_attr = ( 'yes' === get_option( 'sw_wooswatches_tooltip_enable' ) ) ? 'data-toogle="tooltip" data-img="'. esc_url( $img_url[0] ) .'" data-width="' . esc_attr( $img_url[1] ) . '" data-height="' . esc_attr( $img_url[2] ) . '"' : '';		
						}
						$parent_attr  .= $wh_attr;
						
						// This handles < 2.4.0 bw compatibility where text attr were not sanitized.
						$checked = sanitize_title( $args['selected'] ) === $args['selected'] ? checked( $args['selected'], sanitize_title( $option ), false ) : checked( $args['selected'], $option, false );
						$active = ( $checked ) ? 'selected' : '';
						$id = $options_id . '_' . str_replace( ' ', '_', $option ) .'_'. $key;
						$content_html .= '<label class="radio-label sw-radio-variation sw-radio-variation-image sw-radio-variation-'. esc_attr( $key .' '. $active ) .'"  title="'. esc_attr( $option )  .'"  for="'. esc_attr( $id ) . '" '. $parent_attr .'>';
						$content_html .= '<input type="radio" id="'.  esc_attr( $id ) .'" class="variation-radio" name="' . esc_attr( $name ) . '" data-attribute_name="attribute_' . esc_attr( sanitize_title( $attribute ) ) . '" value="' . esc_attr( $option ) . '" '. $checked .'/>';
						$content_html .= '<span '. $attr .'>'. $option .'</span>';
						$content_html .= '</label>';
					}
					$content_html .= '</div>';
				}
			}
			
		}
		return apply_filters( 'sw_wooswatches_single_frontend', $content_html );
	}

	
	function sw_wooswatches_custom_variation_listing(){		
		if( get_option( 'sw_wooswatches_enable_listing' ) === 'no' ){
			return;
		}
		
		// if( !is_shop() && !is_product_category() ):
			// return;
		// endif;
		
		global $product, $post; 
		
		include( WSPATH . '/includes/custom-variation-frontend.php' );
		wp_enqueue_script( 'add-to-cart-variation-ajax', WSURL . '/js/add-to-cart-variation-ajax.js', array( 'jquery' ), null, true );
		wp_localize_script( 'add-to-cart-variation-ajax', 'AddToCartAjax', array(
			'ajaxurl' => WC_AJAX::get_endpoint( "%%endpoint%%" ),
			'notice'	=> esc_html__( 'Please select variation first', 'sw_wooswatches' )
		));
	}
	
	function sw_wooswatches_custom_variation_custom(){
		global $product, $post; 
		
		include( WSPATH . '/includes/custom-variation-frontend.php' );
	}
}

new SW_WooSwatches_Frontend();