<?php
class Emarket_Options_number_slider extends Emarket_Options{
	
	/**
	 * Field Constructor.
	 *
	 * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
	 *
	 * @since SWG_Options 1.0
	*/
	function __construct($field = array(), $value ='', $parent = null ){
		if ( !isset($parent->sections) ){
			$parent->sections = array();
		}
		parent::__construct($parent->sections, $parent->args);
		$this->field = $field;
		$this->value = $value;
		
		
	}//function
	
	
	
	/**
	 * Field Render Function.
	 *
	 * Takes the vars and outputs the HTML for the field in the settings
	 *
	 * @since SWG_Options 1.0
	*/
	function render(){	
		$value = $this->value;
		$max = isset( $this->field['max'] ) ? $this->field['max'] : 300;
		$min = isset( $this->field['min'] ) ? $this->field['min'] : 165;	
	?>
		<div class="slider-number" style="max-width: 400px;">
			<input type="text" readonly name="<?php echo esc_attr( $this->args['opt_name'].'['.$this->field['id'].'][number]' ) ?>" value="<?php echo esc_attr( isset( $value['number'] ) ? $value['number'] : 0 ) ?>" class="input-slider-number"/>
			<input type="text" readonly name="<?php echo esc_attr( $this->args['opt_name'].'['.$this->field['id'].'][numberp]' ) ?>" value="<?php echo esc_attr( isset( $value['numberp'] ) ? $value['numberp'] : 0 ) ?>" class="input-slider-number-percentage" style="display: none;"/>
			<select class="number-meter" name="<?php echo esc_attr( $this->args['opt_name'].'['.$this->field['id'].'][meter]' ) ?>">
				<option value="px" <?php if ( isset( $value['meter'] ) && $value['meter'] === 'px' ){?> selected="selected"<?php } ?>>px</option>
				<option value="%" <?php if ( isset( $value['meter'] ) && $value['meter'] === '%' ){?> selected="selected"<?php } ?> >%</option>
			</select>
			<br/><br/>			
			<div class="slider-range-max-percentage" data-max="40" data-min="10" style="display: none;" data-target=".input-slider-number-percentage"></div>
			<div class="slider-range-max" data-max="<?php echo esc_attr( $max ); ?>" data-min="<?php echo esc_attr( $min ); ?>" data-target=".input-slider-number"></div>
		</div>
		<br/>
		<?php echo (isset($this->field['desc']) && !empty($this->field['desc']))?' <div><span class="description">'. $this->field['desc'] .'</span></div>':''; ?>
	<?php 
	}//function
	
	function enqueue(){
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_style('swg-opts-jquery-ui-css', EMARKET_URL.'/options/css/aristo.css', array(), null);	
		wp_enqueue_script( 'swg-slider-number', EMARKET_URL.'/options/fields/number_slider/number-slider.js', array('jquery'), null, true);		
	}//function
}//class
?>