<?php 
add_filter( 'swg_product_items_layout_args', 'swg_options_product_item_layout_args' );
function swg_options_product_item_layout_args( $args ){
	$args = [
		'default' => [
			'title' => esc_html__( 'Default', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout-default.png' )
		],
		'layout1' => [
			'title' => esc_html__( 'Layout 1', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout1.png' )
		],
		'layout2' => [
			'title' => esc_html__( 'Layout 2', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout2.png' )
		],	
		'layout3' => [
			'title' => esc_html__( 'Layout 3', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout3.png' )
		],
		'layout4' => [
			'title' => esc_html__( 'Layout 4', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout4.png' )
		],
		'layout5' => [
			'title' => esc_html__( 'Layout 5', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout5.png' )
		],
		'layout6' => [
			'title' => esc_html__( 'Layout 6', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout6.png' )
		],
		'layout7' => [
			'title' => esc_html__( 'Layout 7', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout7.png' )
		],
		'layout8' => [
			'title' => esc_html__( 'Layout 8', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout8.png' )
		],
		'layout9' => [
			'title' => esc_html__( 'Layout 9', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout9.png' )
		],
		'layout10' => [
			'title' => esc_html__( 'Layout 10', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout10.png' )
		],
		'layout11' => [
			'title' => esc_html__( 'Layout 11', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout11.png' )
		],
		'layout12' => [
			'title' => esc_html__( 'Layout 12', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout12.png' )
		],
		'layout13' => [
			'title' => esc_html__( 'Layout 13', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout13.png' )
		],
		'layout14' => [
			'title' => esc_html__( 'Layout 14', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout14.png' )
		],
		'layout15' => [
			'title' => esc_html__( 'Layout 15', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout15.png' )
		],
		'layout16' => [
			'title' => esc_html__( 'Layout 16', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout16.png' )
		],
		'layout17' => [
			'title' => esc_html__( 'Layout 17', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout17.png' )
		],
		'layout18' => [
			'title' => esc_html__( 'Layout 18', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout18.png' )
		],
		'layout19' => [
			'title' => esc_html__( 'Layout 19', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout19.png' )
		],
		'layout20' => [
			'title' => esc_html__( 'Layout 20', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout20.png' )
		],
		'layout21' => [
			'title' => esc_html__( 'Layout 21', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout21.png' )
		],
		'layout22' => [
			'title' => esc_html__( 'Layout 22', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout22.png' )
		],
		'layout23' => [
			'title' => esc_html__( 'Layout 23', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout23.png' )
		],
		'layout24' => [
			'title' => esc_html__( 'Layout 24', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout24.png' )
		],
		'layout25' => [
			'title' => esc_html__( 'Layout 25', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout25.png' )
		],
		'layout26' => [
			'title' => esc_html__( 'Layout 26', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout26.png' )
		],
		'layout27' => [
			'title' => esc_html__( 'Layout 27', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout27.png' )
		],
		'layout28' => [
			'title' => esc_html__( 'Layout 28', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout28.png' )
		],
		'layout29' => [
			'title' => esc_html__( 'Layout 29', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout29.png' )
		],
		'layout30' => [
			'title' => esc_html__( 'Layout 30', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout30.png' )
		],
		'layout31' => [
			'title' => esc_html__( 'Layout 31', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout31.png' )
		],
		'layout32' => [
			'title' => esc_html__( 'Layout 32', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout32.png' )
		],
		'layout33' => [
			'title' => esc_html__( 'Layout 33', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout33.png' )
		],
		'layout34' => [
			'title' => esc_html__( 'Layout 34', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout34.png' )
		],
		'layout35' => [
			'title' => esc_html__( 'Layout 35', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout35.png' )
		],
		'layout36' => [
			'title' => esc_html__( 'Layout 36', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout36.png' )
		],
		'layout37' => [
			'title' => esc_html__( 'Layout 37', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout37.png' )
		],
		'layout38' => [
			'title' => esc_html__( 'Layout 38', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout38.png' )
		],
		'layout39' => [
			'title' => esc_html__( 'Layout 39', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout39.png' )
		],
		'layout40' => [
			'title' => esc_html__( 'Layout 40', 'emarket' ),
			'img'	=> esc_url( get_template_directory_uri() . '/assets/img/layout/layout40.png' )
		],
	];
	return $args;
}

/*
** Add To Cart Text
*/
add_filter( 'woocommerce_product_add_to_cart_text', 'emarket_custom_add_to_cart_text' );
add_filter( 'sw_bundle_add_to_cart_text', 'emarket_custom_add_to_cart_text' );
function emarket_custom_add_to_cart_text( $text ){
	global $product;
	$add_to_cart_text = emarket_options()->getCpanelValue( 'product_add_cart_text' );
	if( $product->is_purchasable() && $product->is_in_stock() && !empty( $add_to_cart_text ) ){
		$text = $add_to_cart_text;
	}
	return $text;
}

/*
** Quickview
*/
function emarket_quickview( $echo = false ){
	global $product;
	$html = '';
	$quickview 	= emarket_options()->getCpanelValue( 'product_quickview' );
	$layout 	= emarket_options()->getCpanelValue( 'product_items_layout' );
	if( $quickview ):
	ob_start();
?>
		<a href="#" data-product_id="<?php echo esc_attr( $product->get_id() ) ?>" title="<?php echo esc_attr__( 'Quick View ', 'emarket' ) ?>" class="sw-quickview icon-svg" data-type="quickview" data-ajax_url="<?php echo esc_attr( WC_AJAX::get_endpoint( "%%endpoint%%" ) ); ?>">
			<?php if( in_array( $layout, ['layout3', 'layout6', 'layout12', 'layout22'] ) ){ ?>
			<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"><path d="M2.036 12.322a1 1 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178c.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178"/><path d="M15 12a3 3 0 1 1-6 0a3 3 0 0 1 6 0"/></g></svg>
			<?php }elseif( $layout === 'layout9' ){ ?>
			<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 32 32"><g><path d="M 31.922,16.618c-0.050-0.122-0.124-0.232-0.216-0.324l-4-4c-0.39-0.39-1.024-0.39-1.414,0 c-0.39,0.39-0.39,1.024,0,1.414L 28.586,16L 18,16 L 18,5.414 l 2.292,2.292c 0.39,0.39, 1.024,0.39, 1.414,0c 0.39-0.39, 0.39-1.024,0-1.414 l-4-4C 17.704,2.29, 17.698,2.288, 17.696,2.286C 17.606,2.198, 17.5,2.126, 17.382,2.078C 17.26,2.026, 17.13,2, 17,2C 16.998,2, 16.998,2, 16.996,2 C 16.868,2, 16.74,2.028, 16.618,2.078C 16.5,2.126, 16.394,2.198, 16.304,2.286C 16.3,2.288, 16.296,2.29, 16.292,2.292l-4,4 c-0.39,0.39-0.39,1.024,0,1.414c 0.39,0.39, 1.024,0.39, 1.414,0L 16,5.414L 16,16 L 5.414,16 l 2.292-2.292c 0.39-0.39, 0.39-1.024,0-1.414 c-0.39-0.39-1.024-0.39-1.414,0l-4,4C 2.29,16.296, 2.288,16.302, 2.286,16.304C 2.198,16.394, 2.126,16.5, 2.078,16.618 C 2.026,16.74, 2,16.87, 2,17c0,0.002,0,0.002,0,0.004C 2,17.132, 2.028,17.26, 2.078,17.382c 0.048,0.118, 0.12,0.224, 0.208,0.314 C 2.288,17.7, 2.29,17.704, 2.292,17.708l 4,4c 0.39,0.39, 1.024,0.39, 1.414,0c 0.39-0.39, 0.39-1.024,0-1.414L 5.414,18L 16,18 l0,10.586 l-2.292-2.292c-0.39-0.39-1.024-0.39-1.414,0c-0.39,0.39-0.39,1.024,0,1.414l 4,4c 0.092,0.092, 0.202,0.166, 0.324,0.216 C 16.74,31.972, 16.868,32, 16.996,32c 0.002,0, 0.002,0, 0.004,0c 0.13,0, 0.26-0.026, 0.382-0.078c 0.122-0.050, 0.232-0.124, 0.324-0.216l 4-4 c 0.39-0.39, 0.39-1.024,0-1.414c-0.39-0.39-1.024-0.39-1.414,0L 18,28.586L 18,18 l 10.586,0 l-2.292,2.292 c-0.39,0.39-0.39,1.024,0,1.414c 0.39,0.39, 1.024,0.39, 1.414,0l 4-4c 0.092-0.092, 0.166-0.202, 0.216-0.324 C 31.972,17.26, 32,17.132, 32,17.004c0-0.002,0-0.002,0-0.004C 32,16.87, 31.974,16.74, 31.922,16.618z"/></g></svg>			
			<?php }elseif( in_array( $layout, ['layout16', 'layout18'] ) ){ ?>
			<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 426.742 426.742"><g><g><path d="M398.299,161.491l-90.957-68.128c-51.891-38.867-136.073-38.833-187.928,0l-91.139,68.253    c-37.678,28.217-37.664,74.156-0.167,102.46l91.666,69.191c51.7,39.025,135.58,38.977,187.209,0l91.651-69.191    C436.212,235.705,436.123,189.822,398.299,161.491z M372.924,230.023l-91.651,69.191c-36.439,27.51-99.333,27.521-135.796-0.002    l-91.666-69.191c-14.873-11.227-14.861-23.097,0.037-34.254l91.139-68.253c36.711-27.492,100.061-27.5,136.774-0.002    l90.957,68.128C387.81,206.942,387.843,218.761,372.924,230.023z"/></g></g>g><g><path d="M213.352,138.04c-41.237,0-74.667,33.429-74.667,74.667c0,41.237,33.429,74.667,74.667,74.667    s74.667-33.429,74.667-74.667C288.019,171.469,254.59,138.04,213.352,138.04z M213.352,244.706c-17.673,0-32-14.327-32-32    c0-17.673,14.327-32,32-32s32,14.327,32,32C245.352,230.379,231.025,244.706,213.352,244.706z"/></g></g></svg>
			<?php }else{ ?>
			<svg xmlns='http://www.w3.org/2000/svg' width="1em" height="1em" viewBox="0 0 1000 1000"><path d="M684.416 676.523c-1.451 1.109-2.859 2.347-4.224 3.712s-2.56 2.731-3.712 4.224c-53.675 51.755-126.677 83.541-207.147 83.541-82.475 0-157.099-33.365-211.2-87.467s-87.467-128.725-87.467-211.2 33.365-157.099 87.467-211.2 128.725-87.467 211.2-87.467 157.099 33.365 211.2 87.467 87.467 128.725 87.467 211.2c0 80.469-31.787 153.472-83.584 207.189zM926.165 865.835l-156.8-156.8c52.523-65.707 83.968-149.035 83.968-239.701 0-106.027-43.008-202.069-112.469-271.531s-165.504-112.469-271.531-112.469-202.069 43.008-271.531 112.469-112.469 165.504-112.469 271.531 43.008 202.069 112.469 271.531 165.504 112.469 271.531 112.469c90.667 0 173.995-31.445 239.701-83.968l156.8 156.8c16.683 16.683 43.691 16.683 60.331 0s16.683-43.691 0-60.331z"/></svg>
			<?php } ?>
		</a>

<?php 
		$html .= ob_get_clean();
	endif;
	if( $echo ){
		echo apply_filters( 'emarket_quickview_filter', $html );
	}else{
		return apply_filters( 'emarket_quickview_filter', $html );;
	}
}

/*
** Global hook
*/
/*
** Add second thumbnail loop product
*/
add_action( 'elementor/editor/init', 'custom_init_function' );
add_filter( 'woocommerce_product_get_rating_html', 'emarket_custom_filter_rating', 10, 3 );

remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10  );

add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 5 );
add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_label_sales', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 11 );
add_action( 'woocommerce_shop_loop_item_title', 'emarket_wrap_content_open', 1 );
add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'emarket_product_description', 10 );
// add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 11 );

/*
*** Listing Layout
*/
$main_layout = emarket_options()->getCpanelValue( 'product_items_layout' );

add_action( 'woocommerce_before_shop_loop_item', 'emarket_wrapper_start', 0 );	 
add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_before_shop_loop_item_title_start', 1 );
add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_before_shop_loop_item_title_end', 99 );
if(  in_array( $main_layout, ['default', 'layout4', 'layout5', 'layout8', 'layout11', 'layout13', 'layout14', 'layout15', 'layout20', 'layout21', 'layout23', 'layout31', 'layout33', 'layout36', 'layout38', 'layout40'] ) || empty( $main_layout ) ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom', 98 );
}

if( $main_layout === 'layout1' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout1', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart', 10 );
}

if( $main_layout === 'layout2' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_rating_custom', 9 );
}

if( in_array( $main_layout, ['layout3', 'layout17' ] ) ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout1', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart', 10 );
}
if( in_array( $main_layout, ['layout5', 'layout11'] ) ){
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
}

if( $main_layout === 'layout6' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout1', 98 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart', 10 );
}

if( $main_layout === 'layout7' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout2', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 9 );
}

if( $main_layout === 'layout8' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
}

if( $main_layout === 'layout9' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout2', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
}

if( $main_layout === 'layout10' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 10 );
}

if( $main_layout === 'layout12' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout3', 98 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart_layout1', 10 );
}

if( $main_layout === 'layout13' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_rating_custom', 10 );
}

if( $main_layout === 'layout14' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_rating_custom', 10 );
}

if( $main_layout === 'layout15' ){
	remove_action( 'woocommerce_before_shop_loop_item_title', 'emarket_label_sales', 10 );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_template_loop_price', 10 );
}

if( in_array( $main_layout, [ 'layout16', 'layout18' ] ) ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout2', 98 );
}

if( $main_layout === 'layout17' ){
	//add_action( 'woocommerce_shop_loop_item_title', 'emarket_custom_variation', 8 );
}

if( in_array( $main_layout, [ 'layout17', 'layout20'] ) ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'emarket_label_sales', 10 );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_template_loop_price', 10 );
}

if( $main_layout === 'layout18' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
}

if( $main_layout === 'layout19' ){
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout4', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_template_loop_price_layout1', 10 );	
}

if( in_array( $main_layout, [ 'layout20', 'layout40' ] ) ){
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 9 );
}

if( $main_layout === 'layout22' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_woocommerce_stock_quantity', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart_layout2', 10 );
}

if( $main_layout === 'layout24' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart_layout2', 10 );
}

if( $main_layout === 'layout25' ){
	remove_action( 'woocommerce_before_shop_loop_item_title', 'emarket_label_sales', 10 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout3', 20 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_custom_sale_flash_label', 11  );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_rating_wrapper', 5 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_template_rating_custom', 5 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_product_addcart_end', 11 );
}

if( $main_layout === 'layout26' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout2', 98 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_variation', 10 );
}

if( in_array( $main_layout, [ 'layout27', 'layout29' ] ) ){
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_custom_variation', 98 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_product_item_bottom', 11 );
}	

if( $main_layout === 'layout28' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout1', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_variation', 11 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_before_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item', 'emarket_woocommerce_template_loop_after_add_to_cart', 10 );
}

if( $main_layout === 'layout29' ){
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
}

if( $main_layout === 'layout30' ){
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout4', 98 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_variation', 11 );
}

if( $main_layout === 'layout31' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_custom_variation', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
}

if( $main_layout === 'layout32' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout4', 98 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_custom_variation', 11 );
}

if( in_array( $main_layout, [ 'layout34', 'layout35', 'layout37' ] ) ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout4', 98 );
	add_action( 'woocommerce_shop_loop_item_title', 'emarket_template_categories_name', 9 );
}

if( $main_layout === 'layout36' ){
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 6 );
}

if( $main_layout === 'layout37' ){
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'emarket_custom_variation', 11 );
}

if( $main_layout === 'layout38' ){
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_custom_variation', 98 );
}

if( $main_layout === 'layout39' ){
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 9 );
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 6 );
	add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_item_bottom_layout5', 98 );
}


if( emarket_options()->getCpanelValue( 'product_listing_countdown' ) ){
	// add_action( 'woocommerce_before_shop_loop_item_title', 'emarket_product_deal_listing', 20 );
}
add_action( 'woocommerce_after_shop_loop_item', 'emarket_wrap_content_end', 998 );
add_action( 'woocommerce_after_shop_loop_item', 'emarket_wrapper_end', 999 );

function custom_init_function(){
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
	remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
}

function emarket_custom_filter_rating( $html, $rating, $count = 0 ){
	$label = sprintf( __( 'Rated %s out of 5', 'emarket' ), $rating );
	return '<div class="star-rating" role="img" aria-label="' . esc_attr( $label ) . '">' . wc_get_star_rating_html( $rating, $count ) . '</div>';
}

/*
** Label Sale custom
*/
function emarket_custom_sale_flash_label(){
	global $product;
	if ( $product->is_on_sale() ) :
		echo apply_filters( 'emarket_custom_sale_flash', '<span class="custom-onsale">' . esc_html__( 'Promo', 'emarket' ) . '</span>', $product );
	endif;
}

/*
** Wrap product item
*/
function emarket_wrapper_start(){
	?>
		<div class="products-entry item-wrap">
	<?php 
}

/*
** End wrap product item
*/
function emarket_wrapper_end(){
	?>
		</div>
	<?php 
}

/*
** Wrap product item content ( title, rating, price ... )
*/
function emarket_wrap_content_open(){
	?>
		<div class="item-content">
	<?php 
}

function emarket_wrap_content_end(){
	?>
		</div>
	<?php 
}

/*
** Get Store Name
*/
function emarket_get_vendor_store_name(){
	global $post;
	$userid = (int)$post->post_author;
	$user =  get_userdata( $userid );		
		if( class_exists( 'WC_Vendors' ) && in_array('vendor', $user->roles) ):
	?>
		<a class="shop-user" href="<?php echo esc_url( WCV_Vendors::get_vendor_shop_page( $user->ID ) ); ?>"><?php echo $user->display_name; ?></a>
		
	<?php elseif( class_exists( 'WeDevs_Dokan' ) && in_array('seller', $user->roles) ):
		$store_url  = dokan_get_store_url( $userid );
	?>
		<a class="shop-user" href="<?php echo esc_url( $store_url ); ?>"><?php echo $user->display_name; ?></a>
		
	<?php elseif( class_exists('WCMp') && in_array('dc_vendor', $user->roles) ):
		global $WCMp;
		$vendor = get_wcmp_vendor( $userid );
	?>
		<a class="shop-user" href="<?php echo esc_url( $vendor->get_permalink() ); ?>"><?php echo $vendor->page_title ?></a>
		
	<?php elseif( class_exists('WCFMmp') && in_array('wcfm_vendor', $user->roles) ):
		global $WCFMmp;
		$store_url       = wcfmmp_get_store_url( $userid );
		$store_name      = wcfm_get_vendor_store_name( $userid );
	?>
		<a class="shop-user" href="<?php echo esc_url( $store_url ); ?>"><?php echo $store_name; ?></a>		
	<?php endif;
}

/*
** categories name product
*/
function emarket_template_categories_name(){
	global $product;					
	$terms_id = get_the_terms( $product->get_id(), 'product_cat' );
	$term_str = '<a href="'. get_term_link( $terms_id[0]->term_id, 'product_cat' ) .'">'. esc_html( $terms_id[0]->name ) .'</a>';
	$main_layout = emarket_options()->getCpanelValue( 'product_items_layout' );
?>
	<div class="item-categories">
<?php if( $main_layout === 'layout20'  ){ ?>
		<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><path d="M4 4v3.656l-3 4V12c0 1.645 1.355 3 3 3v13h16v-9h2v9h6V15c1.645 0 3-1.355 3-3v-.344l-3-4V4zm2 2h20v1H6zm-.5 3h21l2.406 3.219c-.11.433-.437.781-.906.781c-.555 0-1-.445-1-1h-2c0 .555-.445 1-1 1s-1-.445-1-1h-2c0 .555-.445 1-1 1s-1-.445-1-1h-2c0 .555-.445 1-1 1s-1-.445-1-1h-2c0 .555-.445 1-1 1s-1-.445-1-1H9c0 .555-.445 1-1 1s-1-.445-1-1H5c0 .555-.445 1-1 1c-.469 0-.797-.348-.906-.781zm.5 5.219c.531.48 1.234.781 2 .781s1.469-.3 2-.781c.531.48 1.234.781 2 .781s1.469-.3 2-.781c.531.48 1.234.781 2 .781s1.469-.3 2-.781c.531.48 1.234.781 2 .781s1.469-.3 2-.781c.531.48 1.234.781 2 .781s1.469-.3 2-.781V26h-2v-9h-6v9H6zM8 17v7h8v-7zm2 2h4v3h-4z"/></svg>
		<?php 
			if( emarket_get_vendor_store_name() ){
				emarket_get_vendor_store_name();
			}else{
				echo  apply_filters( 'emarket_category_term_meta', $term_str );
			}
		?>
	<?php }elseif( $main_layout === 'layout40' ){ ?>
		<?php 
			if( emarket_get_vendor_store_name() ){
				emarket_get_vendor_store_name();
			}else{
				echo  apply_filters( 'emarket_category_term_meta', $term_str );
			}
		?>
	<?php }elseif( in_array( $main_layout, ['layout28', 'layout35'] ) ){ 
		$term_str1 = '';	
		foreach( $terms_id as $key => $value ) :
			$term_str1 .= '<a href="'. get_term_link( $value->term_id, 'product_cat' ) .'">'. esc_html( $value->name ) .'</a>';
		endforeach;
	?>
			<?php echo  apply_filters( 'emarket_category_term_meta', $term_str1 ); ?>	
	<?php }else{ ?>
		<?php echo  apply_filters( 'emarket_category_term_meta', $term_str ); ?>
	<?php } ?>
	</div>
<?php
}

/*
** Rating Custom
*/
function emarket_custom_rating_wrapper(){
?>
	<div class="item-rating-wrap">
<?php 
}	
function emarket_template_rating_custom( $style = 'default' ){
	global $product;
	$rating_count = $product->get_rating_count();
	$review_count = $product->get_review_count();
	$average      = $product->get_average_rating();
	$main_layout = emarket_options()->getCpanelValue( 'product_items_layout' );
?>
	<?php if( $main_layout === 'layout25' ){ ?>
		<?php if (  wc_review_ratings_enabled() && $average > 0 ) { ?>
		<div class="item-rating">
			<?php echo '<span class="average">'.esc_html( $average ).'</span><span class="count-rated">('. esc_html( $rating_count ). '+)</span>';?>
		</div>
		<?php } ?>
	<?php }else{ ?>
		<div class="item-rating">		
			<?php woocommerce_template_loop_rating(); ?>
			<div class="item-rating-count">
			<?php if( $main_layout === 'layout13' ){ ?>
				<?php echo esc_html( '('. $review_count . ')' ); ?>
			<?php }elseif( $main_layout === 'layout14' ){ ?>
				<?php echo esc_html( $review_count ); ?>
			<?php }else{ ?>
				<?php printf( _n( '%s Review', '%s Reviews', $review_count, 'emarket' ), number_format_i18n( $review_count ) ); ?>
			<?php } ?>
			</div>		
		</div>
	<?php } ?>
<?php
}

/*
** Trim word with theme options configuration
*/
function emarket_template_loop_product_title(){
	?>
	<a href="<?php the_permalink(); ?>" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">
		<h2 class="<?php echo esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title' ) ) ?>"><?php emarket_trim_words( get_the_title(), 'product' ) ?></h2>
	</a>
<?php 
}

/*
** Wrap product image item
*/
function emarket_before_shop_loop_item_title_start(){
?>
	<div class="item-img">
<?php 
}

function emarket_before_shop_loop_item_title_end(){
?>
	</div>
<?php 
}

/*
** Add description to layout list
*/
function emarket_product_description(){
	global $post; 
	if ( ! $post->post_excerpt ) return;
	if( is_post_type_archive( 'product' ) || is_tax( 'product_cat' ) || is_tax( 'product_brand' ) ){ 
		echo '<div class="item-description">'.wp_trim_words( $post->post_excerpt, 30 ).'</div>';
	}
}
/*
** Custom Price
*/
function emarket_custom_template_loop_price(){
?>
	<div class="item-price-bottom">
		<?php woocommerce_template_loop_price(); ?>
		<?php emarket_label_sales(1); ?>
	</div>
<?php 
}

function emarket_custom_template_loop_price_layout1(){
?>
	<div class="item-price-bottom">
		<?php woocommerce_template_loop_price(); ?>
		<?php woocommerce_template_loop_add_to_cart(); ?>
	</div>
<?php 
}

/*
** Wrap additional function
*/
function emarket_product_addcart_start( $value = '' ){
?>
	<div class="item-bottom <?php echo esc_attr( $value ); ?>">
<?php 
}

function emarket_product_addcart_start2(){
	$quickview = emarket_options()->getCpanelValue( 'product_quickview' );
	echo '<div class="item-group '. ( $quickview ? '': 'no-quickview') .'">';
}

function emarket_product_addcart_end(){
	echo '</div>';
}

function emarket_product_addcart_end2(){
	echo '</div>';
}

function emarket_product_addcart_mid(){
	global $product, $post;
	$layout 	= emarket_options()->getCpanelValue( 'product_items_layout' );
	$html = '';
	/* compare & wishlist */
	if( class_exists( 'YITH_WCWL' ) ){
		$html .= do_shortcode( "[yith_wcwl_add_to_wishlist]" );
	}
	if( class_exists( 'YITH_WOOCOMPARE' ) ){	
		ob_start();
?>	
		<a href="#" class="compare icon-svg" data-product_id="<?php echo esc_attr( $product->get_id() ); ?>" rel="nofollow" title="<?php echo esc_attr__( 'Compare', 'emarket' ); ?>">
		<?php if( $layout === 'layout9' ){ ?>
			<svg xmlns="http://www.w3.org/2000/svg"  width="1em" height="1em" viewBox="0 0 32 32"><g><path d="M 5.558,23.562c 0.39-0.39, 0.39-1.024,0-1.414L 3.41,20L 21,20 c 0.552,0, 1-0.448, 1-1 C 22,18.448, 21.552,18, 21,18L 3.41,18 l 2.294-2.294c 0.39-0.39, 0.39-1.024,0-1.414c-0.39-0.39-1.024-0.39-1.414,0L 0.292,18.29 C 0.096,18.486,0,18.742,0,19c0,0.258, 0.096,0.514, 0.292,0.71l 3.852,3.852C 4.536,23.954, 5.168,23.954, 5.558,23.562zM 31.708,12.31l-3.852-3.852c-0.39-0.39-1.024-0.39-1.414,0s-0.39,1.024,0,1.414l 2.148,2.148L 11,12.020 C 10.448,12.020, 10,12.468, 10,13.020s 0.448,1, 1,1l 17.59,0 l-2.294,2.294c-0.39,0.39-0.39,1.024,0,1.414 c 0.39,0.39, 1.024,0.39, 1.414,0l 3.998-3.998C 31.904,13.534, 32,13.278, 32,13.020C 32,12.762, 31.904,12.506, 31.708,12.31z"/></g></svg>
		<?php }elseif( in_array( $layout, ['layout16', 'layout18'] ) ){ ?>
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64" width="1em" height="1em"><path d="m19 25h9c1.104 0 2-.896 2-2s-.896-2-2-2h-9c-6.065 0-11 4.935-11 11s4.935 11 11 11h4.172l-1.586 1.586c-.781.781-.781 2.047 0 2.828.391.391.902.586 1.414.586s1.023-.195 1.414-.586l5-5c.781-.781.781-2.047 0-2.828l-5-5c-.781-.781-2.047-.781-2.828 0s-.781 2.047 0 2.828l1.586 1.586h-4.172c-3.859 0-7-3.141-7-7 0-3.86 3.141-7 7-7z"/><path d="m45 21h-4.172l1.586-1.586c.781-.781.781-2.047 0-2.828s-2.047-.781-2.828 0l-5 5c-.781.781-.781 2.047 0 2.828l5 5c.391.391.902.586 1.414.586s1.023-.195 1.414-.586c.781-.781.781-2.047 0-2.828l-1.586-1.586h4.172c3.859 0 7 3.14 7 7 0 3.859-3.141 7-7 7h-9c-1.104 0-2 .896-2 2s.896 2 2 2h9c6.065 0 11-4.935 11-11s-4.935-11-11-11z"/></svg>
		<?php }elseif( in_array( $layout, ['layout26', 'layout29', 'layout34', 'layout38' , 'layout40'] ) ){ ?>
			<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 1024 1024"><path d="m21.84 301.808l475.09 258.72a32.1 32.1 0 0 0 15.312 3.904a32 32 0 0 0 15.184-3.84l480.096-258.72c10.464-5.631 16.975-16.624 16.815-28.528a32.09 32.09 0 0 0-17.504-28.16L531.713 3.904c-9.055-4.592-19.744-4.624-28.88-.064L22.785 245.12c-10.624 5.343-17.44 16.16-17.632 28.064s6.256 22.944 16.687 28.624M517.153 68.287l406.159 206.271L512.336 496.03L106.16 274.846zm484.187 412.031l-94.974-48.225l-68.56 36.976l80 40.624l-410.96 221.456l-406.191-221.184l85.311-42.88l-68.368-37.248l-100.32 50.4c-10.624 5.344-17.44 16.16-17.633 28.065s6.256 22.944 16.688 28.624l475.088 258.72a32.1 32.1 0 0 0 15.312 3.903a32 32 0 0 0 15.184-3.84l480.096-258.72c10.464-5.631 16.975-16.624 16.815-28.528a32 32 0 0 0-17.487-28.143zm.01 223.999l-89.966-44.224l-68.56 36.976l75.008 36.624l-410.976 221.456l-406.192-221.184l79.312-35.872l-68.368-37.248l-94.32 43.408C6.662 709.597-.154 720.413-.346 732.318s6.255 22.944 16.687 28.624l475.088 258.72a32.1 32.1 0 0 0 15.313 3.903a32 32 0 0 0 15.183-3.84l480.096-258.72c10.464-5.632 16.976-16.624 16.816-28.528a32 32 0 0 0-17.488-28.16z"/></svg>
		<?php }else{ ?>
			<svg xmlns='http://www.w3.org/2000/svg' width="1em" height="1em" viewBox="0 0 1000 1000"><path d="M170.667 469.333v-85.333c0-35.371 14.293-67.285 37.504-90.496s55.125-37.504 90.496-37.504h494.336l-97.835 97.835c-16.683 16.683-16.683 43.691 0 60.331s43.691 16.683 60.331 0l170.667-170.667c4.096-4.096 7.168-8.789 9.259-13.824s3.243-10.539 3.243-16.341c0-5.547-1.067-11.136-3.243-16.341-2.091-5.035-5.163-9.728-9.259-13.824l-170.667-170.667c-16.683-16.683-43.691-16.683-60.331 0s-16.683 43.691 0 60.331l97.835 97.835h-494.336c-58.88 0-112.299 23.936-150.869 62.464s-62.464 91.989-62.464 150.869v85.333c0 23.552 19.115 42.667 42.667 42.667s42.667-19.115 42.667-42.667zM853.333 554.667v85.333c0 35.371-14.293 67.285-37.504 90.496s-55.125 37.504-90.496 37.504h-494.336l97.835-97.835c16.683-16.683 16.683-43.691 0-60.331s-43.691-16.683-60.331 0l-170.667 170.667c-3.925 3.925-7.083 8.619-9.259 13.824s-3.243 10.795-3.243 16.341c0 10.923 4.181 21.845 12.501 30.165l170.667 170.667c16.683 16.683 43.691 16.683 60.331 0s16.683-43.691 0-60.331l-97.835-97.835h494.336c58.88 0 112.299-23.936 150.869-62.464s62.464-91.989 62.464-150.869v-85.333c0-23.552-19.115-42.667-42.667-42.667s-42.667 19.115-42.667 42.667z"/></svg>
		<?php } ?>
		</a>	
		<?php
			wp_enqueue_script( 'yith-woocompare-main' );
		?>
<?php 
		$html .= ob_get_clean();
	}
	
	echo apply_filters( 'emarket_add_to_cart_listing_additional', $html );
}

function emarket_product_addcart_quickview(){
	global $product, $post;
	$quickview = emarket_options()->getCpanelValue( 'product_quickview' );
	
	$html = '';	
	$html .= woocommerce_template_loop_add_to_cart();
	$html .= emarket_quickview();
	
	echo apply_filters( 'emarket_add_to_cart_listing_additional', $html );
}

function emarket_product_item_bottom(){
	emarket_product_addcart_start();
	emarket_product_addcart_mid();
	emarket_quickview(true);
	woocommerce_template_loop_add_to_cart();
	emarket_product_addcart_end();
}

function emarket_product_item_bottom_layout1(){
	emarket_product_addcart_start( 'center' );
	emarket_quickview(true);
	emarket_product_addcart_end();
}

function emarket_product_item_bottom_layout2(){
	emarket_product_addcart_start( 'center list' );
	emarket_product_addcart_mid();
	emarket_quickview(true);
	emarket_product_addcart_end();
}

function emarket_product_item_bottom_layout3(){
	emarket_product_addcart_start( 'right show' );
	if( class_exists( 'YITH_WCWL' ) ){
		echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
	}
	emarket_product_addcart_end();
}

function emarket_product_item_bottom_layout4(){
	emarket_product_addcart_start( 'right' );
	emarket_product_addcart_mid();
	emarket_quickview(true);
	emarket_product_addcart_end();
}

function emarket_product_item_bottom_layout5(){
	emarket_product_addcart_start();
	emarket_quickview(true);
	if( class_exists( 'YITH_WCWL' ) ){
		echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
	}
	emarket_product_addcart_end();
}

function emarket_woocommerce_template_loop_before_add_to_cart(){
?>
	<div class="item-bottom-content">
<?php 
}

function emarket_woocommerce_template_loop_after_add_to_cart(){
	emarket_product_addcart_mid();
	emarket_product_addcart_end();
}

function emarket_woocommerce_template_loop_after_add_to_cart_layout1(){
	emarket_quickview(true);
	emarket_product_addcart_end();
}

function emarket_woocommerce_template_loop_after_add_to_cart_layout2(){
	emarket_product_addcart_start( 'right' );
	emarket_quickview(true);
	if( class_exists( 'YITH_WCWL' ) ){
		echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
	}
	emarket_product_addcart_end();
	emarket_product_addcart_end();
}

function emarket_woocommerce_stock_quantity(){
	global $product;
?>
	<div class="box-istock">
	<?php echo emarket_product_stock_hompage(); ?>
	<?php if ( $weight = $product->get_weight() ) {
			echo '<div class="item-weight"> - ' . $weight . get_option('woocommerce_weight_unit') . '</div>';
		} ?>
	</div>
<?php 
}

function emarket_custom_variation(){
	do_action( 'sw_woocommerce_custom_action' );
}