<?php 
/**
 * Theme wrapper
 *
 * @link http://scribu.net/wordpress/theme-wrappers.html
 */



/**
 * Page titles
 */
function emarket_title() {
	if (is_home()) {
		if (get_option('page_for_posts', true)) {
			echo get_the_title(get_option('page_for_posts', true));
		} else {
			esc_html_e('Latest Posts', 'emarket');
		}
	} elseif (is_archive()) {
		$term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
		if ($term) {
			echo $term->name;
		} elseif (is_post_type_archive()) {
			echo get_queried_object()->labels->name;
		} elseif (is_day()) {
			printf(__('Daily Archives: %s', 'emarket'), get_the_date());
		} elseif (is_month()) {
			printf(__('Monthly Archives: %s', 'emarket'), get_the_date('F Y'));
		} elseif (is_year()) {
			printf(__('Yearly Archives: %s', 'emarket'), get_the_date('Y'));
		} elseif (is_author()) {
			printf(__('Author Archives: %s', 'emarket'), get_the_author());
		} else {
			single_cat_title();
		}
	} elseif (is_search()) {
		printf(__('Search Results for <small>%s</small>', 'emarket'), get_search_query());
	} elseif (is_404()) {
		esc_html_e('Not Found', 'emarket');
	}
	elseif( is_single() ){
		$post_type = get_post_type( get_the_ID() );
		if( $post_type == 'post' ){
			$category = get_the_category();
			echo esc_html( $category[0]->name );
		}else if( $post_type == 'product' ){
			$category = get_the_terms( get_the_ID(), 'product_cat' );
			echo esc_html( $category[0]->name );
		}else{
			//the_title();
		}
	}elseif( class_exists( 'WeDevs_Dokan' ) && dokan_is_store_page() ){
		$store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
		echo esc_html( $store_user->get_shop_name() );
	}else{
		the_title();
	}
}

/*
** Get content page by ID
*/
function sw_get_the_content_by_id( $post_id ) {
	$page_data = get_page( $post_id );
	if ( $page_data ) {
		$content = do_shortcode( $page_data->post_content );
		return $content;
	}
	else return false;
}

/**
 * Opposite of built in WP functions for trailing slashes
 */
function emarket_leadingslashit($string) {
	return '/' . emarket_unleadingslashit($string);
}

function emarket_unleadingslashit($string) {
	return ltrim($string, '/');
}

function emarket_element_empty($element) {
	$element = trim($element);
	return empty($element) ? false : true;
}

function emarket_customize(){
	return isset($_POST['customized']) && ( isset($_POST['customize_messenger_chanel']) || isset($_POST['wp_customize']) );
}

/*
** Create HTML list checkbox of nav menu items.
*/
class Emarket_Menu_Checkbox extends Walker_Nav_Menu{
	
	private $menu_slug;
	
	public function __construct( $menu_slug = '') {
		$this->menu_slug = $menu_slug;
	}
	
	public function init($items, $args = array()) {
		$args = array( $items, 0, $args );
		
		return call_user_func_array( array($this, 'walk'), $args );
	}
	
	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
		$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

		$output .= $indent . '<li' . $id . $value . $class_names .'>';
		
		$item_output = '<label for="' . $this->menu_slug . '-' . $item->post_name . '-' . $item->ID . '">';
		$item_output .= '<input type="checkbox" name="' . $this->menu_slug . '_'  . $item->post_name .  '_' . $item->ID . '" ' . $this->menu_slug.$item->post_name.$item->ID . ' id="' . $this->menu_slug . '-'  . $item->post_name . '-' . $item->ID . '" /> ' . $item->title;
		$item_output .= '</label>';

		$output .= $item_output;
	}
	
	public function is_menu_item_active($menu_id, $item_ids) {
		global $wp_query;

		$queried_object = $wp_query->get_queried_object();
		$queried_object_id = (int) $wp_query->queried_object_id;
	
		$items = wp_get_nav_menu_items($menu_id);
		$items_current = array();
		$possible_object_parents = array();
		$home_page_id = (int) get_option( 'page_for_posts' );
		
		if ( $wp_query->is_singular && ! empty( $queried_object->post_type ) && ! is_post_type_hierarchical( $queried_object->post_type ) ) {
			foreach ( (array) get_object_taxonomies( $queried_object->post_type ) as $taxonomy ) {
				if ( is_taxonomy_hierarchical( $taxonomy ) ) {
					$terms = wp_get_object_terms( $queried_object_id, $taxonomy, array( 'fields' => 'ids' ) );
					if ( is_array( $terms ) ) {
						$possible_object_parents = array_merge( $possible_object_parents, $terms );
					}
				}
			}
		}
		
		foreach ($items as $item) {
			
			if (key_exists($item->ID, $item_ids)) {
				$items_current[] = $item;
			}
		}
		
		foreach ($items_current as $item) {
			
			if ( ($item->object_id == $queried_object_id) && (
						( ! empty( $home_page_id ) && 'post_type' == $item->type && $wp_query->is_home && $home_page_id == $item->object_id ) ||
						( 'post_type' == $item->type && $wp_query->is_singular ) ||
						( 'taxonomy' == $item->type && ( $wp_query->is_category || $wp_query->is_tag || $wp_query->is_tax ) && $queried_object->taxonomy == $item->object )
					)
				)
				return true;
			elseif ( $wp_query->is_singular &&
					'taxonomy' == $item->type &&
					in_array( $item->object_id, $possible_object_parents ) ) {
				return true;
			}
		}
		
		return false;
	}
}

/*
** Check widget display
*/
function emarket_check_wdisplay ($widget_display){
	$widget_display = json_decode(json_encode($widget_display), true);
	$Emarket_Menu_Checkbox = new Emarket_Menu_Checkbox;
	if ( isset($widget_display['display_select']) && $widget_display['display_select'] == 'all' ) {
		return true;
	}else{
	if ( in_array( 'sitepress-multilingual-cms/sitepress.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) { 
		if(  isset($widget_display['display_language']) && strcmp($widget_display['display_language'], ICL_LANGUAGE_CODE) != 0  ){
			return false;
		}
	}
	if ( isset($widget_display['display_select']) && $widget_display['display_select'] == 'if_selected' ) {
		
		if (isset($widget_display['checkbox'])) {
			
			if (isset($widget_display['checkbox']['users'])) {
				global $user_ID;
				
				foreach ($widget_display['checkbox']['users'] as $key => $value) {
					
					if ( ($key == 'login' && $user_ID) || ($key == 'logout' && !$user_ID) ){
						
						if (isset($widget_display['checkbox']['general'])) {
							foreach ($widget_display['checkbox']['general'] as $key => $value) {
								$is = 'is_'.$key;
								if ( $is() === true ) return true;
							}
						}
						
						if (isset($widget_display['taxonomy-slugs'])) {
							
							$taxonomy_slugs = preg_split('/[\s,]/', $widget_display['taxonomy-slugs']);
							foreach ($taxonomy_slugs as $slug) {is_post_type_archive('product_cat');
								if (!empty($slug) && is_tax($slug) === true) {
									return true;
								}
							}
						
						}
						
						if (isset($widget_display['post-type'])) {
							$post_type = preg_split('/[\s,]/', $widget_display['post-type']);
							
							foreach ($post_type as $type) {
								if(is_archive()){
									if (!empty($type) && is_post_type_archive($type) === true) {
										return true;
									}
								}
								
								if($type!=EMARKET_PRODUCT_TYPE)
								{
									if(!empty($type) && $type==EMARKET_PRODUCT_DETAIL_TYPE && is_single() && get_post_type() != 'post'){
										return true;
									}else if (!empty($type) && is_singular($type) === true) {
										return true;
									}
									
								}	
							}
						}
						
						if (isset($widget_display['catid'])) {
							$catid = preg_split('/[\s,]/', $widget_display['catid']);
							foreach ($catid as $id) {
								if (!empty($id) && is_category($id) === true) {
									return true;
								}
							}
								
						}
						
						if (isset($widget_display['postid'])) {
							$postid = preg_split('/[\s,]/', $widget_display['postid']);
							foreach ($postid as $id) {
								if (!empty($id) && (is_page($id) === true || is_single($id) === true) ) {
									return true;
								}
							}
						
						}
						
						if (isset($widget_display['checkbox']['menus'])) {
							
							foreach ($widget_display['checkbox']['menus'] as $menu_id => $item_ids) {
								
								if ( $Emarket_Menu_Checkbox->is_menu_item_active($menu_id, $item_ids) ) return true;
							}
						}
					}
				}
			}
			
			return false;
			
		} else return false ;
		
	} elseif ( isset($widget_display['display_select']) && $widget_display['display_select'] == 'if_no_selected' ) {
		
		if (isset($widget_display['checkbox'])) {
			
			if (isset($widget_display['checkbox']['users'])) {
				global $user_ID;
				
				foreach ($widget_display['checkbox']['users'] as $key => $value) {
					if ( ($key == 'login' && $user_ID) || ($key == 'logout' && !$user_ID) ) return false;
				}
			}
			
			if (isset($widget_display['checkbox']['general'])) {
				foreach ($widget_display['checkbox']['general'] as $key => $value) {
					$is = 'is_'.$key;
					if ( $is() === true ) return false;
				}
			}

			if (isset($widget_display['taxonomy-slugs'])) {
				$taxonomy_slugs = preg_split('/[\s,]/', $widget_display['taxonomy-slugs']);
				foreach ($taxonomy_slugs as $slug) {
					if (!empty($slug) && is_tax($slug) === true) {
						return false;
					}
				}
			
			}
			
			if (isset($widget_display['post-type'])) {
				$post_type = preg_split('/[\s,]/', $widget_display['post-type']);
				
				foreach ($post_type as $type) {
					if(is_archive()){
						if (!empty($type) && is_post_type_archive($type) === true) {
							return true;
						}
					}
					
					if($type!=EMARKET_PRODUCT_TYPE)
					{
						if(!empty($type) && $type==EMARKET_PRODUCT_DETAIL_TYPE && is_single() && get_post_type() != 'post'){
							return true;
						}else if (!empty($type) && is_singular($type) === true) {
							return true;
						}
						
					}	
				}
			}			
			
			if (isset($widget_display['catid'])) {
				$catid = preg_split('/[\s,]/', $widget_display['catid']);
				foreach ($catid as $id) {
					if (!empty($id) && is_category($id) === true) {
						return false;
					}
				}
					
			}
			
			if (isset($widget_display['postid'])) {
				$postid = preg_split('/[\s,]/', $widget_display['postid']);
				foreach ($postid as $id) {
					if (!empty($id) && (is_page($id) === true || is_single($id) === true)) {
						return false;
					}
				}
			
			}
			
			if (isset($widget_display['checkbox']['menus'])) {
							
				foreach ($widget_display['checkbox']['menus'] as $menu_id => $item_ids) {
					
					if ( $Emarket_Menu_Checkbox->is_menu_item_active($menu_id, $item_ids) ) return false;
				}
			}			
		} else return false ;
	}
	}
	return true ;
}


/*
**  Is active sidebar
*/
function emarket_sidebar_check($index) {
	global $wp_registered_widgets;
	
	$index = ( is_int($index) ) ? "sidebar-$index" : sanitize_title($index);
	$sidebars_widgets = wp_get_sidebars_widgets();
	if (!empty($sidebars_widgets[$index])) {
		foreach ($sidebars_widgets[$index] as $i => $id) {
			$id_base = preg_replace( '/-[0-9]+$/', '', $id );
			
			if ( isset($wp_registered_widgets[$id]) ) {
				$widget = new WP_Widget($id_base, $wp_registered_widgets[$id]['name']);

				if ( preg_match( '/' . $id_base . '-([0-9]+)$/', $id, $matches ) )
					$number = $matches[1];
					
				$instances = get_option($widget->option_name);
				
				if ( isset($instances) && isset($number) ) {
					$instance = $instances[$number];
					
					if ( isset($instance['widget_display']) && emarket_check_wdisplay($instance['widget_display']) == false ) {
						unset($sidebars_widgets[$index][$i]);
					}
				}
			}
		}
		
		if ( empty($sidebars_widgets[$index]) ) return false;
		
	} else return false;
	
	return true;
}	
	
/*
** Get Social share
*/
/*
** Get Social share
*/
function emarket_get_social() {
	global $post;
	
	$social = emarket_options()->getCpanelValue('social_share');	
	
	if ( !$social ) return false;
	ob_start();
	if( in_array( 1, [emarket_options()->getCpanelValue('social_share_fb'), emarket_options()->getCpanelValue('social_share_tw'), emarket_options()->getCpanelValue('social_share_pi'), emarket_options()->getCpanelValue('social_share_em'), emarket_options()->getCpanelValue('social_share_linkedin'), emarket_options()->getCpanelValue('social_share_app'), emarket_options()->getCpanelValue('social_share_telegram'), ] ) ){
?>
	<div class="social-share">
		<div class="title-share"><?php esc_html_e( 'Share:','emarket' ) ?></div>
		<div class="wrap-content">
			<?php if( emarket_options()->getCpanelValue('social_share_fb') ){ ?>
			<div class="item-social facebook">
				<a href="http://www.facebook.com/share.php?u=<?php echo get_permalink( $post->ID ); ?>&title=<?php echo get_the_title( $post->ID ); ?>" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="M14 13.5h2.5l1-4H14v-2c0-1.03 0-2 2-2h1.5V2.14c-.326-.043-1.557-.14-2.857-.14C11.928 2 10 3.657 10 6.7v2.8H7v4h3V22h4z"/></svg>
					<span><?php echo esc_html__( 'Facebook', 'emarket' ); ?></span>
				</a>
			</div>
			<?php } ?>
			
			<?php if( emarket_options()->getCpanelValue('social_share_tw') ){ ?>
			<div class="item-social twitter">
				<a href="http://twitter.com/intent/tweet?url=<?php echo get_the_title( $post->ID ); ?>+<?php echo get_permalink( $post->ID ); ?>" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 16 16"><path fill="currentColor" d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334q.002-.211-.006-.422A6.7 6.7 0 0 0 16 3.542a6.7 6.7 0 0 1-1.889.518a3.3 3.3 0 0 0 1.447-1.817a6.5 6.5 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.32 9.32 0 0 1-6.767-3.429a3.29 3.29 0 0 0 1.018 4.382A3.3 3.3 0 0 1 .64 6.575v.045a3.29 3.29 0 0 0 2.632 3.218a3.2 3.2 0 0 1-.865.115a3 3 0 0 1-.614-.057a3.28 3.28 0 0 0 3.067 2.277A6.6 6.6 0 0 1 .78 13.58a6 6 0 0 1-.78-.045A9.34 9.34 0 0 0 5.026 15"/></svg>
					<span><?php echo esc_html__( 'Twitter', 'emarket' ); ?></span>
				</a>
			</div>
			<?php } ?>
			
			<?php if( emarket_options()->getCpanelValue('social_share_pi') ){ ?>
			<div class="item-social pinterest">
				<a href="http://pinterest.com/pin/create/button/?url=<?php echo get_permalink( $post->ID ); ?>&description=<?php echo get_the_title( $post->ID ); ?>" class="pin-it-button" count-layout="horizontal" onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 32 32"><path fill="currentColor" d="M16.75.406C10.337.406 4 4.681 4 11.6c0 4.4 2.475 6.9 3.975 6.9c.619 0 .975-1.725.975-2.212c0-.581-1.481-1.819-1.481-4.238c0-5.025 3.825-8.588 8.775-8.588c4.256 0 7.406 2.419 7.406 6.863c0 3.319-1.331 9.544-5.644 9.544c-1.556 0-2.888-1.125-2.888-2.737c0-2.363 1.65-4.65 1.65-7.088c0-4.137-5.869-3.387-5.869 1.613c0 1.05.131 2.212.6 3.169c-.863 3.713-2.625 9.244-2.625 13.069c0 1.181.169 2.344.281 3.525c.212.238.106.213.431.094c3.15-4.313 3.038-5.156 4.463-10.8c.769 1.463 2.756 2.25 4.331 2.25c6.637 0 9.619-6.469 9.619-12.3c0-6.206-5.363-10.256-11.25-10.256z"/></svg>
					<span><?php echo esc_html__( 'Pinterest', 'emarket' ); ?></span>
				</a>
			</div>
			<?php } ?>			
			
			<?php if( emarket_options()->getCpanelValue('social_share_linkedin') ){ ?>
			<div class="item-social linkedin">
				 <a class="resp-sharing-button__link" href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo get_permalink( $post->ID ) ?>&amp;title=<?php echo get_the_title( $post->ID ) ?>&amp;summary=<?php echo get_the_title( $post->ID ) ?>&amp;source=<?php echo get_permalink( $post->ID ) ?>" target="_blank" rel="noopener" aria-label="Share on LinkedIn">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path  d="M6.94 5a2 2 0 1 1-4-.002a2 2 0 0 1 4 .002M7 8.48H3V21h4zm6.32 0H9.34V21h3.94v-6.57c0-3.66 4.77-4 4.77 0V21H22v-7.93c0-6.17-7.06-5.94-8.72-2.91z"/></svg>
					<span><?php echo esc_html__( 'Linkedin', 'emarket' ); ?></span>
				 </a>
			</div>
			<?php } ?>
			
			<?php if( emarket_options()->getCpanelValue('social_share_em') ){ ?>
			<div class="item-social email">
				<a class="resp-sharing-button__link" href="mailto:?subject=<?php echo get_the_title( $post->ID ) ?>&amp;body=<?php echo urlencode( get_permalink( $post->ID ) ) ?>" target="_self" rel="noopener" aria-label="Share by E-Mail">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 20 20"><path fill="currentColor" d="M19 14.5v-9c0-.83-.67-1.5-1.5-1.5H3.49c-.83 0-1.5.67-1.5 1.5v9c0 .83.67 1.5 1.5 1.5H17.5c.83 0 1.5-.67 1.5-1.5m-1.31-9.11c.33.33.15.67-.03.84L13.6 9.95l3.9 4.06c.12.14.2.36.06.51c-.13.16-.43.15-.56.05l-4.37-3.73l-2.14 1.95l-2.13-1.95l-4.37 3.73c-.13.1-.43.11-.56-.05c-.14-.15-.06-.37.06-.51l3.9-4.06l-4.06-3.72c-.18-.17-.36-.51-.03-.84s.67-.17.95.07l6.24 5.04l6.25-5.04c.28-.24.62-.4.95-.07"/></svg>
					<span><?php echo esc_html__( 'Email', 'emarket' ); ?></span>
				</a>
			</div>
			<?php } ?>
			
			<?php if( emarket_options()->getCpanelValue('social_share_app') ){ ?>
			<div class="item-social whatapp">
				 <a class="resp-sharing-button__link" href="whatsapp://send?text=<?php echo urlencode( get_the_title( $post->ID ) ) ?>%20<?php echo urlencode( get_permalink( $post->ID ) ) ?>" target="_blank" rel="noopener" aria-label="Share on WhatsApp">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><g fill="none" fill-rule="evenodd"><path d="M24 0v24H0V0zM12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M12 2C6.477 2 2 6.477 2 12c0 1.89.525 3.66 1.438 5.168L2.546 20.2A1.01 1.01 0 0 0 3.8 21.454l3.032-.892A9.96 9.96 0 0 0 12 22c5.523 0 10-4.477 10-10S17.523 2 12 2M9.738 14.263c2.023 2.022 3.954 2.289 4.636 2.314c1.037.038 2.047-.754 2.44-1.673a.7.7 0 0 0-.088-.703c-.548-.7-1.289-1.203-2.013-1.703a.71.71 0 0 0-.973.158l-.6.915a.23.23 0 0 1-.305.076c-.407-.233-1-.629-1.426-1.055s-.798-.992-1.007-1.373a.23.23 0 0 1 .067-.291l.924-.686a.71.71 0 0 0 .12-.94c-.448-.656-.97-1.49-1.727-2.043a.7.7 0 0 0-.684-.075c-.92.394-1.716 1.404-1.678 2.443c.025.682.292 2.613 2.314 4.636"/></g></svg>
					<span><?php echo esc_html__( 'Whatsapp', 'emarket' ); ?></span>
				 </a>
			</div>
			<?php } ?>
			
			<?php if( emarket_options()->getCpanelValue('social_share_telegram') ){ ?>
			<div class="item-social telegram">
				 <a class="resp-sharing-button__link" href="https://telegram.me/share/url?text=<?php echo urlencode( get_the_title( $post->ID ) ) ?>&amp;url=<?php echo urlencode( get_permalink( $post->ID ) ) ?>" target="_blank" rel="noopener" aria-label="Share on Telegram">
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" d="m20.665 3.717l-17.73 6.837c-1.21.486-1.203 1.161-.222 1.462l4.552 1.42l10.532-6.645c.498-.303.953-.14.579.192l-8.533 7.701h-.002l.002.001l-.314 4.692c.46 0 .663-.211.921-.46l2.211-2.15l4.599 3.397c.848.467 1.457.227 1.668-.785l3.019-14.228c.309-1.239-.473-1.8-1.282-1.434"/></svg>
					<span><?php echo esc_html__( 'Telegram', 'emarket' ); ?></span>
				 </a>
			</div>
			<?php } ?>
		</div>
	</div>
<?php 
	}
	$data = ob_get_clean();
	echo apply_filters( 'sw_social_share_single', $data );

}

/**
 * Use Bootstrap's media object for listing comments
 *
 * @link http://twitter.github.com/bootstrap/components.html#media
 */

function emarket_get_avatar($avatar) {
	$avatar = str_replace("class='avatar", "class='avatar pull-left media-object", $avatar);
	return $avatar;
}
add_filter('get_avatar', 'emarket_get_avatar');


/*
** Check col for sidebar and content product
*/
function emarket_content_product(){ 
	$left_span_class 			= emarket_options()->getCpanelValue('sidebar_left_expand');
	$left_span_md_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_md');
	$left_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_sm');
	$right_span_class 		= emarket_options()->getCpanelValue('sidebar_right_expand');
	$right_span_md_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_md');
	$right_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_sm');
	$sidebar 							= emarket_options()->getCpanelValue('sidebar_product');
	if( !is_post_type_archive( 'product' ) && !is_search() ){
		$term_id = get_queried_object()->term_id;
		$sidebar = ( get_term_meta( $term_id, 'term_sidebar', true ) != '' ) ? get_term_meta( $term_id, 'term_sidebar', true ) : emarket_options()->getCpanelValue('sidebar_product');
	}
	
	if( is_active_sidebar('left-product') && is_active_sidebar('right-product') && $sidebar =='lr' ){
		$content_span_class 	= 12 - ( $left_span_class + $right_span_class );
		$content_span_md_class 	= 12 - ( $left_span_md_class +  $right_span_md_class );
		$content_span_sm_class 	= 12 - ( $left_span_sm_class + $right_span_sm_class );
	} 
	elseif( is_active_sidebar('left-product') && $sidebar =='left' ) {
		$content_span_class 		= (	$left_span_class >= 12	) ? 12 : 12 - $left_span_class ;
		$content_span_md_class 	= ( $left_span_md_class >= 12 ) ? 12 : 12 - $left_span_md_class ;
		$content_span_sm_class 	= ( $left_span_sm_class >= 12 ) ? 12 : 12 - $left_span_sm_class ;
	}
	elseif( is_active_sidebar('right-product') && $sidebar =='right' ) {
		$content_span_class 	= ($right_span_class >= 12) ? 12 : 12 - $right_span_class;
		$content_span_md_class 	= ($right_span_md_class >= 12) ? 12 : 12 - $right_span_md_class ;
		$content_span_sm_class 	= ($right_span_sm_class >= 12) ? 12 : 12 - $right_span_sm_class ;
	}
	else {
		$content_span_class 	= 12;
		$content_span_md_class 	= 12;
		$content_span_sm_class 	= 12;
	}
	$classes = array( 'content' );
	
	$classes[] = 'col-lg-'.$content_span_class.' col-md-'.$content_span_md_class .' col-sm-'.$content_span_sm_class;
	
	echo 'class="' . join( ' ', $classes ) . '"';
}

/*
** Check col for sidebar and content product detail
*/
function emarket_content_product_detail(){
	$left_span_class 			= emarket_options()->getCpanelValue('sidebar_left_expand');
	$left_span_md_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_md');
	$left_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_sm');
	$right_span_class 		= emarket_options()->getCpanelValue('sidebar_right_expand');
	$right_span_md_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_md');
	$right_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_sm');
	$sidebar_template 		= emarket_options()->getCpanelValue('sidebar_product_detail');
	
	if( is_singular( 'product' ) ) :
		$sidebar_template = ( get_post_meta( get_the_ID(), 'page_sidebar_layout', true ) != '' ) ? get_post_meta( get_the_ID(), 'page_sidebar_layout', true ) : emarket_options()->getCpanelValue('sidebar_product_detail');
		$sidebar 					= ( get_post_meta( get_the_ID(), 'page_sidebar_template', true ) != '' ) ? get_post_meta( get_the_ID(), 'page_sidebar_template', true ) : 'left-product-detail';
	endif;
	
	if( is_active_sidebar($sidebar) && $sidebar_template == 'left' ) {
		$content_span_class 		= (	$left_span_class >= 12	) ? 12 : 12 - $left_span_class ;
		$content_span_md_class 	= ( $left_span_md_class >= 12 ) ? 12 : 12 - $left_span_md_class ;
		$content_span_sm_class 	= ( $left_span_sm_class >= 12 ) ? 12 : 12 - $left_span_sm_class ;
	}
	elseif( is_active_sidebar($sidebar) && $sidebar_template == 'right' ) {
		$content_span_class 	= ($right_span_class >= 12) ? 12 : 12 - $right_span_class;
		$content_span_md_class 	= ($right_span_md_class >= 12) ? 12 : 12 - $right_span_md_class ;
		$content_span_sm_class 	= ($right_span_sm_class >= 12) ? 12 : 12 - $right_span_sm_class ;
	}
	else {
		$content_span_class 	= 12;
		$content_span_md_class 	= 12;
		$content_span_sm_class 	= 12;
	}
	$classes = array( 'content' );
	
	$classes[] = 'col-lg-'.$content_span_class.' col-md-'.$content_span_md_class .' col-sm-'.$content_span_sm_class;
	
	echo 'class="' . join( ' ', $classes ) . '"';
}

/*
** Check col for sidebar and content blog
*/
function emarket_content_blog(){
	$left_span_class 			= emarket_options()->getCpanelValue('sidebar_left_expand');
	$left_span_md_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_md');
	$left_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_sm');
	$right_span_class 		= emarket_options()->getCpanelValue('sidebar_right_expand');
	$right_span_md_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_md');
	$right_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_sm');
	$sidebar_template 		= emarket_options() -> getCpanelValue('sidebar_blog');
	$sidebar  						= 'left-blog';
	if( is_single() ) :
		$sidebar_template = ( strlen( get_post_meta( get_the_ID(), 'page_sidebar_layout', true ) ) > 0 ) ? get_post_meta( get_the_ID(), 'page_sidebar_layout', true ) : emarket_options()->getCpanelValue('sidebar_blog');
		$sidebar 					= ( strlen( get_post_meta( get_the_ID(), 'page_sidebar_template', true ) ) > 0 ) ? get_post_meta( get_the_ID(), 'page_sidebar_template', true ) : 'left-blog';
	endif;
	
	if( is_active_sidebar($sidebar) && $sidebar_template == 'left' ) {
		$content_span_class 	= ($left_span_class >= 12) ? 12 : 12 - $left_span_class ;
		$content_span_md_class 	= ($left_span_md_class >= 12) ? 12 : 12 - $left_span_md_class ;
		$content_span_sm_class 	= ($left_span_sm_class >= 12) ? 12 : 12 - $left_span_sm_class ;
	} 
	elseif( is_active_sidebar($sidebar) && $sidebar_template == 'right' ) {
		$content_span_class 	= ($right_span_class >= 12) ? 12 : 12 - $right_span_class;
		$content_span_md_class 	= ($right_span_md_class >= 12) ? 12 : 12 - $right_span_md_class ;
		$content_span_sm_class 	= ($right_span_sm_class >= 12) ? 12 : 12 - $right_span_sm_class ;
	} 
	else {
		$content_span_class 	= 12;
		$content_span_md_class 	= 12;
		$content_span_sm_class 	= 12;
	}
	$classes = array( '' );
	
	$classes[] = 'col-lg-'.$content_span_class.' col-md-'.$content_span_md_class .' col-sm-'.$content_span_sm_class . ' col-xs-12';
	
	echo  join( ' ', $classes ) ;
}

/*
** Check sidebar blog
*/
function emarket_sidebar_template(){
	$emarket_sidebar_teplate = emarket_options() -> getCpanelValue('sidebar_blog');
	if( !is_archive() ){
		$emarket_sidebar_teplate = ( get_term_meta( get_queried_object()->term_id, 'term_sidebar', true ) != '' ) ? get_term_meta( get_queried_object()->term_id, 'term_sidebar', true ) : emarket_options()->getCpanelValue('sidebar_blog');
	}	
	if( is_single() ) {
		$emarket_sidebar_teplate = ( get_post_meta( get_the_ID(), 'page_sidebar_layout', true ) != '' ) ? get_post_meta( get_the_ID(), 'page_sidebar_layout', true ) : emarket_options()->getCpanelValue('sidebar_blog');
	}
	return $emarket_sidebar_teplate;
}

/*
** Check col for sidebar and content page
*/
function emarket_content_page(){
	$left_span_class 			= emarket_options()->getCpanelValue('sidebar_left_expand');
	$left_span_md_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_md');
	$left_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_left_expand_sm');
	$right_span_class 		= emarket_options()->getCpanelValue('sidebar_right_expand');
	$right_span_md_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_md');
	$right_span_sm_class 	= emarket_options()->getCpanelValue('sidebar_right_expand_sm');
	$sidebar_template 		= get_post_meta( get_the_ID(), 'page_sidebar_layout', true );
	$sidebar 							= get_post_meta( get_the_ID(), 'page_sidebar_template', true );
	
	if( is_active_sidebar( $sidebar ) && $sidebar_template == 'left' ) {
		$content_span_class 		= ( $left_span_class >= 12 ) ? 12 : 12 - $left_span_class ;
		$content_span_md_class 	= ( $left_span_md_class >= 12) ? 12 : 12 - $left_span_md_class ;
		$content_span_sm_class 	= ( $left_span_sm_class >= 12) ? 12 : 12 - $left_span_sm_class ;
	} 
	elseif( is_active_sidebar( $sidebar ) && $sidebar_template == 'right' ) {
		$content_span_class 	= ($right_span_class >= 12) ? 12 : 12 - $right_span_class;
		$content_span_md_class 	= ($right_span_md_class >= 12) ? 12 : 12 - $right_span_md_class ;
		$content_span_sm_class 	= ($right_span_sm_class >= 12) ? 12 : 12 - $right_span_sm_class ;
	} 
	else {
		$content_span_class 	= 12;
		$content_span_md_class 	= 12;
		$content_span_sm_class 	= 12;
	}
	$classes = array( '' );
	
	$classes[] = 'col-lg-'.$content_span_class.' col-md-'.$content_span_md_class .' col-sm-'.$content_span_sm_class . ' col-xs-12';
	
	echo  join( ' ', $classes ) ;
}

/*
** Typography
*/
function emarket_typography_css(){
	$styles = '';
	$page_webfonts  = get_post_meta( get_the_ID(), 'google_webfonts', true );
	$webfont 		= ( $page_webfonts != '' ) ? $page_webfonts : emarket_options()->getCpanelValue( 'google_webfonts' );
	$header_webfont = emarket_options()->getCpanelValue( 'header_tag_font' );
	$menu_webfont 	= emarket_options()->getCpanelValue( 'menu_font' );
	$custom_webfont = ( get_post_meta( get_the_ID(), 'webfonts_custom', true ) ) ? get_post_meta( get_the_ID(), 'webfonts_custom', true ) : emarket_options()->getCpanelValue( 'custom_font' );
	$custom_class 	= emarket_options()->getCpanelValue( 'custom_font_class' );
	
	$custom_webfont2 =  ( get_post_meta( get_the_ID(), 'webfonts_custom', true ) ) ? get_post_meta( get_the_ID(), 'webfonts_custom', true ) : emarket_options()->getCpanelValue( 'custom_font_2' );
	$custom_class2 	= emarket_options()->getCpanelValue( 'custom_font_class2' );
	
	$styles = '<style>';
	if ( $webfont ):	
		$webfonts_assign = ( get_post_meta( get_the_ID(), 'webfonts_assign', true ) != '' ) ? get_post_meta( get_the_ID(), 'webfonts_assign', true ) : '';
		if ( $webfonts_assign == 'headers' ){
			$styles .= 'h1, h2, h3, h4, h5, h6 {';
		} else if ( $webfonts_assign == 'custom' ){
			$custom_assign = ( get_post_meta( get_the_ID(), 'webfonts_custom', true ) ) ? get_post_meta( get_the_ID(), 'webfonts_custom', true ) : '';
			$custom_assign = trim($custom_assign);
			if ( !$custom_assign ) return '';
			$styles .= $custom_assign . ' {';
		} else {
			$styles .= 'body, input, button, select, textarea, .search-query {';
		}
		$styles .= 'font-family: ' . esc_attr( $webfont ) . ' !important;}';
	endif;
	
	/* Header webfont */
	if( $header_webfont ) :
		$styles .= 'h1, h2, h3, h4, h5, h6 {';
		$styles .= 'font-family: ' . esc_attr( $header_webfont ) . ' !important;}';
	endif;
	
	/* Menu Webfont */
	if( $menu_webfont ) :
		$styles .= '.primary-menu .menu-title, .vertical_megamenu .menu-title {';
		$styles .= 'font-family: ' . esc_attr( $menu_webfont ) . ' !important;}';
	endif;
	
	/* Custom Webfont */
	if( $custom_webfont && trim( $custom_class ) ) :
		$styles .= $custom_class . ' {';
		$styles .= 'font-family: ' . esc_attr( $custom_webfont ) . ' !important;}';
	endif;
	
	/* Custom Webfont 2 */
	if( $custom_webfont2 && trim( $custom_class2 ) ) :
		$styles .= $custom_class2 . ' {';
		$styles .= 'font-family: ' . esc_attr( $custom_webfont2 ) . ' !important;}';
	endif;
	
	$styles .= '</style>';
	return $styles;
}

function emarket_typography_css_cache(){ 
		
	/* Custom Css */
	if ( emarket_options()->getCpanelValue('advanced_css') != '' ){
		echo'<style>'. emarket_options()->getCpanelValue( 'advanced_css' ) .'</style>';
	}
	$data = emarket_typography_css();
	echo $data;
}
add_action( 'wp_head', 'emarket_typography_css_cache', 12, 0 );

function emarket_typography_webfonts(){
	$page_google_webfonts = get_post_meta( get_the_ID(), 'google_webfonts', true );
	$webfont 		= ( $page_google_webfonts != '' ) ? $page_google_webfonts : emarket_options()->getCpanelValue('google_webfonts');
	$header_webfont = emarket_options()->getCpanelValue( 'header_tag_font' );
	$menu_webfont 	= emarket_options()->getCpanelValue( 'menu_font' );
	$custom_webfont = emarket_options()->getCpanelValue( 'custom_font' );
	$custom_webfont2 = emarket_options()->getCpanelValue( 'custom_font_2' );
	
	if ( $webfont || $header_webfont || $menu_webfont || $custom_webfont || $custom_webfont2 ):
		$font_url = '';
		$webfont_weight = array();
		$webfont_weight	= ( get_post_meta( get_the_ID(), 'webfonts_weight', true ) ) ? get_post_meta( get_the_ID(), 'webfonts_weight', true ) : emarket_options()->getCpanelValue('webfonts_weight');
		$font_weight = '';
		if( empty($webfont_weight) ){
			$font_weight = '400';
		}
		else{
			foreach( $webfont_weight as $i => $wf_weight ){
				( $i < 1 )?	$font_weight .= '' : $font_weight .= ',';
				$font_weight .= $wf_weight;
			}
		}
		
		if( $header_webfont ){
			$webfont .= ( $webfont ) ? '|' . $header_webfont : $header_webfont;
		}
		
		if( $menu_webfont ){
			$webfont .= ( $webfont ) ? '|' . $menu_webfont : $menu_webfont;
		}
		
		if( $custom_webfont ){
			$webfont .= ( $webfont ) ? '|' . $custom_webfont : $custom_webfont;
		}
		
		if( $custom_webfont2 ){
			$webfont .= ( $webfont ) ? '|' . $custom_webfont2 : $custom_webfont2;
		}
		
		if ( 'off' !== _x( 'on', 'Google font: on or off', 'emarket' ) ) {
			$font_url = add_query_arg( 'family', urlencode( $webfont . ':' . $font_weight ), "//fonts.googleapis.com/css" );
		}
		return $font_url;
	endif;
}

function emarket_googlefonts_script() {
    wp_enqueue_style( 'emarket-googlefonts', emarket_typography_webfonts(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'emarket_googlefonts_script' );


/* 
** Get video or iframe from content 
*/
function emarket_get_entry_content_asset( $post_id ){
	global $post;
	$post = get_post( $post_id );
	
	$content = apply_filters ("the_content", $post->post_content);
	
	$value=preg_match('/<iframe.*src=\"(.*)\".*><\/iframe>/isU',$content,$results);
	if($value){
		return $results[0];
	}else{
		return '';
	}
}

function emarket_excerpt($limit) {
  $excerpt = explode(' ', get_the_content(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}

/*
** Tag cloud size
*/
add_filter( 'widget_tag_cloud_args', 'emarket_tag_clound' );
function emarket_tag_clound($args){
	$args['largest'] = 8;
	return $args;
}


/**
 * This class handles the Breadcrumbs generation and display
 */
class emarket_Breadcrumbs {

	/**
	 * Wrapper function for the breadcrumb so it can be output for the supported themes.
	 */
	function breadcrumb_output() {
		$this->breadcrumb( '<div class="breadcumbs">', '</div>' );
	}

	/**
	 * Get a term's parents.
	 *
	 * @param object $term Term to get the parents for
	 * @return array
	 */
	function get_term_parents( $term ) {
		$tax     = $term->taxonomy;
		$parents = array();
		while ( $term->parent != 0 ) {
			$term      = get_term( $term->parent, $tax );
			$parents[] = $term;
		}
		return array_reverse( $parents );
	}

	/**
	 * Display or return the full breadcrumb path.
	 *
	 * @param string $before  The prefix for the breadcrumb, usually something like "You're here".
	 * @param string $after   The suffix for the breadcrumb.
	 * @param bool   $display When true, echo the breadcrumb, if not, return it as a string.
	 * @return string
	 */
	function breadcrumb( $before = '', $after = '', $display = true ) {
		$options = array('breadcrumbs-home' => esc_html__( 'Home', 'emarket' ), 'breadcrumbs-blog-remove' => false, 'post_types-post-maintax' => '0');
		
		global $wp_query, $post;	
		$on_front  = get_option( 'show_on_front' );
		$blog_page = get_option( 'page_for_posts' );

		$links = array(
			array(
				'url'  => get_home_url(),
				'text' => ( isset( $options['breadcrumbs-home'] ) && $options['breadcrumbs-home'] != '' ) ? $options['breadcrumbs-home'] : esc_html__( 'Home', 'emarket' )
			)
		);

		if ( ( $on_front == "page" && is_front_page() ) || ( $on_front == "posts" && is_home() ) ) {

		} else if ( $on_front == "page" && is_home() ) {
			$links[] = array( 'id' => $blog_page );
		} else if ( is_singular() ) {		
			$tax = get_object_taxonomies( $post->post_type );
			if ( 0 == $post->post_parent ) {
				if ( isset( $tax ) && count( $tax ) > 0 ) {
					$main_tax = $tax[0];
					if( $post->post_type == 'product' ){
						$main_tax = 'product_cat';
					}					
					$terms    = wp_get_object_terms( $post->ID, $main_tax );
					
					if ( count( $terms ) > 0 ) {
						// Let's find the deepest term in this array, by looping through and then unsetting every term that is used as a parent by another one in the array.
						$terms_by_id = array();
						foreach ( $terms as $term ) {
							$terms_by_id[$term->term_id] = $term;
						}
						foreach ( $terms as $term ) {
							unset( $terms_by_id[$term->parent] );
						}

						// As we could still have two subcategories, from different parent categories, let's pick the first.
						reset( $terms_by_id );
						$deepest_term = current( $terms_by_id );

						if ( is_taxonomy_hierarchical( $main_tax ) && $deepest_term->parent != 0 ) {
							foreach ( $this->get_term_parents( $deepest_term ) as $parent_term ) {
								$links[] = array( 'term' => $parent_term );
							}
						}
						$links[] = array( 'term' => $deepest_term );
					}

				}
			} else {
				if ( isset( $post->ancestors ) ) {
					if ( is_array( $post->ancestors ) )
						$ancestors = array_values( $post->ancestors );
					else
						$ancestors = array( $post->ancestors );
				} else {
					$ancestors = array( $post->post_parent );
				}

				// Reverse the order so it's oldest to newest
				$ancestors = array_reverse( $ancestors );

				foreach ( $ancestors as $ancestor ) {
					$links[] = array( 'id' => $ancestor );
				}
			}
			$links[] = array( 'id' => $post->ID );
		} else {
			if ( is_post_type_archive() ) {
				$links[] = array( 'ptarchive' => get_post_type() );
			} else if ( is_tax() || is_tag() || is_category() ) {
				$term = $wp_query->get_queried_object();

				if ( is_taxonomy_hierarchical( $term->taxonomy ) && $term->parent != 0 ) {
					foreach ( $this->get_term_parents( $term ) as $parent_term ) {
						$links[] = array( 'term' => $parent_term );
					}
				}

				$links[] = array( 'term' => $term );
			} else if ( is_date() ) {
				$bc = esc_html__( 'Archives for', 'emarket' );
				
				if ( is_day() ) {
					global $wp_locale;
					$links[] = array(
						'url'  => get_month_link( get_query_var( 'year' ), get_query_var( 'monthnum' ) ),
						'text' => $wp_locale->get_month( get_query_var( 'monthnum' ) ) . ' ' . get_query_var( 'year' )
					);
					$links[] = array( 'text' => $bc . " " . get_the_date() );
				} else if ( is_month() ) {
					$links[] = array( 'text' => $bc . " " . single_month_title( ' ', false ) );
				} else if ( is_year() ) {
					$links[] = array( 'text' => $bc . " " . get_query_var( 'year' ) );
				}
			} elseif ( is_author() ) {
				$bc = esc_html__( 'Archives for', 'emarket' );
				$user    = $wp_query->get_queried_object();
				$links[] = array( 'text' => $bc . " " . esc_html( $user->display_name ) );
			} elseif ( is_search() ) {
				$bc = esc_html__( 'You searched for', 'emarket' );
				$links[] = array( 'text' => $bc . ' "' . esc_html( get_search_query() ) . '"' );
			} elseif ( is_404() ) {
				$crumb404 = esc_html__( 'Error 404: Page not found', 'emarket' );
				$links[] = array( 'text' => $crumb404 );
			}
		}
		
		$output = $this->create_breadcrumbs_string( $links );

		if ( $display ) {
			echo $before . $output . $after;
			return true;
		} else {
			return $before . $output . $after;
		}
	}

	/**
	 * Take the links array and return a full breadcrumb string.
	 *
	 * Each element of the links array can either have one of these keys:
	 * "id"            for post types;
	 * "ptarchive"  for a post type archive;
	 * "term"         for a taxonomy term.
	 * If either of these 3 are set, the url and text are retrieved. If not, url and text have to be set.
	 *
	 * @link http://support.google.com/webmasters/bin/answer.py?hl=en&answer=185417 Google documentation on RDFA
	 *
	 * @param array  $links   The links that should be contained in the breadcrumb.
	 * @param string $wrapper The wrapping element for the entire breadcrumb path.
	 * @param string $element The wrapping element for each individual link.
	 * @return string
	 */
	function create_breadcrumbs_string( $links, $wrapper = 'ul', $element = 'li' ) {
		global $paged;
		
		$output = '';

		foreach ( $links as $i => $link ) {

			if ( isset( $link['id'] ) ) {
				$link['url']  = get_permalink( $link['id'] );
				$link['text'] = strip_tags( get_the_title( $link['id'] ) );
			}

			if ( isset( $link['term'] ) ) {
				$link['url']  = get_term_link( $link['term'] );
				$link['text'] = $link['term']->name;
			}

			if ( isset( $link['ptarchive'] ) ) {
				$post_type_obj = get_post_type_object( $link['ptarchive'] );
				$archive_title = $post_type_obj->labels->menu_name;
				$link['url']  = get_post_type_archive_link( $link['ptarchive'] );
				$link['text'] = $archive_title;
			}
			
			$link_class = '';
			if ( isset( $link['url'] ) && ( $i < ( count( $links ) - 1 ) || $paged ) ) {
				$link_output = '<a href="' . esc_url( $link['url'] ) . '" >' . esc_html( $link['text'] ) . '</a><span class="go-page"></span>';
			} else {
				$link_class = ' class="active" ';
				$link_output = '<span>' . esc_html( $link['text'] ) . '</span>';
			}
			
			$element = esc_attr(  $element );
			$element_output = '<' . $element . $link_class . '>' . $link_output . '</' . $element . '>';
			
			$output .=  $element_output;
			
			$class = ' class="breadcrumb" ';
		}

		return '<' . $wrapper . $class . '>' . $output . '</' . $wrapper . '>';
	}

}

global $emarket_breadcrumb;
$emarket_breadcrumb = new emarket_Breadcrumbs();

if ( !function_exists( 'emarket_breadcrumb' ) ) {
	/**
	 * Template tag for breadcrumbs.
	 *
	 * @param string $before  What to show before the breadcrumb.
	 * @param string $after   What to show after the breadcrumb.
	 * @param bool   $display Whether to display the breadcrumb (true) or return it (false).
	 * @return string
	 */
	function emarket_breadcrumb( $before = '', $after = '', $display = true ) {
		global $emarket_breadcrumb;
		
		/* Turn off Breadcrumb */
		if( emarket_options()->getCpanelValue( 'breadcrumb_active' ) ) :
			$display = false;
		endif;
		return $emarket_breadcrumb->breadcrumb( $before, $after, $display );
	}
}


/*
** Footer Adnvanced
*/
add_action( 'wp_footer', 'emarket_footer_advanced' );
function emarket_footer_advanced(){
	/* 
	** Back To Top 
	*/
	if( emarket_options()->getCpanelValue( 'back_active' ) ) :
		echo '<a id="emarket-totop" href="#" ></a>';
	endif;
	
	/* 
	** Popup 
	*/
	if( emarket_options()->getCpanelValue( 'popup_active' ) ) :
		$emarket_content = emarket_options()->getCpanelValue( 'popup_content' );
		$emarket_shortcode = emarket_options()->getCpanelValue( 'popup_form' );
		$popup_attr = ( emarket_options()->getCpanelValue( 'popup_background' ) != '' ) ? 'style="background: url( '. esc_url( emarket_options()->getCpanelValue( 'popup_background' ) ) .' )"' : '';
?>
		<div id="subscribe_popup" class="subscribe-popup">
			<div class="subscribe-popup-container clearfix">
				<div class="image-newsletter pull-left">
					<img src="<?php echo esc_url( emarket_options()->getCpanelValue( 'popup_background' ) )?>" />
				</div>
				<div class="subscribe-content pull-right">
					<?php if( $emarket_content != '' ) : ?>
					<div class="popup-content">
						<?php echo $emarket_content; ?>
					</div>
					<?php endif; ?>
					
					<?php if( $emarket_shortcode != '' ) : ?>
					<div class="subscribe-form">
						<?php echo do_shortcode( '[mc4wp_form]' ); ?>
					</div>
					<?php endif; ?>
					
					<div class="subscribe-checkbox">
						<label for="popup_check">
							<input id="popup_check" name="popup_check" type="checkbox" />
							<?php echo '<span>' . esc_html__( "Don't show this popup again!", "emarket" ) . '</span>'; ?>
						</label>
					</div>
					<div class="subscribe-social">
						<div class="subscribe-social-inner">
							<?php emarket_social_link() ?>
						</div>
					</div>			
				</div>	
			</div>
		</div>
	<?php 
	endif;
	
	/*
	** Login Form 
	*/
	if( class_exists( 'WooCommerce' ) ){
?>
	<div class="modal fade" id="login_form" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog block-popup-login">
			<a href="javascript:void(0)" title="<?php esc_attr_e( 'Close', 'emarket' ) ?>" class="close close-login" data-dismiss="modal"><?php esc_html_e( 'Close', 'emarket' ) ?></a>
			<div class="tt_popup_login"><strong><?php esc_html_e('Sign in Or Register', 'emarket'); ?></strong></div>
			<?php get_template_part('woocommerce/myaccount/login-form'); ?>
			<?php 
				if( class_exists( 'APSL_Class' ) ) : 
					echo '<div class="login-line"><span>'. esc_html__( 'Or', 'emarket' ) .'</span></div>';
					echo do_shortcode('[apsl-login]'); 
				elseif( class_exists( 'APSL_Lite_Class' ) ):
					echo '<div class="login-line"><span>'. esc_html__( 'Or', 'emarket' ) .'</span></div>';
					echo do_shortcode('[apsl-login-lite]'); 
				endif;
			?>
		</div>
	</div>
	
	<!-- Featured Video -->
	<div class="sw-popup-bottom">
		<div class="popup-content" id="popup_content">
			<a href="javascript:void(0)" class="popup-close">x</a>
			<div class="popup-inner"></div>
		</div>	
	</div>
<?php 
	/*
	** Quickview Footer
	*/
	if( emarket_options( 'product_quickview' ) ){
		?>
			<div class="sw-quickview-bottom">
				<div class="quickview-content" id="quickview_content">
					<a href="javascript:void(0)" class="quickview-close">x</a>
					<div class="quickview-inner"></div>
				</div>	
			</div>
		<?php 
				}
			}
	/*
	** Search form to footer
	*/
?>
	<div class="modal fade" id="search_form" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog block-popup-search-form">
			<form role="search" method="get" class="form-search searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				<input type="text" value="<?php if (is_search()) { echo get_search_query(); } ?>" name="s" class="search-query" placeholder="<?php esc_attr_e( 'Enter your keyword...', 'emarket' ) ?>">
				<button type="submit" class=" fa fa-search button-search-pro form-button"></button>
				<a href="javascript:void(0)" title="<?php esc_attr_e( 'Close', 'emarket' ) ?>" class="close close-search" data-dismiss="modal"><?php esc_html_e( 'X', 'emarket' ) ?></a>
			</form>
		</div>
	</div>
<?php 	
}

/**
* Popup Newsletter & Menu Sticky
**/
function emarket_advanced(){	
	$emarket_popup	 		= emarket_options()->getCpanelValue( 'popup_active' );
	$sticky_mobile	 		= emarket_options()->getCpanelValue( 'sticky_mobile' );
	$layout_ID = ( get_option( 'page_on_front' ) ) ? get_option( 'page_on_front' ) : 0;
	$home_layout = get_post_meta( $layout_ID, 'page_home_template', true );
	$layout_styles = emarket_options()->getCpanelValue('layout');
	$product_modern_style 	= emarket_options()->getCpanelValue( 'shop_modern' );
	$sidebar_w = emarket_options()->getCpanelValue( 'sidebar_product_width' );
	$sidebar_detail_w = emarket_options()->getCpanelValue( 'sidebar_product_detail_width' );
	
	$output  = '';
	$output .= '(function($) {';
	if( !emarket_mobile_check() ) : 
		$sticky_menu 		= emarket_options()->getCpanelValue( 'sticky_menu' );
		$sticky_sidebar		= emarket_options()->getCpanelValue( 'sticky_sidebar' );
		$emarket_header_style 	= ( get_post_meta( get_the_ID(), 'page_header_style', true ) != '' ) ? get_post_meta( get_the_ID(), 'page_header_style', true ) : emarket_options()->getCpanelValue('header_style');
		$output_css = '';
		$layout = emarket_options()->getCpanelValue('layout_home');
		$bg_image = emarket_options()->getCpanelValue('bg_box_img');
		$bg_modern = emarket_options()->getCpanelValue('bg_shop_modern');

		$header_mid = emarket_options()->getCpanelValue('header_mid');
		$bg_header_mid = emarket_options()->getCpanelValue('bg_header_mid');					
		$layout_w = emarket_options()->getCpanelValue( 'layout_width' );
		if( $layout == 'boxed' ){ 
			$output_css .= 'body{';		
			$output_css .= ( $bg_image != '' ) ? 'background-image: url('.esc_attr( $bg_image ).') !important;
				background-position: top center !important; 
				background-attachment: fixed !important;' : '';
			$output_css .= '}';
			$output_css .= 'body >.container{ background-color:#fff; }';
			$output_css .= 'body >.elementor-location-footer, body >.elementor-location-archive, body >.elementor-location-single{ background-color:#fff; }';
			$output_css .= 'body >.emarket_breadcrumbs{ margin:0; }';
		}
		if( $product_modern_style ){
			$output_css .= 'body.page-shop-modern:before{';		
			$output_css .= ( $bg_modern != '' ) ? 'background: url('.esc_attr( $bg_modern ).') !important;
				background-repeat: no-repeat !important; 
				background-size    : cover !important;
				background-attachment: fixed !important;' : '';
			$output_css .= '}';
		}
		
		if( ( is_post_type_archive( 'product' ) || is_tax( 'product_cat' ) || is_tax( 'product_brand' ) || is_tax( 'dc_vendor_shop' ) ) && $sidebar_w ){
			$sidebar_number = isset( $sidebar_w['number'] ) ? $sidebar_w['number'] : 250;
			$sidebar_meter = isset( $sidebar_w['meter'] ) ? $sidebar_w['meter'] : 'px';
			if( $sidebar_meter === '%' && isset( $sidebar_w['numberp'] ) ){
				$sidebar_number = $sidebar_w['numberp'];
			}
			if( emarket_options()->getCpanelValue( 'sidebar_product' ) === 'left' ){
				$output_css .= '@media( min-width: 1200px ){.sidebar-row.sidebar{ grid-template-columns:'. $sidebar_number . $sidebar_meter .' calc( 100% - 30px - ' . $sidebar_number . $sidebar_meter .' ); } }';
			}elseif( emarket_options()->getCpanelValue( 'sidebar_product' ) === 'right' ){
				$output_css .= '@media( min-width: 1200px ){.sidebar-row.sidebar.right{ grid-template-columns: calc( 100% - 30px - ' . $sidebar_number . $sidebar_meter .' ) '. $sidebar_number . $sidebar_meter .'; } }';
			}
		}
		
		if( is_singular( 'product' ) && $sidebar_detail_w ){
			$sidebar_number = isset( $sidebar_detail_w['number'] ) ? $sidebar_detail_w['number'] : 250;
			$sidebar_meter = isset( $sidebar_detail_w['meter'] ) ? $sidebar_detail_w['meter'] : 'px';
			if( $sidebar_meter === '%' && isset( $sidebar_detail_w['numberp'] ) ){
				$sidebar_number = $sidebar_detail_w['numberp'];
			}
			if( emarket_options()->getCpanelValue( 'sidebar_product_detail' ) === 'left' ){
				$output_css .= '@media( min-width: 1200px ){.sidebar-row.sidebar{ grid-template-columns:'. $sidebar_number . $sidebar_meter .' calc( 100% - 30px - ' . $sidebar_number . $sidebar_meter .' ); } }';
			}elseif( emarket_options()->getCpanelValue( 'sidebar_product_detail' ) === 'right' ){
				$output_css .= '@media( min-width: 1200px ){.sidebar-row.sidebar.right{ grid-template-columns: calc( 100% - 30px - ' . $sidebar_number . $sidebar_meter .' ) '. $sidebar_number . $sidebar_meter .'; } }';
			}
		}
		
		if( $layout_w ){
			$output_css .= '@media (min-width: 1200px){.container, .wide-1650 .container, body.boxed-layout{ max-width: '. $layout_w. 'px }}';			
		}
		/*
		** Add background header mid
		*/
		
		if( $header_mid ){
			$output_css .= '#header .header-mid{';		
			$output_css .= ( $bg_header_mid != '' ) ? 'background-image: url('.esc_attr( $bg_header_mid ).');
				background-position: top center; 
				background-attachment: fixed;' : '';
			$output_css .= '}';			
		}
		wp_enqueue_style( 'emarket_css' );
		wp_add_inline_style( 'emarket_css', $output_css );
		
		/*
		** Menu Sticky 
		*/
		if( $sticky_menu ) :		
				if( $emarket_header_style == 'style1' || $emarket_header_style == '' || $emarket_header_style == 'style15' || $emarket_header_style == 'style16' || $emarket_header_style == 'style17'){			
					$output .= 'var sticky_navigation_offset = $("#header .header-bottom").offset();';
					$output .= 'if( typeof sticky_navigation_offset != "undefined" ) {';
					$output .= 'var sticky_navigation_offset_top = sticky_navigation_offset.top;';
					$output .= 'var sticky_navigation = function(){';
					$output .= 'var scroll_top = $(window).scrollTop();';
					$output .= 'if (scroll_top > sticky_navigation_offset_top) {';
					$output .= '$("#header .header-mid").addClass("sticky-menu");';
					$output .= '$("#header .header-mid").css({ "top":0, "left":0, "right" : 0 });';
					$output .= '} else {';
					$output .= '$("#header .header-mid").removeClass("sticky-menu");';
					$output .= '}';
					$output .= '};';
					$output .= 'sticky_navigation();';
					$output .= '$(window).scroll(function() {';
					$output .= 'sticky_navigation();';
					$output .= '}); }';
				}
				elseif( $emarket_header_style == 'style2' || $emarket_header_style == 'style3' || $emarket_header_style == 'style4' || $emarket_header_style == 'style5' || $emarket_header_style == 'style6'
			|| $emarket_header_style == 'style7' || $emarket_header_style == 'style8' || $emarket_header_style == 'style9' || $emarket_header_style == 'style10' || $emarket_header_style == 'style11' || $emarket_header_style == 'style12'||
			$emarket_header_style == 'style13' || $emarket_header_style == 'style14' ){
					$output .= 'var sticky_navigation_offset = $("#header .header-bottom").offset();';
					$output .= 'if( typeof sticky_navigation_offset != "undefined" ) {';
					$output .= 'var sticky_navigation_offset_top = sticky_navigation_offset.top;';
					$output .= 'var sticky_navigation = function(){';
					$output .= 'var scroll_top = $(window).scrollTop();';
					$output .= 'if (scroll_top > sticky_navigation_offset_top) {';
					$output .= '$("#header .header-bottom").addClass("sticky-menu");';
					$output .= '$("#header .header-mid").addClass("sticky-mid");';
					$output .= '$("#header .header-bottom").css({ "top":0, "left":0, "right" : 0 });';
					$output .= '} else {';
					$output .= '$("#header .header-bottom").removeClass("sticky-menu");';
					$output .= '$("#header .header-mid").removeClass("sticky-mid");';
					$output .= '}';
					$output .= '};';
					$output .= 'sticky_navigation();';
					$output .= '$(window).scroll(function() {';
					$output .= 'sticky_navigation();';
					$output .= '}); }';
				}
			endif;

			/*
			** Sticky Sidebar
			*/
			if( $sticky_sidebar ) :
			
				$output .= 'jQuery(document).ready(function($) {';
				$output .= 'var $sidebar   = $(".woocommerce .sidebar"), $content   = $(".woocommerce .content");';
				$output .= 'if ($sidebar.length > 0 && $content.length > 0) {';
				$output .= 'var $window    = $(window), offset  = $sidebar.offset(),timer;';

				$output .= '$window.scroll(function() {';
				$output .= 'clearTimeout(timer);';
				$output .= 'timer = setTimeout(function() {';
				$output .= 'if ($content.height() > $sidebar.height()) {';
				$output .= 'var new_margin = $window.scrollTop() - offset.top;';
				$output .= 'if ($window.scrollTop() > offset.top && ($sidebar.height()+new_margin) <= $content.height()) {';
									// Following the scroll...
				$output .= '$sidebar.stop().animate({ marginTop: new_margin });';
				$output .= '$sidebar.addClass("fixed");';
			    $output .= '} else if (($sidebar.height()+new_margin) > $content.height()) {';
									// Reached the bottom...
				$output .= '$sidebar.stop().animate({ marginTop: $content.height()-$sidebar.height() });';
				$output .= '} else if ($window.scrollTop() <= offset.top) {';
									// Initial position...
				$output .= '$sidebar.stop().animate({ marginTop: 0 });';
				$output .= '$sidebar.removeClass("fixed");';
				$output .= '}';
				$output .= '}';
				$output .= '}, 100);';
				$output .= '	});';
				$output .= '}';

				$output .= '});';
				
				$output .= 'jQuery(document).ready(function($) {';
				$output .= 'var $sidebar   = $(".archive .sidebar"), $content   = $(".archive .category-contents");';
				$output .= 'if ($sidebar.length > 0 && $content.length > 0) {';
				$output .= 'var $window    = $(window), offset  = $sidebar.offset(),timer;';

				$output .= '$window.scroll(function() {';
				$output .= 'clearTimeout(timer);';
				$output .= 'timer = setTimeout(function() {';
				$output .= 'if ($content.height() > $sidebar.height()) {';
				$output .= 'var new_margin = $window.scrollTop() - offset.top;';
				$output .= 'if ($window.scrollTop() > offset.top && ($sidebar.height()+new_margin) <= $content.height()) {';
									// Following the scroll...
				$output .= '$sidebar.stop().animate({ marginTop: new_margin });';
				$output .= '$sidebar.addClass("fixed");';
			    $output .= '} else if (($sidebar.height()+new_margin) > $content.height()) {';
									// Reached the bottom...
				$output .= '$sidebar.stop().animate({ marginTop: $content.height()-$sidebar.height() });';
				$output .= '} else if ($window.scrollTop() <= offset.top) {';
									// Initial position...
				$output .= '$sidebar.stop().animate({ marginTop: 0 });';
				$output .= '$sidebar.removeClass("fixed");';
				$output .= '}';
				$output .= '}';
				$output .= '}, 100);';
				$output .= '	});';
				$output .= '}';

				$output .= '});';
				
				$output .= 'jQuery(document).ready(function($) {';
				$output .= 'var $sidebar   = $(".single .sidebar"), $content   = $(".single .single.main");';
				$output .= 'if ($sidebar.length > 0 && $content.length > 0) {';
				$output .= 'var $window    = $(window), offset  = $sidebar.offset(),timer;';

				$output .= '$window.scroll(function() {';
				$output .= 'clearTimeout(timer);';
				$output .= 'timer = setTimeout(function() {';
				$output .= 'if ($content.height() > $sidebar.height()) {';
				$output .= 'var new_margin = $window.scrollTop() - offset.top;';
				$output .= 'if ($window.scrollTop() > offset.top && ($sidebar.height()+new_margin) <= $content.height()) {';
									// Following the scroll...
				$output .= '$sidebar.stop().animate({ marginTop: new_margin });';
				$output .= '$sidebar.addClass("fixed");';
			    $output .= '} else if (($sidebar.height()+new_margin) > $content.height()) {';
									// Reached the bottom...
				$output .= '$sidebar.stop().animate({ marginTop: $content.height()-$sidebar.height() });';
				$output .= '} else if ($window.scrollTop() <= offset.top) {';
									// Initial position...
				$output .= '$sidebar.stop().animate({ marginTop: 0 });';
				$output .= '$sidebar.removeClass("fixed");';
				$output .= '}';
				$output .= '}';
				$output .= '}, 100);';
				$output .= '	});';
				$output .= '}';

				$output .= '});';
			endif;
			
			/*
			** Adnvanced JS
			*/
			if( emarket_options()->getCpanelValue( 'advanced_js' ) != '' ) :
				$output .= emarket_options()->getCpanelValue( 'advanced_js' );
			endif;
			
			/*
			** Home Page Template JS
			*/
				
				if( $home_layout != '' ){
					if( $home_layout == 'home-style17' ){
						$output .= '$(document).ready(function() {
								$(".header-top-elementor19 .icon-sidebar").on("click", function(e){
									$(".header-sibar-home17").addClass("open");
									$("body").addClass("open");
									e.stopPropagation();
								});
								
								$(".header-sibar-home17 .close-sidebar").on("click", function(){
									$(".header-sibar-home17").removeClass("open");
									$("body").removeClass("open");
								});
								$(".header-top-elementor19 .header-dark").on("click", function(){
									$("body").toggleClass("light-style");
								});
								$(document).click(function(e) {			
									var container = $(".header-sibar-home17.open");
									if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
										$(".header-sibar-home17").removeClass("open");
										$("body").removeClass("open");
									}
								});
							});';
					}
					if( $home_layout == 'home-style20' ){
						$output .= '$(document).ready(function() {
									$(".header-bottom-elementor22 .icon-sidebar").on("click", function(e){
									$(".header-sibar-home22").addClass("open");
									$("body").addClass("open1");
									$("html").css( "overflow", "hidden" );
									e.stopPropagation();
								});
								
								$(".header-sibar-home22 .close-sidebar").on("click", function(){
									$(".header-sibar-home22").removeClass("open");
									$("body").removeClass("open1");
									$("html").css( "overflow", "visible" );
								});
								$(document).click(function(e) {			
									var container = $( ".header-sibar-home22" );
									if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
										$(".header-sibar-home22").removeClass("open");
										$("body").removeClass("open1");
										$("html").css( "overflow", "visible" );
									}
								});
							});';
					}
					if( $home_layout == 'home-style21' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-elementor23 .icon-sidebar").on("click", function(e){
										$(".header-sibar-home23").addClass("open");
										$("body").addClass("open1");
										e.stopPropagation();
									});
									
									$(".header-sibar-home23 .close-sidebar").on("click", function(){
										$(".header-sibar-home23").removeClass("open");
										$("body").removeClass("open1");
									});
									
									$(document).click(function(e) {			
										var container = $( ".header-sibar-home23" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sibar-home23").removeClass("open");
											$("body").removeClass("open1");
										}
									});
							});';
					}
					if( $home_layout == 'home-style22' ){
						$output .= '$(document).ready(function() {
											$(".header-mid-elemntor24 .icon-sidebar").on("click", function(e){
											$(".header-sibar-home24").addClass("open");
											$("body").addClass("open1");
											e.stopPropagation();
										});
										
										$(".header-sibar-home24 .close-sidebar").on("click", function(){
											$(".header-sibar-home24").removeClass("open");
											$("body").removeClass("open1");
										});
										$(document).click(function(e) {			
											var container = $( ".header-sibar-home24" );
											if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
												$(".header-sibar-home24").removeClass("open");
												$("body").removeClass("open1");
											}
										});
							});';
					}
					if( $home_layout == 'home-style24' ){
						$output .= '$(document).ready(function() {
											$(".circle").circleText({
												glue: "",
												turn: true,
												padding: 0,
												radius: 70,
												duration: 7,
												repeat: 6,
											});
							});';
					}
					if( $home_layout == 'home-style30' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-elementor31 .icon-sidebar").on("click", function(e){
										$(".header-sidebar-home31").addClass("open");
										$("body").addClass("open1");
										$("html").css( "overflow", "hidden" );
										e.stopPropagation();
									});
									
									$(".header-sidebar-home31 .close-sidebar").on("click", function(){
										$(".header-sidebar-home31").removeClass("open");
										$("body").removeClass("open1");
										$("html").css( "overflow", "visible" );
									});
									
									$(document).click(function(e) {			
										var container = $( ".header-sidebar-home31" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sidebar-home31").removeClass("open");
											$("body").removeClass("open1");
											$("html").css( "overflow", "visible" );
										}
									});
							});';
					}
					if( $home_layout == 'home-style32' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-elementor33 .icon-sidebar").on("click", function(e){
										$(".header-sidebar-home33").addClass("open");
										$("body").addClass("open1");
										$("html").css( "overflow", "hidden" );
										e.stopPropagation();
									});
									
									$(".header-sidebar-home33 .close-sidebar").on("click", function(){
										$(".header-sidebar-home33").removeClass("open");
										$("body").removeClass("open1");
										$("html").css( "overflow", "visible" );
									});
									$(document).click(function(e) {			
										var container = $( ".header-sidebar-home33" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sidebar-home33").removeClass("open");
											$("body").removeClass("open1");
											$("html").css( "overflow", "visible" );
										}
									});
							});';
					}
					if( $home_layout == 'home-style33' ){
						$output .= '$(document).ready(function() {
									$(".header-bottom-elementor34 .icon-sidebar").on("click", function(e){
										$(".header-sidebar-home34").addClass("open");
										$("body").addClass("open1");
										$("html").css( "overflow", "hidden" );
										e.stopPropagation();
									});
									
									$(".header-sidebar-home34 .close-sidebar").on("click", function(){
										$(".header-sidebar-home34").removeClass("open");
										$("body").removeClass("open1");
										$("html").css( "overflow", "visible" );
									});
									$(document).click(function(e) {			
										var container = $( ".header-sidebar-home34" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sidebar-home34").removeClass("open");
											$("body").removeClass("open1");
											$("html").css( "overflow", "visible" );
										}
									});
							});';
					}
					if( $home_layout == 'home-style34' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-elementor35 .icon-sidebar").on("click", function(e){
										$(".header-sidebar-home35").addClass("open");
										$("body").addClass("open1");
										$("html").css( "overflow", "hidden" );
										e.stopPropagation();
									});
									
									$(".header-sidebar-home35 .close-sidebar").on("click", function(){
										$(".header-sidebar-home35").removeClass("open");
										$("body").removeClass("open1");
										$("html").css( "overflow", "visible" );
									});
									$(document).click(function(e) {			
										var container = $( ".header-sidebar-home35" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sidebar-home35").removeClass("open");
											$("body").removeClass("open1");
											$("html").css( "overflow", "visible" );
										}
									});
							});';
					}
					if( $home_layout == 'home-style36' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-elementor37  .elementor-widget-wp-widget-nav_menu h5").on("click", function(){
										$(".header-bottom-elementor37  .elementor-widget-wp-widget-nav_menu").toggleClass("open");
									});
									$( ".content-left-home35 ul.accordion-categories li" ).first().addClass( "active" );
							});';
					}
					if( $home_layout == 'home-style39' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-39 .icon-sidebar").on("click", function(e){
										$(".header-sibar-home39").addClass("open");
										$("body").addClass("open1");
										e.stopPropagation();
									});
									
									$(".header-sibar-home39 .close-sidebar").on("click", function(){
										$(".header-sibar-home39").removeClass("open");
										$("body").removeClass("open1");
									});
									
									$(document).click(function(e) {			
										var container = $( ".header-sibar-home39" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sibar-home39").removeClass("open");
											$("body").removeClass("open1");
										}
									});
							});';
					}
					if( $home_layout == 'home-style42' ){
						$output .= '$(document).ready(function() {
										$(".header-42 .icon-sidebar").on("click", function(e){
										$(".header-sibar-home42").addClass("open");
										$("body").addClass("open1");
										e.stopPropagation();
									});
									
									$(".header-sibar-home42 .close-sidebar").on("click", function(){
										$(".header-sibar-home42").removeClass("open");
										$("body").removeClass("open1");
									});
									
									$(document).click(function(e) {			
										var container = $( ".header-sibar-home42" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sibar-home42").removeClass("open");
											$("body").removeClass("open1");
										}
									});
							});';
					}
					if( $home_layout == 'home-style43' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-43 .icon-sidebar").on("click", function(e){
										$(".header-sibar-home43").addClass("open");
										$("body").addClass("open1");
										e.stopPropagation();
									});
									
									$(".header-sibar-home43 .close-sidebar").on("click", function(){
										$(".header-sibar-home43").removeClass("open");
										$("body").removeClass("open1");
									});
									
									$(document).on( "click", function(e){		
										var container = $( ".header-sibar-home43" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sibar-home43").removeClass("open");
											$("body").removeClass("open1");
										}
									});
							});';
					}
					if( $home_layout == 'home-style44' ){
						$output .= '$(document).ready(function() {
										$(".header-bottom-44 .icon-sidebar").on("click", function(e){
										$(".header-sibar-home44").addClass("open");
										$("body").addClass("open1");
										e.stopPropagation();
									});
									
									$(".header-sibar-home44 .close-sidebar").on("click", function(){
										$(".header-sibar-home44").removeClass("open");
										$("body").removeClass("open1");
									});
									
									$(document).click(function(e) {			
										var container = $( ".header-sibar-home44" );
										if ( typeof container != "undefined" && !container.is(e.target) && container.has(e.target).length === 0 && container.html().length > 0 ){
											$(".header-sibar-home44").removeClass("open");
											$("body").removeClass("open1");
										}
									});
							});';
					}
				}

			if( class_exists( 'WooCommerce' ) && is_singular( 'product' ) ) :
				if( emarket_options()->getCpanelValue( 'product_single_style' ) == 'style7' ){
					$output .= '$(document).ready(function() {
									$(".sw-sidebar-button").on("click", function(e) {
									var target = $(this).data("target");
									$(target).toggleClass("open");
									$("body").toggleClass("open");
									e.preventDefault();
								});

								$(".sw-sidebar-close").on("click", function(e) {
									var target = $(this).data("target");
									$("#"+ target).removeClass("open");
									$("body").removeClass("open");
									e.preventDefault();
								});								
						});';	
				}
				if( emarket_options()->getCpanelValue( 'product_single_style' ) == 'style8' ){
					$output .= '$(document).ready(function() {
									$(".single-product-style8 .product_detail .tabs ul > li").each( function(){
									$(".single-product-style8 .product_detail .tabs ul > li").removeClass("active");
								}); 
								
									$(".single-product-style8 .product_detail .tabs ul > li > a").on("click", function(e) {
									$(".single-product-style8 .product_detail .tabs .tab-content").addClass("open");
									e.preventDefault();
								});

									$(".single-product-style8 .product_detail .tabs .tab-content .close-tab").on("click", function(e) {
									$(".single-product-style8 .product_detail .tabs .tab-content").removeClass("open");
									e.preventDefault();
								});
						});';	
				}
			endif;
		endif;			
			/*
			** Popup Newsletter
			*/
			if( $emarket_popup ){
				$output .= '$(document).ready(function() {
						var check_cookie = $.cookie("subscribe_popup");
						if(check_cookie == null || check_cookie == "shown") {
							 popupNewsletter();
						 }
						$("#subscribe_popup input#popup_check").on("click", function(){
							if($(this).parent().find("input:checked").length){        
								var check_cookie = $.cookie("subscribe_popup");
								 if(check_cookie == null || check_cookie == "shown") {
									$.cookie("subscribe_popup","dontshowitagain");            
								}
								else
								{
									$.cookie("subscribe_popup","shown");
									popupNewsletter();
								}
							} else {
								$.cookie("subscribe_popup","shown");
							}
						}); 
					});

					function popupNewsletter() {
						jQuery.fancybox({
							href: "#subscribe_popup",
							autoResize: true
						});
						jQuery("#subscribe_popup").trigger("click");
						jQuery("#subscribe_popup").parents(".fancybox-overlay").addClass("popup-fancy");
					};';
			}
			/*
			** Sticky Mobile
			*/
			if( emarket_mobile_check() ) : 
				
				if( $sticky_mobile ) :
				
					$output .= '$(window).scroll(function() {   
						var target = $( ".mobile-layout #header" );
						var scroll_top = $(window).scrollTop();
						if ( scroll_top > ( target.height() + 30 ) ) {
							$(".mobile-layout #header").addClass("sticky-mobile");
						}else{
							$(".mobile-layout #header").removeClass("sticky-mobile");
						}
				});';
				
				endif;
				$output .= '$(window).scroll(function() {   
					if( $( "body" ).hasClass( "mobile-layout" ) ) {
						var target = $( ".mobile-layout #header-page" );
						var sticky_nav_mobile_offset = $(".mobile-layout #header-page").offset();
						if( sticky_nav_mobile_offset != null ){
							var sticky_nav_mobile_offset_top = sticky_nav_mobile_offset.top;
							var scroll_top = $(window).scrollTop();
							if ( scroll_top > sticky_nav_mobile_offset_top ) {
								$(".mobile-layout #header-page").addClass("sticky-mobile");
							}else{
								$(".mobile-layout #header-page").removeClass("sticky-mobile");
							}
						}
					}
				});';
				$output .= '$(document).ready(function() {
					$(".mobile-layout .back-history").on("click", function(){
						window.history.back();
					});
					
					$(".mobile-layout .cusom-menu-mobile .widget_nav_menu h2.widgettitle").each(function(){
						$(this).on("click", function(){
							$(this).parent().find("ul.menu").slideToggle();
						});
					});
					
					$( ".mobile-search .icon-seach" ).click(function() {
						$(this).toggleClass( "close" );
						$( ".mobile-search .top-form.top-search" ).slideToggle(100);
					});	
					
					$( ".header-mobile-style1 .mobile-search .icon-seach" ).click(function() {
					  $( ".header-mobile-style1 .mobile-search .top-form.top-search" ).slideToggle( "slow", function() {
					  });
					});
					
					$( ".header-mobile-style2 .mobile-search .icon-seach" ).click(function() {
					  $( ".header-mobile-style2 .mobile-search .top-form.top-search" ).slideToggle( "slow", function() {
					  });
					});
					
					$(".header-menu-categories .open-menu").on("click", function(){
						$(".main-menu").toggleClass("open");
					});
					
					$(".footer-mstyle1 .footer-menu .footer-search a").on("click", function(){
						$(".top-form.top-search").toggleClass("open");
					});
					
					$(".footer-mstyle1 .footer-menu .footer-more a").on("click", function(){
						$(".menu-item-hidden").toggleClass("open");
					});

					$(".footer-mstyle2 .footer-container .footer-open").on("click", function(){
						$(".footer-mstyle2").toggleClass("open");
					});
				});';
			endif;
			
			if( emarket_options()->getCpanelValue( 'product_single_buynow' ) ){
				$output .= '$(document).ready(function() {
									function sw_buynow_variation_product(){
										var element = $( ".single-product" );
										var target = $( ".single-product .variations_form" );
										var bt_addcart = target.find( ".single_add_to_cart_button" );
										var variation  = target.find( ".variation_id" ).val();
										var bt_buynow  = element.find( ".button-buynow" );
										var url = bt_buynow.data( "url" );
										var qty = $(".single-product input.qty").val();
										if( typeof variation != "undefined" ){
											if( variation == 0 ){
												bt_buynow.addClass( "disabled" );
											}else{
												bt_buynow.removeClass( "disabled" );
											}
											if( variation != "" ){
												bt_buynow.attr( "href", url + "="+variation + "&quantity="+ qty );
											}else{
												bt_buynow.attr( "href", url + "&quantity="+ qty );
											}
										}else{
											bt_buynow.attr( "href", url + "&quantity="+ qty );
										}
									}
									$(window).on( "change", function(){
										sw_buynow_variation_product();
									});
									$(document).ready(function(){
										sw_buynow_variation_product();
									});
						});';	
			}
			if( emarket_options()->getCpanelValue( 'sticky_single_product' ) != '' && is_singular( 'product' ) ){
				$output .= "/*sticky single*/
				if( $(window).width() > 991 ) {
					$('.single-product').each(function() {
						var stickyDetail_of = $('.single-product .addcart-wrapper').offset();
						if( typeof( stickyDetail_of ) != 'undefined' ){
							var stickyDetail = stickyDetail_of.top;

							var stickyDT = function() {
								var scrollTop = $(window).scrollTop();
								if (scrollTop > stickyDetail) {
									$('.addcart-wrapper').addClass('sticky-detail-buton');
									$('.sticky-detail').addClass('sticky');

								} else {
									$('.addcart-wrapper').removeClass('sticky-detail-buton');
									$('.sticky-detail').removeClass('sticky');
								}
							};
						
							stickyDT();
							$(window).scroll(function() {
								stickyDT();
							});
						}
					});
					$(document).on( 'click', '.sticky-detail-buton .single_add_to_cart_button.disabled', function (){
						$('body,html').animate({
							scrollTop: 0
						}, 800);
					});
				}";
			}
			if( is_post_type_archive( 'product' ) || is_tax( 'product_cat' )|| is_tax( 'product_tag' ) || is_tax( 'product_brand' ) || is_tax( 'dc_vendor_shop' ) || isset( $_GET['search_posttype'] ) ){
				if( in_array( emarket_options()->getCpanelValue( 'product_items_layout' ), ['layout36'] ) ){
					$output .= '$( window ).on( "load", function() {
					$( "ul.products > li" ).each(function(){
						$(this).css( "height", $(this).outerHeight() );				
					});
					});					
					';
				}
			}	
		$output .= '}(jQuery));';

		$translation_text = array(
			'cart_text' 		 => esc_html__( 'Add To Cart', 'emarket' ),
			'compare_text' 	 => esc_html__( 'Compare', 'emarket' ),
			'wishlist_text'  => esc_html__( 'WishList', 'emarket' ),
			'quickview_text' => esc_html__( 'QuickView', 'emarket' ),
			'ajax_url' => admin_url( 'admin-ajax.php', 'relative' ), 
			'redirect' => get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ),
			'message' => esc_html__( 'Please enter your usename and password', 'emarket' ),
		);
		
		wp_localize_script( 'emarket_custom_js', 'custom_text', $translation_text ); 
		wp_enqueue_script( 'emarket_custom_js', get_template_directory_uri() . '/js/main.js', array(), null, true );
		wp_add_inline_script( 'emarket_custom_js', $output );
	
}
add_action( 'wp_enqueue_scripts', 'emarket_advanced', 101 );


/**
* Set and Get view count
**/
function emarket_getPostViews($postID){    
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if($count==''){
		delete_post_meta($postID, $count_key);
		add_post_meta($postID, $count_key, '0');
		return "0";
	}
	return $count;
}

function emarket_setPostViews($postID) {
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if($count==''){
			$count = 0;
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
	}else{
			$count++;
			update_post_meta($postID, $count_key, $count);
	}
}  

/*
** Create Postview on header
*/
add_action( 'wp_head', 'emarket_create_postview' );
function emarket_create_postview(){
	if( is_single() || is_singular( 'product' ) ) :
		emarket_setPostViews( get_the_ID() );
	endif;
}

/*
** Emarket Logo
*/
function emarket_logo(){
	$scheme_meta = get_post_meta( get_the_ID(), 'scheme', true );
	$scheme 	 = ( $scheme_meta != '' && $scheme_meta != 'none' ) ? $scheme_meta : emarket_options()->getCpanelValue( 'scheme' );
	$meta_img_ID = get_post_meta( get_the_ID(), 'page_logo', true );
	$meta_img 	 = ( $meta_img_ID != '' ) ? wp_get_attachment_image_url( $meta_img_ID, 'full' ) : '';
	$mobile_logo = emarket_options()->getCpanelValue( 'mobile_logo' );
	$logo_select = ( emarket_mobile_check() && $mobile_logo != ''  ) ? $mobile_logo : emarket_options()->getCpanelValue( 'sitelogo' );
	$main_logo	 = ( $meta_img != '' && !emarket_mobile_check() )? $meta_img : $logo_select;
?>
	<a  href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php if( $main_logo != '' ){ ?>
			<img src="<?php echo esc_url( $main_logo ); ?>" alt="<?php bloginfo('name'); ?>"/>
		<?php }else{
			$logo = get_template_directory_uri().'/assets/img/logo-default.png';
			if ( $scheme ){ 
				$logo = get_template_directory_uri().'/assets/img/logo-'. $scheme .'.png'; 
			}
		?>
			<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo('name'); ?>"/>
		<?php } ?>
	</a>
<?php 
}

/*
** Product Meta
*/
add_action("admin_init", "post_init");
add_action( 'save_post', 'emarket_product_save_meta', 10, 1 );
function post_init(){
	add_meta_box("emarket_product_meta", esc_html__( 'Recommend Product:', 'emarket' ), "emarket_product_meta", "product", "side", "high");
	add_meta_box("emarket_product_video_meta", esc_html__( 'Featured Video Product', 'emarket' ), "emarket_product_video_meta", "product", "side", "low");
}	
function emarket_product_meta(){
	global $post;
	$recommend_product = get_post_meta( $post->ID, 'recommend_product', true );
	$newproduct 	   = get_post_meta( $post->ID, 'newproduct', true );
	wp_nonce_field( 'emarket_product_save_meta', 'emarket_product_meta_nonce' );
?>
	<p><label><b><?php esc_html_e( 'Recommend Product:', 'emarket' ) ?></b></label> &nbsp;&nbsp;
	<input type="checkbox" name="recommend_product" value="1" <?php echo checked( $recommend_product, 1 ) ?> /></p>
	
	<p><label><b><?php esc_html_e( 'New Product', 'emarket' ) ?></b></label> &nbsp;&nbsp;
		<input type="number" name="newproduct" value="<?php echo esc_attr( $newproduct ) ?>"/>
		<span class="p-description"><?php echo esc_html__( 'Set day for the new product label from the date publish product.', 'emarket' ); ?></span>
	</p>
<?php }

function emarket_product_video_meta(){
	global $post;
	$featured_video_product = get_post_meta( $post->ID, 'featured_video_product', true );
	$guide_product_preview  = get_post_meta( $post->ID, 'guide_product_preview', true );
	$attach_url =( wp_get_attachment_url( $guide_product_preview ) ) ? wp_get_attachment_url( $guide_product_preview ) : '';
	wp_nonce_field( 'emarket_product_save_meta', 'emarket_product_video_meta_nonce' );
?>
	<div class="featured-image">
		<?php if( $featured_video_product != '' ) : ?>
		<div class="video-wrapper">
			<iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo esc_attr( $featured_video_product ); ?>" frameborder="0" allowfullscreen></iframe>
		</div>
		<?php endif; ?>
		<p><input type="text" name="featured_video_product" placeholder="<?php echo esc_attr__( 'Youtube Video ID', 'emarket' ) ?>" value="<?php echo esc_attr( $featured_video_product ); ?>"/></p>
	</div>
	<div class="guide-product">
		<p><?php esc_html_e( 'Upload guide to choose size', 'emarket' ) ?></p>
		<div class="form-upload">
			<div class="product-thumbnail"><input type="text" readonly value="<?php echo esc_url( $attach_url ); ?>" style="width: 100%; margin-bottom: 10px;"/></div>
			<div>	
				<input type="hidden" class="thumbnail" name="guide_product_preview" value="<?php echo esc_attr( $guide_product_preview ); ?>"/>
				<button type="button" class="upload_image_button button"><?php _e( 'Upload', 'emarket' ); ?></button>
				<button type="button" class="remove_image_button button">x</button>
			</div>									
		</div>
	</div>
	<script>
		(function($) {
			"use strict";
			
			function sw_upload_image( tar_parent ){
				// Only show the "remove image" button when needed
				if ( ! tar_parent.find( '.thumbnail' ).val() ) {
					tar_parent.find( '.remove_image_button' ).hide();
				}

				// Uploading files
				var file_frame;

				tar_parent.find( '.upload_image_button' ).on( 'click', function( event ) {

					event.preventDefault();

					// If the media frame already exists, reopen it.
					if ( file_frame ) {
						file_frame.open();
						return;
					}

					// Create the media frame.
					file_frame = wp.media.frames.downloadable_file = wp.media({
						title: '<?php _e( "Choose an image", 'emarket' ); ?>',
						button: {
							text: '<?php _e( "Use image", 'emarket' ); ?>'
						},
						multiple: false
					});

					// When an image is selected, run a callback.
					file_frame.on( 'select', function() {
						var attachment = file_frame.state().get( 'selection' ).first().toJSON();
						tar_parent.find( '.thumbnail' ).val( attachment.id );
						tar_parent.find( '.product-thumbnail > input' ).val('<?php echo esc_js( $attach_url ); ?>');
						tar_parent.find( '.remove_image_button' ).show();
					});

					// Finally, open the modal.
					file_frame.open();
				});

				tar_parent.find( '.remove_image_button' ).on( 'click', function() {
					tar_parent.find( '.thumbnail' ).val( '' );
					tar_parent.find( '.product-thumbnail > input' ).val('');
					tar_parent.find( '.remove_image_button' ).hide();
					return false;
				});
			}
			$( '.form-upload' ).each( function(){
				sw_upload_image( $(this) );
			});
		})(jQuery);
	</script>
<?php 
}

function emarket_product_save_meta( $post_id ){
	if ( ! isset( $_POST['emarket_product_meta_nonce'] ) || ! isset( $_POST['emarket_product_video_meta_nonce'] ) ) {
		return;
	}
	$guide_product_preview = ( isset( $_POST['guide_product_preview'] ) ) ? $_POST['guide_product_preview'] : '';
	$meta_val = ( isset( $_POST['recommend_product'] ) ) ? $_POST['recommend_product'] : 0;
	update_post_meta( $post_id, 'recommend_product', $meta_val );
	if( isset( $_POST['featured_video_product'] ) ){
		update_post_meta( $post_id, 'featured_video_product', $_POST['featured_video_product'] );
	}
	if( isset( $_POST['newproduct'] ) ){
		update_post_meta( $post_id, 'newproduct', intval( $_POST['newproduct'] ) );
	}
	if( isset( $_POST['guide_product_preview'] ) ){
	update_post_meta( $post_id, 'guide_product_preview', $guide_product_preview );	
	}
}
/*end product meta*/

/*
** Function Get datetime blog 
*/
function emarket_get_time(){
	global $post;
	echo '<span class="entry-date latest_post_date">
		<span class="day-time">'. get_the_time( 'd', $post->ID ) . '</span>
		<span class="month-time">'. get_the_time( 'M', $post->ID ) . '</span>
	</span>';
}

/*
** BLog columns
*/
function emarket_blogcol(){
	global $sw_blogcol;
	$blog_col = ( isset( $sw_blogcol ) && $sw_blogcol > 0 ) ? $sw_blogcol : emarket_options()->getCpanelValue('blog_column');
	$col = 'col-md-'.( 12/$blog_col ).' col-sm-6 col-xs-12 theme-clearfix';
	$col .= ( get_the_post_thumbnail() ) ? '' : ' no-thumb';
	return $col;
}

/*
** Trimword Title
*/

function emarket_trim_words( $title ){
	$title_length = intval( emarket_options()->getCpanelValue( 'title_length' ) );
	$html = '';
	if( $title_length > 0 ){
		$html .= wp_trim_words( $title, $title_length, '...' );
	}else{
		$html .= $title;
	}
	echo esc_html( $html );
}

/*
** Advanced Favico
*/
add_filter( 'get_site_icon_url', 'emarket_site_favicon', 10, 1 );
function emarket_site_favicon( $url ){
	if ( emarket_options()->getCpanelValue('favicon') ){
		$url = esc_url( emarket_options()->getCpanelValue('favicon') );
	}
	return $url;
}

/*
** Social Link
*/
function emarket_social_link(){
	$fb_link = emarket_options()->getCpanelValue('social-share-fb');
	$tw_link = emarket_options()->getCpanelValue('social-share-tw');
	$tb_link = emarket_options()->getCpanelValue('social-share-tumblr');
	$li_link = emarket_options()->getCpanelValue('social-share-in');
	$gg_link = emarket_options()->getCpanelValue('social-share-go');
	$pt_link = emarket_options()->getCpanelValue('social-share-pi');
	$it_link = emarket_options()->getCpanelValue('social-share-instagram');

	$html = '';
	if( $fb_link != '' || $tw_link != '' || $tb_link != '' || $li_link != '' || $gg_link != '' || $pt_link != '' ):
	$html .= '<div class="emarket-socials"><ul>';
		if( $fb_link != '' ):
			$html .= '<li><a href="'. esc_url( $fb_link ) .'" title="'. esc_attr__( 'Facebook', 'emarket' ) .'"><i class="fa fa-facebook"></i></a></li>';
		endif;
		
		if( $tw_link != '' ):
			$html .= '<li><a href="'. esc_url( $tw_link ) .'" title="'. esc_attr__( 'Twitter', 'emarket' ) .'"><i class="fa fa-twitter"></i></a></li>';
		endif;
		
		if( $tb_link != '' ):
			$html .= '<li><a href="'. esc_url( $tb_link ) .'" title="'. esc_attr__( 'Tumblr', 'emarket' ) .'"><i class="fa fa-tumblr"></i></a></li>';
		endif;
		
		if( $li_link != '' ):
			$html .= '<li><a href="'. esc_url( $li_link ) .'" title="'. esc_attr__( 'Linkedin', 'emarket' ) .'"><i class="fa fa-linkedin"></i></a></li>';
		endif;
		
		if( $it_link != '' ):
			$html .= '<li><a href="'. esc_url( $it_link ) .'" title="'. esc_attr__( 'Instagram', 'emarket' ) .'"><i class="fa fa-instagram"></i></a></li>';
		endif;
		
		if( $gg_link != '' ):
			$html .= '<li><a href="'. esc_url( $gg_link ) .'" title="'. esc_attr__( 'Google+', 'emarket' ) .'"><i class="fa fa-google-plus"></i></a></li>';
		endif;
		
		if( $pt_link != '' ):
			$html .= '<li><a href="'. esc_url( $pt_link ) .'" title="'. esc_attr__( 'Pinterest', 'emarket' ) .'"><i class="fa fa-pinterest"></i></a></li>';
		endif;
	$html .= '</ul></div>';
	endif;
	echo wp_kses( $html, array( 'div' => array( 'class' => array() ), 'ul' => array(), 'li' => array(), 'a' => array( 'href' => array(), 'class' => array(), 'title' => array() ), 'i' => array( 'class' => array() ) ) );
}
