<?php
/**
 * Register sidebars and widgets
 */
function emarket_unregister_default_widgets() {
	unregister_widget('WC_Widget_Featured_Products');
	unregister_widget('WC_Widget_Best_Sellers');
	unregister_widget('WC_Widget_Top_Rated_Products');
	unregister_widget( 'WC_Widget_Product_Categories' );
	if ( class_exists( 'WooCommerce' ) ) {
		include_once( get_template_directory() . '/widgets/woocommerce/widget-product-categories.php' );
		register_widget( 'Custom_WC_Widget_Product_Categories' );
	}
}
add_action('widgets_init', 'emarket_unregister_default_widgets', 11);
 
/*
** Register Sidebar and Widgets
*/
function emarket_widgets_init() {
	
	// Sidebars
	global $emarket_widget_areas;
	$emarket_widget_areas = emarket_widget_setup_args();
	if ( count($emarket_widget_areas) ){
		foreach( $emarket_widget_areas as $sidebar ){
			$sidebar_params = apply_filters('emarket_sidebar_params', $sidebar);
			register_sidebar($sidebar_params);
		}
	}

	// Widgets
	register_widget('Emarket_Social_Widget');
	register_widget('Emarket_Posts_Widget');
	register_widget('Emarket_Top_Widget');
}
add_action('widgets_init', 'emarket_widgets_init');

/**
 * Posts widget class
 *
 * @since 2.8.0
*/
class Emarket_Posts_Widget extends Emarket_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'sw_posts', 'description' => esc_html__('SW Posts', 'emarket'));
		parent::__construct('sw_posts', esc_html__('SW Posts', 'emarket'), $widget_ops);
		$this->base = get_template_directory().'/lib';
	}
}

class Emarket_Top_Widget extends Emarket_Widget{

	function __construct(){
		$widget_ops = array('classname' => 'sw_top', 'description' => esc_html__('SW top header widget', 'emarket'));
		parent::__construct('sw_top', esc_html__('SW Top Widget', 'emarket'), $widget_ops);
	}
}

class Emarket_Social_Widget extends WP_Widget{

	function __construct(){
		$widget_ops = array('classname' => 'sw_social', 'description' => esc_html__('SW Social Networks', 'emarket'));
		parent::__construct('sw_social', esc_html__('SW Social', 'emarket'), $widget_ops);
		$this->option_name='socials';
	}

	function widget($args, $instance){
		$socials  = isset($instance['socials']) && is_array($instance['socials']) ? $instance['socials'] : array();
		extract($args);
		$title = apply_filters('widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base);

		echo $before_widget;
		if ($title){
			echo $before_title . $title . $after_title;
		}
		?>
<ul>
    <?php foreach ($socials as $social){?>
    <?php preg_match('/fa-.*?/', $social['icon'], $match); ?>
    <li><a href="<?php echo esc_url( $social['link'] ); ?>"
            title="<?php if (empty($match)) echo esc_attr( $social['icon'] ); ?>">
            <?php if (empty($match)) echo esc_html( $social['icon'] ); else { ?>
            <i class="fa <?php echo esc_attr( $social['icon'] )?>"></i> <?php }?>
        </a></li>
    <?php } ?>
</ul>
<?php
		echo $after_widget;
	}

	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$socials = array();
		foreach ($new_instance['socials'] as $i => $social){
			if (isset($social['icon'])){
				$icon = trim(strip_tags($social['icon']));
				if ( !empty($icon) ){
					$link = trim(strip_tags($social['link']));
					if ( empty($link) ){
						$link = '#';
					}
					$socials[]= array( 'icon' => $icon, 'link' => $link );
				}
			}
		}
		$instance['socials'] = $socials;
		return $instance;
	}

	function form($instance){ 
		$title   = isset($instance['title']) ? sanitize_title($instance['title']) : '';
		$socials = isset($instance['socials']) && is_array($instance['socials']) ? $instance['socials'] : array();

		?>
<p>
    <label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e('Title: ', 'emarket'); ?>
    </label> <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>"
        name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text"
        value="<?php echo esc_attr($title); ?>" />
</p>

<?php 
		// if saved data
		foreach ($socials as $j => $social){

			$name_j = $this->get_field_name($this->option_name).'['.$j.']';
			$id_j = $this->get_field_id($this->option_name).'_'.$j;

			$name_j_icon = $name_j.'[icon]';
			$id_j_icon = $id_j.'_icon';

			$name_j_link = $name_j.'[link]';
			$id_j_link = $id_j.'_link';
			?>
<p>
    <strong><?php echo esc_html__( 'Social', 'emarket' ). ' ' .( $j+1 ); ?>
    </strong><br>
    <?php if (key_exists('icon', $social)){?>
    <label for="<?php echo esc_attr( $id_j_icon ); ?>"><?php esc_html_e('fa-* | title', 'emarket')?>
    </label> <input class="widefat" id="<?php echo esc_attr( $id_j_icon );?>"
        name="<?php echo esc_attr($name_j_icon); ?>" type="text" value="<?php echo esc_attr( $social['icon'] ); ?>"><br>
    <?php }?>
    <label for="<?php echo esc_attr( $id_j_link ); ?>"><?php esc_html_e('Link ', 'emarket')?> </label>
    <input class="widefat" id="<?php echo esc_attr( $id_j_link );?>" name="<?php echo esc_attr($name_j_link); ?>"
        type="text" value="<?php echo esc_attr( $social['link'] ); ?>">
</p>
<?php
		}

		// emarket fields for add new social network
		$i = (is_array($socials) && count($socials)) ? count($socials) : 0;

		$name_i = $this->get_field_name($this->option_name).'['.$i.']';
		$id_i = $this->get_field_id($this->option_name).'_'.$i;

		$name_i_icon = $name_i.'[icon]';
		$id_i_icon = $id_i.'_icon';

		$name_i_link = $name_i.'[link]';
		$id_i_link = $id_i.'_link';

		?>
<p>
    <strong><?php esc_html_e( 'Add a new social network', 'emarket' ) ?></strong><br> <label
        for="<?php echo esc_attr( $id_i_icon ); ?>"><?php esc_html_e('Classname for Icon or Title', 'emarket'); ?>
    </label> <input class="widefat" id="<?php echo esc_attr( $id_i_icon ); ?>"
        name="<?php echo esc_attr( $name_i_icon ); ?>" type="text" value=""
        placeholder="<?php esc_attr_e( 'Enter Font Awesome icon or Title', 'emarket' ) ?>" /> <span><?php esc_html_e( 'If using as
		icon, please choose class name in Font Awesome. This is required.', 'emarket' ) ?></span>
    <label for="<?php echo esc_attr( $id_i_link ); ?>"><?php esc_html_e('Link ', 'emarket')?> </label>
    <input class="widefat" id="<?php echo esc_attr( $id_i_link ); ?>" name="<?php echo esc_attr( $name_i_link ); ?>"
        type="text" value="" placeholder="#" />
</p>
<?php
	}

}

class Emarket_Widgets{

	protected $dir = null;
	protected $url = null;
	protected $styles = null;
	
	protected $widget = null;
	protected $enqueues = array();
	
	public $_enqueue;
			
	public function __construct(){
		add_filter('in_widget_form', array($this, 'in_widget_form'), 10, 3);
		add_filter('widget_update_callback', array($this, 'widget_update_callback'), 10, 3);
		add_filter('widget_display_callback', array($this, 'widget_display_callback'), 10, 3);

		// enqueue
		add_filter('admin_enqueue_scripts', array($this, 'wp_enqueue_scripts'));
		$this->getWidgetStyles();
	}

	public function widget_display_callback( $instance, $widget, $args ){		
		//Widget Display
		$widget_display = isset($instance['widget_display']) ? $instance['widget_display'] : array();
		
		if ( emarket_check_wdisplay($widget_display) == false ) return false;
		
		if ( $style = $this->getStyleIn($instance) ){
			if ( isset($style['before_widget']) && !empty($style['before_widget'])){
				// Substitute HTML id and class attributes into before_widget
				global $wp_registered_widgets;
				$classname_ = '';
				foreach ( (array) $wp_registered_widgets[$widget->id]['classname'] as $cn ) {
					if ( is_string($cn) )
						$classname_ .= '_' . $cn;
					elseif ( is_object($cn) )
					$classname_ .= '_' . get_class($cn);
				}
				$classname_ = ltrim($classname_, '_');
				$args['before_widget'] = sprintf($style['before_widget'], $widget->id, $classname_);
			}
			if ( isset($style['after_widget']) ){
				$args['after_widget'] = $style['after_widget'];
			}
			if ( isset($style['before_title']) || isset($style['after_title']) ){
				$args['before_title'] = $style['before_title'];
				$args['after_title'] = $style['after_title'];
			}
			$widget->widget($args, $instance);
			
			return false;
		}

		return $instance;
	}

	public function widget_update_callback( $instance, $new, $old ){
		$instance_new['widget_style'] = isset($new['widget_style']) ? $new['widget_style'] : 'inherit';
		$instance_new['adoptions'] = isset($new['adoptions']) ? $new['adoptions'] : false;
		
		return wp_parse_args($instance_new, $instance);
	}
	
	public function in_widget_form($widget, $r = null, $instance = array() ){
		
		$this->widget = &$widget;
		$widget_style = isset($instance['widget_style']) ? trim($instance['widget_style']) : '';
		
		//Widgets Style
		$styles = $this->getWidgetStyles();
		$styles = array_merge(array('default' => 'Default'), $styles);
		$styles = array_unique($styles);
		?>

<div class="advanced-opt">
    <div class="advanced-opt-pane">
        <div class="advanced-opt-pane-inner">
            <div class="pane-content">
                <div class="pane-left">
                    <p>
                        <label
                            for="<?php echo esc_attr( $widget->get_field_id('widget_style') ); ?>"><?php esc_html_e( 'Widget Style', 'emarket' ) ?>
                        </label> <select class="widefat"
                            id="<?php echo esc_attr( $widget->get_field_id('widget_style') ); ?>"
                            name="<?php echo esc_attr( $widget->get_field_name('widget_style') ); ?>">
                            <?php foreach ( $styles as $key => $value ){
										$selected = '';
													if ($key == $widget_style) $selected = 'selected="selected"'; ?>
                            <option <?php echo 'value="'.esc_attr( $key ).'" '.$selected ; ?>>
                                <?php echo $value; ?>
                            </option>
                            <?php }	?>
                        </select>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <br class="clear">
</div>

<?php
	}

	public function wp_enqueue_scripts(){

		if (!isset($this->_enqueue)){
			$this->initialize();
			wp_enqueue_style('widget-options', $this->url . 'admin/css/widget-options.css', array(), null);
			wp_enqueue_script('widget-options', $this->url . 'admin/js/widget-options.js', false, null, false);
			$this->_enqueue = true;
		}
	}

	public function initialize(){

		$this->dir 	= trailingslashit( str_replace( '\\', '/', get_template_directory() . '/lib/' ) );
		$this->url 	= trailingslashit( get_template_directory_uri() ) . '/lib/' ;

	}
	
	/**
	 * Scans a directory for files of a certain extension.
	 *
	 * @since 3.4.0
	 * @access private
	 *
	 * @param string $path Absolute path to search.
	 * @param mixed  Array of extensions to find, string of a single extension, or null for all extensions.
	 * @param int $depth How deep to search for files. Optional, defaults to a flat scan (0 depth). -1 depth is infinite.
	 * @param string $relative_path The basename of the absolute path. Used to control the returned path
	 * 	for the found files, particularly when this function recurses to lower depths.
	 */
	protected function scandir( $path, $extensions = null, $depth = 0, $relative_path = '' ) {
		
		if ( ! is_dir( $path ) )
			return false;

		if ( $extensions ) {
			$extensions = (array) $extensions;
			$_extensions = implode( '|', $extensions );
		}

		$relative_path = trailingslashit( $relative_path );
		if ( '/' == $relative_path )
			$relative_path = '';

		$results = array();
		$results = scandir( $path );
		$files = array();
		if( $results ) {
			foreach ( $results as $result ) {
				if ( '.' == $result[0] )
					continue;
				if ( is_dir( $path . '/' . $result ) ) {
					if ( ! $depth || 'CVS' == $result )
						continue;
					$found = self::scandir( $path . '/' . $result, $extensions, $depth - 1 , $relative_path . $result );
					$files = array_merge_recursive( $files, $found );
				} elseif ( ! $extensions || preg_match( '~\.(' . $_extensions . ')$~', $result ) ) {
					$files[ $relative_path . $result ] = $path . '/' . $result;
				}
			}
			return $files;
		}
	}

	protected function getWidgetStyles(){
		
		if ( is_null($this->styles) ){
			$tmp = array();
			if ( $_core_styles = $this->scandir(EMARKET_DIR.'/widgets/_styles', 'php') )
			foreach( $_core_styles as $f ){
				$alias = basename($f, '.php');
				$name  = ucfirst($alias);
				$tmp[ $alias ] = $name;
			}

			if ( $_theme_styles = $this->scandir(get_template_directory().'/widgets/_styles') )
			foreach( $_theme_styles as $f ){
				$alias = basename($f, '.php');
				$name  = ucfirst($alias);
				$tmp[ $alias ] = $name;
			}
			
			$this->styles = $tmp;
		}
		return $this->styles;
	}
	
	protected function getStyleIn( $instance = array(), $load_style = true ){
		
		$styles = $this->getWidgetStyles();
		$current_style = isset( $instance['widget_style'] ) ? trim($instance['widget_style']) : '';
		if ( !empty($current_style) && isset($styles[$current_style]) ){
			
		} else {
			$current_style = '';
		}
		return $load_style ? $this->loadStyle($current_style) : $current_style;
	}
	
	protected function loadStyle( $style = '' ){
		
		if ( !empty($style) ){

			$_theme_style = get_template_directory().'/widgets/_styles/'.$style.'.php';
			
			if ( file_exists($_theme_style) ){
				require $_theme_style;
				return @$ws[$style];
			}
			
			$_core_style = EMARKET_DIR.'/widgets/_styles/'.$style.'.php';
			if ( file_exists($_core_style) ){
				require $_core_style;
				return @$ws[$style];
			}
			
			if ( $style != 'default' ){
				return $this->loadStyle('default');
			}
			
		}
		return false;
	}
}

$widgets = new Emarket_Widgets;