<?php 
/**
	* Layout Countdown Default
	* @version     1.0.0
**/


$default = array(
	'post_type' => 'product',	
	'meta_query' => array(		
		array(
			'key' => '_sale_price',
			'value' => 0,
			'compare' => '>',
			'type' => 'DECIMAL(10,5)'
		),
		array(
			'key' => '_sale_price_dates_from',
			'value' => time(),
			'compare' => '<',
			'type' => 'NUMERIC'
		),
		array(
			'key' => '_sale_price_dates_to',
			'value' => time(),
			'compare' => '>',
			'type' => 'NUMERIC'
		)
	),
	'orderby' => $orderby,
	'order' => $order,
	'post_status' => 'publish',
	'showposts' => $numberposts	
);
if( $category != '' ){	
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ));
}
$id = 'sw_countdown_'.$this->generateID();
$list = new WP_Query( $default );
if ( $list -> have_posts() ){ ?>
	<div id="<?php echo $category.'_'.$id; ?>" class="sw-woo-container-slider responsive-slider countdown-slider3 loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>" data-circle="false">       
		<div class="resp-slider-container">
			<?php if( $title1 != '' ){?>
				<div class="box-title">
					<h3><span><?php echo ( $title1 != '' ) ? $title1 : ''; ?></span></h3>
				</div>
			<?php } ?>
			<div class="slider responsive">	
			<?php 
				$count_items = 0;
				$count_items = ( $numberposts >= $list->found_posts ) ? $list->found_posts : $numberposts;
				$i = 0;
				while($list->have_posts()): $list->the_post();					
				global $product, $post;
				$start_time 	= get_post_meta( $post->ID, '_sale_price_dates_from', true );
				$countdown_date = get_post_meta( $post->ID, '_sale_price_dates_to', true );
			?>
				<div class="item-countdown product" id="<?php echo 'product_'.$id.$post->ID; ?>">
					<div class="item-wrap">
						<div class="item-img">
							<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?></a>
							<div class="item-bottom center">
								<?php emarket_quickview( true ); ?>
							</div>
							<?php if( $countdown_date ) : ?>							
								<div class="product-countdown pull-right" data-date="<?php echo esc_attr( sw_timezone_offset( $countdown_date ) ); ?>"  data-starttime="<?php echo esc_attr( $start_time ); ?>"></div>		
							<?php endif; ?>
						</div>
						<div class="item-content">	
							<?php woocommerce_template_loop_rating(); ?>
							<?php emarket_template_loop_product_title(); ?>
							<?php woocommerce_template_loop_price(); ?>	
							<?php emarket_woocommerce_template_loop_before_add_to_cart(); ?>
							<?php woocommerce_template_loop_add_to_cart(); ?>
							<?php emarket_woocommerce_template_loop_after_add_to_cart(); ?>
						</div>
					</div>
				</div>
			<?php endwhile; wp_reset_postdata();?>
			</div>
		</div>            
	</div>
<?php
	} 
?>