<?php 
/**
	* Layout Countdown Default
	* @version     1.0.0
**/


$default = array(
	'post_type' => 'product',	
	'meta_query' => array(		
		array(
			'key' => '_sale_price',
			'value' => 0,
			'compare' => '>',
			'type' => 'DECIMAL(10,5)'
		),
		array(
			'key' => '_sale_price_dates_from',
			'value' => time(),
			'compare' => '<',
			'type' => 'NUMERIC'
		),
		array(
			'key' => '_sale_price_dates_to',
			'value' => 0,
			'compare' => '>',
			'type' => 'NUMERIC'
		)
	),
	'orderby' => $orderby,
	'order' => $order,
	'post_status' => 'publish',
	'showposts' => $numberposts	
);
if( $category != '' ){
	
	if ( class_exists('Vc_Manager') ) {	
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ));
	}else{		
		$default['tax_query'] = array(
			array(
				'taxonomy'  => 'product_cat',
				'field'     => 'id',
				'terms'     => $category ));
		}
}
$id = 'sw_countdown_'.$this->generateID();
$list = new WP_Query( $default );
if ( $list -> have_posts() ){ ?>
	<div id="<?php echo $category.'_'.$id; ?>" class="sw-woo-container-slider responsive-slider countdown-slider-style9 loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>" data-circle="false">       
		<?php if( $title1 != '' ){?>
			<div class="block-title">
				<h3><span><?php echo ( $title1 != '' ) ? $title1 : ''; ?></span></h3>
				<div class="description"><?php echo ( $description1 != '' ) ? $description1 : ''; ?></div>
			</div>
			<?php } ?>
		<div class="resp-slider-container">
			<div class="slider responsive">	
			<?php 	
				while($list->have_posts()): $list->the_post();					
				global $product, $post;
				$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
				$start_time = get_post_meta( $post->ID, '_sale_price_dates_from', true );
				$countdown_time = get_post_meta( $post->ID, '_sale_price_dates_to', true );	
				$date = sw_timezone_offset( $countdown_time );
			?>
				<div class="item item-countdown product <?php echo esc_attr( $class )?>" id="<?php echo 'product_'.$id.$post->ID; ?>">
					<div class="item-wrap">
						<div class="item-img-wrap">
							<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
							<?php if( $date ) : ?>
								<div class="product-countdown" data-date="<?php echo esc_attr( sw_timezone_offset( $date ) ); ?>"  data-starttime="<?php echo esc_attr( $start_time ); ?>"></div>
							<?php endif; ?>	
						</div>
						<div class="item-content">
							<?php emarket_template_loop_product_title(); ?>	
							<?php woocommerce_template_loop_price(); ?>
							<?php woocommerce_template_loop_add_to_cart(); ?>
						</div>															
					</div>
				</div>
			<?php endwhile; wp_reset_postdata();?>
			</div>
		</div>            
	</div>
<?php
	} 
?>