<?php 
/**
* Layout Countdown Default
* @version     1.0.0
**/

$default = array(
	'post_type' => 'product',	
	'meta_query' => array(
		array(
			'key' => '_sale_price',
			'value' => 0,
			'compare' => '>',
			'type' => 'DECIMAL(10,5)'
		),
		array(
			'key' => '_sale_price_dates_from',
			'value' => time(),
			'compare' => '<',
			'type' => 'NUMERIC'
		),
		array(
			'key' => '_sale_price_dates_to',
			'value' => 0,
			'compare' => '>',
			'type' => 'NUMERIC'
		)
	),
	'orderby' => $orderby,
	'order' => $order,
	'post_status' => 'publish',
	'showposts' => $numberposts	
);
if( $category != '' ){
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ));
}
$countdown_id = 'sw_tab_countdown_'.rand().time();
$countdown_id2 = 'sw_tab_countdown2_'.rand().time();
$list = new WP_Query( $default );
if ( $list -> have_posts() ){ ?>
<div id="<?php echo $countdown_id; ?>" class="sw_tab_countdown">
	<?php if( $title1 != '' ){?>
	<div class="block-title">
		<h3><span><?php echo ( $title1 != '' ) ? $title1 : ''; ?></span></h3>
	</div>
	<?php } ?>
	<div  class="tab-countdown-slide clearfix">
		<div class="tab-content image-left">
			<?php
				$count_items 	= 0;
				$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
				$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
				$i 				= 0;
				while($list->have_posts()): $list->the_post();
				global $product, $post;
				$start_time 	= get_post_meta( $post->ID, '_sale_price_dates_from', true );
				$countdown_date = get_post_meta( $post->ID, '_sale_price_dates_to', true );
				$terms_id = get_the_terms( $post->ID, 'product_cat' );
				$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
				$term_str = '';
										
				foreach( $terms_id as $key => $value ) :
					$term_str .= '<a href="'. get_term_link( $value->term_id, 'product_cat' ) .'">'. esc_html( $value->name ) .'</a>';
				endforeach;
			?>
			<div class="tab-pane <?php echo ( $i == 0 ) ? 'active' : ''; ?>" id="<?php echo 'product_tab_'.$post->ID; ?>" >
				<div class="item">
					<div class="item-wrap">
						<div class="item-img products-thumb">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'shop_single', array( 'alt' => get_the_title() ) ); ?></a>
							<?php sw_label_sales() ?>
						</div>
						<div class="item-content">															
							<?php emarket_template_loop_product_title(); ?>
							<?php woocommerce_template_loop_price(); ?>
							<div class="item-description"><?php echo $post->post_excerpt; ?></div>
							<?php 
							if( $product->get_stock_quantity() != 0 ){ 
							$available 	 = $product->get_stock_quantity();
							$total_sales = get_post_meta( $post->ID, 'total_sales', true );
							$bar_width 	 = intval( $available ) / intval( $available + $total_sales ) * 100;
						?>
						<div class="emarket-stock clearfix">
							<div class="stock-avail pull-left"><?php esc_html_e( 'Available: ', 'emarket' ) ?><span><?php echo $available; ?></span></div>
							<div class="stock-sold pull-right"><?php esc_html_e( 'Sold: ', 'emarket' ) ?><span><?php echo $total_sales; ?></span></div>
						</div>
						<div class="sales-bar clearfix">
							<div class="sales-bar-total">
								<span style="width: <?php echo esc_attr( $bar_width . '%' ); ?>"></span>
							</div>
						</div>
						<?php } ?>
						<?php if( $countdown_date ) : ?>
						<div class="countdown-wrapper text">
							<div class="count-left pull-left">
								<h2><?php esc_html_e( 'Hurry up!', 'emarket' ) ?></h2>
								<p><?php esc_html_e( 'Offers end in:', 'emarket' ) ?></p>
							</div>
							<div class="product-countdown" data-date="<?php echo esc_attr( sw_timezone_offset( $countdown_date ) ); ?>"  data-starttime="<?php echo esc_attr( $start_time ); ?>"></div>		
						</div>
						<?php endif; ?>
						</div>							
					</div>
				</div>
			</div>
			<?php
				$i++; endwhile; wp_reset_postdata();
			?>
		</div>

				<div class="top-tab-slider clearfix">
					<div id="<?php echo 'tab_' . $countdown_id; ?>" class="sw-tab-slider responsive-slider loading hidden-xs" data-lg="8" data-md="5" data-sm="4" data-xs="4" data-mobile="3" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>" data-autoplay="false" data-vertical="false">
						<ul class="nav nav-tabs slider responsive">
							<?php
							$i = 0;
							while($list->have_posts()): $list->the_post();	
								global $product, $post;
								?>
								<li <?php echo ( $i == 0 )? 'class="item active"' : 'class="item"'; ?>>
									<a href="#<?php echo 'product_tab_'.$post->ID; ?>" data-toggle="tab">
										<?php echo get_the_post_thumbnail( $post->ID, 'woocommerce_thumbnail', array( 'alt' => $post->post_title ) ); ?>
									</a>
								</li>
								<?php
								$i++; endwhile; wp_reset_postdata();
								?>
							</ul>
						</div>
					</div>

				</div>
			</div>
			<?php
		} 
		?>
		<script type="text/javascript">
/* (function ($) {
	"use strict";
	$('#<?php echo 'mytab_' . $countdown_id; ?> a').click(function (e) {
		console.log( $(this) );
		e.preventDefault();
		$(this).tab('show');
	});
})(jQuery);*/
</script>