<?php 
/**
	* Layout Countdown Default
	* @version     1.0.0
**/

$default = array(
	'post_type' => 'product',	
	'meta_query' => array(
		array(
			'key' => '_sale_price',
			'value' => 0,
			'compare' => '>',
			'type' => 'DECIMAL(10,5)'
		),
		array(
			'key' => '_sale_price_dates_from',
			'value' => time(),
			'compare' => '<',
			'type' => 'NUMERIC'
		),
		array(
			'key' => '_sale_price_dates_to',
			'value' => time(),
			'compare' => '>',
			'type' => 'NUMERIC'
		)
	),
	'orderby' => $orderby,
	'order' => $order,
	'post_status' => 'publish',
	'showposts' => $numberposts	
);
if( $category != '' ){
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ));
}
$default = sw_check_product_visiblity( $default );

$countdown_id = 'sw_tab_countdown_'.$this->generateID();
$countdown_id2 = 'sw_tab_countdown2_'.$this->generateID();
$list = new WP_Query( $default );
if ( $list -> have_posts() ){ ?>
<div id="<?php echo $countdown_id; ?>" class="sw_tab_countdown2">
<?php if( $title1 != '' ){?>
			<div class="block-title">
				<h3><?php echo ( $title1 != '' ) ? $title1 : ''; ?></h3>
			</div>
<?php } ?>
<div  class="tab-countdown-slide clearfix">
		<div class="top-tab-slider clearfix">	
			<div id="<?php echo 'mytab_' . $countdown_id; ?>" class="sw-tab-slider responsive-slider loading" data-lg="4" data-md="3" data-sm="3" data-xs="3" data-mobile="3" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>" data-autoplay="false" data-vertical="true">
				<ul class="nav nav-tabs slider responsive">
					<?php
						$i = 0;
						while($list->have_posts()): $list->the_post();	
						global $post;
					?>
					<li class="<?php echo ( $i == 0  ) ? 'active' : '' ?>">
						<a href="#<?php echo 'product_tab_'.$post->ID; ?>" data-toggle="tab">
							<?php echo get_the_post_thumbnail( $post->ID, 'woocommerce_thumbnail', array( 'alt' => $post->post_title ) ); ?>
						</a>
					</li>
					<?php
						$i++; endwhile; wp_reset_postdata();
					?>
				</ul>
			</div>
		</div>
		<div class="top-tab-slider-full clearfix">	
			<div id="<?php echo 'tab2_' . $countdown_id2; ?>" class="sw-tab-slider responsive-slider loading hidden-lg hidden-md" data-lg="3" data-md="3" data-sm="3" data-xs="3" data-mobile="3" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>" data-autoplay="false" data-vertical="false">
				<ul class="nav nav-tabs slider responsive">
					<?php
						$i = 0;
						while($list->have_posts()): $list->the_post();	
						global $post;
					?>
						<li class="<?php echo ( $i == 0  ) ? 'active' : '' ?>">
						<a href="#<?php echo 'product_tab_'.$post->ID; ?>" data-toggle="tab">
							<?php echo get_the_post_thumbnail( $post->ID, 'woocommerce_thumbnail', array( 'alt' => $post->post_title ) ); ?>
						</a>
					</li>
					<?php
						$i++; endwhile; wp_reset_postdata();
					?>
				</ul>
			</div>
		</div>
		<div class="tab-content clearfix">
			<?php
				$count_items 	= 0;
				$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
				$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
				$i 				= 0;
				while($list->have_posts()): $list->the_post();
				global $product, $post;
				$start_time 	= get_post_meta( $post->ID, '_sale_price_dates_from', true );
				$countdown_date = get_post_meta( $post->ID, '_sale_price_dates_to', true );
				$terms_id = get_the_terms( $post->ID, 'product_cat' );
				$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
				$term_str = '';
										
				foreach( $terms_id as $key => $value ) :
					$term_str .= '<a href="'. get_term_link( $value->term_id, 'product_cat' ) .'">'. esc_html( $value->name ) .'</a>';
				endforeach;
			?>
			<div class="tab-pane <?php echo ( $i == 0 ) ? 'active' : ''; ?>" id="<?php echo 'product_tab_'.$post->ID; ?>" >
				<div class="item">
					<div class="item-wrap">
						<div class="item-detail">										
							<div class="item-img products-thumb">
							   <span class="onsale"><?php echo esc_html__('Sale','emarket') ?></span>
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
									<?php 
										$id = get_the_ID();
										if ( has_post_thumbnail() ){
												echo get_the_post_thumbnail( $post->ID, 'shop_single', array( 'alt' => $post->post_title ) ) ? get_the_post_thumbnail( $post->ID, 'shop_single', array( 'alt' => $post->post_title ) ): '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'large'.'.png" alt="No thumb">';		
										}else{
											echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/'.'large'.'.png" alt="No thumb">';
										}
									?>
								</a>
							</div>
							<div class="item-content">															
								<div class="product-countdown" data-date="<?php echo esc_attr( sw_timezone_offset( $countdown_date ) ); ?>"  data-starttime="<?php echo esc_attr( $start_time ); ?>"></div>
								<?php emarket_template_categories_name(); ?>
								<?php emarket_template_loop_product_title(); ?>
								<?php emarket_template_rating_custom(); ?>
								<?php woocommerce_template_loop_price(); ?>
								<div class="description"><?php echo $post->post_excerpt; ?></div>	
								 <!-- add to cart, wishlist, compare -->
								<div class="item-button">
									<?php woocommerce_template_loop_add_to_cart(); ?>
									<?php
									if ( class_exists( 'YITH_WCWL' ) ){
											echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
									} ?>
									<?php if ( class_exists( 'YITH_WOOCOMPARE' ) ){ 
										?>
										<div class="woocommerce product compare-button">
											<a href="javascript:void(0)" class="compare button"  title="<?php esc_html_e( 'Add to Compare', 'emarket' ) ?>" data-product_id="<?php echo esc_attr($post->ID); ?>" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 1024 1024"><path d="m21.84 301.808l475.09 258.72a32.1 32.1 0 0 0 15.312 3.904a32 32 0 0 0 15.184-3.84l480.096-258.72c10.464-5.631 16.975-16.624 16.815-28.528a32.09 32.09 0 0 0-17.504-28.16L531.713 3.904c-9.055-4.592-19.744-4.624-28.88-.064L22.785 245.12c-10.624 5.343-17.44 16.16-17.632 28.064s6.256 22.944 16.687 28.624M517.153 68.287l406.159 206.271L512.336 496.03L106.16 274.846zm484.187 412.031l-94.974-48.225l-68.56 36.976l80 40.624l-410.96 221.456l-406.191-221.184l85.311-42.88l-68.368-37.248l-100.32 50.4c-10.624 5.344-17.44 16.16-17.633 28.065s6.256 22.944 16.688 28.624l475.088 258.72a32.1 32.1 0 0 0 15.312 3.903a32 32 0 0 0 15.184-3.84l480.096-258.72c10.464-5.631 16.975-16.624 16.815-28.528a32 32 0 0 0-17.487-28.143zm.01 223.999l-89.966-44.224l-68.56 36.976l75.008 36.624l-410.976 221.456l-406.192-221.184l79.312-35.872l-68.368-37.248l-94.32 43.408C6.662 709.597-.154 720.413-.346 732.318s6.255 22.944 16.687 28.624l475.088 258.72a32.1 32.1 0 0 0 15.313 3.903a32 32 0 0 0 15.183-3.84l480.096-258.72c10.464-5.632 16.976-16.624 16.816-28.528a32 32 0 0 0-17.488-28.16z"/></svg></a>
										</div>
									<?php } ?>								
									<?php emarket_quickview(true) ;?>
								</div>							
							</div>
							
							</div>
					</div>
				</div>
			</div>
			<?php
				$i++; endwhile; wp_reset_postdata();
			?>
		</div>

</div>
</div>
<?php
	} 
?>
<script type="text/javascript">
/* (function ($) {
	"use strict";
	$('#<?php echo 'mytab_' . $countdown_id; ?> a').click(function (e) {
		console.log( $(this) );
		e.preventDefault();
		$(this).tab('show');
	});
})(jQuery);*/
</script>