<?php 

/**
	* Layout Child Category
	* @version     1.0.0
**/
if( $category == '' ){
	return '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'Please select a category for SW Woo Slider. Layout ', 'emarket' ).'</p>
	</div>';
}

$widget_id = isset( $widget_id ) ? $widget_id : $this->generateID();
$viewall = get_permalink( wc_get_page_id( 'shop' ) );
$default = array();
if( $category != '' ){
	$default = array(
		'post_type' => 'product',
		'tax_query' => array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ) ),
		'orderby' => $orderby,
		'order' => $order,
		'post_status' => 'publish',
		'showposts' => $numberposts
	);
}

$term_name = '';
$term = get_term_by( 'slug', $category, 'product_cat' );
if( $term ) :
	$term_name = $term->name;
	$viewall = get_term_link( $term->term_id, 'product_cat' );
endif;

$list = new WP_Query( $default );
if ( $list -> have_posts() ){
	$x_array = array();
		$key = 0;
		foreach( $list->posts as $item ){
			$m_array = array();
			$terms = get_the_terms( $item->ID, 'product_brand' );
			if( $terms && taxonomy_exists( 'product_brand' ) ){
				foreach( $terms as $x => $bterm ){
					$m_array[$x] = $bterm -> term_id;
				}
				$x_array[$key] = implode( ',', $m_array );
				$key ++; 
			}		
		}
		$z_array = implode( ',', $x_array );
?>
	<div id="<?php echo 'slider_' . $widget_id.rand(); ?>" class="responsive-slider sw-banner-cat-product2 title-home25 loading" data-append=".resp-slider-container" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-dots="true" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
		<div class="box-title has-viewall">
			<h3><span><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></span></h3>
			<a class="view-all pull-right" href="<?php echo esc_url( $viewall ); ?>"><?php echo esc_html__('see all','emarket'); ?> <i class="fa fa-caret-right"></i></a>
		</div>
		<div class="childcat-slider-content clearfix">
			<!-- Product tab listing -->
						<?php 
			$banner_links = explode( ',', $banner_links );
			if( $image != '' ) :
				$image = explode( ',', $image );	
			?>

			<div class="banner-category">
				<div id="<?php echo esc_attr( 'banner_' . $widget_id ); ?>" class="banner-slider" data-lg="1" data-md="1" data-sm="1" data-xs="1" data-mobile="1" data-arrow="false" data-fade="false">
					<div class="banner-responsive">
						<?php foreach( $image as $key => $img ) : ?>
							<div class="item">
								<a href="<?php echo esc_url( isset( $banner_links[$key] ) ? $banner_links[$key] : '#' ); ?>"><?php echo wp_get_attachment_image( $img, 'large' ); ?></a>
							</div>
						<?php endforeach;?>
					</div>
				</div>									
			</div>
			<?php else:
				echo esc_html__('Please enter the banner image ID for layout.','emarket');
			 endif;?>
			<div class="resp-slider-container">
				<ul class="slider responsive">	
				<?php 							
					while($list->have_posts()): $list->the_post();
						wc_get_template_part( 'content', 'product' );
					endwhile; wp_reset_postdata();
				?>
				</ul>
			</div>
			<div class="banner-brand">
				<div class="wrap-banner">
					<!-- Brand -->
					<?php if( count( $x_array ) > 0 ) : ?>
					<div id="<?php echo esc_attr( 'brand_' . $widget_id ); ?>" class="brand-categories" data-lg="1" data-md="1" data-sm="1" data-xs="1" data-mobile="1" data-arrow="false" data-fade="false">
						<div class="slider">
								<?php 
									$x_array = array_unique( explode( ',', $z_array ) );
									foreach( $x_array as $key => $cat ) {
									if( $key > 5 ){
										break;
									}
										$thumbnail_id 	= absint( get_term_meta( intval( $cat ), 'thumbnail_bid', true ) );
										$thumb = wp_get_attachment_image( $thumbnail_id, array(104, 49) );
										$thubnail = ( $thumb != '' ) ? $thumb : '<img src="http://placehold.it/104x49" alt=""/>';
								?>
								<div class="item-brand">
									<a href="<?php echo get_term_link( intval( $cat ), 'product_brand' ); ?>"><?php echo $thubnail ?></a>
								</div>
								<?php
									}
								?>
							</div>
						</div>
					<?php endif; ?>	
				</div>
			</div>	
		</div>
	</div>
	<?php
	}else{
		echo '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'There is not product in this category', 'emarket' ) .'</p>
	</div>';
	}
?>