<?php ; 
wp_reset_postdata();
$default = array(
	'post_type'		=> 'product',		
	'post_status' 	=> 'publish',
	'no_found_rows' => 1,					
	'showposts' 	=> $numberposts	,
	'orderby' 				=> $orderby,
	'order' 				=> $order,
    'meta_query'     => array(
		array(
			'key'           => '_sale_price',
			'value'         => 0,
			'compare'       => '>',
			'type'          => 'numeric'
		)
	)		
);
if( $category != '' ){	
	$default['tax_query'] = array(
		array(
			'taxonomy'	=> 'product_cat',
			'field'		=> 'slug',
			'terms'		=> $category,
		)
	);
}
$default = sw_check_product_visiblity( $default );

$term_name = '';
$term = get_term_by( 'slug', $category, 'product_cat' );
if( $term ) :
	$term_name = $term->name;
endif;
$id = 'sw_toprated_'.rand().time();
$list = new WP_Query( $default );
$countdown_time = strtotime( $date );
$today = time();

if ( $list -> have_posts() ){
?>
	<div id="<?php echo $id; ?>" class="sw-woo-container-slider  responsive-slider dailydeals-product5 loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-dots="false" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
		<div class="box-slider-top clearfix">
			<div class="wrap-link clearfix">
				<?php if( $countdown_time > $today  ): ?> <div class="item-countdown" data-cdtime="<?php echo esc_attr( $countdown_time ); ?>"></div><?php else: ?><span class="message-cd"><?php echo esc_html__('Please select a time for layout.','emarket'); ?></span><?php endif; ?>
			</div>
			<?php if( $title1 != '' ){
				$titles = strpos($title1, ' ');
			?>
			<div class="block-title clearfix">
				<h3><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></h3>
			</div>
			<?php } ?>	
		</div>
		<div class="resp-slider-container">
			<div class="slider responsive">			
			<?php while($list->have_posts()): $list->the_post();global $product, $post; ?>
				<div class="item product">
					<div class="item-wrap">									
						<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
						<div class="item-content">	
							<?php emarket_template_loop_product_title(); ?>
							<?php woocommerce_template_loop_rating(); ?>
							<?php woocommerce_template_loop_price(); ?>
							<?php 
								if( $product->get_stock_quantity() != 0 ){
								$available 	 = $product->get_stock_quantity();
								$total_sales = get_post_meta( $post->ID, 'total_sales', true );
								$bar_width 	 = intval( $available ) / intval( $available + $total_sales ) * 100;
								?>
								<div class="sales-bar clearfix">
									<div class="sales-bar-total">
										<span style="width: <?php echo esc_attr( $bar_width . '%' ); ?>"></span>
									</div>
								</div>
								<div class="stock-sold"><span><?php echo $total_sales; ?></span><?php esc_html_e( 'Sold', 'emarket' ) ?></div>
							<?php } ?>
						</div>								
					</div>
				</div>
			    <?php endwhile; wp_reset_postdata();?>
			</div>
		</div>					
	</div>
<?php
}	
?>