<?php 

/**
* Layout Default
* @version     1.0.0
**/


$widget_id = isset( $widget_id ) ? $widget_id : $this->generateID();
$term_name = esc_html__( 'All Categories', 'emarket' );
$default = array(
	'post_type' => 'product',		
	'post_status' => 'publish',
	'showposts' => $numberposts,
	'meta_key'	=> 'post_views_count',
	'orderby'   => 'meta_value_num'
	);
if( $category != '' ){
	$term = get_term_by( 'slug', $category, 'product_cat' );	
	if( $term ){
		$term_name = $term->name;
	}
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category )
		);	
}
$default = sw_check_product_visiblity( $default );
$list = new WP_Query( $default );

if ( $list -> have_posts() ){ ?>
<div id="<?php echo 'slider_' . $widget_id; ?>" class="sw-woo-container-slider responsive-slider woo-slider-style2 loading" data-append=".resp-slider-container" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
	<?php if( $title1 != '' ){?>
	<div class="box-title">
		<div class="description"><?php echo ( $description != '' ) ? $description : ''; ?></div>
		<h3><span><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></span></h3>
	</div>
	<?php } ?>         
	<div class="resp-slider-container">
		<div class="slider responsive">	
			<?php 		
				while($list->have_posts()): $list->the_post();global $product, $post;
				$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
			?>
				<div class="item <?php echo esc_attr( $class )?> product">
					<div class="item-wrap">
						<?php if ( has_post_thumbnail() ){ ?>
						<div class="item-img products-thumb">		
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
								<?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?>
							</a>
						</div>
					<?php } ?>
						<div class="item-content">
							<?php emarket_template_loop_product_title(); ?>			
							<?php woocommerce_template_loop_price(); ?>	
						</div>								
					</div>
				</div>
					<?php endwhile; wp_reset_postdata();?>
		</div>
	</div>            
</div>
<?php } ?>
