<?php 

/**
* Layout Default
* @version     1.0.0
**/


$widget_id = isset( $widget_id ) ? $widget_id : $this->generateID();
$term_name = esc_html__( 'All Categories', 'emarket' );
$viewall = get_permalink( wc_get_page_id( 'shop' ) );
$default = array(
	'post_type' => 'product',		
	'orderby' => $orderby,
	'order' => $order,
	'post_status' => 'publish',
	'showposts' => $numberposts
	);
if( $category != '' ){
	$term = get_term_by( 'slug', $category, 'product_cat' );	
	if( $term ) :
		$term_name = $term->name;
		$viewall = get_term_link( $term->term_id, 'product_cat' );
	endif;

	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category )
		);	
}
$default = sw_check_product_visiblity( $default );

$list = new WP_Query( $default );

if ( $list -> have_posts() ){ ?>
<div id="<?php echo 'slider_' . $widget_id; ?>" class="sw-woo-container-slider responsive-slider woo-slider-style22 loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
	<?php if( $title1 != '' ){ ?>
		<div class="box-title">
			<h3><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></h3>
			<div class="description"><?php echo ( $description != '' ) ? $description : ''; ?></div>
		</div>
	<?php } ?>
	<div class="resp-slider-container">			
		<div class="slider responsive">	
		<?php 		
			$i = 0;
			while($list->have_posts()): $list->the_post(); global $product, $post;
			$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';				
		?>	 
			<div class="item product <?php echo esc_attr( $class )?>">
				<div class="item-wrap">
					<div class="item-detail">										
						<div class="item-img products-thumb">
							<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
							<?php do_action( 'sw_woocommerce_custom_action' ); ?>
						</div>									
						<div class="item-content">	
							<?php emarket_template_loop_product_title(); ?>							
							<?php woocommerce_template_loop_price(); ?>	
							<?php woocommerce_template_loop_add_to_cart(); ?>	
						</div>
					</div>
					<div class="item-banner-right">
						<?php
						 $j = 0;
						if( $image != '' ) :
						$images = explode( ',', $image );	
					?>
						<?php foreach( $images as $key => $img ) : 
								if( $i == $j ){
						?>
							<div class="item">
								<?php echo wp_get_attachment_image( $img, 'large' ); ?>
							</div>
								<?php }?>
						<?php $j++; endforeach;  endif; ?>
					</div>
				</div>
			</div>
		<?php $i++; endwhile; wp_reset_postdata(); ?>
		</div>
	</div>           
</div>
<?php
	}else{
		echo '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'Has no product in this category', 'emarket' ) .'</p>
	</div>';
}
?>
