<?php 
/**
* Layout Countdown Default
* @version     1.0.0
**/

$default = array(
	'post_type'				=> 'product',
	'post_status' 			=> 'publish',
	'ignore_sticky_posts'	=> 1,
	'posts_per_page' 		=> $numberposts,
	'orderby' 				=> $orderby,
	'order' 				=> $order,
);

$default['tax_query'][] = array(						
	'taxonomy' => 'product_visibility',
	'field'    => 'name',
	'terms'    => 'featured',
	'operator' => 'IN',	
);

if( $category != '' ){
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category )
		);	
}
$default = sw_check_product_visiblity( $default );

$countdown_id = 'sw_tab_featured_'.rand().time();

$list = new WP_Query( $default );
if ( $list -> have_posts() ){ ?>
<div id="<?php echo $countdown_id; ?>" class="sw_tab_featured">
	<?php if( $title1 != '' ){?>
	<div class="block-title">
		<h3><span><?php echo ( $title1 != '' ) ? $title1 : ''; ?></span></h3>
	</div>
	<?php } ?>
	<div  class="tab-sw-slide clearfix">
		<div class="tab-content clearfix">
			<?php
			$count_items 	= 0;
			$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
			$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
			$i 				= 0;
			while($list->have_posts()): $list->the_post();global $product, $post;
			$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
		?>
				<div class="tab-pane <?php echo ( $i == 0 ) ? 'active' : ''; ?>" id="<?php echo 'product_tab_arrival'.$post->ID; ?>" >
					<ul class="items-products">
						<?php wc_get_template_part( 'content', 'product' ); ?>
					</ul>
				</div>
			<?php $i++; endwhile; wp_reset_postdata(); ?>
		</div>

		<div class="top-tab-slider clearfix">
			<div id="<?php echo 'tab_' . $countdown_id; ?>" class="sw-tab-slider responsive-slider loading hidden-xs" data-lg="4" data-md="4" data-sm="3" data-xs="3" data-mobile="2" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>" data-autoplay="false" data-vertical="true">
				<ul class="nav nav-tabs slider responsive-verticle">
					<?php
					$i = 0;
					while($list->have_posts()): $list->the_post();	
					global $product, $post;
					?>
					<li <?php echo ( $i == 0 )? 'class="item active"' : 'class="item"'; ?>>
						<a href="#<?php echo 'product_tab_arrival'.$post->ID; ?>" data-toggle="tab">
							<?php echo get_the_post_thumbnail( $post->ID, 'woocommerce_thumbnail' ); ?>
						</a>
					</li>
					<?php $i++; endwhile; wp_reset_postdata(); ?>
				</ul>
			</div>
		</div>
	</div>
</div>
<?php } ?>