<?php 

/**
	* Layout Top Rated
	* @version     1.0.0
**/


$term_name = esc_html__( 'Top Rated Products', 'emarket' );
$default = array(
	'post_type'		=> 'product',		
	'post_status' 	=> 'publish',
	'no_found_rows' => 1,					
	'showposts' 	=> $numberposts						
);
if( $category != '' ){
	$term = get_term_by( 'slug', $category, 'product_cat' );	
	if( $term ) :
		$term_name = $term->name;
	endif;
	
	$default['tax_query'] = array(
		array(
			'taxonomy'	=> 'product_cat',
			'field'		=> 'slug',
			'terms'		=> $category,
			'operator' 	=> 'IN'
		)
	);
}
$default = sw_check_product_visiblity( $default );

$default['meta_key'] = '_wc_average_rating';	
$default['orderby'] = 'meta_value_num';

$id = 'sw_toprated_'.$this->generateID();
$list = new WP_Query( $default );

if ( $list -> have_posts() ){
?>
	<div id="<?php echo $id; ?>" class="sw-woo-container-slider responsive-slider toprated-product2 loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-dots="true" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
		<?php if( $title1 != '' ){?>
		<div class="box-title">
			<h3 class="custom-font"><span><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></span></h3>
		</div>
		<?php } ?>
		<div class="resp-slider-container">
			<div class="slider responsive">	
			<?php 							
				while($list->have_posts()): $list->the_post();
					wc_get_template_part( 'content', 'product' );
				endwhile; wp_reset_postdata();
			?>
			</div>
		</div> 					
	</div>
<?php
}	else{
		echo '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'There is not product in this category', 'emarket' ) .'</p>
	</div>';
	}
?>