<?php 

/**
	* Layout Tab Category Default
	* @version     1.0.0
**/

	$tag_id = 'sw_woo_rplisting_'. rand().time();
	$nav_id = 'nav_tabs_res'.rand().time();
	$attribute = 'columns-'.$columns.' columns-md-'.$columns1.' columns-sm-'.$columns2.' columns-xs-'.$columns3;
?>
<div class="sw-woo-tab-listing default woocommerce" id="<?php echo esc_attr( $tag_id ); ?>">
		<?php if( $title1 != '' ){ ?>
			<div class="box-title"><h3><?php echo  $title1; ?></h3></div>
		<?php } ?>
		<ul class="tab-listing-container products products-loop <?php echo esc_attr( $attribute ); ?>">
			<?php
				$default = array(
					'post_type' => 'product',		
					'orderby' => $orderby,
					'order' => $order,
					'post_status' => 'publish',
					'showposts' => $numberposts
					);
				if( $category != '' ){
					$default['tax_query'] = array(
						array(
							'taxonomy'  => 'product_cat',
							'field'     => 'slug',
							'terms'     => $category ),
							'operator' => 'IN'
						);	
				}
				$default = sw_check_product_visiblity( $default );				
				$list = new WP_Query( $default );
				$max_page = $list -> max_num_pages;
				if( $list->have_posts() ) : 			 
					while($list->have_posts()): $list->the_post();
					global $product, $post;
				?>
					<li class="product item-listing">
						<div class="item-wrap">
							<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
							<div class="item-content">
								<?php 
									emarket_template_loop_product_title();
									woocommerce_template_loop_price();
								?>
								<?php do_action( 'woocommerce_after_add_to_cart_form'); ?>
							</div>								
						</div>
					</li>
					<?php endwhile; wp_reset_postdata();?>
					
				<?php 
					else :
						esc_html_e( 'There is no product on this category', 'emarket' );
					endif;
				?>			
		</ul>
		<div class="item-listing item-more">
			<a href="#" data-ajaxurl="<?php echo esc_url( sw_ajax_url() ) ?>" data-layout="<?php echo esc_attr( isset( $widget_template ) ? $widget_template : $layout );?>" data-maxpage="<?php echo esc_attr( $max_page ) ?>" data-number="<?php echo esc_attr( $numberposts ) ?>" data-orderby="<?php echo esc_attr( $orderby ) ?>" data-order="<?php echo esc_attr( $order ) ?>" data-category="<?php echo esc_attr( $category ) ?>" data-label-loaded="<?php esc_attr_e( 'All Item', 'emarket' ); ?>" data-label="<?php esc_html_e( 'Load More', 'emarket' ); ?>"></a>
		</div>
	</div>
