<?php 
	if( !is_array( $select_order ) ){
		$select_order = explode( ',', $select_order );
	}
	$viewall = get_permalink( wc_get_page_id( 'shop' ) );
	$widget_id =  'sw_woo_tab_'. $this->generateID();
?>
<div class="sw-wootab-slider sw-ajax sw-woo-tab-<?php echo esc_attr( isset( $widget_template ) ? $widget_template : $layout );?>" id="<?php echo esc_attr( 'woo_tab_' . $widget_id ); ?>" >
	<div class="resp-tab <?php echo isset( $style ) ? esc_attr( $style ) : '';;?>" style="position:relative;">				
		
			<div class="top-tab-slider toggle-button clearfix">
				<?php if( $title1 != '' ): ?>
					<div class="box-title"><h3><?php echo ( $title1 != '' ) ? $title1 : ''; ?></h3></div>
				<?php endif; ?>
				<!-- Get child category -->
				<button class="navbar-toggle collapsed pull-right" type="button" data-toggle="collapse" data-target="#<?php echo 'nav_'.$widget_id; ?>"  aria-expanded="false">			
					<svg xmlns="http://www.w3.org/2000/svg" width="1em" height="1em" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M3 16h18v2H3zm0-5h18v2H3zm0-5h18v2H3z"/></svg>
				</button>
				<ul class="nav nav-tabs" id="<?php echo 'nav_'.$widget_id; ?>">
					<?php 
						$active = $tab_active -1;
						$tab_title = '';
						foreach( $select_order as $i  => $so ){						
							switch ($so) {
							case 'latest':
								$tab_title = __( 'Latest Products', 'emarket' );
							break;
							case 'rating':
								$tab_title = __( 'Top Rating Products', 'emarket' );
							break;
							case 'bestsales':
								$tab_title = __( 'Best Selling', 'emarket' );
							break;						
							default:
								$tab_title = __( 'Featured Products', 'emarket' );
							}
						?>
						<li <?php echo ( $i == $active ) ? 'class="active loaded"' : ''; ?>>
							<a href="#<?php echo esc_attr( $so. '_' .$widget_id ) ?>" data-type="so_ajax" data-layout="<?php echo esc_attr( isset( $widget_template ) ? $widget_template : $layout );?>" data-row="<?php echo esc_attr( $item_row ) ?>" data-length="<?php echo esc_attr( $title_length ) ?>" data-ajaxurl="<?php echo esc_url( sw_ajax_url() ) ?>" data-category="<?php echo esc_attr( $category ) ?>" data-toggle="tab" data-sorder="<?php echo esc_attr( $so ); ?>" data-catload="ajax" data-number="<?php echo esc_attr( $numberposts ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
								<?php echo esc_html( $tab_title ); ?>
							</a>
						</li>			
					<?php } ?>
				</ul>
			</div>
		<!-- End get child category -->		
			<div class="tab-content clearfix">					
			<!-- Product tab slider -->						
				<div class="tab-pane active" id="<?php echo esc_attr( $select_order[$active]. '_' .$widget_id ) ?>">
				<?php 
					$default = array();			
					if( $select_order[$active] == 'latest' ){
						$default = array(
							'post_type'	=> 'product',
							'paged'		=> 1,
							'showposts'	=> $numberposts,
							'orderby'	=> 'date'
						);						
					}
					if( $select_order[$active] == 'rating' ){
						$default = array(
							'post_type'		=> 'product',							
							'post_status' 	=> 'publish',
							'no_found_rows' => 1,					
							'showposts' 	=> $numberposts						
						);
						$default['meta_key'] = '_wc_average_rating';	
						$default['orderby'] = 'meta_value_num';						
					}
					if( $select_order[$active] == 'bestsales' ){
						$default = array(
							'post_type' 			=> 'product',							
							'post_status' 			=> 'publish',
							'ignore_sticky_posts'   => 1,
							'showposts'				=> $numberposts,
							'meta_key' 		 		=> 'total_sales',
							'orderby' 		 		=> 'meta_value_num',							
						);
					}
					if( $select_order[$active] == 'featured' ){
						$default = array(
							'post_type'	=> 'product',
							'post_status' 			=> 'publish',
							'ignore_sticky_posts'	=> 1,
							'showposts' 		=> $numberposts,							
						);
						$default['tax_query'][] = array(						
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
							'operator' => 'IN',	
						);						
					}
					if( $category != '' ){
						$term = get_term_by( 'slug', $category, 'product_cat' );
						
						if( $term ) :
							$thumbnail_id 	= get_term_meta( $term->term_id, 'thumbnail_id', true );
							$thumb = wp_get_attachment_image( $thumbnail_id,'full', array( 'alt' => $term->name ) );
							$viewall = get_term_link( $term->term_id, 'product_cat' );
						endif;
						
						$default['tax_query'][] = array(
							'taxonomy'	=> 'product_cat',
							'field'		=> 'slug',
							'terms'		=> $category,
							'operator' 	=> 'IN'
						);
					}
					$default = sw_check_product_visiblity( $default );
					
					$list = new WP_Query( $default );				
					if( $list->have_posts() ) :
				?>
					<div id="<?php echo esc_attr( 'tab_'. $select_order[$active]. '_' .$widget_id ); ?>" class="woo-tab-container-slider" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
						<div class="resp-slider-container">
							<ul class="slider">
								<!-- Product tab listing -->
								<?php 
									if( $term ) :	
								?>
								<li class="item item-banner clearfix">
									<div class="item-image">
										<a href="<?php echo esc_url( $viewall ); ?>"><?php echo $thumb; ?></a>
									</div>							
								</li>
							<?php endif; ?>
							<?php 								
								while($list->have_posts()): $list->the_post();
								global $product, $post;	
								$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
								wc_get_template_part( 'content', 'product' );
								endwhile; wp_reset_postdata();
							?>
							</ul>
						</div>
					</div>
				<?php 
					else :
						echo '<div class="alert alert-warning alert-dismissible" role="alert">
						<a class="close" data-dismiss="alert">&times;</a>
						<p>'. esc_html__( 'There is not product on this tab', 'emarket' ) .'</p>
						</div>';
					endif;				
				?>
				</div>
			<!-- End product tab slider -->
			</div>
	</div>
</div>