(function($) {
	"use strict";
	$( '.award-more' ).on( 'click', function(e){
		var content = '<div class="author-awards-item">' +
				'<input type="text" name="sw_awards_title[]" value="" class="awards-title" placeholder="'+ sw_author.award_title +'"/>' +
				'<input type="number" name="sw_awards_year[]" value="" class="awards-year" min="1000"  placeholder="'+ sw_author.award_title +'"/>' +
				'<input type="text" name="sw_awards_book[]" value="" class="awards-book"  placeholder="'+ sw_author.award_title +'"/>' +
				'<a href="#" class="delete-award-item">'+ sw_author.award_delete +'</a>' +
			'</div>';
		$('.sw-author-awards').append( content );
		
		$( '.delete-award-item' ).on( 'click', function(e){
			$(this).parent().remove();
			e.preventDefault();
		});		
		e.preventDefault();
	});
	
	$( '.delete-award-item' ).on( 'click', function(e){
		$(this).parent().remove();
		e.preventDefault();
	});
	
	$("#author_product").selectWoo({
	  multiple: true,
	  ajax: {
		url: sw_author.ajaxurl + '?action=sw_search_author_callback',
		dataType: 'json',
		delay: 250,
		data: function (params) {
		  return {
			q: params.term, // search term
			page: params.page
		  };
		},
		processResults: function (data, page) {
		  // parse the results into the format expected by Select2.
		  // since we are using custom formatting functions we do not need to
		  // alter the remote JSON data
		  return {
			results: data.items
		  };
		},
		cache: true
	  },
	 escapeMarkup: function (markup) { return markup; },
		minimumInputLength: 1,
		templateResult: formatRepo,
		templateSelection: formatRepoSelection

	});

	function formatRepo (repo) {
		if (repo.loading) return repo.text;

		var markup = 
		'<div class="author-result">' +	   
		 repo.title + '</div>';
		return markup;
	}

	function formatRepoSelection (repo) {
		return repo.title || repo.text;
	}
	
})(jQuery);