<?php 
namespace WCPATH\SWG_MENU;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Core\Settings\Manager as SettingsManager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;

final class SWG_Menu_elementor extends Widget_Base{
	protected $nav_menu_index = 1;
	
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}
	
	function get_name() {
		return 'swg_menu';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE Menu', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-post-elements' ];
	}
	
	public function get_style_depends() {
		return ['swg-megamenu-style'];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'swg-megamenu' ];
	}
	
	protected function get_nav_menu_index() {
		return $this->nav_menu_index++;
	}
	
	public function get_icon() {
		return 'eicon-nav-menu';
	}
	
	public function get_available_menus(){
		$all_categories = wp_get_nav_menus();

		$data = array();
		if( $all_categories ){
			foreach ($all_categories as $cat) {
				$data[$cat->name] = $cat->name;
			}
		}
		return $data;
	}
	
	public function register_controls() {
		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Content', 'sw_core' ),
			)
		);	
		
		$menus = $this->get_available_menus();

		if ( ! empty( $menus ) ) {
			$this->add_control(
				'menu',
				[
					'label' => esc_html__( 'Menu', 'elementor-pro' ),
					'type' => Controls_Manager::SELECT,
					'options' => $menus,
					'default' => array_keys( $menus )[0],
					'save_default' => true,
					'separator' => 'after',
					'description' => sprintf(
						/* translators: 1: Link opening tag, 2: Link closing tag. */
						esc_html__( 'Go to the %1$sMenus screen%2$s to manage your menus.', 'elementor-pro' ),
						sprintf( '<a href="%s" target="_blank">', admin_url( 'nav-menus.php' ) ),
						'</a>'
					),
				]
			);
		} else {
			$this->add_control(
				'menu',
				[
					'type' => Controls_Manager::RAW_HTML,
					'raw' => '<strong>' . esc_html__( 'There are no menus in your site.', 'elementor-pro' ) . '</strong><br>' .
							sprintf(
								/* translators: 1: Link opening tag, 2: Link closing tag. */
								esc_html__( 'Go to the %1$sMenus screen%2$s to create one.', 'elementor-pro' ),
								sprintf( '<a href="%s" target="_blank">', admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
								'</a>'
							),
					'separator' => 'after',
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}
		
		$this->add_control(
			'menu_icon_dropdown',
			[
				'label' => esc_html__( 'Menu Icon Dropdown', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'fas fa-angle-down',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
					
				],
				'default' => [
					'value' => 'fas fa-angle-down',
					'library' => 'fa-solid',
				],				
			]
		);
		
		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout Type', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'horizontal',
				'options' => [
					'horizontal' => esc_html__( 'Horizontal', 'elementor-pro' ),
					'vertical' => esc_html__( 'Vertical', 'elementor-pro' ),
					'vertical_toggle' => esc_html__( 'Vertical Toggle', 'elementor-pro' ),
					'horizon_toogle' => esc_html__( 'Horizontal Toggle', 'elementor-pro' ),
				],
				'frontend_available' => true,
			]
		);
		
		$this->add_control(
			'layout_vertical',
			[
				'label' => esc_html__( 'Vertical Menu Type', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( 'Expand', 'elementor-pro' ),
					'1' => esc_html__( 'Collapse', 'elementor-pro' ),
					'2' => esc_html__( 'Hover Collapse', 'elementor-pro' ),
				],
				'frontend_available' => true,
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);
		
		
		
		$this->add_control(
			'pointer',
			[
				'label' => esc_html__( 'Pointer', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'underline',
				'options' => [
					'none' => esc_html__( 'None', 'elementor-pro' ),
					'underline' => esc_html__( 'Underline', 'elementor-pro' ),
					'overline' => esc_html__( 'Overline', 'elementor-pro' ),
					'double-line' => esc_html__( 'Double Line', 'elementor-pro' ),
					'framed' => esc_html__( 'Framed', 'elementor-pro' ),
					'background' => esc_html__( 'Background', 'elementor-pro' ),
					'text' => esc_html__( 'Text', 'elementor-pro' ),
				],
				'style_transfer' => true,
				'condition' => [
					'layout!' => 'dropdown',
				],
			]
		);
		
		$this->add_responsive_control(
			'menu_wrapper_width',
			[
				'label' => esc_html__( 'Menu Wrapper Width', 'elementor-pro' ),
				'description' =>  esc_html__( 'Set menu wrapper width to align mega menu', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1000,
						'max' => 1920,
					],
				],
			]
		);
		
		$this->add_control(
			'menu_title',
			[
				'label'   => __( 'Menu Title', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle']
				],
			]
		);	
		
		$this->add_control(
			'toggle_icon_layout',
			[
				'label' => esc_html__( 'Icon For Toggle Layout', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'fas fa-bars',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
					
				],
				'default' => [
					'value' => 'fas fa-bars',
					'library' => 'fa-solid',
				],
				'condition' => [
					'layout' => ['horizon_toggle', 'vertical_toggle']
				],
			]
		);
		$this->add_control(
			'menu_icon',
			[
				'label' => esc_html__( 'Menu Icon Before Title', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'fas fa-bars',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
					
				],
				'default' => [
					'value' => 'fas fa-bars',
					'library' => 'fa-solid',
				],
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle']
				],
			]
		);
		
		$this->add_control(
			'menu_dropdown_icon',
			[
				'label' => esc_html__( 'Menu Icon After Title', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'fas fa-chevron-down',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
					
				],
				'default' => [
					'value' => 'fas fa-chevron-down',
					'library' => 'fa-solid',
				],
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle']
				],
			]
		);	
		
		/* More Menu */
		$this->add_control(
			'vertical_menu_more',
			[
				'label'   => __( 'More Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'See More', 'sw_core' ),
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle']
				],
			]
		);
		
		$this->add_control(
			'vertical_menu_less',
			[
				'label'   => __( 'Less Text', 'sw_core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'See Less', 'sw_core' ),
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle']
				],
			]
		);	
		
		$this->add_control(
			'vertical_menu_number',
			[
				'label'   => __( 'Number Item To Show', 'sw_core' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 0,
				'condition' => [
					'layout' => ['vertical', 'vertical_toggle']
				],
			]
		);	
		
		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_menu',
			array(
				'label' => __( 'Responsive Menu Configure', 'sw_core' ),
			)
		);
		
		// TODO: For Pro 3.6.0, convert this to the breakpoints utility method introduced in core 3.5.0.
		$breakpoints = ElementorPlugin::$instance->breakpoints->get_active_breakpoints();
		$dropdown_options = [];
		$excluded_breakpoints = [
			'laptop',
			'widescreen',
		];
		
		
		foreach ( $breakpoints as $breakpoint_key => $breakpoint_instance ) {
			// Do not include laptop and widscreen in the options since this feature is for mobile devices.
			if ( in_array( $breakpoint_key, $excluded_breakpoints, true ) ) {
				continue;
			}

			$dropdown_options[ $breakpoint_key ] = sprintf(
				/* translators: 1: Breakpoint label, 2: `>` character, 3: Breakpoint value. */
				esc_html__( '%1$s (%2$s %3$dpx)', 'elementor-pro' ),
				$breakpoint_instance->get_label(),
				'>',
				$breakpoint_instance->get_value()
			);
		}
		

		$dropdown_options['none'] = esc_html__( 'None', 'elementor-pro' );

		$this->add_control(
			'dropdown',
			[
				'label' => esc_html__( 'Breakpoint', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'tablet',
				'options' => $dropdown_options,
				'prefix_class' => 'swg-nav-menu-responsive-',				
			]
		);

		$this->add_control(
			'full_width',
			[
				'label' => esc_html__( 'Full Width', 'elementor-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'description' => esc_html__( 'Stretch the dropdown of the menu to full width.', 'elementor-pro' ),
				'prefix_class' => 'swg-nav-menu-responsive--',
				'return_value' => 'stretch',
				'frontend_available' => true,
				'condition' => [
					'dropdown!' => 'none',
				],
			]
		);

		$this->add_control(
			'text_align',
			[
				'label' => esc_html__( 'Text  Align', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'aside',
				'options' => [
					'aside' => esc_html__( 'Aside', 'elementor-pro' ),
					'center' => esc_html__( 'Center', 'elementor-pro' ),
				],
				'prefix_class' => 'swg-nav-menu__text-align-'
			]
		);

		$this->add_control(
			'toggle',
			[
				'label' => esc_html__( 'Toggle Button', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'burger',
				'options' => [
					'' => esc_html__( 'None', 'elementor-pro' ),
					'burger' => esc_html__( 'Hamburger', 'elementor-pro' ),
				],
				'prefix_class' => 'swg-nav-menu-toggle swg-nav-menu-',
				'render_type' => 'template',
				'frontend_available' => true,
				'condition' => [
					'dropdown!' => 'none',
				],
			]
		);

		$this->start_controls_tabs( 'nav_icon_options' );

		$this->start_controls_tab( 'nav_icon_normal_options', [
			'label' => esc_html__( 'Normal', 'elementor-pro' ),
			'condition' => [
				'toggle' => 'burger',
			],
		] );
		
		$this->add_control(
			'toggle_icon_normal',
			[
				'label' => esc_html__( 'Icon', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'eicon-menu-bar',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
				],
				'recommended' => [
					'fa-solid' => [
						'plus-square',
						'plus',
						'plus-circle',
						'bars',
					],
					'fa-regular' => [
						'plus-square',
					],
				],
				'condition' => [
					'toggle' => 'burger',
				],
			]
		);		

		$this->end_controls_tab();

		$this->start_controls_tab( 'nav_icon_hover_options', [
			'label' => esc_html__( 'Hover', 'elementor-pro' ),
			'condition' => [
				'toggle' => 'burger',
			],
		] );

		$this->add_control(
			'toggle_icon_hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'elementor-pro' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
				'frontend_available' => true,
				'render_type' => 'template',
				'condition' => [
					'toggle' => 'burger',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'nav_icon_active_options', [
			'label' => esc_html__( 'Active', 'elementor-pro' ),
			'condition' => [
				'toggle' => 'burger',
			],
		] );
		
		$this->add_control(
			'toggle_icon_active',
			[
				'label' => esc_html__( 'Icon', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'eicon-close',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
				],
				'recommended' => [
					'fa-solid' => [
						'plus-square',
						'plus',
						'plus-circle',
						'bars',
					],
					'fa-regular' => [
						'plus-square',
					],
				],
				'condition' => [
					'toggle' => 'burger',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'toggle_align',
			[
				'label' => esc_html__( 'Toggle Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'selectors_dictionary' => [
					'left' => 'margin-right: auto',
					'center' => 'margin: 0 auto',
					'right' => 'margin-left: auto',
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle' => '{{VALUE}}',
				],
				'condition' => [
					'toggle!' => '',
					'dropdown!' => 'none',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style_layout_toggle',
			[
				'label' => esc_html__( 'Layout Toggle', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' =>[
					'layout' => ['horizon_toggle', 'vertical_toggle'],
				],
			]
		);
		
		$this->add_responsive_control(
			'layout_toggle_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'layout_toggle_border',
				'selector' => '{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu',
				'separator' => 'before',
			]
		);
		
		$this->start_controls_tabs( 'layout_toggle_style' );

		$this->start_controls_tab(
			'tab_layout_toggle_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'layout_toggle_icon_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'color: {{VALUE}}', // Harder selector to override text color control
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu svg' => 'fill: {{VALUE}}', // Harder selector to override text color control
				],
			]
		);

		$this->add_control(
			'layout_toggle_icon_background_color',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_layout_toggle_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'layout_toggle_icon_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu:hover' => 'color: {{VALUE}}', // Harder selector to override text color control
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu:hover svg' => 'fill: {{VALUE}}', // Harder selector to override text color control
				],
			]
		);

		$this->add_control(
			'layout_toggle_icon_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu:hover' => 'background-color: {{VALUE}}',
				],
			]
		);	
		$this->add_control(
			'layout_toggle_icon_border_color_hover',
			[
				'label' => esc_html__( 'border Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu:hover' => 'border-color: {{VALUE}}',
				],
			]
		);	
		

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_control(
			'layout_toggle_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
					'body.rtl {{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'padding_layout_toggle_icon',
			[
				'label' => esc_html__( 'Horizontal Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'padding_layout_toggle_icon_vertical',
			[
				'label' => esc_html__( 'Vertical Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'layout_toggle_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_style_heading',
			[
				'label' => esc_html__( 'Heading', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',				
				'selector' => '{{WRAPPER}} .swg-menu .mega-title',
			]
		);
		
		$this->add_control(
			'heading_align',
			[
				'label' => esc_html__( 'Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title' => 'text-align: {{VALUE}}',
				],				
				'separator' => 'before',
			]
		);
		
		$this->start_controls_tabs( 'tabs_heading_style' );

		$this->start_controls_tab(
			'tab_heading_style_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'heading_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title' => 'color: {{VALUE}}', // Harder selector to override text color control
				],
			]
		);

		$this->add_control(
			'heading_background_color',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_heading_style_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'toggle_heading_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu:hover .mega-title' => 'color: {{VALUE}}', // Harder selector to override text color control
				],
			]
		);

		$this->add_control(
			'heading_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu:hover .mega-title' => 'background-color: {{VALUE}}',
				],
			]
		);	
		

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'padding_horizontal_heading',
			[
				'label' => esc_html__( 'Horizontal Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .menu-title' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'padding_vertical_heading',
			[
				'label' => esc_html__( 'Vertical Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .menu-title' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'heading_space_between',
			[
				'label' => esc_html__( 'Space Between', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'heading_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
					'body.rtl {{WRAPPER}} .swg-menu .mega-title' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'heading_border',
				'selector' => '{{WRAPPER}} .swg-menu .mega-title',
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'heading_bicon_style',
			[
				'label' => esc_html__( 'Menu Icon Before Title Style', 'elementor-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'heading_bicon_size',
			[
				'label' => esc_html__( 'Size', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_menu_bicon_style' );

		$this->start_controls_tab(
			'tabs_menu_bicon_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);
		
		$this->add_control(
			'heading_bicon_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title > svg' => 'fill: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'heading_bicon_background',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'background-color: {{VALUE}}',
				],
			]
		);	
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tabs_menu_bicon_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);
		
		$this->add_control(
			'heading_bicon_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu:hover .mega-title .icon-before-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu:hover .mega-title .icon-before-title > svg' => 'fill: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'heading_bicon_background_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu:hover .mega-title .icon-before-title' => 'background-color: {{VALUE}}',
				],
			]
		);	
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'padding_bicon',
			[
				'label' => esc_html__( 'Horizontal Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'padding_bicon_vertical',
			[
				'label' => esc_html__( 'Vertical Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'bicon_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-menu .mega-title .icon-before-title' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'heading_aicon_style',
			[
				'label' => esc_html__( 'Menu Icon After Title Style', 'elementor-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'heading_aicon_size',
			[
				'label' => esc_html__( 'Size', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'default' =>[
					'px' => 14,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-after-title' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_menu_aicon_style' );

		$this->start_controls_tab(
			'tabs_menu_aicon_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);
		
		$this->add_control(
			'heading_aicon_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-after-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu .mega-title .icon-after-title svg' => 'fill: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'heading_aicon_background',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-after-title' => 'background-color: {{VALUE}}',
				],
			]
		);	
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tabs_menu_aicon_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);
		
		$this->add_control(
			'heading_aicon_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu:hover .mega-title .icon-after-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu:hover .mega-title .icon-after-title svg' => 'fill: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'heading_aicon_background_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu:hover .mega-title .icon-after-title' => 'background-color: {{VALUE}}',
				],
			]
		);	
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'padding_aicon',
			[
				'label' => esc_html__( 'Horizontal Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-after-title' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'padding_aicon_vertical',
			[
				'label' => esc_html__( 'Vertical Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .mega-title .icon-after-title' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style_main-menu',
			[
				'label' => esc_html__( 'Main Menu', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'vertical_heading_config',
			[
				'label' => esc_html__( 'Vertical Configurations', 'elementor-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'vertical_menu_width',
			[
				'label' => esc_html__( 'Vertical Menu Width', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 150,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-vertical' => 'min-width: {{SIZE}}{{UNIT}};',
				],
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);
		
		$this->add_responsive_control(
			'vertical_menu_offset_top',
			[
				'label' => esc_html__( 'Vertical Menu Offset Top', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-vertical' => 'top: calc( 100% + {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper' => 'top: calc( 100% + {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .vertical-toggle.swg-menu .swg-menu-vertical:before,
					{{WRAPPER}} .vertical-hover.swg-menu .swg-menu-vertical:before,
					{{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper:before' => 'height: {{SIZE}}{{UNIT}}; top: -{{SIZE}}{{UNIT}};',
				],
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);
		
		
		$this->add_responsive_control(
			'vertical_menu_offset_left',
			[
				'label' => esc_html__( 'Vertical Menu Offset Left', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-vertical' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper' => 'left: {{SIZE}}{{UNIT}};',
					'body.rtl {{WRAPPER}} {{WRAPPER}} .swg-menu .swg-menu-vertical' => 'right: {{SIZE}}{{UNIT}}; left: auto;',
					'body.rtl {{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper' => 'right: {{SIZE}}{{UNIT}}; left:auto',
				],
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);	
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'vertical_menu_border',
				'selector' => '{{WRAPPER}} .swg-menu .swg-menu-vertical, {{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper',
				'separator' => 'before',
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);
		
		$this->add_control(
			'vertical_menu_background',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-vertical' => 'background-color: {{VALUE}}',
				],
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);	
		
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'vertical_menu_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .swg-menu .swg-menu-vertical, {{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper',
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				],
			]
		);		
		
		$this->add_responsive_control(
			'vertical_menu_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-vertical, {{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-menu .swg-menu-vertical, body.rtl {{WRAPPER}} .swg-menu.swg-menus-toggle .menu-toggle-wrapper' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'condition' =>[
					'layout' => ['vertical', 'vertical_toggle'],
				]
			]
		);
		
		$this->add_responsive_control(
			'vertical_menu_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-vertical' => 'padding: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',

			]
		);
		
		$this->add_responsive_control(
			'res_menu_offset_top',
			[
				'label' => esc_html__( 'Responsive Menu Offset Top', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-horizontal' => 'top: calc( 100% + {{SIZE}}{{UNIT}} );',
				],
				'condition' =>[
					'layout!' => ['vertical', 'vertical_toggle'],
					'dropdown!' => 'none',
				],
			]
		);
		
		$this->add_control(
			'mainmenu_config',
			[
				'label' => esc_html__( 'Menu Configurations', 'elementor-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography',
				'selector' => '{{WRAPPER}} .swg-elementor-menu > li > .elementor-item',
			]
		);
		
		$this->add_responsive_control(
			'res_menu_align',
			[
				'label' => esc_html__( 'Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'left',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li > .elementor-item' => 'text-align: {{VALUE}}',
				],				
				'separator' => 'before',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'menu_item_border',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .swg-elementor-menu > li > .elementor-item',				
			]
		);
		
		$this->add_responsive_control(
			'menu_item_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li > .elementor-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-elementor-menu > li > .elementor-item' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],				
			]
		);

		$this->start_controls_tabs( 'tabs_menu_item_style' );

		$this->start_controls_tab(
			'tab_menu_item_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'color_menu_item',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,				
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li > .elementor-item' => 'color: {{VALUE}};;',
					'{{WRAPPER}} .swg-elementor-menu > li > .elementor-item .dropdown-icon svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li.dropdown > a:after' => 'border-top-color: {{VALUE}}'
				],
			]
		);
		
		$this->add_control(
			'background_color_menu_item',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,	
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li > .elementor-item' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_menu_item_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'color_menu_item_hover',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li:hover > .elementor-item,
					{{WRAPPER}} .swg-elementor-menu > li.active > .elementor-item,
					{{WRAPPER}} .swg-elementor-menu > li .elementor-item.highlighted,
					{{WRAPPER}} .swg-elementor-menu > li .elementor-item:focus' => 'color: {{VALUE}};',
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li.dropdown:hover > a:after' => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .swg-elementor-menu > li:hover > .elementor-item .dropdown-icon svg,
					{{WRAPPER}} .swg-elementor-menu > li.active > .elementor-item .dropdown-icon svg' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'pointer!' => 'background',
				],
			]
		);

		$this->add_control(
			'color_menu_item_hover_pointer_bg',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li > .elementor-item:hover,
					{{WRAPPER}} .swg-elementor-menu > li.active > .elementor-item,
					{{WRAPPER}} .swg-elementor-menu > li .elementor-item.highlighted,
					{{WRAPPER}} .swg-elementor-menu > li .elementor-item:focus' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li.dropdown:hover > a:after' => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .swg-elementor-menu > li:hover > .elementor-item .dropdown-icon svg,
					{{WRAPPER}} .swg-elementor-menu > li.active > .elementor-item .dropdown-icon svg' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'pointer' => 'background',
				],
			]
		);

		$this->add_control(
			'pointer_color_menu_item_hover',
			[
				'label' => esc_html__( 'Pointer Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,				
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu:not(.pointer-framed) li:hover .elementor-item:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .pointer-background .elementor-item:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .pointer-framed .elementor-item:before,
					{{WRAPPER}} .pointer-double-line .elementor-item:before' => 'border-color: {{VALUE}}',
					
				],
				'condition' => [
					'pointer!' => [ 'none', 'text' ],
				],
			]
		);
		
		$this->add_control(
			'background_color_menu_item_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li:hover > .elementor-item' => 'background-color: {{VALUE}}; fill: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'border_color_menu_item_hover',
			[
				'label' => esc_html__( 'Border Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li:hover > .elementor-item' => 'border-color: {{VALUE}}; fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_menu_item_active',
			[
				'label' => esc_html__( 'Active', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'color_menu_item_active',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li.active > .elementor-item' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li.dropdown.active > a:after' => 'border-top-color: {{VALUE}}'
				],
			]
		);
	
		$this->add_control(
			'pointer_color_menu_item_active',
			[
				'label' => esc_html__( 'Pointer Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu:not(.pointer-framed) .active .elementor-item:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .pointer-framed .active .elementor-item:before' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .pointer-background .active .elementor-item' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'pointer!' => [ 'none', 'text' ],
				],
			]
		);
		
		$this->add_control(
			'background_color_menu_item_active',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li.active > .elementor-item' => 'background-color: {{VALUE}}; fill: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'border_color_menu_item_active',
			[
				'label' => esc_html__( 'Border Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li.active > .elementor-item' => 'border-color: {{VALUE}}; fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		/* This control is required to handle with complicated conditions */
		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_responsive_control(
			'pointer_width',
			[
				'label' => esc_html__( 'Pointer Width', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 30,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .pointer-framed .elementor-item:before' => 'border-width: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .pointer-underline .elementor-item:before,
					 {{WRAPPER}} .pointer-overline .elementor-item:before' => 'height: {{SIZE}}{{UNIT}}',
					 '{{WRAPPER}} .pointer-double-line .elementor-item:before' => 'border-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'pointer' => [ 'underline', 'overline', 'double-line', 'framed' ],
				],
			]
		);

		$this->add_responsive_control(
			'padding_horizontal_menu_item',
			[
				'label' => esc_html__( 'Horizontal Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li > .elementor-item' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'padding_vertical_menu_item',
			[
				'label' => esc_html__( 'Vertical Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li > .elementor-item' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'menu_space_between',
			[
				'label' => esc_html__( 'Space Between', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li' => 'margin: 0 {{SIZE}}{{UNIT}} 0 {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'dropdown_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu.swg-menus-toggle .button-toggle-menu' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'border_radius_menu_item',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-item:before' => 'border-radius: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .elementor-item' => 'border-radius: {{SIZE}}{{UNIT}}',
					
				],
				'condition' => [
					'pointer' => 'background',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_dropdown',
			[
				'label' => esc_html__( 'Dropdown', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'dropdown_wrapper_heading',
			[
				'label' => esc_html__( 'Dropdown Wrapper', 'elementor-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'dropdown_wrapper_background',
			[
				'label' => esc_html__( 'Background', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li.dropdown > .dropdown-menu' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'dropdown_wrapper_border',
				'selector' => '{{WRAPPER}} .swg-elementor-menu > li.dropdown > .dropdown-menu',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'dropdown_wrapper_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li.dropdown > .dropdown-menu' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'dropdown_wrapper_box_shadow',			
				'selector' => '{{WRAPPER}} .swg-elementor-menu > li.dropdown > .dropdown-menu',
			]
		);

		$this->add_responsive_control(
			'dropdown_wrapper_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-elementor-menu > li.dropdown > .dropdown-menu' => 'padding: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',

			]
		);
		
		$this->add_control(
			'dropdown_item_heading',
			[
				'label' => esc_html__( 'Dropdown Items', 'elementor-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'dropdown_description',
			[
				'raw' => esc_html__( 'On desktop, this will affect the submenu. On mobile, this will affect the entire menu.', 'elementor-pro' ),
				'type' => Controls_Manager::RAW_HTML,
				'content_classes' => 'elementor-descriptor',
			]
		);

		$this->start_controls_tabs( 'tabs_dropdown_item_style' );

		$this->start_controls_tab(
			'tab_dropdown_item_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'color_dropdown_item',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li > a, {{WRAPPER}} .swg-menu .dropdown-sub > li > a, {{WRAPPER}} .swg-menu-toggle' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'background_color_dropdown_item',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li, {{WRAPPER}} .swg-menu .dropdown-sub > li' => 'background-color: {{VALUE}}',
				],
				'separator' => 'none',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_dropdown_item_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'color_dropdown_item_hover',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li:hover > a,
					{{WRAPPER}} .swg-menu .dropdown-sub > li:hover > a,
					{{WRAPPER}} .swg-menu .dropdown-menu > li.active > a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu .dropdown-menu > li.dropdown-submenu:hover > a:after' => 'border-top-color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'background_color_dropdown_item_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li:hover > a,
					{{WRAPPER}} .swg-menu .dropdown-sub > li:hover > a,
					{{WRAPPER}} .swg-menu .dropdown-menu > li > a.elementor-item-active,
					{{WRAPPER}} .swg-menu .dropdown-menu > li > a.highlighted' => 'background-color: {{VALUE}}',
				],
				'separator' => 'none',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_dropdown_item_active',
			[
				'label' => esc_html__( 'Active', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'color_dropdown_item_active',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li.active > a,
					{{WRAPPER}} .swg-menu .dropdown-sub > li.active > a,' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-menu .dropdown-menu > li.dropdown-submenu.active > a:after' => 'border-top-color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'background_color_dropdown_item_active',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li.active > a,
					{{WRAPPER}} .swg-menu .dropdown-sub > li.active > a,' => 'background-color: {{VALUE}}',
				],
				'separator' => 'none',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'dropdown_typography',			
				'selector' => '{{WRAPPER}} .swg-menu .dropdown-menu > li >  a, {{WRAPPER}} .swg-menu .dropdown-sub > li > a',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'dropdown_border',
				'selector' => '{{WRAPPER}} .swg-menu .dropdown-menu > li > a, {{WRAPPER}} .swg-menu .dropdown-sub > li > a',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'dropdown_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li > a, {{WRAPPER}} .swg-menu .dropdown-sub > li > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .swg-menu .dropdown-menu > li:first-child > a' => 'border-top-left-radius: {{TOP}}{{UNIT}}; border-top-right-radius: {{RIGHT}}{{UNIT}};',
					'{{WRAPPER}} .swg-menu .dropdown-menu > li:last-child > a' => 'border-bottom-right-radius: {{BOTTOM}}{{UNIT}}; border-bottom-left-radius: {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-menu .dropdown-menu > li > a, body.rtl {{WRAPPER}} .swg-menu .dropdown-sub > li > a' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'dropdown_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .swg-menu .dropdown-menu',
			]
		);

		$this->add_responsive_control(
			'padding_horizontal_dropdown_item',
			[
				'label' => esc_html__( 'Horizontal Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li > a, 
					{{WRAPPER}} .swg-menu .dropdown-sub > li > a' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],
				'separator' => 'before',

			]
		);

		$this->add_responsive_control(
			'padding_vertical_dropdown_item',
			[
				'label' => esc_html__( 'Vertical Padding', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .dropdown-menu > li > a, 
					{{WRAPPER}} .swg-menu .dropdown-sub > li > a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);	

		$this->add_responsive_control(
			'dropdown_top_distance',
			[
				'label' => esc_html__( 'Distance', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li > .dropdown-menu' => 'top: calc( 100% + {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li > .dropdown-menu:before' => 'height: {{SIZE}}{{UNIT}}; top: -{{SIZE}}{{UNIT}}; margin-top: -2px;',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'dropdown_left_distance',
			[
				'label' => esc_html__( 'Left Offset', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-elementor-menu > li > .dropdown-menu' => 'left: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section( 'style_toggle',
			[
				'label' => esc_html__( 'Toggle Button', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'toggle!' => '',
					'dropdown!' => 'none',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_toggle_style' );

		$this->start_controls_tab(
			'tab_toggle_style_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'toggle_color',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} div.swg-menu-toggle' => 'color: {{VALUE}}', // Harder selector to override text color control
					'{{WRAPPER}} div.swg-menu-toggle svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'toggle_background_color',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_toggle_style_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor-pro' ),
			]
		);

		$this->add_control(
			'toggle_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} div.swg-menu-toggle:hover' => 'color: {{VALUE}}', // Harder selector to override text color control
					'{{WRAPPER}} div.swg-menu-toggle:hover svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'toggle_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'toggle_size',
			[
				'label' => esc_html__( 'Size', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 15,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle' => 'font-size: {{SIZE}}{{UNIT}}',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'toggle_border_width',
			[
				'label' => esc_html__( 'Border Width', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'range' => [
					'px' => [
						'max' => 20,
					],
					'em' => [
						'max' => 2,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle' => 'border-width: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'toggle_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'toggle_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-menu .swg-menu-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-menu .swg-menu-toggle' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',					
				],
			]
		);

		$this->end_controls_section();
	}
	
	
	protected function render() {
		$available_menus = $this->get_available_menus();

		if ( ! $available_menus ) {
			return;
		}
		$settings = $this->get_active_settings();
		
		$layout_vertical = '';
		if( isset( $settings['layout_vertical'] ) &&  $settings['layout_vertical'] == '1' ){
			$layout_vertical = 'vertical-toggle';
		}
		elseif( isset( $settings['layout_vertical'] ) &&  $settings['layout_vertical'] == '2' ){
			$layout_vertical = 'vertical-hover';
		}
		
		if( $settings['layout'] === 'vertical_toggle' || $settings['layout'] === 'horizon_toggle' ){
			$layout_vertical .= ' swg-menus-toggle';
		}
		
		if ( $settings['pointer'] ) :
			$this->add_render_attribute( 'main-menu', 'class', 'pointer-' . $settings['pointer'] );
		endif;

		$settings = $this->get_settings_for_display();
		if( !$settings['menu'] ){
			return;
		}
		$layout = 'swg-menu-horizontal';	
		if( $settings['layout'] === 'vertical_toggle' || $settings['layout'] === 'vertical' ){
			$layout = 'swg-menu-vertical';
		}
		
		$layout_wrapper = ( $settings['layout'] === 'horizontal' ) ? 'swg-menu-horizontal-wrapper' : '';
		$this->add_render_attribute( 'main-menu', 'class', [
			'swg-menu', $layout_vertical, $layout_wrapper] 
		);
		$container_w = ElementorPlugin::$instance->kits_manager->get_active_kit_for_frontend()->get_settings();
	?>
		<div <?php $this->print_render_attribute_string( 'main-menu' ); ?> data-width="<?php echo esc_attr( ( isset( $settings['menu_wrapper_width']['size'] ) && !empty( $settings['menu_wrapper_width']['size'] ) ) ? $settings['menu_wrapper_width']['size'] : $container_w['container_width']['size']  ) ?>">
		<?php if( $settings['layout'] === 'vertical_toggle' || $settings['layout'] === 'horizon_toggle' ){ ?>
			<button class="elementor-icon button-toggle-menu"><?php \Elementor\Icons_Manager::render_icon( $settings['toggle_icon_layout'], [ 'aria-hidden' => 'true' ] ); ?></button>
			<div class="menu-toggle-wrapper">
		<?php } ?>
		<?php if(  $settings['layout'] === 'vertical' ||  $settings['layout'] === 'vertical_toggle' ){ ?>
				<div class="mega-title">	
					<?php if( isset( $settings['menu_icon']['value'] ) && $settings['menu_icon']['value'] ) { ?>
					<span class="elementor-icon icon-before-title">
						<?php \Elementor\Icons_Manager::render_icon( $settings['menu_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</span>
					<?php } ?>
					
					<?php if( isset( $settings['menu_title'] ) && $settings['menu_title'] != '' ){ ?>
					<span class="menu-title"><?php echo wp_kses_post( $settings['menu_title'] ); ?></span>
					<?php } ?>
					
					<?php if( isset( $settings['menu_dropdown_icon']['value'] ) && $settings['menu_dropdown_icon']['value'] ) { ?>
					<span class="elementor-icon icon-after-title">
						<?php \Elementor\Icons_Manager::render_icon( $settings['menu_dropdown_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</span>
					<?php } ?>
				</div>
				<?php } ?>
			
				<?php 
					$this->render_menu_toggle( $settings );
				?>
				
				<div class="wrapper-menu <?php echo esc_attr( $layout ); ?>" data-number="<?php echo esc_attr( isset( $settings['vertical_menu_number'] ) ? $settings['vertical_menu_number']: 0 ); ?>" data-more_text="<?php echo esc_attr( isset( $settings['vertical_menu_more'] ) ? $settings['vertical_menu_more']: __( 'See More', 'sw_core' ) ); ?>" data-less_text="<?php echo esc_attr( isset( $settings['vertical_menu_less'] ) ? $settings['vertical_menu_less']: __( 'See Less', 'sw_core' ) ); ?>">
					<?php wp_nav_menu( array( 'menu' => $settings['menu'], 'menu_class' => 'swg-elementor-menu') ); ?>
					<div class="icon-dropdown hidden">
					<?php 
						if( isset( $settings['menu_icon_dropdown'] ) ){
							\Elementor\Icons_Manager::render_icon( $settings['menu_icon_dropdown'], [ 'aria-hidden' => 'true' ] ); 
						}else{
					?>
						<svg width="1em" height="1em" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M4.43057 8.51192C4.70014 8.19743 5.17361 8.161 5.48811 8.43057L12 14.0122L18.5119 8.43057C18.8264 8.16101 19.2999 8.19743 19.5695 8.51192C19.839 8.82642 19.8026 9.29989 19.4881 9.56946L12.4881 15.5695C12.2072 15.8102 11.7928 15.8102 11.5119 15.5695L4.51192 9.56946C4.19743 9.29989 4.161 8.82641 4.43057 8.51192Z"/>
						</svg>
					<?php }	?>
					</div>
				</div>
			<?php if( $settings['layout'] === 'vertical_toggle' || $settings['layout'] === 'horizon_toggle' ){ ?>
			</div>
			<?php } ?>
		</div>
	<?php 
	}
	
	private function render_menu_toggle( $settings ) {
		if ( ! isset( $settings['toggle'] ) || 'burger' !== $settings['toggle'] ) {
			return;
		}

		$this->add_render_attribute( 'menu-toggle', [
			'class' => 'swg-menu-toggle',
			'role' => 'button',
			'tabindex' => '0',
			'aria-label' => esc_html__( 'Menu Toggle', 'elementor-pro' ),
			'aria-expanded' => 'false',
		] );
		if ( ElementorPlugin::$instance->editor->is_edit_mode() ) {
			$this->add_render_attribute( 'menu-toggle', [
				'class' => 'elementor-clickable',
			] );
		}

		?>
		<div <?php $this->print_render_attribute_string( 'menu-toggle' ); ?>>
			<?php
			$toggle_icon_hover_animation = ! empty( $settings['toggle_icon_hover_animation'] )
			? ' elementor-animation-' . $settings['toggle_icon_hover_animation']
			: '';

			$open_class = 'swg-menu-toggle-icon-open' . $toggle_icon_hover_animation;
			$close_class = 'swg-menu-toggle-icon-close' . $toggle_icon_hover_animation;

			$normal_icon = ! empty( $settings['toggle_icon_normal']['value'] )
				? $settings['toggle_icon_normal']
				: [
					'library' => 'eicons',
					'value' => 'eicon-menu-bar',
				];

			$is_normal_icon_svg = 'svg' === $normal_icon['library'];

			if ( $is_normal_icon_svg ) {
				echo '<span class="' . esc_attr( $open_class ) . '">';
			}

			\Elementor\Icons_Manager::render_icon(
				$normal_icon,
				[
					'aria-hidden' => 'true',
					'role' => 'presentation',
					'class' => $open_class,
				]
			);

			if ( $is_normal_icon_svg ) {
				echo '</span>';
			}

			$active_icon = ! empty( $settings['toggle_icon_active']['value'] )
				? $settings['toggle_icon_active']
				: [
					'library' => 'eicons',
					'value' => 'eicon-close',
				];

			$is_active_icon_svg = 'svg' === $active_icon['library'];

			if ( $is_active_icon_svg ) {
				echo '<span class="' . esc_attr( $close_class ) . '">';
			}

			\Elementor\Icons_Manager::render_icon(
				$active_icon,
				[
					'aria-hidden' => 'true',
					'role' => 'presentation',
					'class' => $close_class,
				]
			);

			if ( $is_active_icon_svg ) {
				echo '</span>';
			}
			?>
			<span class="elementor-screen-only"><?php echo esc_html__( 'Menu', 'elementor-pro' ); ?></span>
		</div>
		<?php
	}	
}

ElementorPlugin::instance()->widgets_manager->register(new SWG_Menu_elementor());
?>