<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WC_Product_bundle extends WC_Product {
	public $product_type;
	public $price = 0;
	
	public function __construct( $product ) {
		$this->product_type = 'bundle';
		parent::__construct( $product );
	}
	
	/**
	 * Calculate and return the price for the bundle
	 *
	 * @return string [ price ]
	 *
	 */
	public function get_category() {
		 $bundles_product = apply_filters( 'swpb/load/bundle', $product );	
		   	if( count( $bundles_product ) > 0 ) { 
               	foreach ( $bundles_product as $key => $value ) { 
                    $this->category = $key;
               	}
		   	}
		   	return $this->category;
	}
	public function get_price_html($context = 'view') {
		$price = 0;
		
			/* Sale price has not been set,
			 * So here we are going to sum
			 **/
			global $product;
			$bundles = apply_filters( 'swpb/load/bundle', $this->id );
		    $tax_enable = get_option( 'woocommerce_tax_display_shop' );
		    $suffix = $this->get_price_suffix();
			
			$producttotal = wc_get_product( $this->id );
			if( is_array( $bundles ) ) {
				foreach ( $bundles as $key => $value ) {
					$quantity = isset( $value["quantity"] ) ? $value["quantity"] : 1;
					if( get_post_type( $key ) == 'product_variation' ){
						$bundle = new WC_Product_Variation( $key );
						if( $tax_enable  == "incl" ) {
							$price += wc_get_price_including_tax( $bundle, array( 'qty'   => $quantity, $value["price"] => $price ) );
						} else {
							$price += wc_get_price_excluding_tax( $bundle, array( 'qty'   => $quantity, $value["price"] => $price ) );
						}	
						
					}else{
						if( get_post_type( $key ) == 'product' ) {
							$bundle = new WC_Product( $key );					
							if( $tax_enable  == "incl" ) {
								$price +=  apply_filters( 'swpb_bundle_product_price', wc_get_price_including_tax($bundle,array('qty' =>  $quantity ) ), $bundle, $quantity );
							} else {
								$price += apply_filters( 'swpb_bundle_product_price', wc_get_price_excluding_tax( $bundle,array('qty' =>  $quantity ) ), $bundle, $quantity );
							}	
						}
					}
				}
			}
			$this->price = apply_filters( 'swpb_bundle_regular_price', $price, $this );
			$from = $this->price;

			$price = $this->get_regular_price();
			if( $tax_enable  == "incl" ) {
		        $to = wc_get_price_including_tax($producttotal);
	        }else {
	        	$to = wc_get_price_excluding_tax($producttotal);
	        }
			
			$html_price_return = '';
			if($to < $from){
				$html_price_return = '<del>'. ( ( is_numeric( $from ) ) ? wc_price( $from ) : $from ) .'</del> <ins>'.( ( is_numeric( $to ) ) ? wc_price( $to ) : $to ) .'</ins>'.$suffix;
			} else {
				$html_price_return = '<ins>'.( ( is_numeric( $to ) ) ? wc_price( $to ) : $to ) .'</ins>'.$suffix;
			}			
	       
	         return $html_price_return;
	         //return '<del>'. ( ( is_numeric( $from ) ) ? wc_price( $from ) : $from ) .'</del> <ins>'.( ( is_numeric( $to ) ) ? wc_price( $to ) : $to ) .'</ins>'.$suffix;
			
	}
	
	/**
	 * Returns the product weight - in this case sum of bundles items weight.
	 *
	 * @return decimal
	 */
	public function get_weight($context = 'view') {
		$weight = 0;		
		if( parent::get_weight() ) {
			$weight = parent::get_weight();
		} else {		
			$bundles =  json_decode( get_post_meta( $this->id, "swpb_bundle_products", true ), true );
			if( is_array( $bundles ) ) {
				foreach ( $bundles as $key => $value ) {
					$quantity = isset( $value["quantity"] ) ? $value["quantity"] : 1;
					$bundle = new WC_Product( $key );
					if( $bundle->has_weight() ) {
						$weight += ( floatval( $bundle->get_weight() ) * intval( $quantity ) );
					}				
				}
			}
		}		
		return $weight;
	}
	
	/**
	 * Returns whether or not the product has weight set.
	 *
	 * @return bool
	 */
	public function has_weight() {
		return $this->get_weight() ? true : false;
	}

}
