<?php
namespace WCPATH\SWG_Breadcrumb;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class SWG_Breadcrumb extends Widget_Base {

	public function get_name() {
		return 'swg-breadcrumb';
	}

	public function get_title() {
		return esc_html__( 'SWE Breadcrumb', 'sw_core' );
	}

	public function get_icon() {
		return 'eicon-product-breadcrumbs';
	}

	public function get_keywords() {
		return [ 'breadcrumb' ];
	}
	
	public function get_categories() {
		return [ 'sw-woo-elements', 'sw-post-elements' ];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'swg-countdown', 'swg-core' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_breadcrumb_style',
			[
				'label' => esc_html__( 'Breadcrumb', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'breadcrumb_typography',
				'selector' => '{{WRAPPER}} .breadcrumb > li',				
			]
		);
		
		$this->add_control(
			'breadcrumb_color',
			[
				'label' => esc_html__( 'Link Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb > li > a' => 'color: {{VALUE}};',
				],				
			]
		);
		
		$this->add_control(
			'breadcrumb_color_hover',
			[
				'label' => esc_html__( 'Link Color Hover', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb > li > a:hover' => 'color: {{VALUE}};',
				],				
			]
		);
		
		$this->add_control(
			'breadcrumb_color_separator',
			[
				'label' => esc_html__( 'Separator Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb > li:before' => 'color: {{VALUE}};',
				],				
			]
		);
		
		$this->add_control(
			'breadcrumb_color_active',
			[
				'label' => esc_html__( 'Color Active', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .breadcrumb > li > span' => 'color: {{VALUE}};',
				],				
			]
		);
		
		$this->add_responsive_control(
			'breadcrumb_spacing',
			[
				'label' => esc_html__( 'Spacing', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .breadcrumb > li:before' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}}',
				],				
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		$swg_breadcrumb = new \swg_Breadcrumbs();			
		return $swg_breadcrumb->breadcrumb();
	}
}
ElementorPlugin::instance()->widgets_manager->register(new SWG_Breadcrumb());
