<?php 
namespace WCSPATH\SWG_Search;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;

final class SWG_Search extends Widget_Base{
	
	function get_name() {
		return 'swg_search';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE Search', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-woo-elements' ];
	}
	
	public function get_script_depends() {
		return [ 'swg-woo-search-elementor' ];
	}
	
	public function get_icon() {
		return 'eicon-search';
	}
	
	public function register_controls() {
		$this->start_controls_section(
			'search_content',
			[
				'label' => esc_html__( 'Search Form', 'sw_core' ),
			]
		);		
		
		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'sw_core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__( 'Classic', 'sw_core' ),
					'2' => esc_html__( 'Popup', 'sw_core' ),
				],
				'prefix_class' => 'swg-responsive-search-layout-',	
			]
		);

		$this->add_control(
			'placeholder',
			[
				'label' => esc_html__( 'Placeholder', 'sw_core' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
				'default' => esc_html__( 'Search', 'sw_core' ) . '...',
				'dynamic' => [
					'active' => true,
				],
			]
		);
		
		$this->add_control(
			'heading_button_content',
			[
				'label' => esc_html__( 'Button', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);

		$this->add_control(
			'button_type',
			[
				'label' => esc_html__( 'Type', 'sw_core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
				'options' => [
					'icon' => esc_html__( 'Icon', 'sw_core' ),
					'text' => esc_html__( 'Text', 'sw_core' ),
				],
				'prefix_class' => 'elementor-search-form--button-type-',
				'render_type' => 'template',				
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Text', 'sw_core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Search', 'sw_core' ),
				'condition' => [
					'button_type' => 'text',					
				],
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'eicon-search',
						],						
					],
				],
				'default' => [
					'value' => 'fas fa-search',
					'library' => 'fa-solid',
				],
			]
		);		
		
		
		$this->add_control(
			'heading_config',
			[
				'label' => esc_html__( 'Avanced Configurations', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);		
		
		$this->add_control(
			'size',
			[
				'label' => esc_html__( 'Size', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'default' => [
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .search-wrapper' => 'min-height: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .elementor-search-form__submit' => 'min-width: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search, {{WRAPPER}} .swg-default-search .search-wrapper .category-selection, {{WRAPPER}}.elementor-search-form--button-type-text .elementor-search-form__submit' => 'padding-left: calc({{SIZE}}{{UNIT}} / 3); padding-right: calc({{SIZE}}{{UNIT}} / 3)',
				],				
				'separator' => 'before',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_search',
			array(
				'label' => __( 'Responsive Search Configurations', 'sw_core' ),
				'condition' => [
					'layout' => '1'
				]
			)
		);
		
		// TODO: For Pro 3.6.0, convert this to the breakpoints utility method introduced in core 3.5.0.
		$breakpoints = ElementorPlugin::$instance->breakpoints->get_active_breakpoints();
		$dropdown_options = [];
		$excluded_breakpoints = [
			'laptop',
			'widescreen',
		];
		
		
		foreach ( $breakpoints as $breakpoint_key => $breakpoint_instance ) {
			// Do not include laptop and widscreen in the options since this feature is for mobile devices.
			if ( in_array( $breakpoint_key, $excluded_breakpoints, true ) ) {
				continue;
			}

			$dropdown_options[ $breakpoint_key ] = sprintf(
				/* translators: 1: Breakpoint label, 2: `>` character, 3: Breakpoint value. */
				esc_html__( '%1$s (%2$s %3$dpx)', 'elementor-pro' ),
				$breakpoint_instance->get_label(),
				'>',
				$breakpoint_instance->get_value()
			);
		}
		

		$dropdown_options['none'] = esc_html__( 'None', 'elementor-pro' );

		$this->add_control(
			'search_breakpoint',
			[
				'label' => esc_html__( 'Breakpoint', 'elementor-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => $dropdown_options,
				'prefix_class' => 'swg-responsive-search-',					
			]
		);				
		
		$this->end_controls_section();		
		
		$this->start_controls_section(
			'search_content_popup',
			[
				'label' => esc_html__( 'Popup Config', 'sw_core' ),
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'name' => 'search_breakpoint',
							'operator' => '!==',
							'value' => 'none',
						],
						[
							'name' => 'layout',
							'operator' => '===',
							'value' => '2',
						],	
					]
				]
			]
		);	
		
		$this->add_responsive_control(
			'popup_width',
			[
				'label' => esc_html__( 'Content Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [			
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 2000,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .popup-search-wrapper' => 'width: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'toggle_icon_normal',
			[
				'label' => esc_html__( 'Icon', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'eicon-search',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
				],
				'recommended' => [
					'fa-solid' => [
						'plus-square',
						'plus',
						'plus-circle',
						'bars',
					],
					'fa-regular' => [
						'plus-square',
					],
				],
				'default' => [
					'value' => 'fas fa-search',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'toggle_icon_active',
			[
				'label' => esc_html__( 'Close Icon', 'elementor-pro' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'elementor-pro' ),
							'icon' => 'eicon-close',
						],
						'icon' => [
							'icon' => 'eicon-star',
						],
					],
				],
				'recommended' => [
					'fa-solid' => [
						'window-close',
						'times-circle',
						'times',
						'minus-square',
						'minus-circle',
						'minus',
					],
					'fa-regular' => [
						'window-close',
						'times-circle',
						'minus-square',
					],					
				],
				'default' => [
					'value' => 'fas fa-times',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'toggle_align',
			[
				'label' => esc_html__( 'Toggle Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'selectors_dictionary' => [
					'left' => 'margin-right: auto',
					'center' => 'margin: 0 auto',
					'right' => 'margin-left: auto',
				],
				'selectors' => [
					'{{WRAPPER}} .swg-menu-toggle' => '{{VALUE}}',
				],
				'separator' => 'before',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_input_style',
			[
				'label' => esc_html__( 'Input', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'input_order',
			[
				'label' => esc_html__( 'Order', 'sw_core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0',
				'options' => [
					'1' => 1,
					'2' => 2,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'order: {{VALUE}}',
				]
			]
		);
		
		$this->add_responsive_control(
			'input_width',
			[
				'label' => esc_html__( 'Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'width: {{SIZE}}{{UNIT}}',
				],
				'default' => [
					'unit' => '%',
					'size' => 85,
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'input_typography',
				'selector' => '{{WRAPPER}} .swg-default-search .search-wrapper .input-search',				
			]
		);

		$this->start_controls_tabs( 'tabs_input_colors' );

		$this->start_controls_tab(
			'tab_input_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'input_placeholder_color',
			[
				'label' => esc_html__( 'Placeholder Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search::placeholder' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'input_text_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'color: {{VALUE}}; fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'input_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'background-color: {{VALUE}}',
				]				
			]
		);

		$this->add_control(
			'input_border_color',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_input_focus',
			[
				'label' => esc_html__( 'Focus', 'sw_core' ),
			]
		);

		$this->add_control(
			'input_text_color_focus',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search:focus' => 'color: {{VALUE}}; fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'input_background_color_focus',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search:focus' => 'background-color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'input_border_color_focus',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search:focus' => 'border-color: {{VALUE}}',
				],
			]
		);	

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'input_border_width',
			[
				'label' => esc_html__( 'Border Width', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'input_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],				
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'input_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'input_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .search-wrapper .input-search' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__( 'Button', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		
		$this->add_control(
			'button_order',
			[
				'label' => esc_html__( 'Order', 'sw_core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0',
				'options' => [
					'1' => 1,
					'2' => 2,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .elementor-search-form__submit' => 'order: {{VALUE}}',
				]
			]
		);
		
		$this->add_responsive_control(
			'button_width',
			[
				'label' => esc_html__( 'Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-wrapper .elementor-search-form__submit' => 'width: {{SIZE}}{{UNIT}}',
				],
				'default' => [
					'unit' => '%',
					'size' => 15,
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .elementor-search-form__submit',
				'condition' => [
					'button_type' => 'text',
				]				
			]
		);

		$this->start_controls_tabs( 'tabs_button_colors' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit' => 'color: {{VALUE}}',
					'{{WRAPPER}} .elementor-search-form__submit svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'button_text_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .elementor-search-form__submit:hover svg' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .elementor-search-form__submit:focus' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .elementor-search-form__submit:focus' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit' => '--e-search-form-submit-icon-size: {{SIZE}}{{UNIT}}; font-size:{{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'button_type' => 'icon',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .elementor-search-form__submit' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .elementor-search-form__submit' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'button_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-search-form__submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .elementor-search-form__submit' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_toggle_style',
			[
				'label' => esc_html__( 'Popup Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'name' => 'search_breakpoint',
							'operator' => '!==',
							'value' => 'none',
						],
						[
							'name' => 'layout',
							'operator' => '===',
							'value' => '2',
						],	
					]
				]				
			]
		);
		
		$this->add_control(
			'popup_bg_overlay',
			[
				'label' => esc_html__( 'Background Overlay', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'heading_popup_content',
			[
				'label' => esc_html__( 'Content', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);		
		
		$this->add_responsive_control(
			'content_offset',
			[
				'label' => esc_html__( 'Offset Top', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .popup-search-wrapper' => 'top: {{SIZE}}{{UNIT}}',
				],				
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'popup_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}}.swg-responsive-search-layout-2 .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-tablet .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-mobile .popup-search .popup-search-wrapper' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'popup_border',
				'selector' => '{{WRAPPER}}.swg-responsive-search-layout-2 .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-tablet .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-mobile .popup-search .popup-search-wrapper',
			]
		);
		
		$this->add_responsive_control(
			'popup_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}}.swg-responsive-search-layout-2 .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-tablet .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-mobile .popup-search .popup-search-wrapper' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'popup_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}}.swg-responsive-search-layout-2 .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-tablet .popup-search .popup-search-wrapper,
					{{WRAPPER}}.swg-responsive-search-mobile .popup-search .popup-search-wrapper' => 'padding: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'heading_popup_toggle',
			[
				'label' => esc_html__( 'Toggle Icon', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'toggle_border',
				'selector' => '{{WRAPPER}} .swg-default-search .search-button-toggle',
			]
		);

		$this->start_controls_tabs( 'tabs_toggle_colors' );

		$this->start_controls_tab(
			'tab_toggle_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'toggle_color',
			[
				'label' => esc_html__( 'Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-default-search .search-button-toggle svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'toggle_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_toggle_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'toggle_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle:hover, {{WRAPPER}} .swg-default-search .search-button-toggle:focus' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-default-search .search-button-toggle:hover svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'toggle_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle:hover' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .swg-default-search .search-button-toggle:focus' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'toggle_border_color_hover',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle:hover' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swg-default-search .search-button-toggle:focus' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'toggle_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'font-size: {{SIZE}}{{UNIT}}',
				],				
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'toggle_width',
			[
				'label' => esc_html__( 'Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'min-width: calc( {{SIZE}} * {{size.SIZE}}{{size.UNIT}} )',
				],
			]
		);
		$this->add_responsive_control(
			'toggle_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .search-button-toggle' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'toggle_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .search-button-toggle' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'toggle_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .search-button-toggle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .search-button-toggle' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);	

		$this->add_control(
			'heading_popup_close',
			[
				'label' => esc_html__( 'Close Icon', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'close_icon_border',
				'selector' => '{{WRAPPER}} .swg-default-search .popup-search .search-close',
			]
		);

		$this->start_controls_tabs( 'tabs_close_icon_colors' );

		$this->start_controls_tab(
			'tab_close_icon_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);

		$this->add_control(
			'close_icon_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-default-search .popup-search .search-close svg' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'close_icon_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_close_icon_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);

		$this->add_control(
			'close_icon_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swg-default-search .popup-search .search-close:hover svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'close_icon_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'close_icon_border_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'close_icon_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'font-size: {{SIZE}}{{UNIT}}',
				],				
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'close_icon_width',
			[
				'label' => esc_html__( 'Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'min-width: calc( {{SIZE}} * {{size.SIZE}}{{size.UNIT}} )',
				],
			]
		);
		$this->add_responsive_control(
			'close_icon_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .popup-search .search-close' => 'border-radius: {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'close_icon_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-default-search .popup-search .search-close' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'close_icon_veritcal',
			[
				'label' => esc_html__( 'Vertical Offset', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'top: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'close_icon_horizontal',
			[
				'label' => esc_html__( 'Horizontal Offset', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swg-default-search .popup-search .search-close' => 'right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();		
	}
	
	
	protected function render() {
		wp_enqueue_style( 'swg-ajax-search' );
		$settings = $this->get_settings_for_display();		
		extract( $settings );
		$layout = ( isset( $settings['layout'] ) ) ? $settings['layout'] : '1';
	?>
	<div class="swg-default-search">
	<?php if( $layout == '2' || $search_breakpoint != 'none' ){ ?>
		<button data-type="toggle" class="elementor-icon search-button-toggle">
		<?php \Elementor\Icons_Manager::render_icon( $settings['toggle_icon_normal'], [ 'aria-hidden' => 'true' ] ); ?>
		</button>
		<div class="popup-search">
			<div class="popup-search-wrapper">
			<a href="#" class="elementor-icon search-close"><?php \Elementor\Icons_Manager::render_icon( $settings['toggle_icon_active'], [ 'aria-hidden' => 'true' ] ); ?></a>
	<?php }  ?>	
		<form method="POST" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
			<div class="search-wrapper">							
				<input class="input-search" type="search" value="<?php echo get_search_query(); ?>" size="50" autocomplete="off" placeholder="<?php echo esc_attr( $settings['placeholder'] ); ?>" name="s">	
					
				<button class="elementor-icon elementor-search-form__submit" type="submit" aria-label="<?php esc_attr_e( 'Search', 'sw_core' ); ?>">
					<?php if ( 'icon' === $settings['button_type'] ) : ?>
						<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						<span class="elementor-screen-only"><?php esc_html_e( 'Search', 'sw_core' ); ?></span>
					<?php elseif ( ! empty( $settings['button_text'] ) ) : ?>
						<?php $this->print_unescaped_setting( 'button_text' ); ?>
					<?php endif; ?>
				</button>				
			</div>		
		</form>
		<?php if( $layout == '2' || $search_breakpoint != 'none' ){ ?>
		</div>
		</div>
	<?php }  ?>	
	</div>
	<?php 
	}
	private function render_search_icon( $icon, $attributes = [] ) {
		// When the experiment is active and the search icon renders as SVG, it needs additional container for the icon box border.
		if ( Plugin::elementor()->experiments->is_feature_active( 'e_font_icon_svg' ) ) {
			$icon_html = \Elementor\Icons_Manager::render_font_icon( $icon, $attributes );

			Utils::print_unescaped_internal_string( sprintf( '<div class="e-font-icon-svg-container">%s</div>', $icon_html ) );
		} else {
			$migration_allowed = \Elementor\Icons_Manager::is_migration_allowed();

			if ( ! $migration_allowed || ! \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ) ) {
				Utils::print_unescaped_internal_string( sprintf( '<i %s aria-hidden="true"></i>', $this->get_render_attribute_string( 'icon' ) ) );
			}
		}
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SWG_Search());
?>