<?php 
namespace SWPATH\SW_Testimonial;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use ElementorPro\Plugin;

/**
 * SWE_Woo_Categories_Slider
 *
 * @author Youtech
 * @package SWE
 */

final class SWE_Testimonial_Element extends Widget_Base {
	/**
	 * @return string
	 */
	function get_name() {
		return 'swg-testimonial';
	}

	/**
	 * @return string
	 */
	function get_title() {
		return esc_html__('SWE Testimonial', 'sw_core');
	}

	/**
	 * @return array
	 */
	public function get_categories() {
		return [ 'sw-post-elements' ];
	}

	/**
	 * @return string
	 */
	function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_style_depends() {
		return ['slick'];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'slick', 'swwe-script' ];
	}
	
	public function get_orderby(){
		return array('name' => 'Name', 'author' => 'Author', 'date' => 'Date', 'title' => 'Title', 'modified' => 'Modified', 'parent' => 'Parent', 'ID' => 'ID', 'rand' =>'Rand', 'comment_count' => 'Comment Count');
	}

	/**
	 * Register controls
	 */
	public function register_controls() {

		/**
		* Content Settings
		*/
		$this->start_controls_section( 'content_settings', [
			'label' => __( 'Settings', 'sw_core' ),
			'tab' => Controls_Manager::TAB_CONTENT,
		]);
		
		$this->add_control( 'title', [
			'label' => esc_html__('Title', 'sw_core'),
			'type' => Controls_Manager::TEXT,
			'label_block' => true,
			'default'     => '',
		]);	
		
		$this->add_control( 'description', [
			'label' => esc_html__('Description', 'sw_core'),
			'type' => Controls_Manager::TEXT,
			'label_block' => true,
			'default'     => '',
		]);		
		
		$this->add_control( 'length', [
			'label' => esc_html__('Content Length', 'sw_core'),
			'type' => Controls_Manager::NUMBER,
			'label_block' => true,
			'default'     => 20,
		]);	
		
		$this->add_control( 'numberposts', [
			'label' => esc_html__('Number Posts', 'sw_core'),
			'type' => Controls_Manager::NUMBER,
			'label_block' => true,
			'default'     => 5,
		]);		
		
		$this->add_control( 'order', [
			'label' => __( 'Order', 'sw_core' ),
			'type' => Controls_Manager::SELECT,
			'options' => [
				'DESC' => __('DESC', 'sw_core'),
				'ASC' => __('ASC', 'sw_core')
			],
			'default' => 'DESC',
		]);
		
		$this->add_control( 'orderby', [
			'label' => __( 'Orderby', 'sw_core' ),
			'type' => Controls_Manager::SELECT,
			'options' => $this->get_orderby(),
			'default' => 'name',
		]);

		$this->add_control( 'show_image', [
			'label' => __( 'Show Image', 'sw_core' ),
			'description' => __('Display thumbnail of product Child category', 'sw_core'),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);		
		
		$this->add_group_control( Group_Control_Image_Size::get_type(), [
			'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
			'default' => 'full',
			'separator' => 'none',
		]);
		
		$this->add_control('layout_style', [
			'label' => __( 'Layout style', 'sw_core' ),
			'type' => Controls_Manager::SELECT,
			'options' => apply_filters( 'swg_testimonial_style_args', [
				'style-1' => __('Style 1', 'sw_core'),
			] ),
			'default' => 'style-1'
		]);
		
		$this->end_controls_section();
	
		/**
		* Slider Config
		*/
		$this->start_controls_section( 'slider_config', [
			'label' => __( 'Slider Config', 'sw_core' ),
			'tab' => Controls_Manager::TAB_CONTENT,
		]);
		
		$this->add_responsive_control( 'button_image', [
			'label' => __( 'Use Image Background', 'sw-woo-elements' ),
			'type' => Controls_Manager::SWITCHER,
			'description' => __( 'Use background image for button next and previous', 'sw-woo-elements' ),
			'label_on' => __( 'Show', 'sw-woo-elements' ),
			'label_off' => __( 'Hide', 'sw-woo-elements' ),
			'return_value' => 'yes',
			'default' => '',
		]);
		
		$this->add_control(
			'icon_left',
			[
				'label' => esc_html__( 'Icon Left', 'sw_core' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'sw_core' ),
							'icon' => 'eicon-arrow-left',
						],						
					],
				],
				'default' => [
					'value' => '',
				],
				'condition' => [
					'button_image!' => 'yes'
				]
			]
		);	
		
		$this->add_control(
			'icon_right',
			[
				'label' => esc_html__( 'Icon Right', 'sw_core' ),
				'type' => Controls_Manager::ICONS,
				'skin' => 'inline',
				'label_block' => false,
				'skin_settings' => [
					'inline' => [
						'none' => [
							'label' => esc_html__( 'Default', 'sw_core' ),
							'icon' => 'eicon-arrow-right',
						],						
					],
				],
				'default' => [
					'value' => '',
				],
				'condition' => [
					'button_image!' => 'yes'
				]
			]
		);	
		
		$this->add_control('bg_button_left', [
			'label' => __( 'Background Image Button Left', 'sw-woo-elements' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.prev-item' => 'background-image: url("{{URL}}");',
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.prev-item i, {{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.prev-item svg' => 'visibility: hidden;',
			],
			'render_type' => 'template',
			'condition' => [
				'button_image' => 'yes'
			]
		]);
		
		$this->add_control('bg_button_left_hover', [
			'label' => __( 'Background Image Button Left Hover', 'sw-woo-elements' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.prev-item:hover' => 'background-image: url("{{URL}}");',
			],
			'render_type' => 'template',
			'condition' => [
				'button_image' => 'yes'
			]
		]);
		
		$this->add_control('bg_button_right', [
			'label' => __( 'Background Image Button Right', 'sw-woo-elements' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.next-item' => 'background-image: url("{{URL}}");',
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.next-item i, {{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.next-item svg' => 'visibility: hidden;',
			],
			'render_type' => 'template',
			'condition' => [
				'button_image' => 'yes'
			]
		]);
		
		$this->add_control('bg_button_right_hover', [
			'label' => __( 'Background Image Button Right Hover', 'sw-woo-elements' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.next-item:hover' => 'background-image: url("{{URL}}");',
			],
			'has_sizes' => true,
			'render_type' => 'template',
			'condition' => [
				'button_image' => 'yes'
			]
		]);

		$this->add_control('slides_to_show', [
			'label' => __( 'Number of cols on Desktop', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 4,
			],
		]);
		
		$this->add_control('slides_to_show_tablet', [
			'label' => __( 'Number of cols on Tablet', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 3,
			],
		]);
		
		$this->add_control('slides_to_show_mobile', [
			'label' => __( 'Number of cols on Mobile', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 2,
			],
		]);

		$this->add_control('slides_to_rows', [
			'label' => __( 'Number of rows', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 5,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 1,
			],
		]);

		$this->add_control('slides_to_scroll', [
			'label' => __( 'Slides To Scroll', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 8,
				],
			],
			'default' => [
				'size' => 1
			]
		]);

		$this->add_responsive_control('slides_space', [
			'label' => __( 'Space Items', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 30,
			],
			'selectors' => [
				'{{WRAPPER}} .slick-slider .slick-list' => 'margin: 0 calc(-{{SIZE}}px/2);',
				'{{WRAPPER}} .slick-slider .slick-slide' => 'margin: 0 calc({{SIZE}}px/2);',
			],
		]);

		$this->add_responsive_control( 'arrows', [
			'label' => __( 'Arrows', 'sw_core' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);

		$this->add_responsive_control( 'dots', [
			'label' => __( 'Dots', 'sw_core' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);

		$this->add_control( 'pause_on_hover', [
			'label' => __( 'Pause On Hover', 'sw_core' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);

		$this->add_control( 'autoplay', [
			'label' => __( 'Autoplay', 'sw_core' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);

		$this->add_control('autoplay_speed', [
			'label' => __( 'Autoplay Speed', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
					'step' => 0.1,
				],
			],
			'default' => [
				'size' => 3
			]
		]);

		$this->add_control( 'infinite', [
			'label' => __( 'Loop', 'sw_core' ),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'sw_core' ),
			'label_off' => __( 'Hide', 'sw_core' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]);

		$this->add_control( 'lazyload', [
			'label' => __( 'Lazy Load', 'sw_core' ),
			'type' => Controls_Manager::SELECT,
			'options' => [
				'ondemand' => __('Ondemand', 'sw_core'),
				'progressive' => __('Progressive', 'sw_core')
			],
			'default' => 'progressive',
		]);

		$this->end_controls_section();	
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Item Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'content_border',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .item',
			]
		);		
		
		$this->add_responsive_control(
			'content_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item' => 'border-radius: {{SIZE}}{{UNIT}}',
				]				
			]
		);
		
		$this->start_controls_tabs( 'tabs_content_colors' );

		$this->start_controls_tab(
			'tab_content_normal',
			[
				'label' => esc_html__( 'Normal', 'sw_core' ),
			]
		);	

		$this->add_control(
			'content_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item' => 'background-color: {{VALUE}}',
				]				
			]
		);	

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_content_hover',
			[
				'label' => esc_html__( 'Hover', 'sw_core' ),
			]
		);	

		$this->add_control(
			'content_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item:hover' => 'background-color: {{VALUE}}',
				]				
			]
		);

		$this->add_control(
			'content_border_color_hover',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item:hover' => 'border-color: {{VALUE}}',
				],
			]
		);	

		$this->end_controls_tab();

		$this->end_controls_tabs();	
		
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_heading_style',
			[
				'label' => esc_html__( 'Heading', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);	
		
		$this->add_responsive_control(
			'heading_align',
			[
				'label' => esc_html__( 'Text Alignment', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sw_core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sw_core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sw_core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_heading',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .block-title',
			]
		);		

		$this->add_responsive_control(
			'heading_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title' => 'border-radius: {{SIZE}}{{UNIT}}',
				]				
			]
		);	

		$this->add_control(
			'heading_section',
			[
				'label' => esc_html__( 'Title', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before'		
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .block-title h3',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'heading_text_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title h3' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'heading_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title h3' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'heading_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .block-title h3' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'heading_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .block-title h3' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'heading_section_desc',
			[
				'label' => esc_html__( 'Description', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before'		
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography_desc',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .block-title p',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'heading_desc_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title p' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'heading_desc_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'heading_desc_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .block-title p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();	

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content Detail', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);		
		
		$this->add_control(
			'testimonial_content',
			[
				'label' => esc_html__( 'Testimonial content', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_responsive_control(
			'testimonial_content_align',
			[
				'label' => esc_html__( 'Text Alignment', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sw_core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sw_core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sw_core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'testimonial_typography',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .item .client-comment',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'testimonial_text_color',
			[
				'label' => esc_html__( 'Text Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'testimonial_background_color',
			[
				'label' => esc_html__( 'Background Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment:before' => 'border-top-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'testimonial_border',
			[
				'label' => esc_html__( 'Border', 'sw_core' ),
				'type' => Controls_Manager::SWITCHER				
			]
		);
		
		$this->add_control(
			'testimonial_border_style',
			[
				'label' => esc_html__( 'Style', 'sw_core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'None', 'sw_core' ),
					'solid' => _x( 'Solid', 'Border Control', 'sw_core' ),
					'double' => _x( 'Double', 'Border Control', 'sw_core' ),
					'dotted' => _x( 'Dotted', 'Border Control', 'sw_core' ),
					'dashed' => _x( 'Dashed', 'Border Control', 'sw_core' ),
					'groove' => _x( 'Groove', 'Border Control', 'sw_core' ),
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'border-style: {{VALUE}};',
				],
				'condition' => [
					'testimonial_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'testimonial_border_width',
			[
				'label' => esc_html__( 'Border Width', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'testimonial_border' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'testimonial_border_color',
			[
				'label' => esc_html__( 'Border Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'testimonial_border' => 'yes',
				]
			]
		);	

		$this->add_responsive_control(
			'testimonial_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'testimonial_border' => 'yes',
				],
			]
		);
		
		$this->add_responsive_control(
			'testimonial_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'testimonial_margin',
			[
				'label' => esc_html__( 'Margin', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item .client-comment' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'image_content',
			[
				'label' => esc_html__( 'Image', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .item .item-content img',
				'separator' => 'before',
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content img' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'image_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item .item-content img' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);
		$this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__( 'Width', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'default' => [
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content img' => 'width: {{SIZE}}{{UNIT}}',
				],	
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);
		
		$this->add_responsive_control(
			'image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'sw_core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content img' => 'margin-right: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item .item-content img' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0',
				],
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'author_testimonial',
			[
				'label' => esc_html__( 'Author Testimonial', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_testimonial_typography',
				'selector' => '{{WRAPPER}} .swg-testimonial-slider .item .item-content h4 > a'							
			]
		);	

		$this->add_control(
			'author_testimonial_text_color',
			[
				'label' => esc_html__( 'Author Heading Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content h4 > a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'author_testimonial_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content h4 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item .item-content h4 a' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',				
			]
		);
		
		$this->add_control(
			'author_info_testimonial',
			[
				'label' => esc_html__( 'Author Information', 'sw_core' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_info_typography',
				'selector' => '.swg-testimonial-slider .item .item-content .author-info',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'author_info_text_color',
			[
				'label' => esc_html__( 'Author Information Color', 'sw_core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content .author-info' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'author_info_padding',
			[
				'label' => esc_html__( 'Padding', 'sw_core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content .author-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'body.rtl {{WRAPPER}} .swg-testimonial-slider .item .item-content .author-info' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
				],
				'separator' => 'before',				
			]
		);
		
		$this->add_control(
			'author_align_heading',
			[
				'label' => '',
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_responsive_control(
			'author_align',
			[
				'label' => esc_html__( 'Text Alignment', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sw_core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sw_core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sw_core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'author_vertical_align',
			[
				'label' => esc_html__( 'Verical Alignment', 'sw_core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'top', 'sw_core' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Middle', 'sw_core' ),
						'icon' => 'eicon-v-align-middle',
					],
					'flex-end' => [
						'title' => esc_html__( 'Bottom', 'sw_core' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swg-testimonial-slider .item .item-content' => 'align-items: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();	
		
		/**
		* Style Arrows and dots
		*/
		$this->start_controls_section( 'section_style_arrows_and_dots', [
			'label' => __( 'Arrows & dots', 'sw_core' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]);

		$this->add_responsive_control(
			'button_align',
			[
				'label' => esc_html__( 'Button Align', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'top' => [
						'title' => esc_html__( 'Top', 'elementor-pro' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'elementor-pro' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'prefix_class' => 'swe-slider-button-align--',				
			]
		);
		
		$this->add_responsive_control(
			'button_position',
			[
				'label' => esc_html__( 'Button Position', 'elementor-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor-pro' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor-pro' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor-pro' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'swe-slider-button-position--',				
			]
		);		
		
		$this->add_responsive_control('button_offset_top', [
			'label' => __( 'Arrow Offset Top/ Bottom', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.swe-slider-button-align--top .swe-slider-wrapper .swe-slider-btn' => 'top: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.swe-slider-button-align--bottom .swe-slider-wrapper .swe-slider-btn' => 'bottom: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('button_offset_position_left', [
			'label' => __( 'Arrow Left Offset', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.swe-slider-button-position--left .swe-slider-wrapper .swe-slider-btn.prev-item' => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.swe-slider-button-position--right .swe-slider-wrapper .swe-slider-btn.prev-item' => 'right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'button_position' => ['left', 'right']
			],
		]);
		
		$this->add_responsive_control('button_offset_position_right', [
			'label' => __( 'Arrow Right Offset', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.swe-slider-button-position--left .swe-slider-wrapper .swe-slider-btn.next-item' => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.swe-slider-button-position--right .swe-slider-wrapper .swe-slider-btn.next-item' => 'right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'button_position' => ['left', 'right']
			],
		]);

		$this->add_control( 'section_style_arrows', [
			'label' => __( 'Arrows', 'sw-woo-elements' ),
			'type' => Controls_Manager::HEADING,
		]);

		$this->add_responsive_control('slider_arrows_space', [
			'label' => __( 'Space', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -100,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.prev-item' => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn.next-item' => 'right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'button_position!' => ['left', 'right']
			],
		]);

		$this->add_responsive_control('slider_arrows_block', [
			'label' => __( 'Width', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn' => 'width: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('slider_arrows_block_h', [
			'label' => __( 'Height', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control('slider_arrows_size', [
			'label' => __( 'Size', 'sw-woo-elements' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn' => 'font-size: {{SIZE}}{{UNIT}}; background-size: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'arrow_border',
				'selector' => '{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn',
			]
		);
		
		
		$this->start_controls_tabs( 'slider_arrows_tabs' );

		$this->start_controls_tab( 'slider_arrows_normal', [
			'label' => __( 'Normal', 'sw_core' ),
		]);

		$this->add_control( 'slider_arrows_color', [
			'label' => __( 'Color', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn' => 'color: {{VALUE}};',
			],
		]);

		$this->add_control( 'slider_arrows_bg', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn' => 'background-color: {{VALUE}};',
			],
		]);

		$this->end_controls_tab();

		$this->start_controls_tab( 'slider_arrows_hover', [
			'label' => __( 'Hover', 'sw_core' ),
		]);

		$this->add_control( 'slider_arrows_color_hover', [
			'label' => __( 'Color', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn:hover' => 'fill: {{VALUE}};',
			],
		]);

		$this->add_control( 'slider_arrows_bg_hover', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn:hover' => 'background-color: {{VALUE}};',
			],
		]);
		
		$this->add_control( 'slider_arrows_border_hover', [
			'label' => __( 'Border Color', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn:hover' => 'border-color: {{VALUE}};',
			],
		]);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control('slider_arrows_border_radius', [
			'label' => __( 'Border radius', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .swe-slider-wrapper .swe-slider-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_control( 'section_style_dots', [
			'label' => __( 'Dots', 'sw_core' ),
			'type' => Controls_Manager::HEADING,
			'separator' => 'before',
		]);

		$this->add_responsive_control('slider_dots_space', [
			'label' => __( 'Space', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots' => 'margin-top: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->start_controls_tabs( 'slider_dots_tabs' );

		$this->start_controls_tab( 'slider_dots_normal', [
			'label' => __( 'Normal', 'sw_core' ),
		]);

		$this->add_control( 'slider_dots_bg', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .slick-dots li' => 'background-color: {{VALUE}};',
			],
		]);

		$this->add_responsive_control('slider_dots_block', [
			'label' => __( 'Block', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots li' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->end_controls_tab();

		$this->start_controls_tab( 'slider_dots_hover', [
			'label' => __( 'Hover & Active', 'sw_core' ),
		]);

		$this->add_control( 'slider_dots_bg_hover', [
			'label' => __( 'Background', 'sw_core' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .slick-dots li:hover, {{WRAPPER}} .slick-dots li.slick-active' => 'background-color: {{VALUE}};',
			],
		]);
		
		$this->add_responsive_control('slider_dots_active_width', [
			'label' => __( 'Width active', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 20,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots li.slick-active' => 'width: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control('slider_dots_border_radius', [
			'label' => __( 'Border radius', 'sw_core' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots li' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->end_controls_section();	
	}

	/**
	 * Render
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$id_int = substr( $this->get_id_int(), 0, 3 );
		$settings['id_int'] = $id_int;
		
		$button_prev = !empty( \Elementor\Icons_Manager::try_get_icon_html( $settings['icon_left'], [ 'aria-hidden' => 'true' ] ) ) ? '<button class="swe-slider-btn prev-item">'. \Elementor\Icons_Manager::try_get_icon_html( $settings['icon_left'], [ 'aria-hidden' => 'true' ] ) . '</button>' : apply_filters( 'swe_button_prev_slider', '<button class="swe-slider-btn prev-item"><i class="fas fa-chevron-left"></i></button>' );
		$button_next = !empty( \Elementor\Icons_Manager::try_get_icon_html( $settings['icon_right'], [ 'aria-hidden' => 'true' ] ) ) ? '<button class="swe-slider-btn next-item">'. \Elementor\Icons_Manager::try_get_icon_html( $settings['icon_right'], [ 'aria-hidden' => 'true' ] ). '</button>' : apply_filters( 'swe_button_next_slider', '<button class="swe-slider-btn next-item"><i class="fas fa-chevron-right"></i></button>' );
		
		$this->add_render_attribute( 'slider_options', [
			'data-slides_to_show'   => $settings[ 'slides_to_show' ] ? $settings[ 'slides_to_show' ]['size'] : 3,
			'data-slides_to_show_tablet'   => isset($settings[ 'slides_to_show_tablet' ]) ? $settings[ 'slides_to_show_tablet' ]['size'] : 2,
			'data-slides_to_show_mobile'   => isset($settings[ 'slides_to_show_mobile' ]) ? $settings[ 'slides_to_show_mobile' ]['size'] : 1,

			'data-slides_to_rows'   => $settings[ 'slides_to_rows' ] ? $settings[ 'slides_to_rows' ]['size'] : 1,

			'data-slides_to_scroll'   => $settings[ 'slides_to_scroll' ] ? $settings[ 'slides_to_scroll' ]['size'] : 1,

			'data-arrows' =>  isset( $settings[ 'arrows' ] ) ? $settings[ 'arrows' ] : 1,
			'data-arrows_tablet' =>  isset( $settings[ 'arrows_tablet' ] ) ? $settings[ 'arrows_tablet' ]: 1,
			'data-arrows_mobile' =>  isset( $settings[ 'arrows_mobile' ] ) ? $settings[ 'arrows_mobile' ] : 1,

			'data-dots'   =>  isset( $settings[ 'dots' ] ) ? $settings[ 'dots' ] : 0,
			'data-dots_tablet'   =>  isset( $settings[ 'dots_tablet' ] ) ? $settings[ 'dots_tablet' ] : 0,
			'data-dots_mobile'   =>  isset( $settings[ 'dots_mobile' ] ) ? $settings[ 'dots_mobile' ] : 0,

			'data-pause_on_hover'   => $settings[ 'pause_on_hover' ],
			'data-autoplay'   => $settings[ 'autoplay' ],
			'data-autoplay_speed'   => $settings[ 'autoplay_speed' ] ? $settings[ 'autoplay_speed' ]['size'] : 3,
			'data-infinite'   => $settings[ 'infinite' ],
			'data-lazyload' => $settings['lazyload'],
			'data-prev' => $button_prev,
			'data-next' => $button_next,
		]);

		$settings['slider_options'] = $this->get_render_attribute_string('slider_options');
		
		$default = array(
			'post_type' => 'testimonial',
			'orderby' =>  $settings['orderby'],
			'order' =>  $settings['order'],
			'post_status' => 'publish',
			'showposts' =>  $settings['numberposts']
		);
		$list = new \WP_Query( $default );
		if ( $list -> have_posts() ){			
			include( sw_core_override_check( 'elementor', 'testimonial-layout' ) );
		}
	}
}

ElementorPlugin::instance()->widgets_manager->register(new SWE_Testimonial_Element());