<?php
namespace WCPATH\SWG_Title;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Utils;
use Elementor\Plugin as ElementorPlugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class SWG_Title extends Widget_Base {

	public function get_name() {
		return 'swg-title';
	}

	public function get_title() {
		return esc_html__( 'SWE Title', 'sw_core' );
	}

	public function get_icon() {
		return 'eicon-archive-title';
	}

	public function get_keywords() {
		return [ 'title' ];
	}
	
	public function get_categories() {
		return [ 'sw-woo-elements', 'sw-post-elements' ];
	}

	/**
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'swg-countdown', 'swg-core' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'sw_core' ),				
			]
		);
		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'div' => 'div',
					'span' => 'span',
					'p' => 'p',
				],
				'default' => 'h2',
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Style', 'sw_core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);			
		
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'elementor' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .swe-heading-title',				
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .swe-heading-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Text_Stroke::get_type(),
			[
				'name' => 'text_stroke',
				'selector' => '{{WRAPPER}} .swe-heading-title',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_shadow',
				'selector' => '{{WRAPPER}} .swe-heading-title',
			]
		);

		$this->add_control(
			'blend_mode',
			[
				'label' => esc_html__( 'Blend Mode', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Normal', 'elementor' ),
					'multiply' => esc_html__( 'Multiply', 'elementor' ),
					'screen' => esc_html__( 'Screen', 'elementor' ),
					'overlay' => esc_html__( 'Overlay', 'elementor' ),
					'darken' => esc_html__( 'Darken', 'elementor' ),
					'lighten' => esc_html__( 'Lighten', 'elementor' ),
					'color-dodge' => esc_html__( 'Color Dodge', 'elementor' ),
					'saturation' => esc_html__( 'Saturation', 'elementor' ),
					'color' => esc_html__( 'Color', 'elementor' ),
					'difference' => esc_html__( 'Difference', 'elementor' ),
					'exclusion' => esc_html__( 'Exclusion', 'elementor' ),
					'hue' => esc_html__( 'Hue', 'elementor' ),
					'luminosity' => esc_html__( 'Luminosity', 'elementor' ),
				],
				'selectors' => [
					'{{WRAPPER}} .swe-heading-title' => 'mix-blend-mode: {{VALUE}}',
				],
			]
		);		

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		ob_start();
		if ( is_archive() ) {
			$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var('taxonomy') );
			if ($term) {
				echo esc_html( $term->name );
			} elseif ( is_post_type_archive() ) {
				echo get_queried_object()->labels->name;
			} 
		} elseif( is_single() ){
			$post_type = get_post_type( get_the_ID() );
			if( $post_type == 'post' ){
				$category = get_the_category();
				echo esc_html( $category[0]->name );
			}else{
				the_title();
			}
		}elseif( is_page() ){
			the_title();
		}
		$content = ob_get_clean();
		echo '<' . $settings['header_size']. ' class="swe-heading-title">' . $content . '</'. $settings['header_size'] .'>';		
	}
}
ElementorPlugin::instance()->widgets_manager->register( new SWG_Title() );
