<?php 
	$swgWrap = 'swg-ourteam-slider swe-wrapper';
	if ($settings['layout_style']) {
		$swgWrap .= ' ' . $settings['layout_style'];
	}
?>
	<div class="<?php echo esc_attr($swgWrap); ?>">
		<?php if( $settings['title'] != '' ){?>
		<div class="block-title">
			<h3><?php echo esc_html( $settings['title'] ) ?></h3>
			<?php if($settings['description'] != '' ){ ?><p><?php echo esc_html( $settings['description'] ); ?></p> <?php } ?>
		</div>
		<?php } ?>
		<div class="swe-slider-wrapper">
			<div class="swe-slider swg-ourteam-slider" <?php echo $settings['slider_options']; ?>>
			<?php
				$count_items = ($settings['numberposts'] >= $list->found_posts) ? $list->found_posts : $settings['numberposts'];
				while($list->have_posts()): $list->the_post();
				global  $post;
				$facebook = get_post_meta( $post->ID, 'facebook', true );	
				$twitter = get_post_meta( $post->ID, 'twitter', true );
				$pint = get_post_meta( $post->ID, 'pint', true );
				$linkedin = get_post_meta( $post->ID, 'linkedin', true );
				$insta = get_post_meta( $post->ID, 'insta', true );
				$team_info = get_post_meta( $post->ID, 'team_info', true );
			?>
				<div class="item">
					<?php if( has_post_thumbnail() && $settings['show_image'] === 'yes' ){ ?>
						<div class="item-img item-height">
							<div class="item-img-info">				
								<?php the_post_thumbnail( $settings['image_size'] ); ?>						
							</div>
						</div>
					<?php } ?>			
					<div class="item-content">
						<h4><?php the_title(); ?></h4>
						<?php if( $team_info != '' ){ ?>
						<div class="team-info"><?php echo esc_html( $team_info ); ?></div>
						<?php } ?>
						<div class="team-desc"><?php echo wp_trim_words( get_the_excerpt(), $settings['length'] ); ?></div>
						<ul class="social">
							<?php if( $facebook != '' ){ ?>
								<li><a href="<?php echo esc_url( $facebook ); ?>"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
							<?php } ?>
							<?php if( $twitter != '' ){ ?>
								<li><a href="<?php echo esc_url( $twitter ); ?>"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>
							<?php } ?>
							<?php if( $linkedin != '' ){ ?>
								<li><a href="<?php echo esc_url( $linkedin ); ?>"><i class="fab fa-instagram" aria-hidden="true"></i></a></li>
							<?php } ?>
							<?php if( $pint != '' ){ ?>
								<li><a href="<?php echo esc_url( $pint ); ?>"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a></li>
							<?php } ?>
							<?php if( $insta != '' ){ ?>
								<li><a href="<?php echo esc_url( $insta ); ?>"><i class="fab fa-instagram" aria-hidden="true"></i></a></li>
							<?php } ?>
						</ul>
					</div>				
				</div>
			<?php endwhile; wp_reset_query();?>
			</div>
		</div>
	</div>