<?php 	
$widget_id = isset( $widget_id ) ? $widget_id : 'category_slide_'.$this->generateID();
$viewall = get_permalink( wc_get_page_id( 'shop' ) );
if( $category == '' ){
	return '<div class="alert alert-warning alert-dismissible" role="alert">
	<a class="close" data-dismiss="alert">&times;</a>
	<p>'. esc_html__( 'Please select a category for SW Woocommerce Category Slider. Layout ', 'sw-woocommerce' ) . $layout .'</p>
</div>';
}
$nav_id = 'nav_tabs_res'.rand().time();
?>
<div class="sw-woo-tab-cat26" id="<?php echo esc_attr( 'category_' . $widget_id ); ?>" >
	<div class="resp-tab" style="position:relative;">
			<ul class="nav nav-tabs" id="<?php echo esc_attr( $nav_id ); ?>" role="tablist">
				<?php
				$i = 0;
				if( !is_array( $category ) ){
					$category = explode( ',', $category );
				}
				foreach( $category as $cat ){
					$term = get_term_by('slug', $cat, 'product_cat');	
					if( $term ) :
						$thumbnail_id1 	= get_term_meta( $term->term_id, 'thumbnail_id1', true );
						$thumb = wp_get_attachment_image( $thumbnail_id1,'full', "", array( 'alt' => $term->name ) );
					?>
					<li class="<?php echo ( $i == 1 ) ? 'active' : ''; ?>">
						<a href="#<?php echo esc_attr( $cat.'_' .$widget_id )?>" data-toggle="tab"><?php sw_trim_words( $term->name, $title_length ); ?></a>
					</li>
					
				<?php endif; ?>
				<?php $i++; } ?>
			</ul>
			<div class="tab-content clearfix">
					<?php
						$i = 0;
						if( !is_array( $category ) ){
							$category = explode( ',', $category );
						}
						foreach( $category as $cat ){
							$term = get_term_by('slug', $cat, 'product_cat');	
					?>
					<div class="tab-pane <?php echo ( $i == 1 ) ? 'active' : ''; ?>" id="<?php echo esc_attr( $cat.'_' .$widget_id )?>">
						<!-- Get child category -->
									<?php
									$termchildren = get_terms('product_cat',array('child_of' => $term->term_id));
										if( count( $termchildren ) > 0 ){
										?>
											<?php 
										$termchildren = get_terms('product_cat',array('child_of' => $term->term_id));
										?>
											<div id="<?php echo esc_attr( 'tab_cat__' .$widget_id ); ?>" class="responsive-slider loading clearfix" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
												<div class="resp-slider-container">
													<div class="slider responsive">
														<?php $j = 1;
														foreach ( $termchildren as $child ) {
																$thumbnail_id1 	= get_term_meta( $child->term_id, 'thumbnail_id', true );
																$thumb = wp_get_attachment_image( $thumbnail_id1,'full', "", array( 'alt' => $term->name ) );
																?>
																<div class="item item-product-cat">
																	<div class="item-wrap">
																		<div class="item-image">
																			<a href="<?php echo get_term_link( $child, 'product_cat' ); ?>" title="<?php echo esc_attr( $child->name ); ?>"><?php echo $thumb; ?></a>
																		</div>
																		<div class="item-content">
																			<div class="wrap-content">
																				<h3><a href="<?php echo get_term_link( $child, 'product_cat' ); ?>"><?php sw_trim_words( $child->name, $title_length ); ?></a></h3>
																				<div class="desciption"><?php echo  $child->description; ?></div>
																				<a href="<?php echo get_term_link( $child, 'product_cat' ); ?>"><?php echo esc_html__( 'Read More', 'sw-woocommerce' ) ?></a>
																			</div>
																		</div>
																	</div>
																</div>
														<?php }?>
													</div>
												</div>
											</div>
									<?php } ?>
						</div>
					<?php $i++; }?>
			</div>
	</div>
</div>	