<?php 

/**
	* Layout Tab Category Default
	* @version     1.0.0
**/

	$tag_id = 'sw_woo_rplisting_'. rand().time();
	$nav_id = 'nav_tabs_res'.rand().time();
	
?>
<div class="sw-woo-tab-listing style2" id="<?php echo esc_attr( $tag_id ); ?>" >
		<?php if( $title1 != '' ){ ?>
			<div class="box-title"><h3><?php echo  $title1; ?></h3></div>
		<?php } ?>
		<div class="tab-listing-container row">
			<?php
				$default = array(
					'post_type' => 'product',		
					'post_status' => 'publish',
					'showposts' => $numberposts,
					'ignore_sticky_posts'   => 1,
					'meta_key' 		 		=> 'total_sales',
					'orderby' 		 		=> 'meta_value_num '. $orderby ,
					'order' => $order,
					);
				if( $category != '' ){
					$default['tax_query'] = array(
						array(
							'taxonomy'  => 'product_cat',
							'field'     => 'slug',
							'terms'     => $category ),
							'operator' => 'IN'
						);	
				}
				$default = sw_check_product_visiblity( $default );
				
				$attribute = '';
				$col1 = 12 / $columns;
				$col2 = 12 / $columns1;
				$col3	= 12 / $columns2;
				$col4	= 12 / $columns3;
				$attribute .= 'item item-listing product col-lg-'.$col1.' col-md-'.$col2.' col-sm-'.$col3.' col-xs-'.$col4.' clearfix';
				$list = new WP_Query( $default );
				$max_page = $list -> max_num_pages;
				if( $list->have_posts() ) : 			 
					while($list->have_posts()): $list->the_post();
					global $product, $post;
					
					$terms_id = get_the_terms( $post->ID, 'product_cat' );
					$term_str = '';
					
					foreach( $terms_id as $key => $value ) :
						$term_str .= '<a href="'. get_term_link( $value->term_id, 'product_cat' ) .'">'. esc_html( $value->name ) .'</a>';
					endforeach;
					
					$attribute .= ( $product->get_price_html() ) ? '' : ' item-nonprice';
				?>
					<div class="<?php echo esc_attr( $attribute ); ?>">
						<div class="item-wrap18">
							<div class="item-detail">										
								<div class="item-img products-thumb">			
									<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
									<div class="item-button">
										<?php
										if ( class_exists( 'YITH_WCWL' ) ){
										echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
										} ?>
										<?php if ( class_exists( 'YITH_WOOCOMPARE' ) ){ 
										?>
										<a href="javascript:void(0)" class="compare button"  title="<?php esc_html_e( 'Add to Compare', 'sw-woocommerce' ) ?>" data-product_id="<?php echo esc_attr($post->ID); ?>" rel="nofollow"> <?php esc_html('compare','sw-woocomerce'); ?></a>
										<?php } ?>
										<?php echo emarket_quickview(); ?>
									</div>
									<?php woocommerce_template_loop_add_to_cart(); ?>
								</div>										
								<div class="item-content">	
									<div class="categories-name">
										<?php echo  $term_str; ?>
									</div>			
									<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php sw_trim_words( get_the_title(), $title_length ); ?></a></h4>
									<!-- rating  -->
									<?php 
									$rating_count = $product->get_rating_count();
									$review_count = $product->get_review_count();
									$average      = $product->get_average_rating();
									?>
									<?php if (  wc_review_ratings_enabled() ) { ?>
									<div class="reviews-content">
										<div class="star"><?php echo ( $average > 0 ) ?'<span style="width:'. ( $average*16 ).'px"></span>' : ''; ?></div>
									</div>
									<?php } ?>
									<!-- end rating  -->
									
									<!-- price -->
									<?php if ( $price_html = $product->get_price_html() ){?>
									<div class="item-price">
										<span>
											<?php echo $price_html; ?>
										</span>
									</div>
									<?php } ?>
									<?php do_action( 'sw_woocommerce_custom_action' ); ?>
								</div>								
							</div>
						</div>
					</div>
							<?php endwhile; wp_reset_postdata();?>
					<div class="item item-listing item-more">
						<a href="javascript:void(0)" data-ajaxurl="<?php echo esc_url( sw_ajax_url() ) ?>" data-layout="<?php echo esc_attr( isset( $widget_template ) ? $widget_template : $layout );?>" data-maxpage="<?php echo esc_attr( $max_page ) ?>" data-attributes="<?php echo esc_attr( $attribute ) ?>" data-number="<?php echo esc_attr( $numberposts ) ?>" data-orderby="<?php echo esc_attr( $orderby ) ?>" data-order="<?php echo esc_attr( $order ) ?>" data-category="<?php echo esc_attr( $category ) ?>" data-label-loaded="<?php esc_attr_e( 'All Item', 'sw-woocommerce' ); ?>" data-label="<?php esc_html_e( 'Load More', 'sw-woocommerce' ); ?>"></a>
					</div>
				<?php 
					else :
						esc_html_e( 'There is no product on this category', 'sw-woocommerce' );
					endif;
				?>			
		</div>
	</div>
