<?php 

/**
	* Layout Theme 15 Ajax
	* @version     1.0.0
**/
?>
<div id="<?php echo esc_attr( 'tab_'. str_replace( '%', '', $target ) ); ?>" class="woo-tab-container-slider responsive-slider" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
	<div class="resp-slider-container">
		<div class="slider responsive">
		<?php 
			$count_items 	= 0;
			$numb 			= ( $list->found_posts > 0 ) ? $list->found_posts : count( $list->posts );
			$count_items 	= ( $numberposts >= $numb ) ? $numb : $numberposts;
			$i 				= 0;
			$j				= 0;
			while($list->have_posts()): $list->the_post();
			global $product, $post;	
			$terms_id = get_the_terms( $post->ID, 'product_cat' );
			$term_str = '';
			
			foreach( $terms_id as $key => $value ) :
				$term_str .= '<a href="'. get_term_link( $value->term_id, 'product_cat' ) .'">'. esc_html( $value->name ) .'</a>';
			endforeach;
			$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
		?>
			<div class="item <?php echo esc_attr( $class )?> product clearfix">
				<div class="item-wrap">
					<div class="item-detail">										
						<div class="item-img products-thumb">
							<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
							<?php emarket_product_item_bottom();?>
						</div>									
						<div class="item-content">	
							<?php emarket_template_loop_product_title(); ?>	
							<?php emarket_template_rating_custom(); ?>								
							<?php woocommerce_template_loop_price(); ?>	
							<?php
								$userid = (int)$post->post_author;
								$user =  get_userdata( $userid );
								
								if( class_exists( 'WC_Vendors' ) && in_array('vendor', $user->roles) ):
							?>
								<a class="shop-user" href="<?php echo esc_url( WCV_Vendors::get_vendor_shop_page( $user->ID ) ); ?>"><?php echo $user->display_name; ?></a>
								
							<?php elseif( class_exists( 'WeDevs_Dokan' ) && in_array('seller', $user->roles) ):
								$store_url  = dokan_get_store_url( $userid );
							?>
								<a class="shop-user" href="<?php echo esc_url( $store_url ); ?>"><?php echo $user->display_name; ?></a>
								
							<?php elseif( class_exists('WCMp') && in_array('dc_vendor', $user->roles) ):
								global $WCMp;
								$vendor = get_wcmp_vendor( $userid );
							?>
								<a class="shop-user" href="<?php echo esc_url( $vendor->get_permalink() ); ?>"><?php echo $vendor->page_title ?></a>
								
							<?php elseif( class_exists('WCFMmp') && in_array('wcfm_vendor', $user->roles) ):
								global $WCFMmp;
								$store_user      = wcfmmp_get_store( $userid );
								$store_url       = wcfmmp_get_store_url( $userid );
								$store_name      = wcfm_get_vendor_store_name( $userid );
								$gravatar        = $store_user->get_avatar();
							?>
								<a class="shop-user" href="<?php echo esc_url( $store_url ); ?>"><img width="20" src="<?php echo esc_url( $gravatar ) ?>" /><?php echo $store_name; ?></a>	
							
							<?php endif; ?>	
						</div>
					</div>
				</div>
			</div>
		<?php $i++; $j++; endwhile; wp_reset_postdata();?>
		</div>
	</div>
</div>