<?php 
/**
 * Plugin Name: Sw Woocommerce Swatches
 * Plugin URI: http://www.smartaddons.com/
 * Description: A plugin help to display woocommerce beauty.
 * Version: 1.2.7
 * Author: SmartAddons
 * Author URI: http://www.smartaddons.com/
 * Requires at least: 4.1
 * Tested up to: WorPress 6.7.x and WooCommerce 9.5.x
 * WC tested up to: 9.5
 * Text Domain: sw_wooswatches
 * Domain Path: /languages/
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// define plugin path
if ( ! defined( 'WSPATH' ) ) {
	define( 'WSPATH', plugin_dir_path( __FILE__ ) );
}

// define plugin URL
if ( ! defined( 'WSURL' ) ) {
	define( 'WSURL', plugins_url(). '/sw_wooswatches' );
}

// define plugin theme path
if ( ! defined( 'WSTHEME' ) ) {
	define( 'WSTHEME', plugin_dir_path( __FILE__ ). 'includes/themes' );
}

function sw_wooswatches_construct(){
	global $woocommerce;

	if ( ! isset( $woocommerce ) || ! function_exists( 'WC' ) ) {
		add_action( 'admin_notices', 'sw_wooswatches_admin_notice' );
		return;
	}
	
	add_action( 'before_woocommerce_init', 'sw_wooswatches_hpos_compatible_init' );

	/* Enqueue Script */
	add_action( 'wp_enqueue_scripts', 'sw_wooswatches_custom_script', 1001 );
	
	/* Load text domain */
	load_plugin_textdomain( 'sw_wooswatches', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
	
	/* Include files */
	require_once( WSPATH . '/admin/admin-settings.php' );
	require_once( WSPATH . '/admin/admin-attribute-metabox.php' );
	require_once( WSPATH . '/includes/product-variation.php' );
	require_once( WSPATH . '/includes/custom-filter/class-wc-widget-layered-nav.php' );
	require_once( WSPATH . '/includes/inc.php' );
}

add_action( 'plugins_loaded', 'sw_wooswatches_construct', 20 );

function sw_wooswatches_hpos_compatible_init(){
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        }
}

/*
** Load admin notice when WooCommerce not active
*/
function sw_wooswatches_admin_notice(){
	?>
	<div class="error">
		<p><?php _e( 'Sw WooSwatches is enabled but not effective. It requires WooCommerce in order to work.', 'sw_wooswatches' ); ?></p>
	</div>
<?php
}

/*
** Load Custom variation script
*/
function sw_wooswatches_custom_script(){	
	if( current_theme_supports( 'sw_theme' ) || get_option( 'sw_wooswatches_enable' ) === 'yes' ) :
		wp_dequeue_script('wc-add-to-cart-variation');	
		wp_deregister_script('wc-add-to-cart-variation');
		$w_folder = ( ! current_theme_supports( 'sw_theme' ) ) ? 'woocommerce' : 'woocommerce/custom';
		if( get_option( 'sw_wooswatches_enable' ) === 'no' ){
			$w_folder = 'woocommerce-select';
		}
		if( current_theme_supports( 'sw_theme' ) ):
			wp_register_script( 'wc-add-to-cart-variation', WSURL . '/js/woocommerce/custom/add-to-cart-variation.js', array( 'jquery', 'wp-util' ),null, true  );
		else:
			wp_register_script( 'wc-add-to-cart-variation', plugins_url( 'assets/js/frontend/add-to-cart-variation.min.js', WC_PLUGIN_FILE ), array( 'jquery', 'wp-util', 'jquery-blockui' ), null, true );
		endif;
		
		wp_enqueue_style( 'sw-wooswatches', plugins_url( 'css/style.css', __FILE__ ), array(), null );			
		if( is_singular( 'product' ) ) :
			wp_enqueue_script( 'wc-add-to-cart-variation-custom', WSURL . '/js/woocommerce/custom/add-to-cart-variation.min.js', array( 'jquery', 'wp-util' ),null, true  );
			wp_enqueue_script( 'wc-add-to-cart-variation' );
						
		endif;
		if( get_option( 'sw_wooswatches_enable_listing' ) === 'yes' ){
			wp_enqueue_script( 'add-to-cart-variation-ajax', WSURL . '/js/add-to-cart-variation-ajax.js', array( 'jquery' ), null, true );
			wp_localize_script( 'add-to-cart-variation-ajax', 'AddToCartAjax', array(
				'ajaxurl' => WC_AJAX::get_endpoint( "%%endpoint%%" ),
				'notice'	=> esc_html__( 'Please select variation first', 'sw_wooswatches' )
			));
			wp_enqueue_script( 'wc-add-to-cart-variation' );
			wp_enqueue_script( 'wc-add-to-cart-variation-frontend', WSURL . '/js/woocommerce/custom/add-to-cart-variation-frontend.js', array( 'jquery', 'wp-util' ),null, true  );
		}
	endif;
}