<?php
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;

/**
 * Elementor WordPress widget.
 *
 * Elementor widget that displays all the WordPress widgets.
 *
 * @since 1.0.0
 */
class WP_Custom_Widgets extends Widget_Base {
	/**
	 * WordPress widget name.
	 *
	 * @access private
	 *
	 * @var string
	 */
	private $_widget_name = null;

	/**
	 * WordPress widget instance.
	 *
	 * @access private
	 *
	 * @var \WP_Widget
	 */
	private $_widget_instance = null;

	public function hide_on_search() {
		return false;
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve WordPress widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'wp-widget-' . $this->get_widget_instance()->id_base;
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve WordPress widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return $this->get_widget_instance()->name;
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the WordPress widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories. Returns either a WordPress category.
	 */
	public function get_categories() {
		return [ 'wordpress' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve WordPress widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon. Returns either a WordPress icon.
	 */
	public function get_icon() {
		return 'eicon-wordpress';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'wordpress', 'widget' ];
	}

	public function get_help_url() {
		return '';
	}

	/**
	 * Whether the reload preview is required or not.
	 *
	 * Used to determine whether the reload preview is required.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return bool Whether the reload preview is required.
	 */
	public function is_reload_preview_required() {
		return true;
	}

	/**
	 * Retrieve WordPress widget form.
	 *
	 * Returns the WordPress widget form, to be used in Elementor.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget form.
	 */
	public function get_form() {
		$instance = $this->get_widget_instance();

		ob_start();
		echo '<div class="widget-inside media-widget-control"><div class="form wp-core-ui">';
		echo '<input type="hidden" class="id_base" value="' . esc_attr( $instance->id_base ) . '" />';
		echo '<input type="hidden" class="widget-id" value="widget-' . esc_attr( $this->get_id() ) . '" />';
		echo '<div class="widget-content">';
		$widget_data = $this->get_settings( 'wp' );
		$instance->form( $widget_data );
		do_action( 'in_widget_form', $instance, null, $widget_data );
		echo '</div></div></div>';
		return ob_get_clean();
	}

	/**
	 * Retrieve WordPress widget instance.
	 *
	 * Returns an instance of WordPress widget, to be used in Elementor.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return \WP_Widget
	 */
	public function get_widget_instance() {
		if ( is_null( $this->_widget_instance ) ) {
			global $wp_widget_factory;

			if ( isset( $wp_widget_factory->widgets[ $this->_widget_name ] ) ) {
				$this->_widget_instance = $wp_widget_factory->widgets[ $this->_widget_name ];
				$this->_widget_instance->_set( 'REPLACE_TO_ID' );
			} elseif ( class_exists( $this->_widget_name ) ) {
				$this->_widget_instance = new $this->_widget_name();
				$this->_widget_instance->_set( 'REPLACE_TO_ID' );
			}
		}
		return $this->_widget_instance;
	}

	/**
	 * Retrieve WordPress widget parsed settings.
	 *
	 * Returns the WordPress widget settings, to be used in Elementor.
	 *
	 * @access protected
	 * @since 2.3.0
	 *
	 * @return array Parsed settings.
	 */
	protected function get_init_settings() {
		$settings = parent::get_init_settings();

		if ( ! empty( $settings['wp'] ) ) {
			$widget = $this->get_widget_instance();
			$instance = $widget->update( $settings['wp'], [] );
			/** This filter is documented in wp-includes/class-wp-widget.php */
			$settings['wp'] = apply_filters( 'widget_update_callback', $instance, $settings['wp'], [], $widget );
		}

		return $settings;
	}
	
	public function get_control_tab_style(){
		$this->start_controls_section(
			'section_tab_style',
			[
				'label' => esc_html__( 'Tab Style', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'tab_parent_heading',
			[
				'label' => esc_html__( 'Tab Parent', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'tab_parent_background',
			[
				'label' => esc_html__( 'Background', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tab_parent_border',
				'label' => esc_html__( 'Border', 'emarket' ),
				'selector' => '{{WRAPPER}} .resp-tab .nav-tabs',
			]
		);
		
		$this->add_responsive_control(
			'tab_parent_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'tab_parent_margin',
			[
				'label' => esc_html__( 'Margin', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'tab_parent_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		
		
		
		$this->add_control(
			'tab_item_heading',
			[
				'label' => esc_html__( 'Tab Item', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_typography',
				'selector' => 	'{{WRAPPER}} .resp-tab .nav-tabs > li > a, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li > a',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tab_item_border',
				'label' => esc_html__( 'Tab Item Border', 'emarket' ),
				'selector' => '{{WRAPPER}} .resp-tab .nav-tabs > li, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li',
			]
		);
		
		$this->add_responsive_control(
			'tab_item_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_style' );

		$this->start_controls_tab(
			'tab_style_normal',
			[
				'label' => esc_html__( 'Normal', 'emarket' ),
			]
		);

		$this->add_control(
			'tab_item_color',
			[
				'label' => esc_html__( 'Tab Item Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li > a, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li > a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tab_item_background',
			[
				'label' => esc_html__( 'Tab Item Background', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li > a' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tab_style_hover',
			[
				'label' => esc_html__( 'Hover', 'emarket' ),
			]
		);
		
		$this->add_control(
			'tab_item_color_hover',
			[
				'label' => esc_html__( 'Tab Item Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li:hover > a, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li:hover > a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tab_item_background_hover',
			[
				'label' => esc_html__( 'Tab Item Background', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li:hover, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'tab_item_border_hover',
			[
				'label' => esc_html__( 'Tab Item Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li:hover, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li:hover' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tab_style_active',
			[
				'label' => esc_html__( 'Active', 'emarket' ),
			]
		);
		
		$this->add_control(
			'tab_item_color_active',
			[
				'label' => esc_html__( 'Tab Item Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li.active > a, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li.active > a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tab_item_background_active',
			[
				'label' => esc_html__( 'Tab Item Background', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li.active, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li.active' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'tab_item_border_active',
			[
				'label' => esc_html__( 'Tab Item Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li.active, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li.active' => 'border-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->add_responsive_control(
			'tab_item_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .resp-tab .nav-tabs > li > a, {{WRAPPER}} .resp-tab .category-slider-content .nav-tabs > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->end_controls_section();
	}
	
	/*
	** Get control for ourteam
	*/
	public function get_control_team_style(){
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content Detail', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);			
		
		$this->add_control(
			'image_content',
			[
				'label' => esc_html__( 'Image', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_control(
			'image_border',
			[
				'label' => esc_html__( 'Border', 'emarket' ),
				'type' => Controls_Manager::SWITCHER,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'border-style: solid',
				],
			]
		);
		
		$this->add_control(
			'image_border_style',
			[
				'label' => esc_html__( 'Style', 'emarket' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'None', 'emarket' ),
					'solid' => _x( 'Solid', 'Border Control', 'emarket' ),
					'double' => _x( 'Double', 'Border Control', 'emarket' ),
					'dotted' => _x( 'Dotted', 'Border Control', 'emarket' ),
					'dashed' => _x( 'Dashed', 'Border Control', 'emarket' ),
					'groove' => _x( 'Groove', 'Border Control', 'emarket' ),
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'border-style: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'image_border_width',
			[
				'label' => esc_html__( 'Border Width', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'image_border_color',
			[
				'label' => esc_html__( 'Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'border-color: {{VALUE}}',
				],
			]
		);	

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'image_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__( 'Width', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],		
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'width: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_responsive_control(
			'image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-img .item-img-info img' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_control(
			'member_ourteam',
			[
				'label' => esc_html__( 'Member Content', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'member_ourteam_typography',
				'selector' => '{{WRAPPER}} .sw-ourteam-slider .item .item-content h3'							
			]
		);	

		$this->add_control(
			'member_ourteam_text_color',
			[
				'label' => esc_html__( 'Member Heading Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-content h3' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'member_ourteam_spacing',
			[
				'label' => esc_html__( 'Member Heading Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-content h3' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_control(
			'member_info_ourteam',
			[
				'label' => esc_html__( 'Member Information', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'member_info_typography',
				'selector' => '{{WRAPPER}} .sw-ourteam-slider .item .item-content .team-info',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'member_info_text_color',
			[
				'label' => esc_html__( 'Member Information Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-content .team-info' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'member_info_spacing',
			[
				'label' => esc_html__( 'Member Information Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-content .team-info' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_control(
			'member_desc',
			[
				'label' => esc_html__( 'Member Description', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'member_desc_typography',
				'selector' => '.sw-ourteam-slider .item .item-content .item-desc',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'member_desc_text_color',
			[
				'label' => esc_html__( 'Member Description Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-content .item-desc' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'member_desc_spacing',
			[
				'label' => esc_html__( 'Member Description Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .item .item-content .item-desc' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_control(
			'member_social',
			[
				'label' => esc_html__( 'Member Description', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_responsive_control(
			'member_social_size',
			[
				'label' => esc_html__( 'Social Size', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div a' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
				]				
			]
		);
		
		$this->add_control( 'member_social_switcher', [
			'label' => __( 'Custom Social', 'emarket' ),
			'description' => __('Customizing social icon', 'emarket'),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'emarket' ),
			'label_off' => __( 'Hide', 'emarket' ),
			'return_value' => 'yes',
			'default' => 'no',
			'selectors' => [
				'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'display: block;',
			]
		]);	


		$this->start_controls_tabs( 'tabs_socials_colors', [
			'condition' => [
				'member_social_switcher' => 'yes',
			],
		]);

		$this->start_controls_tab(
			'tab_member_normal',
			[
				'label' => esc_html__( 'Normal', 'emarket' ),
			]
		);	

		$this->add_control(
			'member_social_background_color',
			[
				'label' => esc_html__( 'Background Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'background-color: {{VALUE}}',
				]				
			]
		);
		
		$this->add_control(
			'member_social_color',
			[
				'label' => esc_html__( 'Icon Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a > i' => 'color: {{VALUE}}',
				]				
			]
		);

		$this->add_control(
			'member_social_border_color',
			[
				'label' => esc_html__( 'Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_member_hover',
			[
				'label' => esc_html__( 'Hover', 'emarket' ),
			]
		);	

		$this->add_control(
			'member_social_background_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a:hover' => 'background-color: {{VALUE}}',
				]				
			]
		);
		
		$this->add_control(
			'member_social_color_hover',
			[
				'label' => esc_html__( 'Icon Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a:hover' => 'color: {{VALUE}}',
				]				
			]
		);

		$this->add_control(
			'member_social_border_color_hover',
			[
				'label' => esc_html__( 'Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a:hover' => 'border-color: {{VALUE}}',
				],
			]
		);	

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_control(
			'member_social_border',
			[
				'label' => esc_html__( 'Border', 'emarket' ),
				'type' => Controls_Manager::SWITCHER,			
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'border-style: solid',
				],
			]
		);

		$this->add_control(
			'member_social_border_width',
			[
				'label' => esc_html__( 'Border Width', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'member_social_border' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'member_social_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'member_social_border' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'member_social_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'member_social_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-ourteam-slider .resp-slider-container .item .item-social > div > a > i' => 'font-size: {{SIZE}}{{UNIT}}',
				]				
			]
		);

		$this->end_controls_section();	
	}
	
	/*
	** Get control for testimonial
	*/
	public function get_control_testimonial_style(){
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content Detail', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);		
		
		$this->add_control(
			'testimonial_content',
			[
				'label' => esc_html__( 'Testimonial content', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'testimonial_typography',
				'selector' => '{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'testimonial_text_color',
			[
				'label' => esc_html__( 'Text Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'testimonial_background_color',
			[
				'label' => esc_html__( 'Background Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment:before' => 'border-top-color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'testimonial_border',
			[
				'label' => esc_html__( 'Border', 'emarket' ),
				'type' => Controls_Manager::SWITCHER				
			]
		);
		
		$this->add_control(
			'testimonial_border_style',
			[
				'label' => esc_html__( 'Style', 'emarket' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'None', 'emarket' ),
					'solid' => _x( 'Solid', 'Border Control', 'emarket' ),
					'double' => _x( 'Double', 'Border Control', 'emarket' ),
					'dotted' => _x( 'Dotted', 'Border Control', 'emarket' ),
					'dashed' => _x( 'Dashed', 'Border Control', 'emarket' ),
					'groove' => _x( 'Groove', 'Border Control', 'emarket' ),
				],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'border-style: {{VALUE}};',
				],
				'condition' => [
					'testimonial_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'testimonial_border_width',
			[
				'label' => esc_html__( 'Border Width', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'testimonial_border' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'testimonial_border_color',
			[
				'label' => esc_html__( 'Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'testimonial_border' => 'yes',
				]
			]
		);	

		$this->add_responsive_control(
			'testimonial_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'testimonial_border' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'testimonial_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'testimonial_margin',
			[
				'label' => esc_html__( 'Margin', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'image_content',
			[
				'label' => esc_html__( 'Image', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',	
			]
		);
		
		$this->add_control(
			'image_border',
			[
				'label' => esc_html__( 'Border', 'emarket' ),
				'type' => Controls_Manager::SWITCHER,
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'border-style: solid',
				],
			]
		);
		
		$this->add_control(
			'image_border_style',
			[
				'label' => esc_html__( 'Style', 'emarket' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'None', 'emarket' ),
					'solid' => _x( 'Solid', 'Border Control', 'emarket' ),
					'double' => _x( 'Double', 'Border Control', 'emarket' ),
					'dotted' => _x( 'Dotted', 'Border Control', 'emarket' ),
					'dashed' => _x( 'Dashed', 'Border Control', 'emarket' ),
					'groove' => _x( 'Groove', 'Border Control', 'emarket' ),
				],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'border-style: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'image_border_width',
			[
				'label' => esc_html__( 'Border Width', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'image_border_color',
			[
				'label' => esc_html__( 'Border Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,				
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'border-color: {{VALUE}}',
				],
			]
		);	

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'border-radius: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'image_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__( 'Width', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'width: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_responsive_control(
			'image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .client-image img, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .image-client img' => 'margin-right: {{SIZE}}{{UNIT}}',
				],				
			]
		);
		
		$this->add_control(
			'author_testimonial',
			[
				'label' => esc_html__( 'Author Testimonial', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_testimonial_typography',
				'selector' => '{{WRAPPER}} .sw-testimonial-slider .item .item-content h4 > a,{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-say-info h2 a, {{WRAPPER}}  .sw-testimonial-slider .item .item-inner .client-say-info h2'							
			]
		);	

		$this->add_control(
			'author_testimonial_text_color',
			[
				'label' => esc_html__( 'Author Heading Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-content h4 > a,{{WRAPPER}}  .sw-testimonial-slider .item .item-inner .client-say-info h2 a, {{WRAPPER}}  .sw-testimonial-slider .item .item-inner .client-say-info h2' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'author_info_testimonial',
			[
				'label' => esc_html__( 'Author Information', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_info_typography',
				'selector' => '.sw-testimonial-slider .item .item-content .author-info,{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-say-info h4, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-say-info .info-client',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				]			
			]
		);	

		$this->add_control(
			'author_info_text_color',
			[
				'label' => esc_html__( 'Author Information Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-content .author-info,{{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-say-info h4, {{WRAPPER}} .sw-testimonial-slider .item .item-inner .client-say-info .info-client' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'author_align_heading',
			[
				'label' => '',
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',				
			]
		);
		
		$this->add_control(
			'author_align',
			[
				'label' => esc_html__( 'Text Alignment', 'emarket' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'emarket' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'emarket' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'author_vertical_align',
			[
				'label' => esc_html__( 'Verical Alignment', 'emarket' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'top', 'emarket' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Middle', 'emarket' ),
						'icon' => 'eicon-v-align-middle',
					],
					'flex-end' => [
						'title' => esc_html__( 'Bottom', 'emarket' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .sw-testimonial-slider .item .item-content' => 'align-items: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();	
	}
	
	/*
	** Get control for responsive post
	*/
	public function get_control_responsive_post_style(){
		$this->start_controls_section(
			'section_responsive_post_style',
			[
				'label' => esc_html__( 'Style', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'resp_align',
			[
				'label' => esc_html__( 'Alignment', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'emarket' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'emarket' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'prefix_class' => 'elementor-responsive-post-item--align-',
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'resp_heading_image_style',
			[
				'label' => esc_html__( 'Image', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'resp_image_border',
				'selector' => '{{WRAPPER}} .responsive-slider .item .img_over img',
			]
		);

		$this->add_responsive_control(
			'resp_image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .img_over img, {{WRAPPER}} .responsive-slider .slick-list .item .img_over img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'resp_image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .img_over img' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'resp_heading_title_style',
			[
				'label' => esc_html__( 'Title', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->start_controls_tabs( 'tabs_resp_title_style' );

		$this->start_controls_tab(
			'tab_resp_title_normal',
			[
				'label' => esc_html__( 'Normal', 'emarket' ),
			]
		);

		$this->add_control(
			'resp_title_color',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item h3 > a,
					{{WRAPPER}} .responsive-slider .item h4 > a,
					{{WRAPPER}} .responsive-slider .slider .item h3 > a,
					{{WRAPPER}} .responsive-slider .slider .item h4 > a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tab_resp_title_hover',
			[
				'label' => esc_html__( 'Hover', 'emarket' ),
			]
		);
		
		$this->add_control(
			'title_resp_color_hover',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item h3 > a:hover,
					{{WRAPPER}} .responsive-slider .item h4 > a:hover,
					{{WRAPPER}} .responsive-slider .slider .item h3 > a:hover,
					{{WRAPPER}} .responsive-slider slider .item h4 > a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'resp_title_typography',
				'selector' => 	'{{WRAPPER}} .responsive-slider .item h3 > a, {{WRAPPER}} .responsive-slider .item h4 > a, {{WRAPPER}} .responsive-slider .slider .item h3 > a, {{WRAPPER}} .responsive-slider .slider .item h4 > a',
			]
		);

		$this->add_responsive_control(
			'resp_title_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item h3,
					{{WRAPPER}} .responsive-slider .item h4, 
					{{WRAPPER}} .responsive-slider .slider .item h3, 
					{{WRAPPER}} .responsive-slider .slider .item h4' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'resp_title_border',
				'selector' => '{{WRAPPER}} .responsive-slider .item h4, {{WRAPPER}} .responsive-slider .item h3, {{WRAPPER}} .responsive-slider .slider .item h3, {{WRAPPER}} .responsive-slider .slider .item h4',
			]
		);
		$this->add_responsive_control(
			'resp_title_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item h3 > a,
					{{WRAPPER}} .responsive-slider .item h4 > a, 
					{{WRAPPER}} .responsive-slider .slider .item h3 > a, 
					{{WRAPPER}} .responsive-slider .slider .item h4 > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->add_control(
			'resp_heading_meta_style',
			[
				'label' => esc_html__( 'Meta', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'meta_resp_color',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .entry-meta a, 
					{{WRAPPER}} .responsive-slider .slider .item .entry-meta span a, 
					{{WRAPPER}} .responsive-slider .sslider .item .entry-content .entry-meta a, 
					{{WRAPPER}} .responsive-slider .slider .item .entry-content .entry-meta' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'resp_meta_typography',
				'selector' => 	'{{WRAPPER}} .responsive-slider .item .entry-meta a, {{WRAPPER}} .responsive-slider .slider .item .entry-meta span a, {{WRAPPER}} .responsive-slider .slider .item .entry-content .entry-meta a,
				{{WRAPPER}} .responsive-slider .slider .item .entry-content .entry-meta',
			]
		);

		$this->add_responsive_control(
			'resp_meta_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .item .entry-meta, 
					{{WRAPPER}} .responsive-slider .slider .item .entry-meta' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		
		$this->end_controls_section();
	}
	
	public function get_control_categories(){
		$this->start_controls_section(
			'section_products_style',
			[
				'label' => esc_html__( 'Categories', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'emarket' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'emarket' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'prefix_class' => 'elementor-categories-item--align-',
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'heading_image_style',
			[
				'label' => esc_html__( 'Image', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .responsive-slider .item .item-image img',
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .item-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .item-image img' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_title_style',
			[
				'label' => esc_html__( 'Title', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->start_controls_tabs( 'tabs_title_style' );

		$this->start_controls_tab(
			'tab_title_normal',
			[
				'label' => esc_html__( 'Normal', 'emarket' ),
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .item-wrap h3 > a, {{WRAPPER}} .responsive-slider .item .item-wrap .item-content h3 > a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tab_title_hover',
			[
				'label' => esc_html__( 'Hover', 'emarket' ),
			]
		);
		
		$this->add_control(
			'title_color_hover',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item .item-wrap h3 > a:hover, {{WRAPPER}} .responsive-slider .item .item-wrap .item-content h3 > a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => 	'{{WRAPPER}} .responsive-slider .item .item-wrap h3 > a, {{WRAPPER}} .responsive-slider .item .item-wrap .item-content h3 > a',
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .item h3' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'title_border',
				'selector' => '{{WRAPPER}} .responsive-slider .item h3',
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'.responsive-slider .item h3 > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		
		$this->end_controls_section();
	}
	
	public function get_control_product_slider(){
		$this->start_controls_section(
			'section_products_style',
			[
				'label' => esc_html__( 'Products', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'emarket' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'emarket' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'prefix_class' => 'elementor-product-loop-item--align-',
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'heading_image_style',
			[
				'label' => esc_html__( 'Image', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .responsive-slider .product .item-img img',
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product .item-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product .item-img img' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_title_style',
			[
				'label' => esc_html__( 'Title', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->start_controls_tabs( 'tabs_title_style' );

		$this->start_controls_tab(
			'tab_title_normal',
			[
				'label' => esc_html__( 'Normal', 'emarket' ),
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product .item-content h4 > a,
					{{WRAPPER}} .responsive-slider .product h3 > a,
					{{WRAPPER}} .responsive-slider .product h4 > a' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tab_title_hover',
			[
				'label' => esc_html__( 'Hover', 'emarket' ),
			]
		);
		
		$this->add_control(
			'title_color_hover',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product .item-content h4 > a:hover,
					{{WRAPPER}} .responsive-slider .product h3 > a:hover,
					{{WRAPPER}} .responsive-slider .product h4 > a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => 	'{{WRAPPER}} .responsive-slider .product .item-content h4 > a, {{WRAPPER}} .responsive-slider .product h3 > a, {{WRAPPER}} .responsive-slider .product h4 > a',
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product .item-content h4,
					{{WRAPPER}} .responsive-slider .product h3,
					{{WRAPPER}} .responsive-slider .product h4' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'title_border',
				'selector' => '{{WRAPPER}} .responsive-slider .product .item-content h4,{{WRAPPER}} .responsive-slider .product h3,{{WRAPPER}} .responsive-slider .product h4',
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'emarket' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .product .item-content h4 > a,
					{{WRAPPER}} .responsive-slider .product h3 > a,
					{{WRAPPER}} .responsive-slider .product h4 > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_rating_style',
			[
				'label' => esc_html__( 'Rating', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'rating_spacing',
			[
				'label' => esc_html__( 'Spacing', 'emarket' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .responsive-slider .slider .product .item-wraps .reviews-content, {{WRAPPER}} .responsive-slider .slider .product .reviews-content,
					{{WRAPPER}}  .resp-tab .tab-pane .responsive-slider .slider .product .item-content .reviews-content' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_price_style',
			[
				'label' => esc_html__( 'Price', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'price_color',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .responsive-slider .product .item-price' => 'color: {{VALUE}}',
					'{{WRAPPER}}  .responsive-slider .product .item-price ins' => 'color: {{VALUE}}',
					'{{WRAPPER}}  .responsive-slider .product .item-price ins .amount' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}}  .responsive-slider .product .item-price',
			]
		);

		$this->add_control(
			'heading_old_price_style',
			[
				'label' => esc_html__( 'Regular Price', 'emarket' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'old_price_color',
			[
				'label' => esc_html__( 'Color', 'emarket' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .responsive-slider .product .item-price del' => 'color: {{VALUE}}',
					'{{WRAPPER}}  .responsive-slider .product .item-price del .amount' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'old_price_typography',				
				'selector' => '{{WRAPPER}}  .responsive-slider .product .item-price del .amount  ',
				'selector' => '{{WRAPPER}}  .responsive-slider .product .item-price del ',
			]
		);
		$this->end_controls_section();		
	}
	
	function get_slider_config( $condition = '', $value = array() ){		
		if( !empty( $condition ) && count( $value ) ){
			$args = [
				'label' => __( 'Slider Config', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					$condition => $value
				],
			];
		}else{
			$args = [
				'label' => __( 'Slider Config', 'emarket' ),
				'tab' => Controls_Manager::TAB_STYLE,				
			];
		}	
		
		$this->start_controls_section( 'slider_config', $args );

		$this->add_responsive_control('button_visible', [
			'label' => __( 'Button Slider Visible', 'emarket' ),
			'type' =>\Elementor\Controls_Manager::SELECT,
			'default' => 'hover',
			'options' => [
				'hover' => __( 'Hover To Show', 'emarket' ),
				'show'	=> __( 'Alway Show Button', 'emarket' ),
				'hidden'=> __( 'Hide Button', 'emarket' ),
			],
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .slick-arrow' => '{{VALUE}}',
			],
			'selectors_dictionary' => [
				'hover'   => 'display: flex;',
				'show'   => 'visibility: visible; opacity: 1;',
				'hidden'   => 'display: none;visibility: hidden;',
			],
		]);
		
		$this->add_control('bg_button_left', [
			'label' => __( 'Background Image Button Left', 'emarket' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .slick-arrow.slick-prev' => 'background-image: url("{{URL}}");',
				'{{WRAPPER}} .responsive-slider .slick-arrow.slick-prev svg' => 'visibility: hidden;',
			],
			'render_type' => 'template',			
		]);
		
		$this->add_control('bg_button_left_hover', [
			'label' => __( 'Background Image Button Left Hover', 'emarket' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .slick-arrow.slick-prev:hover' => 'background-image: url("{{URL}}");',
			],
			'render_type' => 'template',			
		]);
		
		$this->add_control('bg_button_right', [
			'label' => __( 'Background Image Button Right', 'emarket' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .slick-arrow.slick-next' => 'background-image: url("{{URL}}");',
				'{{WRAPPER}} .responsive-slider .slick-arrow.slick-next svg' => 'visibility: hidden;',
			],
			'render_type' => 'template',			
		]);
		
		$this->add_control('bg_button_right_hover', [
			'label' => __( 'Background Image Button Right Hover', 'emarket' ),
			'type' => Controls_Manager::MEDIA,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .slick-arrow.slick-next:hover' => 'background-image: url("{{URL}}");',
			],
			'has_sizes' => true,
			'render_type' => 'template',			
		]);
		
		$this->add_responsive_control('slides_space', [
			'label' => __( 'Space Items', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .slick-list' => 'margin: 0 calc(-{{SIZE}}px/2);',
				'{{WRAPPER}} .slick-slider .slick-slide' => 'padding: 0 calc({{SIZE}}px/2);grid-row-gap: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->end_controls_section();
	}
	
	public function get_control_arrow_style(){
		/**
		* Style Arrows and dots
		*/
		$this->start_controls_section( 'section_style_arrows_and_dots', [
			'label' => __( 'Arrows & dots', 'emarket' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]);

		$this->add_control( 'section_style_arrows', [
			'label' => __( 'Arrows', 'emarket' ),
			'type' => Controls_Manager::HEADING,
		]);
		
		$this->add_responsive_control(
			'button_align',
			[
				'label' => esc_html__( 'Button Align', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'top' => [
						'title' => esc_html__( 'Top', 'emarket' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-v-align-middle',
					],
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'emarket' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'prefix_class' => 'sw-slider-button-align--',				
			]
		);
		
		$this->add_responsive_control(
			'button_position',
			[
				'label' => esc_html__( 'Button Position', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'emarket' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'emarket' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'sw-slider-button-position--',				
			]
		);		
		
		$this->add_responsive_control('button_offset_top', [
			'label' => __( 'Arrow Offset Top/ Bottom', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.sw-slider-button-align--top .responsive-slider .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.sw-slider-button-align--bottom .responsive-slider .slick-arrow' => 'bottom: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('button_offset_position_left', [
			'label' => __( 'Arrow Left Offset', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.sw-slider-button-position--left .responsive-slider .slick-arrow.slick-prev' => 'left: {{SIZE}}{{UNIT}};right: auto;',
				'{{WRAPPER}}.sw-slider-button-position--right .responsive-slider .slick-arrow.slick-prev' => 'right: {{SIZE}}{{UNIT}};left: auto;',
			],
			'condition' => [
				'button_position' => ['left', 'right']
			],
		]);
		
		$this->add_responsive_control('button_offset_position_right', [
			'label' => __( 'Arrow Right Offset', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.sw-slider-button-position--left .responsive-slider .slick-arrow.slick-next' => 'left: {{SIZE}}{{UNIT}};right: auto;',
				'{{WRAPPER}}.sw-slider-button-position--right .responsive-slider .slick-arrow.slick-next' => 'right: {{SIZE}}{{UNIT}};left: auto;',
			],
			'condition' => [
				'button_position' => ['left', 'right']
			],
		]);

		$this->add_responsive_control('slider_arrows_space', [
			'label' => __( 'Space', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -100,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .responsive-slider .res-button.slick-prev,{{WRAPPER}} .carousel .carousel-ctr.left' => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .responsive-slider .res-button.slick-next,{{WRAPPER}} .carousel .carousel-ctr.right' => 'right: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control('slider_arrows_block', [
			'label' => __( 'Width', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .responsive-slider .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('slider_arrows_block_h', [
			'label' => __( 'Height', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .responsive-slider .slick-arrow' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_responsive_control('slider_arrows_size', [
			'label' => __( 'Size', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .responsive-slider .res-button, {{WRAPPER}} .carousel .carousel-ctr' => 'font-size: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'slider_arrows_border',
				'selector' => '{{WRAPPER}} .responsive-slider .slick-arrow',
			]
		);
		
		$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'slider_arrows_box_shadow',
					'selector' => '{{WRAPPER}} .responsive-slider .slick-arrow',
				]
			);
			
		$this->start_controls_tabs( 'slider_arrows_tabs' );

		$this->start_controls_tab( 'slider_arrows_normal', [
			'label' => __( 'Normal', 'emarket' ),
		]);

		$this->add_control( 'slider_arrows_color', [
			'label' => __( 'Color', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .res-button, {{WRAPPER}} .carousel .carousel-ctr' => 'color: {{VALUE}};',
				'{{WRAPPER}} .responsive-slider .res-button svg' => 'fill: {{VALUE}};',
			],
		]);

		$this->add_control( 'slider_arrows_bg', [
			'label' => __( 'Background', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .res-button, {{WRAPPER}} .carousel .carousel-ctr' => 'background-color: {{VALUE}};',
			],
		]);

		$this->end_controls_tab();

		$this->start_controls_tab( 'slider_arrows_hover', [
			'label' => __( 'Hover', 'emarket' ),
		]);

		$this->add_control( 'slider_arrows_color_hover', [
			'label' => __( 'Color', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .res-button:hover, {{WRAPPER}} .carousel .carousel-ctr:hover' => 'color: {{VALUE}};',
				'{{WRAPPER}} .responsive-slider .res-button:hover svg' => 'fill: {{VALUE}};',
			],
		]);

		$this->add_control( 'slider_arrows_bg_hover', [
			'label' => __( 'Background', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .res-button:hover, {{WRAPPER}} .carousel .carousel-ctr:hover' => 'background-color: {{VALUE}};',
			],
		]);
		
		$this->add_control( 'slider_arrows_border_hover', [
			'label' => __( 'Background', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .res-button:hover, {{WRAPPER}} .carousel .carousel-ctr:hover' => 'border-color: {{VALUE}};',
			],
		]);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control('slider_arrows_border_radius', [
			'label' => __( 'Border radius', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .responsive-slider .res-button, {{WRAPPER}} .carousel .carousel-ctr' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->add_control( 'section_style_dots', [
			'label' => __( 'Dots', 'emarket' ),
			'type' => Controls_Manager::HEADING,
			'separator' => 'before',
		]);

		$this->add_responsive_control('slider_dots_space', [
			'label' => __( 'Space', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots' => 'margin-top: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->start_controls_tabs( 'slider_dots_tabs' );
		
		$this->add_responsive_control(
			'dots_align',
			[
				'label' => esc_html__( 'Dots Align', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'top' => [
						'title' => esc_html__( 'Top', 'emarket' ),
						'icon' => 'eicon-v-align-top',
					],					
					'bottom' => [
						'title' => esc_html__( 'Bottom', 'emarket' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'prefix_class' => 'sw-slider-dots-align--',				
			]
		);
		
		$this->add_responsive_control(
			'dots_position',
			[
				'label' => esc_html__( 'Dots Position', 'emarket' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'emarket' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'emarket' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'emarket' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'prefix_class' => 'sw-slider-dots-position--',				
			]
		);	
		
		$this->add_responsive_control('dots_offset_top', [
			'label' => __( 'Dots Offset Top/ Bottom', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.sw-slider-dots-align--top .responsive-slider .slick-dots' => 'top: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}}.sw-slider-dots-align--bottom .responsive-slider .slick-dots' => 'bottom: {{SIZE}}{{UNIT}};',
			],
		]);
		
		$this->add_responsive_control('dots_offset_position_left', [
			'label' => __( 'Dots Left/ Right Offset', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => -200,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}}.sw-slider-dots-position--left .responsive-slider .slick-dots' => 'left: {{SIZE}}{{UNIT}};right: auto;',
				'{{WRAPPER}}.sw-slider-dots-position--right .responsive-slider .slick-dots' => 'right: {{SIZE}}{{UNIT}};left: auto;',
			],
			'condition' => [
				'button_position' => ['left', 'right']
			],
		]);

		$this->start_controls_tab( 'slider_dots_normal', [
			'label' => __( 'Normal', 'emarket' ),
		]);

		$this->add_control( 'slider_dots_bg', [
			'label' => __( 'Background', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .slick-dots li' => 'background: {{VALUE}};',
			],
		]);

		$this->add_responsive_control('slider_dots_block', [
			'label' => __( 'Block', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots li' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->end_controls_tab();

		$this->start_controls_tab( 'slider_dots_hover', [
			'label' => __( 'Hover & Active', 'emarket' ),
		]);

		$this->add_control( 'slider_dots_bg_hover', [
			'label' => __( 'Background', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .slick-dots li:hover, {{WRAPPER}} .slick-dots li.slick-active' => 'background: {{VALUE}};',
			],
		]);
		
		$this->add_responsive_control('slider_dots_active_width', [
			'label' => __( 'Width active', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 20,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots li.slick-active' => 'width: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control('slider_dots_border_radius', [
			'label' => __( 'Border radius', 'emarket' ),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .slick-dots li' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);

		$this->end_controls_section();
	}

	/**
	 * Register WordPress widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {	
		$this->add_control(
			'wp',
			[
				'label' => esc_html__( 'Form', 'emarket' ),
				'type' => Controls_Manager::WP_WIDGET,
				'widget' => $this->get_name(),
				'id_base' => $this->get_widget_instance()->id_base,
			]
		);
				
		$this->get_slider_config();
		
		$this->start_controls_section( 'section_style_wrap_item', [
			'label' => __( 'Items', 'emarket' ),
			'tab'   => Controls_Manager::TAB_STYLE,
		]);

		$this->add_responsive_control( 'wrap_item_padding', [
			'label'      => __( 'Padding', 'emarket' ),
			'type'       => Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .responsive-slider .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$this->add_group_control( Group_Control_Border::get_type(), [
			'name' => 'wrap_item_border',
			'label' => __( 'Border', 'emarket' ),
			'selector' => '{{WRAPPER}} .responsive-slider .item',
		]);

		$this->add_control( 'wrap_item_border_radius', [
			'label'     => __( 'Border Radius', 'emarket' ),
			'type'      => Controls_Manager::SLIDER,
			'range'     => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
				'%'  => [
					'min' => 0,
					'max' => 100,
				],
			],
			'size_units'     => [ '%', 'px' ],
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .item' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]);		
		

		$this->start_controls_tabs( 'wrap_item_tabs' );
		$this->start_controls_tab( 'wrap_item_normal', [
			'label' => __( 'Normal', 'emarket' ),
		]);

		$this->add_control( 'wrap_item_background', [
			'label' => __( 'Background', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .item' => 'background: {{VALUE}};',
			],
		]);
		
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'content_box_shadow',
				'selector' => '{{WRAPPER}} .responsive-slider .item',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'wrap_item_hover', [
			'label' => __( 'Hover', 'emarket' ),
		]);

		$this->add_control( 'wrap_item_background_hover', [
			'label' => __( 'Color', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .item:hover' => 'background: {{VALUE}};',
			],
		]);

		$this->add_control( 'wrap_item_border_hover', [
			'label' => __( 'Border Color', 'emarket' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .responsive-slider .item:hover' => 'border-color: {{VALUE}};',
			],
		]);
		
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'content_box_shadow_hover',
				'selector' => '{{WRAPPER}} .responsive-slider .item:hover',
			]
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();
		
		$this->end_controls_section();
		
		if( in_array( $this->get_widget_instance()->id_base, array( 'sw_woo_slider_countdown_widget', 'sw_woo_tab_cat_slider', 'sw_woo_tab_slider' ) ) ){
			$this->get_control_tab_style();
		}
		
		if( in_array( $this->get_widget_instance()->id_base, array( 'sw_woo_slider_widget', 'sw_recent_viewed_widget', 'sw_related_upsell_widget', 'sw_woo_slider_countdown_widget', 'sw_woo_tab_cat_slider', 'sw_woo_tab_slider' ) ) ){
			$this->get_control_product_slider();
		} 
		
		if( in_array( $this->get_widget_instance()->id_base, array( 'sw_brand', 'sw_woo_cat_slider_widget' ) ) ){
			$this->get_control_categories();
		} 
		
		if( $this->get_widget_instance()->id_base == 'sw_team_slider' ){
			$this->get_control_team_style();
		} 	
		
		if( $this->get_widget_instance()->id_base == 'sw_testimonial_slider' ){
			$this->get_control_testimonial_style();
		} 
		
		if( $this->get_widget_instance()->id_base == 'sw_resp_slider' ){
			$this->get_control_responsive_post_style();
		} 	
		
		$this->get_control_arrow_style();
	}

	/**
	 * Render WordPress widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$default_widget_args = [
			'widget_id' => $this->get_name(),
			'before_widget' => '',
			'after_widget' => '',
			'before_title' => '<h5>',
			'after_title' => '</h5>',
		];

		/**
		 * WordPress widget args.
		 *
		 * Filters the WordPress widget arguments when they are rendered in Elementor panel.
		 *
		 * @since 1.0.0
		 *
		 * @param array            $default_widget_args Default widget arguments.
		 * @param Widget_WordPress $this                The WordPress widget.
		 */
		$default_widget_args = apply_filters( 'elementor/widgets/wordpress/widget_args', $default_widget_args, $this );
		$is_gallery_widget = 'wp-widget-media_gallery' === $this->get_name();

		if ( $is_gallery_widget ) {
			add_filter( 'wp_get_attachment_link', [ $this, 'add_lightbox_data_to_image_link' ], 10, 2 );
		}

		$this->get_widget_instance()->widget( $default_widget_args, $this->get_settings( 'wp' ) );

		if ( $is_gallery_widget ) {
			remove_filter( 'wp_get_attachment_link', [ $this, 'add_lightbox_data_to_image_link' ] );
		}
	}

	/**
	 * Render WordPress widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 2.9.0
	 * @access protected
	 */
	protected function content_template() {}

	/**
	 * WordPress widget constructor.
	 *
	 * Used to run WordPress widget constructor.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @param array $data Widget data. Default is an empty array.
	 * @param array $args Widget arguments. Default is null.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->_widget_name = $args['widget_name'];

		parent::__construct( $data, $args );
	}

	/**
	 * Render WordPress widget as plain content.
	 *
	 * Override the default render behavior, don't render widget content.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @param array $instance Widget instance. Default is empty array.
	 */
	public function render_plain_content( $instance = [] ) {}
}

