<?php
$lib_dir = trailingslashit( str_replace( '\\', '/', get_template_directory() . '/lib/' ) );

if( !defined('EMARKET_DIR') ){
	define( 'EMARKET_DIR', $lib_dir );
}

if( !defined('EMARKET_URL') ){
	define( 'EMARKET_URL', trailingslashit( get_template_directory_uri() ) . 'lib' );
}

if( !defined('EMARKET_OPTIONS_URL') ){
	define( 'EMARKET_OPTIONS_URL', trailingslashit( get_template_directory_uri() ) . 'lib/options/' ); 
}

if ( !defined('SW_THEME') ){
	define( 'SW_THEME', 'emarket_theme' . get_locale() );
}

defined('EMARKET_THEME') or die;

if (!isset($content_width)) { $content_width = 940; }

define("EMARKET_PRODUCT_TYPE","product");
define("EMARKET_PRODUCT_DETAIL_TYPE","product_detail");

require_once( get_template_directory().'/lib/options.php' );
function emarket_Options_Setup(){
	global $emarket_options, $options, $options_args;
	
	$homepage_args = apply_filters( 'sw_homepage_layout_args', array() );
	$options = array();
	
	$layout_ID = ( get_option( 'page_on_front' ) ) ? get_option( 'page_on_front' ) : 0;
	if( get_post_meta( $layout_ID, '_elementor_edit_mode', true ) == 'builder' ) {
		$options[] = array(
			'title' => esc_html__('General', 'emarket'),
			'desc' => wp_kses( __('<p class="description">The theme allows to build your own styles right out of the backend without any coding knowledge. Upload new logo and favicon or get their URL.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
			'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_019_cogwheel.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
			'fields' => array(	
				
				array(
					'id' => 'layout',
					'type' => 'multi_select',
					'title' => esc_html__('Include Style Layout', 'emarket'),
					'sub_desc' => esc_html__( 'Include style layout homepage which you want to use', 'emarket' ),
					'options' => $homepage_args
					),			

				array(
					'id' => 'title_length',
					'type' => 'text',
					'title' => esc_html__('Title Length Of Item Listing Page', 'emarket'),
					'sub_desc' => esc_html__( 'Choose title length if you want to trim word, leave 0 to not trim word', 'emarket' ),
					'std' => 0
					),
				array(
				   'id' => 'page_404',
				   'type' => 'pages_select',
				   'title' => esc_html__('404 Page Content', 'emarket'),
				   'sub_desc' => esc_html__('Select page 404 content', 'emarket'),
				   'std' => ''
				),
			)		
		);
	}else{
		$options[] = array(
			'title' => esc_html__('General', 'emarket'),
			'desc' => wp_kses( __('<p class="description">The theme allows to build your own styles right out of the backend without any coding knowledge. Upload new logo and favicon or get their URL.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
			'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_019_cogwheel.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
			'fields' => array(	
				
				array(
					'id' => 'layout',
					'type' => 'multi_select',
					'title' => esc_html__('Include Style Layout', 'emarket'),
					'sub_desc' => esc_html__( 'Include style layout homepage which you want to use', 'emarket' ),
					'options' => $homepage_args
					),
					
				array(
					'id' => 'sitelogo',
					'type' => 'upload',
					'title' => esc_html__('Logo Image', 'emarket'),
					'sub_desc' => esc_html__( 'Use the Upload button to upload the new logo and get URL of the logo', 'emarket' ),
					'std' => get_template_directory_uri().'/assets/img/logo-default.png'
					),

				array(
					'id' => 'favicon',
					'type' => 'upload',
					'title' => esc_html__('Favicon', 'emarket'),
					'sub_desc' => esc_html__( 'Use the Upload button to upload the custom favicon', 'emarket' ),
					'std' => ''
					),			

				array(
					'id' => 'title_length',
					'type' => 'text',
					'title' => esc_html__('Title Length Of Item Listing Page', 'emarket'),
					'sub_desc' => esc_html__( 'Choose title length if you want to trim word, leave 0 to not trim word', 'emarket' ),
					'std' => 0
					),
				array(
				   'id' => 'page_404',
				   'type' => 'pages_select',
				   'title' => esc_html__('404 Page Content', 'emarket'),
				   'sub_desc' => esc_html__('Select page 404 content', 'emarket'),
				   'std' => '',
				),
			)		
		);
	}

	$options[] = array(
		'title' => esc_html__('Schemes', 'emarket'),
		'desc' => wp_kses( __('<p class="description">Custom color scheme for theme. Unlimited color that you can choose.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_163_iphone.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(		
		array(
			'id' => 'scheme',
			'type' => 'radio_img',
			'title' => esc_html__('Color Scheme', 'emarket'),
			'sub_desc' => '',
			'desc' => '',
			'options' => array(
				'default' => array('title' => 'Default', 'img' => get_template_directory_uri().'/assets/img/default.png'),
				'orange' => array('title' => 'Orange', 'img' => get_template_directory_uri().'/assets/img/orange.png'),
				'orange2' => array('title' => 'Orange2', 'img' => get_template_directory_uri().'/assets/img/orange2.png'),
				'orange3' => array('title' => 'Orange3', 'img' => get_template_directory_uri().'/assets/img/orange3.png'),
				'orange4' => array('title' => 'Orange4', 'img' => get_template_directory_uri().'/assets/img/orange4.png'),
				'orange5' => array('title' => 'Orange5', 'img' => get_template_directory_uri().'/assets/img/orange5.png'),
				'orange6' => array('title' => 'Orange6', 'img' => get_template_directory_uri().'/assets/img/orange6.png'),
				'blue' => array('title' => 'Blue', 'img' => get_template_directory_uri().'/assets/img/blue.png'),
				'blue2' => array('title' => 'Blue 2', 'img' => get_template_directory_uri().'/assets/img/blue2.png'),
				'blue3' => array('title' => 'Blue 3', 'img' => get_template_directory_uri().'/assets/img/blue3.png'),
				'plum' => array('title' => 'Plum', 'img' => get_template_directory_uri().'/assets/img/plum.png'),
				'brown' => array('title' => 'Brown', 'img' => get_template_directory_uri().'/assets/img/brown.png'),
				'brown2' => array('title' => 'Brown2', 'img' => get_template_directory_uri().'/assets/img/brown2.png'),
				'green' => array('title' => 'Green', 'img' => get_template_directory_uri().'/assets/img/green.png'),
				'green2' => array('title' => 'Green2', 'img' => get_template_directory_uri().'/assets/img/green2.png'),
				'green3' => array('title' => 'Green3', 'img' => get_template_directory_uri().'/assets/img/green3.png'),
				'green4' => array('title' => 'Green4', 'img' => get_template_directory_uri().'/assets/img/green4.png'),
				'green5' => array('title' => 'Green5', 'img' => get_template_directory_uri().'/assets/img/green5.png'),
				'green6' => array('title' => 'Green6', 'img' => get_template_directory_uri().'/assets/img/green6.png'),
				'green7' => array('title' => 'Green7', 'img' => get_template_directory_uri().'/assets/img/green7.png'),
				'green36' => array('title' => 'Green36', 'img' => get_template_directory_uri().'/assets/img/green36.png'),
				'green37' => array('title' => 'Green37', 'img' => get_template_directory_uri().'/assets/img/green36.png'),
				'pink' => array('title' => 'Pink', 'img' => get_template_directory_uri().'/assets/img/pink.png'),
				'red' => array('title' => 'Red', 'img' => get_template_directory_uri().'/assets/img/red.png'),
				'red2' => array('title' => 'Red2', 'img' => get_template_directory_uri().'/assets/img/red2.png'),
				'red3' => array('title' => 'Red3', 'img' => get_template_directory_uri().'/assets/img/red3.png'),
				'red4' => array('title' => 'Red4', 'img' => get_template_directory_uri().'/assets/img/red4.png'),
				'red5' => array('title' => 'Red5', 'img' => get_template_directory_uri().'/assets/img/red5.png'),
				'red6' => array('title' => 'Red6', 'img' => get_template_directory_uri().'/assets/img/red6.png'),
				'red7' => array('title' => 'Red7', 'img' => get_template_directory_uri().'/assets/img/red7.png'),
				
				), //Must provide key => value(array:title|img) pairs for radio options
			'std' => 'default'
			),
		
		array(
			'id' => 'scheme_color',
			'type' => 'color',
			'title' => esc_html__('Color', 'emarket'),
			'sub_desc' => esc_html__('Select main custom color.', 'emarket'),
			'std' => ''
			),

		)
	);

	$options[] = array(
		'title' => esc_html__('Layout', 'emarket'),
		'desc' => wp_kses( __('<p class="description">SmartAddons Framework comes with a layout setting that allows you to build any number of stunning layouts and apply theme to your entries.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_319_sort.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(
		array(
			'id' => 'layout_width',
			'type' => 'number',
			'title' => esc_html__('Layout Width', 'emarket'),
			'sub_desc' => esc_html__( 'Select Layout width content', 'emarket' ),				
			'std' => 1170
		),
		array(
			'id' => 'layout_home',
			'type' => 'select',
			'title' => esc_html__('Layout Type', 'emarket'),
			'sub_desc' => esc_html__( 'Select Layout Box or Wide', 'emarket' ),
			'options' => array(
				'full' => esc_html__( 'Wide', 'emarket' ),
				'boxed' => esc_html__( 'Boxed', 'emarket' ),
				),
			'std' => 'full'
			),

		array(
			'id' => 'bg_box_img',
			'type' => 'upload',
			'title' => esc_html__('Background Box Image', 'emarket'),
			'sub_desc' => '',
			'std' => ''
			),
		array(
			'id' => 'layout_light',
			'type' => 'select',
			'title' => esc_html__('Layout Style', 'emarket'),
			'sub_desc' => esc_html__( 'Select Layout Dark or Light(Only work with #17 Gaming News)', 'emarket' ),
			'options' => array(
				'dark' => esc_html__( 'Dark', 'emarket' ),
				'light' => esc_html__( 'Light', 'emarket' ),
				),
			'std' => ''
			),
		array(
			'id' => 'sidebar_left_expand',
			'type' => 'select',
			'title' => esc_html__('Left Sidebar Expand', 'emarket'),
			'options' => array(
				'2' => '2/12',
				'3' => '3/12',
				'4' => '4/12',
				'5' => '5/12', 
				'6' => '6/12',
				'7' => '7/12',
				'8' => '8/12',
				'9' => '9/12',
				'10' => '10/12',
				'11' => '11/12',
				'12' => '12/12'
				),
			'std' => '3',
			'sub_desc' => esc_html__( 'Select width of left sidebar.', 'emarket' ),
			),

		array(
			'id' => 'sidebar_right_expand',
			'type' => 'select',
			'title' => esc_html__('Right Sidebar Expand', 'emarket'),
			'options' => array(
				'2' => '2/12',
				'3' => '3/12',
				'4' => '4/12',
				'5' => '5/12',
				'6' => '6/12',
				'7' => '7/12',
				'8' => '8/12',
				'9' => '9/12',
				'10' => '10/12',
				'11' => '11/12',
				'12' => '12/12'
				),
			'std' => '3',
			'sub_desc' => esc_html__( 'Select width of right sidebar medium desktop.', 'emarket' ),
			),
		array(
			'id' => 'sidebar_left_expand_md',
			'type' => 'select',
			'title' => esc_html__('Left Sidebar Medium Desktop Expand', 'emarket'),
			'options' => array(
				'2' => '2/12',
				'3' => '3/12',
				'4' => '4/12',
				'5' => '5/12',
				'6' => '6/12',
				'7' => '7/12',
				'8' => '8/12',
				'9' => '9/12',
				'10' => '10/12',
				'11' => '11/12',
				'12' => '12/12'
				),
			'std' => '4',
			'sub_desc' => esc_html__( 'Select width of left sidebar medium desktop.', 'emarket' ),
			),
		array(
			'id' => 'sidebar_right_expand_md',
			'type' => 'select',
			'title' => esc_html__('Right Sidebar Medium Desktop Expand', 'emarket'),
			'options' => array(
				'2' => '2/12',
				'3' => '3/12',
				'4' => '4/12',
				'5' => '5/12',
				'6' => '6/12',
				'7' => '7/12',
				'8' => '8/12',
				'9' => '9/12',
				'10' => '10/12',
				'11' => '11/12',
				'12' => '12/12'
				),
			'std' => '4',
			'sub_desc' => esc_html__( 'Select width of right sidebar.', 'emarket' ),
			),
		array(
			'id' => 'sidebar_left_expand_sm',
			'type' => 'select',
			'title' => esc_html__('Left Sidebar Tablet Expand', 'emarket'),
			'options' => array(
				'2' => '2/12',
				'3' => '3/12',
				'4' => '4/12',
				'5' => '5/12',
				'6' => '6/12',
				'7' => '7/12',
				'8' => '8/12',
				'9' => '9/12',
				'10' => '10/12',
				'11' => '11/12',
				'12' => '12/12'
				),
			'std' => '4',
			'sub_desc' => esc_html__( 'Select width of left sidebar tablet.', 'emarket' ),
			),
		array(
			'id' => 'sidebar_right_expand_sm',
			'type' => 'select',
			'title' => esc_html__('Right Sidebar Tablet Expand', 'emarket'),
			'options' => array(
				'2' => '2/12',
				'3' => '3/12',
				'4' => '4/12',
				'5' => '5/12',
				'6' => '6/12',
				'7' => '7/12',
				'8' => '8/12',
				'9' => '9/12',
				'10' => '10/12',
				'11' => '11/12',
				'12' => '12/12'
				),
			'std' => '4',
			'sub_desc' => esc_html__( 'Select width of right sidebar tablet.', 'emarket' ),
			),				
		)
	);
	
	if( get_post_meta( $layout_ID, '_elementor_edit_mode', true ) == 'builder' ) {
		$options[] = array(
			'title' => esc_html__('Header & Footer', 'emarket'),
			'desc' => wp_kses( __('<p class="description">SmartAddons Framework comes with a header and footer setting that allows you to build style header.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
					//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
					//You dont have to though, leave it emarket for default.
			'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_336_read_it_later.png',
					//Lets leave this as a emarket section, no options just some intro text set above.
			'fields' => array(
				array(
					'id' => 'enable_elementor',
					'title' => esc_html__( 'Enable Header & Footer Elementor', 'emarket' ),
					'type' => 'checkbox',
					'sub_desc' => esc_html__( 'Turn on/off Header & Footer elementor on some pages', 'emarket' ),
					'desc' => '',
					'std' => '0'
				),
				array(
					'id' => 'disable_search',
					'title' => esc_html__( 'Disable Search', 'emarket' ),
					'type' => 'checkbox',
					'sub_desc' => esc_html__( 'Check this to disable search on header', 'emarket' ),
					'desc' => '',
					'std' => '0'
				),

				array(
					'id' => 'disable_cart',
					'title' => esc_html__( 'Disable Cart', 'emarket' ),
					'type' => 'checkbox',
					'sub_desc' => esc_html__( 'Check this to disable cart on header', 'emarket' ),
					'desc' => '',
					'std' => '0'
				),
				
				array(
					'id' => 'header_layout',
					'type' => 'header_select',
					'title' => esc_html__('Header Style', 'emarket'),
					'sub_desc' => esc_html__('Select header template for your site', 'emarket'),
					'std' => ''
				),

				array(
					'id' => 'footer_layout',
					'type' => 'footer_select',
					'title' => esc_html__('Footer Style', 'emarket'),
					'sub_desc' => esc_html__('Select footer template for your site', 'emarket'),
					'std' => ''
				),
			)
		);
	}else{
		$options[] = array(
			'title' => esc_html__('Header & Footer', 'emarket'),
			'desc' => wp_kses( __('<p class="description">SmartAddons Framework comes with a header and footer setting that allows you to build style header.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
					//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
					//You dont have to though, leave it emarket for default.
			'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_336_read_it_later.png',
					//Lets leave this as a emarket section, no options just some intro text set above.
			'fields' => array(
				array(
					'id' => 'header_style',
					'type' => 'select',
					'title' => esc_html__('Header Style', 'emarket'),
					'sub_desc' => esc_html__('Select Header style', 'emarket'),
					'options' => array(
						'style1'  => esc_html__( 'Style 1', 'emarket' ),
						'style2'  => esc_html__( 'Style 2', 'emarket' ),
						'style3'  => esc_html__( 'Style 3', 'emarket' ),
						'style4'  => esc_html__( 'Style 4', 'emarket' ),
						'style5'  => esc_html__( 'Style 5', 'emarket' ),
						'style6'  => esc_html__( 'Style 6', 'emarket' ),
						'style7'  => esc_html__( 'Style 7', 'emarket' ),
						'style8'  => esc_html__( 'Style 8', 'emarket' ),
						'style9'  => esc_html__( 'Style 9', 'emarket' ),
						'style10'  => esc_html__( 'Style 10', 'emarket' ),
						'style11'  => esc_html__( 'Style 11', 'emarket' ),
						'style12'  => esc_html__( 'Style 12', 'emarket' ),
						'style13'  => esc_html__( 'Style 13', 'emarket' ),
						'style14'  => esc_html__( 'Style 14', 'emarket' ),
						'style15'  => esc_html__( 'Style 15', 'emarket' ),
						'style16'  => esc_html__( 'Style 16', 'emarket' ),
						'style17'  => esc_html__( 'Style 17', 'emarket' ),
						'style18'  => esc_html__( 'Style 18', 'emarket' ),
						),
					'std' => 'style1'
					),

				array(
					'id' => 'disable_search',
					'title' => esc_html__( 'Disable Search', 'emarket' ),
					'type' => 'checkbox',
					'sub_desc' => esc_html__( 'Check this to disable search on header', 'emarket' ),
					'desc' => '',
					'std' => '0'
					),

				array(
					'id' => 'disable_cart',
					'title' => esc_html__( 'Disable Cart', 'emarket' ),
					'type' => 'checkbox',
					'sub_desc' => esc_html__( 'Check this to disable cart on header', 'emarket' ),
					'desc' => '',
					'std' => '0'
					),				

				array(
					'id' => 'footer_style',
					'type' => 'pages_select',
					'title' => esc_html__('Footer Style', 'emarket'),
					'sub_desc' => esc_html__('Select Footer style', 'emarket'),
					'std' => ''
					),

				array(
					'id' => 'copyright_style',
					'type' => 'select',
					'title' => esc_html__('Copyright Style', 'emarket'),
					'sub_desc' => esc_html__('Select Copyright style', 'emarket'),
					'options' => array(
						'style1'  => esc_html__( 'Style 1', 'emarket' ),
						'style2'  => esc_html__( 'Style 2', 'emarket' ),
						'style3'  => esc_html__( 'Style 3', 'emarket' ),
						'style4'  => esc_html__( 'Style 4', 'emarket' ),
						),
					'std' => 'style1'
					),

				array(
					'id' => 'footer_copyright',
					'type' => 'editor',
					'sub_desc' => '',
					'title' => esc_html__( 'Copyright text', 'emarket' )
					),	

				)
		);
	}

	$options[] = array(
		'title' => esc_html__('Mobile Layout', 'emarket'),
		'desc' => wp_kses( __('<p class="description">SmartAddons Framework comes with a mobile setting home page layout.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_163_iphone.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(				
			array(
				'id' => 'mobile_enable',
				'type' => 'checkbox',
				'title' => esc_html__('Enable Mobile Layout', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
					'std' => '1'// 1 = on | 0 = off
			),
			
			array(
				'id' => 'mobile_elementor',
				'type' => 'checkbox',
				'title' => esc_html__('Enable Mobile Elementor for other page', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
					'std' => '1'// 1 = on | 0 = off
			),

			array(
				'id' => 'mobile_logo',
				'type' => 'upload',
				'title' => esc_html__('Logo Mobile Image', 'emarket'),
				'sub_desc' => esc_html__( 'Use the Upload button to upload the new mobile logo', 'emarket' ),
				'std' => get_template_directory_uri().'/assets/img/logo-default.png'
				),
			
			array(
				'id' => 'mobile_logo_account',
				'type' => 'upload',
				'title' => esc_html__('Logo Mobile My Account Page', 'emarket'),
				'sub_desc' => esc_html__( 'Use the Upload button to upload the new mobile logo in my account page', 'emarket' ),
				'std' => get_template_directory_uri().'/assets/img/icon-myaccount.png'
			),
			array(
				'id' => 'mobile_header',
				'type' => 'header_select',
				'title' => esc_html__('Mobile Header Elementor', 'emarket'),
				'sub_desc' => esc_html__('Select header elementor for this mobile layout', 'emarket'),
				'std' => ''
			),
			array(
				'id' => 'sticky_mobile',
				'type' => 'checkbox',
				'title' => esc_html__('Sticky Mobile', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
						'std' => '0'// 1 = on | 0 = off
						),

			array(
				'id' => 'mobile_content',
				'type' => 'pages_select',
				'title' => esc_html__('Mobile Layout Content', 'emarket'),
				'sub_desc' => esc_html__('Select content index for this mobile layout', 'emarket'),
				'std' => ''
				),

			array(
					'id' => 'mobile_footer',
					'type' => 'footer_select',
					'title' => esc_html__('Mobile Footer Elementor', 'emarket'),
					'sub_desc' => esc_html__('Select footer elementor for this mobile layout', 'emarket'),
					'std' => ''
				),
			array(
				'id' => 'mobile_header_style',
				'type' => 'select',
				'title' => esc_html__('Header Mobile Style', 'emarket'),
				'sub_desc' => esc_html__('Select header mobile style', 'emarket'),
				'options' => array(
					'mstyle1'  => esc_html__( 'Style 1', 'emarket' ),
					'mstyle2'  => esc_html__( 'Style 2', 'emarket' ),
					'mstyle3'  => esc_html__( 'Style 3', 'emarket' ),
					),
				'std' => 'style1'
				),

			array(
				'id' => 'mobile_footer_style',
				'type' => 'select',
				'title' => esc_html__('Footer Mobile Style', 'emarket'),
				'sub_desc' => esc_html__('Select footer mobile style', 'emarket'),
				'options' => array(
					'mstyle1'  => esc_html__( 'Style 1', 'emarket' ),
					'mstyle2'  => esc_html__( 'Style 2', 'emarket' ),
				),
				'std' => 'style1'
				),
			
			array(
				'id' => 'mobile_addcart',
				'type' => 'checkbox',
				'title' => esc_html__('Enable Add To Cart Button', 'emarket'),
				'sub_desc' => esc_html__( 'Enable Add To Cart Button on product listing', 'emarket' ),
				'desc' => '',
					'std' => '0'// 1 = on | 0 = off
			),
			
			array(
				'id' => 'mobile_header_inside',
				'type' => 'checkbox',
				'title' => esc_html__('Enable Header Other Pages', 'emarket'),
				'sub_desc' => esc_html__( 'Enable header in other pages which are different with homepage', 'emarket' ),
				'desc' => '',
					'std' => '0'// 1 = on | 0 = off
			),

			array(
				'id' => 'mobile_jquery',
				'type' => 'checkbox',
				'title' => esc_html__('Include Jquery Revolution', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
				'std' => '0'// 1 = on | 0 = off
				),
		)
	);

	$options[] = array(
		'title' => esc_html__('Navbar Options', 'emarket'),
		'desc' => wp_kses( __('<p class="description">If you got a big site with a lot of sub menus we recommend using a mega menu. Just select the dropbox to display a menu as mega menu or dropdown menu.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_157_show_lines.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(
			array(
				'id' => 'menu_type',
				'type' => 'select',
				'title' => esc_html__('Menu Type', 'emarket'),
				'options' => array( 'dropdown' => 'Dropdown Menu', 'mega' => 'Mega Menu' ),
				'std' => 'mega'
				),

			array(
				'id' => 'menu_location',
				'type' => 'menu_location_multi_select',
				'title' => esc_html__('Mega Menu Location', 'emarket'),
				'sub_desc' => esc_html__( 'Select theme location to active mega menu.', 'emarket' ),
				'std' => 'primary_menu'
				),		
			array(
				'id' => 'more_menu',
				'type' => 'checkbox',
				'title' => esc_html__('Active More Menu', 'emarket'),
				'sub_desc' => esc_html__('Active more menu if your primary menu is too long', 'emarket'),
				'desc' => '',
				'std' => '0'// 1 = on | 0 = off
				),

			array(
				'id' => 'menu_event',
				'type' => 'select',
				'title' => esc_html__('Menu Event', 'emarket'),
				'options' => array( 'hover' => esc_html__( 'Hover Event', 'emarket' ), 'click' => esc_html__( 'Click Event', 'emarket' ) ),
				'std' => ''
				),

			array(
				'id' => 'info_typon2',
				'type' => 'info',
				'title' => esc_html__( 'Responsive Menu Config', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
			),
			
			array(
				'id' => 'mobile_menu',
				'type' => 'menu_location_multi_select',
				'title' => esc_html__('Mobile & Responsive Menu Location', 'emarket'),
				'sub_desc' => esc_html__( 'Select theme location to active mobile menu.', 'emarket' ),
				'std' => 'primary_menu'
			),
			
			array(
				'id' => 'mobile_menu_title',
				'type' => 'text',
				'title' => esc_html__('Mobile Menu Title', 'emarket'),
				'sub_desc' => esc_html__( 'Change title heading of menu responsive. If there are many menu, each title separated by commas.', 'emarket' ),
				'std' => ''
			),
			)
	);
	$options[] = array(
		'title' => esc_html__('Blog Options', 'emarket'),
		'desc' => wp_kses( __('<p class="description">Select layout in blog listing page.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
			//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
			//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_071_book.png',
			//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(
			array(
				'id' => 'sidebar_blog',
				'type' => 'select',
				'title' => esc_html__('Sidebar Blog Layout', 'emarket'),
				'options' => array(
					'full' => esc_html__( 'Full Layout', 'emarket' ),		
					'left'	=>  esc_html__( 'Left Sidebar', 'emarket' ),
					'right' => esc_html__( 'Right Sidebar', 'emarket' ),
					),
				'std' => 'left',
				'sub_desc' => esc_html__( 'Select style sidebar blog', 'emarket' ),
				),
			array(
				'id' => 'blog_layout',
				'type' => 'select',
				'title' => esc_html__('Blog Layout', 'emarket'),
				'options' => array(
					'list'	=>  esc_html__( 'List Layout', 'emarket' ),
					'grid' =>  esc_html__( 'Grid Layout', 'emarket' ),	
					),
				'std' => 'list',
				'sub_desc' => esc_html__( 'Select style layout blog', 'emarket' ),
				),
			
			array(
				'id' => 'blog_style',
				'type' => 'select',
				'title' => esc_html__('Blog Style', 'emarket'),
				'options' => array(
					'default'	   =>  esc_html__( 'Default Style', 'emarket' ),
					'home-style17' => esc_html__( 'Games Style', 'emarket' ),								
					'blog-style-service' => esc_html__( 'Service Style', 'emarket' ),								
					'home-style57' => esc_html__( 'Home57 Style', 'emarket' ),								
					),
				'std' => '',
				'sub_desc' => esc_html__( 'Select Blog Style. Please include style #17 Gaming News if you choose Game Style.
										   Please include style #50 Professional & Business if you choose Service Style', 'emarket' ),
				),
				
			array(
				'id' => 'blog_column',
				'type' => 'select',
				'title' => esc_html__('Blog column', 'emarket'),
				'options' => array(								
					'2' => '2 columns',
					'3' => '3 columns',
					'4' => '4 columns'								
					),
				'std' => '2',
				'sub_desc' => esc_html__( 'Select style number column blog', 'emarket' ),
				),
			)
	);	
	$options[] = array(
		'title' => esc_html__('Product Options', 'emarket'),
		'desc' => wp_kses( __('<p class="description">Select layout in product listing page.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
			//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
			//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_202_shopping_cart.png',
			//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(
			array(
				'id' => 'info_typo1',
				'type' => 'info',
				'title' => esc_html( 'Product Categories Config', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),
			
			array(
				'id' => 'product_colcat_large',
				'type' => 'select',
				'title' => esc_html__('Product Category Listing column Desktop', 'emarket'),
				'options' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',							
					),
				'std' => '4',
				'sub_desc' => esc_html__( 'Select number of column on Desktop Screen', 'emarket' ),
				),

			array(
				'id' => 'product_colcat_medium',
				'type' => 'select',
				'title' => esc_html__('Product Listing Category column Medium Desktop', 'emarket'),
				'options' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',	
					'5' => '5',
					'6' => '6',
					),
				'std' => '3',
				'sub_desc' => esc_html__( 'Select number of column on Medium Desktop Screen', 'emarket' ),
				),

			array(
				'id' => 'product_colcat_sm',
				'type' => 'select',
				'title' => esc_html__('Product Listing Category column Tablet', 'emarket'),
				'options' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',	
					'5' => '5',
					'6' => '6'
					),
				'std' => '2',
				'sub_desc' => esc_html__( 'Select number of column on Tablet Screen', 'emarket' ),
				),
			
			array(
				'id' => 'info_typo1',
				'type' => 'info',
				'title' => esc_html( 'Product General Config', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),
			array(
				'id' => 'product_items_layout',
				'type' => 'radio_img',
				'title' => esc_html__('Product Items Layout', 'emarket'),
				'options' => apply_filters( 'swg_product_items_layout_args', array() ),
				'std' => 'default',
				'sub_desc' => esc_html__( 'Select layout for item product', 'emarket' ),
				'class'	=> 'emarket-layout-radio'
			),
			
			array(
				'id' => 'product_add_cart_text',
				'type' => 'text',
				'title' => esc_html__("Add To Cart Text", 'emarket'),
				'sub_desc' => esc_html__( 'You can replace add to cart text by this text', 'emarket' ),
				'std' => '',
			),
			
			array(
				'id' => 'product_loadmore',
				'title' => esc_html__( 'Enable load more product listing', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off load more in product listing', 'emarket' ),
				'std' => '1'
				),
				
			array(
				'id' => 'product_loadmore_style',
				'title' => esc_html__( 'Select style load more ajax', 'emarket' ),
				'type' => 'select',
				'options' => array(
					'0' => esc_html__( 'Click', 'emarket' ),
					'1' => esc_html__( 'Scroll', 'emarket' )					
					),
				'std' => '0',
				'sub_desc' => esc_html__( 'Select style for ajax load more in product listing', 'emarket' ),
				),
			
			array(
				'id' => 'product_layout',
				'type' => 'select',
				'title' => esc_html__('Shop Layout', 'emarket'),
				'options' => array(
					'grid' 	=>  esc_html__( 'Grid Layout', 'emarket' ),
					'list2'	=>  esc_html__( 'List Layout', 'emarket' )											
				),
				'std' => 'grid',
				'sub_desc' => esc_html__( 'Select style layout product', 'emarket' ),
			),
			
			array(
				'id' => 'product_recent_viewed',
				'type' => 'multi_select',
				'title' => esc_html__('Enable Recent Viewed Product', 'emarket'),
				'options' => array(
					'page' => esc_html__( 'Show on Page', 'emarket' ),
					'product' => esc_html__( 'Show on product detail', 'emarket' ),
					'product_cat' => esc_html__( 'Show on product listing', 'emarket' ),
					'category' => esc_html__( 'Show on blog listing', 'emarket' ),
					'post' => esc_html__( 'Show on blog detail', 'emarket' ),
				),
				'std' => 'page',
				'sub_desc' => esc_html__( 'Select page which you want to show widget recent viewed product', 'emarket' ),
			),
			
			array(
				'id' => 'product_filter_style',
				'type' => 'select',
				'title' => esc_html__('Types of Filters', 'emarket'),
				'options' => array(
					'dropdown' 	        =>  esc_html__( 'Filter Dropdown', 'emarket' ),
					'drawer'	=>  esc_html__( 'Filter  Drawer', 'emarket' ),
					'canvas' 	=>  esc_html__( 'Filter Off Canvas', 'emarket' ),
					'accordion'	=>  esc_html__( 'Filter  Accordion', 'emarket' )							
				),
				'std' => '',
				'sub_desc' => esc_html__( 'Select style Filter in shop. Filter Dropdown only work with full-width layout. Filter  Drawer only work with Left/right sidebar layout.', 'emarket' ),
			),
				
			array(
				'id' => 'product_categories',
				'title' => esc_html__( 'Top Categories Shop', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Top Categories Shop. Config Sidebar Product Layout Full width', 'emarket' ),
				'std' => '1'
				),
			
			array(
				'id' => 'bg_shop_bread',
				'title' => esc_html__( 'Background Shop Breadcrumb', 'emarket' ),
				'type' => 'upload',
				'sub_desc' => esc_html__( 'Choose background shop categories Breadcrumb image', 'emarket' ),
				'desc' => '',
				'std' => get_template_directory_uri().'/assets/img/maintaince/bg-main.jpg'
				),
				
			array(
				'id' => 'shop_modern',
				'title' => esc_html__( 'Shop Modern', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Shop Modern', 'emarket' ),
				'std' => '1'
				),
			
			array(
				'id' => 'bg_shop_modern',
				'type' => 'upload',
				'title' => esc_html__('Background Image Shop Modern', 'emarket'),
				'sub_desc' => esc_html__( 'Use the Upload button to upload Background Shop Modern', 'emarket' ),
				'std' => get_template_directory_uri().'/assets/img/bg-shop.jpg'
				),
				
			array(
				'id' => 'product_banner',
				'title' => esc_html__( 'Shop Banner Type', 'emarket' ),
				'type' => 'select',
				'sub_desc' => '',
				'options' => array(
					'img_banner' => esc_html__( 'Use Banner', 'emarket' ),
					'page' => esc_html__( 'Use Page Content', 'emarket' ),
					'listing' => esc_html__( 'Use Category Product Image', 'emarket' ),
					),
				'std' => '',
				),		
			
			array(
				'id' => 'product_listing_banner',
				'type' => 'upload',
				'title' => esc_html__('Banner Image', 'emarket'),
				'sub_desc' => esc_html__( 'Use the Upload button to upload banner product listing', 'emarket' ),
				'std' => get_template_directory_uri().'/assets/img/logo-default.png'
				),
				
			array(
				'id' => 'link_banner_shop',
				'type' => 'text',
				'title' => esc_html__("Banner's Link", 'emarket'),
				'sub_desc' => esc_html__( 'Use the link for the banner product listing', 'emarket' ),
				'std' => '',
				),
				
			array(
				'id' => 'shop_content_top',
				'type' => 'pages_select',
				'title' => esc_html__('Shop Content Top', 'emarket'),
				'sub_desc' => esc_html__('Select content index for this shop layout', 'emarket'),
				'std' => ''
			),
			
			array(
				'id' => 'product_col_large',
				'type' => 'select',
				'title' => esc_html__('Product Listing column Desktop', 'emarket'),
				'options' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',							
					),
				'std' => '4',
				'sub_desc' => esc_html__( 'Select number of column on Desktop Screen', 'emarket' ),
				),

			array(
				'id' => 'product_col_medium',
				'type' => 'select',
				'title' => esc_html__('Product Listing column Medium Desktop', 'emarket'),
				'options' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',	
					'5' => '5',
					'6' => '6',
					),
				'std' => '3',
				'sub_desc' => esc_html__( 'Select number of column on Medium Desktop Screen', 'emarket' ),
				),

			array(
				'id' => 'product_col_sm',
				'type' => 'select',
				'title' => esc_html__('Product Listing column Tablet', 'emarket'),
				'options' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',	
					'5' => '5',
					'6' => '6'
					),
				'std' => '2',
				'sub_desc' => esc_html__( 'Select number of column on Tablet Screen', 'emarket' ),
				),
			
			array(
			'id' => 'product_col_mb',
			'type' => 'select',
			'title' => esc_html__('Product Listing column Mobile', 'emarket'),
			'options' => array(
				'1' => '1',
				'2' => '2',
				),
			'std' => '1',
			'sub_desc' => esc_html__( 'Select number of column on Mobile Screen', 'emarket' ),
			),
			array(
				'id' => 'sidebar_product',
				'type' => 'select',
				'title' => esc_html__('Sidebar Product Layout', 'emarket'),
				'options' => array(
					'left'	=> esc_html__( 'Left Sidebar', 'emarket' ),
					'full' => esc_html__( 'Full Layout', 'emarket' ),		
					'right' => esc_html__( 'Right Sidebar', 'emarket' )
					),
				'std' => 'left',
				'sub_desc' => esc_html__( 'Select style sidebar product', 'emarket' ),
				),
			
			array(
				'id' => 'sidebar_product_width',
				'title' => esc_html__( 'Sidebar Width', 'emarket' ),
				'type' => 'number_slider',
				'sub_desc' => esc_html__( 'Set sidebar width when you select sidebar product is left or right on screens wider than 1200px.', 'emarket' ),
				'max' => 600,
				'min' => 200,
				'desc' => '',
				'std' => [270, 'px']
			),
			
			array(
				'id' => 'shop_button_style',
				'type' => 'select',
				'title' => esc_html__('Shop Button Style', 'emarket'),
				'options' => array(
					'default'   =>  esc_html__( 'Default', 'emarket' ),
					'style28'	=>  esc_html__( 'Style 28', 'emarket' ),							
					'style29'	=>  esc_html__( 'Style 29', 'emarket' ),							
					'style30'	=>  esc_html__( 'Style 30', 'emarket' ),							
					'style31'	=>  esc_html__( 'Style 31', 'emarket' ),							
					'style33'	=>  esc_html__( 'Style 33', 'emarket' ),							
					'style34'	=>  esc_html__( 'Style 34', 'emarket' ),							
				),
				'std' => 'default',
				'sub_desc' => esc_html__( 'Select Shop button style by button style Home Page', 'emarket' ),
			),
			
			array(
				'id' => 'product_percent_sale',
				'title' => esc_html__( 'Show % Sale', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Product % Sale', 'emarket' ),
				'std' => '1'
				),
				
			array(
				'id' => 'product_quickview',
				'title' => esc_html__( 'Quickview', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Product Quickview', 'emarket' ),
				'std' => '1'
				),
			
			array(
				'id' => 'product_listing_countdown',
				'title' => esc_html__( 'Enable Countdown', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Product Countdown on product listing', 'emarket' ),
				'std' => '1'
				),
			
			array(
				'id' => 'product_soldout',
				'title' => esc_html__( 'Product Sold Out', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off product sold out label', 'emarket' ),
				'std' => '1'
				),
				
			
			array(
				'id' => 'product_thumb_hover',
				'title' => esc_html__( 'Product Thumbnail hover', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off product image thumbnail hover', 'emarket' ),
				'std' => '1'
				),
				
			array(
				'id' => 'sticky_sidebar',
				'type' => 'checkbox',
				'title' => esc_html__('Active sticky Sidebar', 'emarket'),
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off product sticky sidebar', 'emarket' ),
				'std' => '0'// 1 = on | 0 = off
				),
				
			array(
				'id' => 'product_number',
				'type' => 'text',
				'title' => esc_html__('Product Listing Number', 'emarket'),
				'sub_desc' => esc_html__( 'Show number of product in listing product page.', 'emarket' ),
				'std' => 12
				),
			
			array(
					'id' => 'newproduct_time',
					'title' => esc_html__( 'New Product', 'emarket' ),
					'type' => 'number',
					'sub_desc' => '',
					'desc' => esc_html__( 'Set day for the new product label from the date publish product.', 'emarket' ),
					'std' => '1'
					),
			
			array(
				'id' => 'info_typo1',
				'type' => 'info',
				'title' => esc_html( 'Product Single Config', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),
			
			array(
				'id' => 'sidebar_product_detail',
				'type' => 'select',
				'title' => esc_html__('Sidebar Product Single Layout', 'emarket'),
				'options' => array(
					'left'	=> esc_html__( 'Left Sidebar', 'emarket' ),
					'full' => esc_html__( 'Full Layout', 'emarket' ),		
					'right' => esc_html__( 'Right Sidebar', 'emarket' )
					),
				'std' => 'left',
				'sub_desc' => esc_html__( 'Select style sidebar product single', 'emarket' ),
				),
			
			array(
				'id' => 'sidebar_product_detail_width',
				'title' => esc_html__( 'Sidebar Width', 'emarket' ),
				'type' => 'number_slider',
				'sub_desc' => esc_html__( 'Set sidebar width when you select sidebar product detail is left or right on screens wider than 1200px.', 'emarket' ),
				'max' => 600,
				'min' => 170,
				'desc' => '',
				'std' => [270, 'px']
			),	
			
			array(
				'id' => 'product_single_style',
				'type' => 'select',
				'title' => esc_html__('Product Detail Style', 'emarket'),
				'options' => array(
					'default'	=> esc_html__( 'Default', 'emarket' ),
					'style1' 	=> esc_html__( 'Full Width', 'emarket' ),	
					'style2' 	=> esc_html__( 'Full Width - Accordion Style 1', 'emarket' ),	
					'style3' 	=> esc_html__( 'Full Width - Accordion Style 2', 'emarket' ),	
					'style4' 	=> esc_html__( 'Extra Sidebar', 'emarket' ),	
					'style5' 	=> esc_html__( 'Full Width Page Sticky', 'emarket' ),	
					'style6' 	=> esc_html__( 'Full Width Brand', 'emarket' ),	
					'style7' 	=> esc_html__( 'Full Canvas Sidebar', 'emarket' ),	
					'style8' 	=> esc_html__( 'Full Page Hidden', 'emarket' ),	
					'style9' 	=> esc_html__( 'Printing Page Style', 'emarket' ),	
				),
				'std' => 'default',
				'sub_desc' => esc_html__( 'Select style for product single', 'emarket' ),
				),
			array(
				'id' => 'sticky_single_product',
				'type' => 'select',
				'title' => esc_html__('Product Single Sticky', 'emarket'),
				'options' => array(
					''	=> esc_html__( 'Disable Sticky', 'emarket' ),
					'top'	=> esc_html__( 'Sticky Top', 'emarket' ),
					'bottom' 		=> esc_html__( 'Sticky Bottom', 'emarket' ),			
				),
				'std' => '',
				'sub_desc' => esc_html__( 'Select single product sticky', 'emarket' ),
			),	
			
			// array(
				// 'id' => 'label_sale_off',
				// 'type' => 'checkbox',
				// 'title' => esc_html__('Show Label Sale %', 'emarket'),
				// 'desc' => '',
				// 'sub_desc' => esc_html__( 'Turn On/Off Show Label Sale %', 'emarket' ),
				// 'std' => '1'// 1 = on | 0 = off
				// ),
				
			array(
				'id' => 'product_single_thumbnail',
				'type' => 'select',
				'title' => esc_html__('Product Thumbnail Position', 'emarket'),
				'options' => array(
					'bottom'	=> esc_html__( 'Bottom', 'emarket' ),
					'left' 		=> esc_html__( 'Left', 'emarket' ),	
					'right' 	=> esc_html__( 'Right', 'emarket' ),	
					'top' 		=> esc_html__( 'Top', 'emarket' ),					
				),
				'std' => 'bottom',
				'sub_desc' => esc_html__( 'Select style for product single thumbnail', 'emarket' ),
				),	
			
			array(
				'id' => 'product_shortcode_form',
				'type' => 'text',
				'title' => esc_html__( 'Short Code Form Sold Out Product', 'emarket' ),
				'sub_desc' => esc_html__( 'Put your shortcode form to show on product which was sold out', 'emarket' ),
				'std' => ''
			),	
				
			array(
				'id' => 'product_zoom',
				'title' => esc_html__( 'Product Zoom', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off image zoom when hover on single product', 'emarket' ),
				'std' => '1'
				),
			
			array(
				'id' => 'product_brand',
				'title' => esc_html__( 'Enable Product Brand Image', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off product brand image show on single product.', 'emarket' ),
				'std' => '1'
				),

			array(
				'id' => 'product_single_countdown',
				'title' => esc_html__( 'Enable Countdown Single', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Product Countdown on product single', 'emarket' ),
				'std' => '1'
				),
			
			array(
				'id' => 'product_single_buynow',
				'title' => esc_html__( 'Enable Buy Now Button', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off buy now button on product single and quickview', 'emarket' ),
				'std' => '1'
			),
			
			array(
				'id' => 'product_single_full_bg',
				'title' => esc_html__( 'Enable Product Single Full background', 'emarket' ),
				'type' => 'checkbox',
				'desc' => '',
				'sub_desc' => esc_html__( 'Turn On/Off Product Single Full', 'emarket' ),
				'std' => '1'
			),		
			array(
				'id' => 'info_typo1',
				'type' => 'info',
				'title' => esc_html( 'Config For Product Categories Widget', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),
			
			array(
				'id' => 'product_categories_accordion',
				'title' => esc_html__( 'Enable accordion for widget categories', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => '',
				'desc' => '',
				'std' => '1'
				),
					
			array(
				'id' => 'product_number_item',
				'type' => 'text',
				'title' => esc_html__( 'Category Number Item Show', 'emarket' ),
				'sub_desc' => esc_html__( 'Choose to number of item category that you want to show, leave 0 to show all category', 'emarket' ),
				'std' => 8
				),	

			array(
				'id' => 'product_more_text',
				'type' => 'text',
				'title' => esc_html__( 'Category More Text', 'emarket' ),
				'sub_desc' => esc_html__( 'Change more text on category product', 'emarket' ),
				'std' => ''
				),

			array(
				'id' => 'product_less_text',
				'type' => 'text',
				'title' => esc_html__( 'Category Less Text', 'emarket' ),
				'sub_desc' => esc_html__( 'Change less text on category product', 'emarket' ),
				'std' => ''
				)	
			)
	);		
	$options[] = array(
		'title' => esc_html__('Typography', 'emarket'),
		'desc' => wp_kses( __('<p class="description">Change the font style of your blog, custom with Google Font.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_151_edit.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(
			array(
				'id' => 'info_typo1',
				'type' => 'info',
				'title' => esc_html( 'Global Typography', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),

			array(
				'id' => 'google_webfonts',
				'type' => 'google_webfonts',
				'title' => esc_html__('Use Google Webfont', 'emarket'),
				'sub_desc' => esc_html__( 'Insert font style that you actually need on your webpage.', 'emarket' ), 
				'std' => ''
				),

			array(
				'id' => 'webfonts_weight',
				'type' => 'multi_select',
				'sub_desc' => esc_html__( 'For weight, see Google Fonts to custom for each font style.', 'emarket' ),
				'title' => esc_html__('Webfont Weight', 'emarket'),
				'options' => array(
					'100' => '100',
					'200' => '200',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900'
					),
				'std' => ''
				),

			array(
				'id' => 'info_typo2',
				'type' => 'info',
				'title' => esc_html( 'Header Tag Typography', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),

			array(
				'id' => 'header_tag_font',
				'type' => 'google_webfonts',
				'title' => esc_html__('Header Tag Font', 'emarket'),
				'sub_desc' => esc_html__( 'Select custom font for header tag ( h1...h6 )', 'emarket' ), 
				'std' => ''
				),

			array(
				'id' => 'info_typo2',
				'type' => 'info',
				'title' => esc_html( 'Main Menu Typography', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
				),

			array(
				'id' => 'menu_font',
				'type' => 'google_webfonts',
				'title' => esc_html__('Main Menu Font', 'emarket'),
				'sub_desc' => esc_html__( 'Select custom font for main menu', 'emarket' ), 
				'std' => ''
				),
				
			array(
				'id' => 'info_typo2',
				'type' => 'info',
				'title' => esc_html( 'Custom Typography', 'emarket' ),
				'desc' => '',
				'class' => 'emarket-opt-info'
			),

			array(
				'id' => 'custom_font',
				'type' => 'google_webfonts',
				'title' => esc_html__('Custom Font', 'emarket'),
				'sub_desc' => esc_html__( 'Select custom font for custom class', 'emarket' ), 
				'std' => ''
			),
			
			array(
				'id' => 'custom_font_class',
				'title' => esc_html__( 'Custom Font Class', 'emarket' ),
				'type' => 'text',
				'sub_desc' => esc_html__( 'Put custom class to this field. Each class separated by commas.', 'emarket' ),
				'desc' => '',
				'std' => '',
			),
			
			array(
				'id' => 'custom_font_2',
				'type' => 'google_webfonts',
				'title' => esc_html__('Custom Font 2', 'emarket'),
				'sub_desc' => esc_html__( 'Select custom font for custom class2', 'emarket' ), 
				'std' => ''
			),
			
			array(
				'id' => 'custom_font_class2',
				'title' => esc_html__( 'Custom Font Class 2', 'emarket' ),
				'type' => 'text',
				'sub_desc' => esc_html__( 'Put custom class to this field. Each class separated by commas2.', 'emarket' ),
				'desc' => '',
				'std' => '',
			),
		)
	);
	if( !get_post_meta( $layout_ID, '_elementor_edit_mode', true ) == 'builder' ) {
		$options[] = array(
			'title' => __('Social', 'emarket'),
			'desc' => wp_kses( __('<p class="description">This feature allow to you link to your social.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it blank for default.
			'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_222_share.png',
				//Lets leave this as a blank section, no options just some intro text set above.
			'fields' => array(
				array(
					'id' => 'social-share-fb',
					'title' => esc_html__( 'Facebook', 'emarket' ),
					'type' => 'text',
					'sub_desc' => '',
					'desc' => '',
					'std' => '',
					),
				array(
					'id' => 'social-share-tw',
					'title' => esc_html__( 'Twitter', 'emarket' ),
					'type' => 'text',
					'sub_desc' => '',
					'desc' => '',
					'std' => '',
					),
				array(
					'id' => 'social-share-tumblr',
					'title' => esc_html__( 'Tumblr', 'emarket' ),
					'type' => 'text',
					'sub_desc' => '',
					'desc' => '',
					'std' => '',
					),
				array(
					'id' => 'social-share-in',
					'title' => esc_html__( 'Linkedin', 'emarket' ),
					'type' => 'text',
					'sub_desc' => '',
					'desc' => '',
					'std' => '',
					),
				array(
					'id' => 'social-share-instagram',
					'title' => esc_html__( 'Instagram', 'emarket' ),
					'type' => 'text',
					'sub_desc' => '',
					'desc' => '',
					'std' => '',
					),
				array(
					'id' => 'social-share-pi',
					'title' => esc_html__( 'Pinterest', 'emarket' ),
					'type' => 'text',
					'sub_desc' => '',
					'desc' => '',
					'std' => '',
					)

				)
		);
	}
	$options[] = array(
		'title' => __('Social Share', 'emarket'),
		'desc' => wp_kses( __('<p class="description">This feature allow to you link to your social.</p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
			//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
			//You dont have to though, leave it blank for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_222_share.png',
			//Lets leave this as a blank section, no options just some intro text set above.
		'fields' => array(
			array(
				'id' => 'social_share',
				'title' => esc_html__( 'Social Share', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share', 'emarket' ),
				'desc' => '',
				'std' => '1'
				),
			
			array(
				'id' => 'social_share_fb',
				'title' => esc_html__( 'Facebook', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share Facebook', 'emarket' ),
				'desc' => '',
				'std' => '1'
			),
			
			array(
				'id' => 'social_share_tw',
				'title' => esc_html__( 'Twitter', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share Twitter', 'emarket' ),
				'desc' => '',
				'std' => '1'
			),
			
			array(
				'id' => 'social_share_pi',
				'title' => esc_html__( 'Pinterest', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share Pinterest', 'emarket' ),
				'desc' => '',
				'std' => '1'
			),
			
			array(
				'id' => 'social_share_em',
				'title' => esc_html__( 'Email', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share Email', 'emarket' ),
				'desc' => '',
				'std' => ''
			),
			
			array(
				'id' => 'social_share_linkedin',
				'title' => esc_html__( 'Linkedin', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share Linkedin', 'emarket' ),
				'desc' => '',
				'std' => '1'
			),
			
			array(
				'id' => 'social_share_app',
				'title' => esc_html__( 'WhatsApp', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share WhatsApp', 'emarket' ),
				'desc' => '',
				'std' => ''
			),
			
			array(
				'id' => 'social_share_telegram',
				'title' => esc_html__( 'Telegram', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn on/off social share Telegram', 'emarket' ),
				'desc' => '',
				'std' => ''
			),
		)
	);

	$options[] = array(
		'title' => esc_html__('Advanced Plugin', 'emarket'),
		'desc' => wp_kses( __('<p class="description">Custom advanced plugin with Cpanel </p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_083_random.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(		

			array(
				'id' => 'testimonial_enable',
				'title' => esc_html__( 'Turn Off Testimonial', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn off testimonial', 'emarket' ),
				'desc' => '',
				'std' => '0'
				),
				
			array(
				'id' => 'portfolio_enable',
				'title' => esc_html__( 'Turn Off Portfolio', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn off portfolio', 'emarket' ),
				'desc' => '',
				'std' => '0'
				),
		)
	);

	$options[] = array(
		'title' => esc_html__('Advanced', 'emarket'),
		'desc' => wp_kses( __('<p class="description">Custom advanced with Cpanel, Widget advanced, Developer mode </p>', 'emarket'), array( 'p' => array( 'class' => array() ) ) ),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it emarket for default.
		'icon' => EMARKET_URL.'/options/img/glyphicons/glyphicons_083_random.png',
				//Lets leave this as a emarket section, no options just some intro text set above.
		'fields' => array(		

			array(
				'id' => 'breadcrumb_active',
				'title' => esc_html__( 'Turn Off Breadcrumb', 'emarket' ),
				'type' => 'checkbox',
				'sub_desc' => esc_html__( 'Turn off breadcumb on all page', 'emarket' ),
				'desc' => '',
				'std' => '0'
				),

			array(
				'id' => 'back_active',
				'type' => 'checkbox',
				'title' => esc_html__('Back to top', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
							'std' => '1'// 1 = on | 0 = off
				),	
				
			array(
				'id' => 'preloader',
				'type' => 'checkbox',
				'title' => esc_html__('Preloader', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
				'std' => '0'// 1 = on | 0 = off
			),
			array(
				'id' => 'direction',
				'type' => 'checkbox',
				'title' => esc_html__('Direction RTL', 'emarket'),
				'sub_desc' => '',
				'desc' => '',
				'std' => '0'// 1 = on | 0 = off
			),
		)
	);

$options_args = array();

	//Setup custom links in the footer for share icons
$options_args['share_icons']['facebook'] = array(
	'link' => 'https://www.facebook.com/wpthemego',
	'title' => 'Facebook',
	'img' => EMARKET_URL.'/options/img/glyphicons/glyphicons_320_facebook.png'
	);
$options_args['share_icons']['twitter'] = array(
	'link' => 'https://twitter.com/wpthemego',
	'title' => 'Folow me on Twitter',
	'img' => EMARKET_URL.'/options/img/glyphicons/glyphicons_322_twitter.png'
	);
$options_args['share_icons']['linked_in'] = array(
	'link' => 'https://www.instagram.com/wpthemego/',
	'title' => 'Find me on LinkedIn',
	'img' => EMARKET_URL.'/options/img/glyphicons/glyphicons_337_linked_in.png'
	);


	//Choose a custom option name for your theme options, the default is the theme name in lowercase with spaces replaced by underscores
$options_args['opt_name'] = EMARKET_THEME;

	$options_args['google_api_key'] = 'AIzaSyCeJRBSK2P19K17ykCSqT0wZaGBZZ1oPmM'; //must be defined for use with google webfonts field type

	//Custom menu title for options page - default is "Options"
	$options_args['menu_title'] = esc_html__('Theme Options', 'emarket');

	//Custom Page Title for options page - default is "Options"
	$options_args['page_title'] = esc_html__('Emarket Options ', 'emarket') . wp_get_theme()->get('Name');

	//Custom page slug for options page (wp-admin/themes.php?page=***) - default is "emarket_theme_options"
	$options_args['page_slug'] = 'emarket_theme_options';

	//page type - "menu" (adds a top menu section) or "submenu" (adds a submenu) - default is set to "menu"
	$options_args['page_type'] = 'submenu';

	//custom page location - default 100 - must be unique or will override other items
	$options_args['page_position'] = 27;
	$emarket_options = new Emarket_Options( $options, $options_args );
}
add_action( 'admin_init', 'emarket_Options_Setup', 0 );
emarket_Options_Setup();

add_filter( 'sw_googlefont_api_key_filter', 'emarket_custom_google_api_key' );
function emarket_custom_google_api_key(){
	$webfont = ( emarket_options()->getCpanelValue( 'google_webfonts_api' ) != '' ) ? emarket_options()->getCpanelValue( 'google_webfonts_api' ) : 'AIzaSyCeJRBSK2P19K17ykCSqT0wZaGBZZ1oPmM';
	return $webfont;
}

function emarket_widget_setup_args(){
	$emarket_widget_areas = array(
		
		array(
			'name' => esc_html__('Sidebar Left Blog', 'emarket'),
			'id'   => 'left-blog',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
			),
		array(
			'name' => esc_html__('Sidebar Right Blog', 'emarket'),
			'id'   => 'right-blog',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
			),
		
		array(
			'name' => esc_html__('Top Header', 'emarket'),
			'id'   => 'top',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),

		array(
			'name' => esc_html__('Top Header3', 'emarket'),
			'id'   => 'top2',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Top Header6', 'emarket'),
			'id'   => 'top3',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Top Header7', 'emarket'),
			'id'   => 'top4',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		
		array(
			'name' => esc_html__('Top Header13', 'emarket'),
			'id'   => 'top5',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
			
		array(
			'name' => esc_html__('Mid Header', 'emarket'),
			'id'   => 'mid-header',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),

		array(
			'name' => esc_html__('Mid Header3', 'emarket'),
			'id'   => 'mid-header2',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),

		array(
			'name' => esc_html__('Mid Header6', 'emarket'),
			'id'   => 'mid-header6',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
			
		array(
			'name' => esc_html__('Mid Header9', 'emarket'),
			'id'   => 'mid-header9',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Bottom Right', 'emarket'),
			'id'   => 'bottom-right-home5',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Bottom Header', 'emarket'),
			'id'   => 'bottom-header',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Bottom Header6', 'emarket'),
			'id'   => 'bottom-header2',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Header Menu Bar', 'emarket'),
			'id'   => 'menu-bar',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		array(
			'name' => esc_html__('Sidebar Above Product', 'emarket'),
			'id'   => 'above-product',
			'before_widget' => '<div class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
		),
		
		array(
			'name' => esc_html__('Shop Categories', 'emarket'),
			'id'   => 'shop-categories',
			'before_widget' => '<div class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
		),
		
		array(
			'name' => esc_html__('Sidebar Left Product', 'emarket'),
			'id'   => 'left-product',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
			),
		
		array(
			'name' => esc_html__('Sidebar Right Product', 'emarket'),
			'id'   => 'right-product',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
			),

		array(
			'name' => esc_html__('Sidebar Left Detail Product', 'emarket'),
			'id'   => 'left-product-detail',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
			),
		
		array(
			'name' => esc_html__('Sidebar Right Detail Product', 'emarket'),
			'id'   => 'right-product-detail',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
			),
		
		array(
			'name' => esc_html__('Sidebar Extra Single Product', 'emarket'),
			'id'   => 'extra-product-detail',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
		),
		
		array(
			'name' => esc_html__('Sidebar Brand Single Product', 'emarket'),
			'id'   => 'brand-product-detail',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget' => '</div></div>',
			'before_title' => '<div class="block-title-widget"><h2><span>',
			'after_title' => '</span></h2></div>'
		),
		
		array(
			'name' => esc_html__('Sidebar Bottom Detail Product', 'emarket'),
			'id'   => 'bottom-detail-product',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s" data-scroll-reveal="enter bottom move 20px wait 0.2s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		
		array(
			'name' => esc_html__('Sidebar Bottom Detail Product Printing', 'emarket'),
			'id'   => 'bottom-detail-product2',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s" data-scroll-reveal="enter bottom move 20px wait 0.2s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
			
		array(
				'name' => esc_html__('Bottom Detail Product Mobile', 'emarket'),
				'id'   => 'bottom-detail-product-mobile',
				'before_widget' => '<div id="%1$s" class="widget %1$s %2$s" data-scroll-reveal="enter bottom move 20px wait 0.2s"><div class="widget-inner">',
				'after_widget'  => '</div></div>',
				'before_title'  => '<h3>',
				'after_title'   => '</h3>'
		),

		array(
				'name' => esc_html__('Filter Mobile', 'emarket'),
				'id'   => 'filter-mobile',
				'before_widget' => '<div id="%1$s" class="widget %1$s %2$s" data-scroll-reveal="enter bottom move 20px wait 0.2s"><div class="widget-inner">',
				'after_widget'  => '</div></div>',
				'before_title'  => '<h3>',
				'after_title'   => '</h3>'
		),
		array(
			'name' => esc_html__('Footer Copyright', 'emarket'),
			'id'   => 'footer-copyright',
			'before_widget' => '<div id="%1$s" class="widget %1$s %2$s"><div class="widget-inner">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>'
			),
		);
return apply_filters( 'emarket_widget_register', $emarket_widget_areas );
}