<?php
class Emarket_Options_header_select extends Emarket_Options{	
	
	/**
	 * Field Constructor.
	 *
	 * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
	 *
	 * @since Emarket_Options 1.0.1
	*/
	function __construct($field = array(), $value ='', $parent = null){
		
		parent::__construct($parent->sections, $parent->args, $parent->extra_tabs);
		$this->field = $field;
		$this->value = $value;
		
		
	}//function
	
	
	
	/**
	 * Field Render Function.
	 *
	 * Takes the vars and outputs the HTML for the field in the settings
	 *
	 * @since Emarket_Options 1.0.1
	*/
	function render(){
		
		$class = (isset($this->field['class']))? 'class="emarket-single-select '.esc_attr( $this->field['class'] ).'" ': 'class="emarket-single-select"';
		$placehold = ( isset( $this->field['placehold'] ) )? $this->field['placehold'] : esc_html__( 'Please select', 'emarket' );
		echo '<select id="'.esc_attr( $this->field['id'] ).'" name="'.$this->args['opt_name'].'['.$this->field['id'].']" '.$class.' data-placehold="'. esc_attr( $placehold ) .'">';
		echo '<option value="" selected>'.esc_html__( 'Select Header', 'emarket' ).'</option>';
		
		$args_headers = array();
		
		$headers = new WP_Query( array(
			'post_type' => 'hftemplate', 
			'orderby' => 'name', 
			'order' => 'ASC', 
			'showposts' => -1 
		));
		
		if( $headers->have_posts() ){
			foreach ( $headers->posts as $item ) {
				$meta = get_post_meta( $item->ID, '_elementor_page_settings', true );
				if( isset( $meta['template_type'] ) && $meta['template_type'] === 'header' ){
					$args_headers[$item->ID] = $item->post_title;
				}
			}
		}		
		wp_reset_postdata();
		
		$headers_pro = new WP_Query( array(
			'post_type' => 'elementor_library', 
			'orderby' => 'name', 
			'order' => 'ASC', 
			'meta_key' => '_elementor_template_type', 
			'meta_value' => 'header', 
			'showposts' => -1 
		));
		
		if( $headers_pro->have_posts() ){
			foreach ( $headers_pro->posts as $item ) {
				$args_headers[$item->ID] = $item->post_title . ' ' . esc_html__( '( Elementor Pro Template )', 'emarket' );
			}
		}
		
		foreach( $args_headers as $key => $item ){
			echo '<option value="'.esc_attr( $key ).'"'.selected($this->value, $key, false).'>'.esc_html( $item ).'</option>';
		}

		echo '</select>';

		echo (isset($this->field['desc']) && !empty($this->field['desc']))?' <span class="description">'.esc_html( $this->field['desc'] ).'</span>':'';
		
	}//function
	
	public function getCpanelHtml(){
		echo ' <div class="control-group">';
		echo '<label class="control-label">'.esc_html( $this->field['title'] ).'</label>';
		echo '<div class="controls">';
		$this->render();
		echo '</div></div>';
	}
}//class
?>