<?php 
/**
* Layout Countdown Default
* @version     1.0.0
**/


$term_name = esc_html__( 'All Categories', 'emarket' );
$default = array(
	'post_type' => 'product',	
	'meta_query' => array(		
		array(
			'key' => '_sale_price',
			'value' => 0,
			'compare' => '>',
			'type' => 'DECIMAL(10,5)'
			),
		array(
			'key' => '_sale_price_dates_from',
			'value' => time(),
			'compare' => '<',
			'type' => 'NUMERIC'
			),
		array(
			'key' => '_sale_price_dates_to',
			'value' => time(),
			'compare' => '>',
			'type' => 'NUMERIC'
			)
		),
	'orderby' => $orderby,
	'order' => $order,
	'post_status' => 'publish',
	'showposts' => $numberposts	
	);
if( $category != '' ){
	$term = get_term_by( 'slug', $category, 'product_cat' );
	if( $term ) :
		$term_name = $term->name;
	endif; 
	
	$default['tax_query'] = array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ));
}
$default = sw_check_product_visiblity( $default );

$id = 'sw_countdown_'.$this->generateID();
$list = new WP_Query( $default );
if ( $list -> have_posts() ){ ?>
<div id="<?php echo $category.'_'.$id; ?>" class="sw-woo-container-slider responsive-slider countdown-slider style2 loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>" data-circle="false">       
	<div class="resp-slider-container">
		<?php if( $title1 != '' ){?>
		<div class="box-title">
			<h3><span><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></span></h3>
		</div>
		<?php } ?>
		<div class="slider responsive">	
			<?php 
				while($list->have_posts()): $list->the_post();					
				global $product, $post;
				$start_time 	= get_post_meta( $post->ID, '_sale_price_dates_from', true );
				$countdown_date = get_post_meta( $post->ID, '_sale_price_dates_to', true );
			?>
			<div class="item-countdown product" id="<?php echo 'product_'.$id.$post->ID; ?>">
				<div class="item-wrap">
					<div class="item-img">
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail( 'shop_single', array( 'alt' => get_the_title() ) ); ?></a>
						<?php emarket_product_item_bottom(); ?>
					</div>
					<div class="item-content">							
						<?php emarket_template_loop_product_title(); ?>
						<?php woocommerce_template_loop_price(); ?>
						<div class="item-description"><?php echo $post->post_excerpt; ?></div>
						<?php 
							if( $product->get_stock_quantity() != 0 ){ 
							$available 	 = $product->get_stock_quantity();
							$total_sales = get_post_meta( $post->ID, 'total_sales', true );
							$bar_width 	 = intval( $available ) / intval( $available + $total_sales ) * 100;
						?>
						<div class="emarket-stock clearfix">
							<div class="stock-avail pull-left"><?php esc_html_e( 'Available: ', 'emarket' ) ?><span><?php echo $available; ?></span></div>
							<div class="stock-sold pull-right"><?php esc_html_e( 'Sold: ', 'emarket' ) ?><span><?php echo $total_sales; ?></span></div>
						</div>
						<div class="sales-bar clearfix">
							<div class="sales-bar-total">
								<span style="width: <?php echo esc_attr( $bar_width . '%' ); ?>"></span>
							</div>
						</div>
						<?php } ?>
						<?php if( $countdown_date ) : ?>
						<div class="countdown-wrapper text">
							<div class="count-left pull-left">
								<h2><?php esc_html_e( 'Hurry up!', 'emarket' ) ?></h2>
								<p><?php esc_html_e( 'Offers end in:', 'emarket' ) ?></p>
							</div>
							<div class="product-countdown pull-right" data-date="<?php echo esc_attr( sw_timezone_offset( $countdown_date ) ); ?>"  data-starttime="<?php echo esc_attr( $start_time ); ?>"></div>		
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endwhile; wp_reset_postdata();?>
		</div>
	</div>
</div>
<?php } ?>