<?php 

/**
	* ayout Tab Category Countdown 1
	* @version     1.0.0
**/

	
	$widget_id = isset( $widget_id ) ? $widget_id : $this->generateID();
	if( $category == '' ){
		return '<div class="alert alert-warning alert-dismissible" role="alert">
			<a class="close" data-dismiss="alert">&times;</a>
			<p>'. esc_html__( 'Please select a category for SW Woocommerce Tab Category Slider. Layout ', 'emarket' ) .esc_attr( isset( $widget_template ) ? $widget_template : $layout ).'</p>
		</div>';
	}
	if( !is_array( $category ) ){
		$category = explode( ',', $category );
	}
?>
<div class="sw-tab-countdown sw-woo-tab-cat-ajax sw-ajax" id="<?php echo esc_attr( 'category_' . $widget_id ); ?>" >
	<div class="resp-tab" style="position:relative;">
		<div class="top-tab-slider clearfix">
			<div class="box-title pull-left"><?php echo ( $title1 != '' ) ? '<h3>'. esc_html( $title1 ) .'</h3>' : ''; ?></div>
			<ul class="nav nav-tabs pull-right" id="<?php echo 'nav_'.$widget_id; ?>">
			<?php 
				$i = 1;
				foreach($category as $cat){
					$terms = get_term_by('slug', $cat, 'product_cat');
					if( $terms != NULL ){			
			?>
				<li class="<?php if( $i == $tab_active ){echo 'active loaded'; }?>">
					<a href="#<?php echo esc_attr( $cat. '_' .$widget_id ) ?>" data-type="tab_ajax_countdown" data-layout="<?php echo esc_attr( isset( $widget_template ) ? $widget_template : $layout );?>" data-length="<?php echo esc_attr( $title_length ) ?>" data-ajaxurl="<?php echo esc_url( sw_ajax_url() ) ?>" data-category="<?php echo esc_attr( $cat ) ?>" data-toggle="tab" data-catload="ajax" data-number="<?php echo esc_attr( $numberposts ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
						<?php echo $terms->name; ?>
					</a>
				</li>	
				<?php $i ++; ?>
			<?php } } ?>
			</ul>
			<button class="button-collapse collapsed pull-right" type="button" data-toggle="collapse" data-target="#<?php echo 'nav_'.$widget_id; ?>"  aria-expanded="false"></button>
		</div>
		<div class="tab-content">
		<?php 
			$active = ( $tab_active - 1 >= 0 ) ? $tab_active - 1 : 0;
			$default = array(
				'post_type'	=> 'product',
				'tax_query'	=> array(
				array(
					'taxonomy'	=> 'product_cat',
					'field'		=> 'slug',
					'terms'		=> $category[$active])),
					'orderby' => $orderby,
					'order' => $order,
					'post_status' => 'publish',
					'showposts' => $numberposts,
					'meta_query' => array(		
					array(
						'key' => '_sale_price',
						'value' => 0,
						'compare' => '>',
						'type' => 'DECIMAL(10,5)'
					),
					array(
						'key' => '_sale_price_dates_from',
						'value' => time(),
						'compare' => '<',
						'type' => 'NUMERIC'
					),
					array(
						'key' => '_sale_price_dates_to',
						'value' => 0,
						'compare' => '>',
						'type' => 'NUMERIC'
					)
				)
			);
			$list = new WP_Query( $default );
		?>
			<div class="tab-pane active" id="<?php echo esc_attr( $category[$active]. '_' .$widget_id ) ?>">
				<?php if( $list->have_posts() ) : ?>
				<div id="<?php echo esc_attr( 'tab_cat_'. $category[$active]. '_' .$widget_id ); ?>" class="woo-tab-container-slider responsive-slider loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
					<div class="resp-slider-container">
						<div class="slider responsive">
						<?php 					
							while($list->have_posts()): $list->the_post();
							global $product, $post;
							$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
							$start_time = get_post_meta( $post->ID, '_sale_price_dates_from', true );
							$countdown_time = get_post_meta( $post->ID, '_sale_price_dates_to', true );	
							$forginal_price = get_post_meta( $post->ID, '_regular_price', true );	
							$fsale_price = get_post_meta( $post->ID, '_sale_price', true );	
							$symboy = get_woocommerce_currency_symbol( get_woocommerce_currency() );
							$date = sw_timezone_offset( $countdown_time );
						?>
							<div class="item <?php echo esc_attr( $class ) ?> product clearfix">
								<div class="item-wrap">
									<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>									
									<div class="item-content">
										<?php woocommerce_template_loop_rating(); ?>
										<?php emarket_template_loop_product_title(); ?>
										<?php woocommerce_template_loop_price(); ?>
										<!-- add to cart, wishlist, compare -->
										<?php //do_action( 'woocommerce_after_shop_loop_item' ); ?>
									
										<?php 
											if( $product->get_stock_quantity() != 0 ){ 
											$available 	 = $product->get_stock_quantity();
											$total_sales = get_post_meta( $post->ID, 'total_sales', true );
											$bar_width 	 = intval( $available ) / intval( $available + $total_sales ) * 100;
										?>
										<div class="sales-bar clearfix">
											<div class="sales-bar-total">
												<span style="width: <?php echo esc_attr( $bar_width . '%' ); ?>"></span>
											</div>
										</div>
										<div class="stock-sold"><?php esc_html_e( 'Sold: ', 'emarket' ) ?><span><?php echo $total_sales; ?></span></div>
										<?php } ?>
										<div class="product-countdown" data-date="<?php echo esc_attr( $date ); ?>" data-price="<?php echo esc_attr( $symboy.$forginal_price ); ?>" data-starttime="<?php echo esc_attr( $start_time ); ?>" data-cdtime="<?php echo esc_attr( $countdown_time ); ?>" data-id="<?php echo 'product_'.$widget_id.$post->ID; ?>"></div>	
										<div class="item-bottom-content">
											<?php
												woocommerce_template_loop_add_to_cart();
												emarket_product_addcart_mid();
											?>
										</div>
									</div>
								</div>
							</div>
						<?php endwhile; wp_reset_postdata();?>
						</div>
					</div>
				</div>			
				<?php 
					else :
						echo '<div class="alert alert-warning alert-dismissible" role="alert">
						<a class="close" data-dismiss="alert">&times;</a>
						<p>'. esc_html__( 'There is not product on this tab', 'emarket' ) .'</p>
						</div>';
					endif;
				?>
			</div>
		</div>
	</div>
</div>