<?php 

/**
	* Layout Child Category
	* @version     1.0.0
**/
if( $category == '' ){
	return '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'Please select a category for SW Woo Slider. Layout ', 'emarket' ).'</p>
	</div>';
}

$widget_id = isset( $widget_id ) ? $widget_id : $this->generateID();
$viewall = get_permalink( wc_get_page_id( 'shop' ) );
$default = array();
if( $category != '' ){
	$default = array(
		'post_type' => 'product',
		'tax_query' => array(
		array(
			'taxonomy'  => 'product_cat',
			'field'     => 'slug',
			'terms'     => $category ) ),
		'ignore_sticky_posts'   => 1,
		'meta_key' 		 		=> 'total_sales',
		'orderby' 		 		=> 'meta_value_num '. $orderby ,
		'order' => $order,
		'post_status' => 'publish',
		'showposts' => $numberposts
	);
}

$term_name = '';
$term = get_term_by( 'slug', $category, 'product_cat' );
if( $term ) :
	$term_name = $term->name;
	$viewall = get_term_link( $term->term_id, 'product_cat' );
endif;

$list = new WP_Query( $default );
if ( $list -> have_posts() ){
?>
	<div id="<?php echo 'slider_' . $widget_id.rand(); ?>" class="sw-banner-cat-product4" data-row="<?php echo esc_attr( $item_row ); ?>" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-dots="false" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
		<div class="childcat-slider-content clearfix">
			<!-- Product tab listing -->
						<?php 
			$banner_links = explode( ',', $banner_links );
			if( $image != '' ) :
				$image = explode( ',', $image );	
			?>

			<div class="banner-category">
				<div id="<?php echo esc_attr( 'banner_' . $widget_id ); ?>" class="banner-slider" data-lg="1" data-md="1" data-sm="1" data-xs="1" data-mobile="1" data-arrow="false" data-fade="false">
					<div class="banner-responsive">
						<?php foreach( $image as $key => $img ) : ?>
							<div class="item">
								<a href="<?php echo esc_url( isset( $banner_links[$key] ) ? $banner_links[$key] : '#' ); ?>"><?php echo wp_get_attachment_image( $img, 'large' ); ?></a>
							</div>
						<?php endforeach;?>
					</div>
				</div>									
			</div>
			<?php else:
				echo esc_html__('Please enter the banner image ID for layout.','emarket');
			 endif;?>
			<div class="box-title">
				<h3><span><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></span></h3>
				<a class="view-all pull-right" href="<?php echo esc_url( $viewall ); ?>"><?php echo esc_html__('View all','emarket'); ?></a>
			</div>
			<div class="resp-slider-container">
				<ul class="slider clearfix">	
				<?php while($list->have_posts()): $list->the_post(); global $post ?>
					<li class="item product">
						<div class="item-wrap">
							<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>				
							<div class="item-content">
								<?php emarket_template_loop_product_title(); ?>
								<?php emarket_custom_template_loop_price(); ?>
								<?php $total_sales = get_post_meta( $post->ID, 'total_sales', true ); ?>
								<div class="stock-sold"><span><?php echo $total_sales; ?><?php echo esc_html__(' Sold','emarket');?></span></div>
							</div>
						</div>
					</li>
				<?php endwhile; wp_reset_postdata(); ?>
				</ul>
			</div>	
		</div>
	</div>
	<?php
	}else{
		echo '<div class="alert alert-warning alert-dismissible" role="alert">
		<a class="close" data-dismiss="alert">&times;</a>
		<p>'. esc_html__( 'There is not product in this category', 'emarket' ) .'</p>
	</div>';
	}
?>