<?php 

/**
	* Layout Best Sales
	* @version     1.0.0
**/


$term_name = esc_html__( 'Best Sales', 'emarket' );
$default = array(
	'post_type' 			=> 'product',		
	'post_status' 			=> 'publish',
    'meta_query'     => array(
		array(
			'key'           => '_sale_price',
			'value'         => 0,
			'compare'       => '>',
			'type'          => 'numeric'
		)
	),
	'ignore_sticky_posts'   => 1,
	'showposts'				=> $numberposts,
	'meta_key' 		 		=> 'total_sales',
	'orderby' 		 		=> 'meta_value_num '. $orderby ,
	'order' => $order,
);
if( $category != '' ){
	$term = get_term_by( 'slug', $category, 'product_cat' );
	if( $term ) :
		$term_name = $term->name;
	endif;
	
	$default['tax_query'] = array(
		array(
			'taxonomy'	=> 'product_cat',
			'field'	=> 'slug',
			'terms'	=> $category,
			'operator' => 'IN'
		)
	);
}
$id = 'sw_bestsales3_'.$this->generateID();
$list = new WP_Query( $default );
$countdown_time = strtotime( $date );
$today = time();

if ( $list -> have_posts() ){
?>
	<div id="<?php echo $id; ?>" class="sw-woo-container-slider responsive-slider best-selling-product3 image-left loading" data-row="<?php echo esc_attr( $item_row ); ?>" data-rtl="true" data-lg="<?php echo esc_attr( $columns ); ?>" data-md="<?php echo esc_attr( $columns1 ); ?>" data-sm="<?php echo esc_attr( $columns2 ); ?>" data-xs="<?php echo esc_attr( $columns3 ); ?>" data-mobile="<?php echo esc_attr( $columns4 ); ?>" data-speed="<?php echo esc_attr( $speed ); ?>" data-scroll="<?php echo esc_attr( $scroll ); ?>" data-interval="<?php echo esc_attr( $interval ); ?>"  data-autoplay="<?php echo esc_attr( $autoplay ); ?>">
		<div class="sw-slide-left">
			<div class="box-title clearfix">
				<h3><?php echo ( $title1 != '' ) ? $title1 : $term_name; ?></h3>
				<h2><?php echo ( $description != '' ) ? htmlspecialchars_decode( $description ): ''; ?></h2>
			</div>
			<div class="item-countdown-wrap">
				<h4><?php echo esc_html__('Hurry Up! Offer End In:','emarket');?></h4>
			<?php if( $countdown_time > $today  ): ?> <div class="item-countdown" data-cdtime="<?php echo esc_attr( $countdown_time ); ?>"></div><?php else: ?><span class="message-cd"><?php echo esc_html__('Please select a time for layout.','emarket'); ?></span><?php endif; ?>
			</div>
		</div>
		<div class="resp-slider-container">			
			<div class="slider responsive">	
			<?php 				
				while($list->have_posts()): $list->the_post(); global $product, $post;
				$class = ( $product->get_price_html() ) ? '' : 'item-nonprice';
			?>
				<div class="item product <?php echo esc_attr( $class )?>">
					<div class="item-wrap">
						<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>						
						<div class="item-content">							
							<?php emarket_template_loop_product_title(); ?>
							<?php woocommerce_template_loop_rating(); ?>
							<?php woocommerce_template_loop_price(); ?>
							<?php 
								if( $product->get_stock_quantity() != 0 ){
								$available 	 = $product->get_stock_quantity();
								$total_sales = get_post_meta( $post->ID, 'total_sales', true );
								$bar_width 	 = intval( $available ) / intval( $available + $total_sales ) * 100;
								?>
								<div class="emarket-stock clearfix">
									<div class="stock-avail pull-left"><?php esc_html_e( 'Available: ', 'emarket' ) ?><span><?php echo $available; ?></span></div>						</div>
								<div class="sales-bar clearfix">
									<div class="sales-bar-total">
										<span style="width: <?php echo esc_attr( $bar_width . '%' ); ?>"></span>
									</div>
								</div>
							<?php } ?>
								<!-- add to cart, wishlist, compare -->
							<?php 
								emarket_woocommerce_template_loop_before_add_to_cart();
								woocommerce_template_loop_add_to_cart();
								emarket_woocommerce_template_loop_after_add_to_cart();
							?>
						</div>
					</div>
				</div>
			<?php  endwhile; wp_reset_postdata(); ?>
			</div>
		</div>					
	</div>
<?php } ?>